//==============================================================================
//	
//	Copyright (c) 2002-
//	Authors:
//	* Andrew Hinton <ug60axh@cs.bham.ac.uk> (University of Birmingham)
//	* Dave Parker <david.parker@comlab.ox.ac.uk> (University of Oxford, formerly University of Birmingham)
//	
//------------------------------------------------------------------------------
//	
//	This file is part of PRISM.
//	
//	PRISM is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License as published by
//	the Free Software Foundation; either version 2 of the License, or
//	(at your option) any later version.
//	
//	PRISM is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//	GNU General Public License for more details.
//	
//	You should have received a copy of the GNU General Public License
//	along with PRISM; if not, write to the Free Software Foundation,
//	Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//	
//==============================================================================

package userinterface.properties;

import java.awt.Font;

public class GUIPropertyResultDialog extends javax.swing.JDialog
{
	private static int noOpen = 0;
	
	private GUIProperty gp;
	private GUIMultiProperties gmp;
	
	/** Creates new form GUIPropertyResultDialog */
	public GUIPropertyResultDialog(java.awt.Frame parent, GUIMultiProperties gmp, GUIProperty gp)
	{
		super(parent, false);
		
		initComponents();
		getRootPane().setDefaultButton(jButton1);
		setTitle("Property Details");

		if (!("Result".equals(gp.getProperty().getResultName())))
			jLabel8.setText("Result ("+gp.getProperty().getResultName().toLowerCase()+"):");
		
		propertyLabel.setText(gp.getPropString());
		constantsLabel.setText(gp.getConstantsString());
		methodLabel.setText(gp.getMethodString());
		resultLabel.setText("<html>" + gp.getResultString().replaceAll("\n", "<br/>") + "</html>");
		if (gp.getNumberOfWarnings() == 0) {
			warningLabel.setText("");
		} else if (gp.getNumberOfWarnings() == 1) {
			warningLabel.setText(gp.getNumberOfWarnings() + " warning (see log)");
		} else {
			warningLabel.setText(gp.getNumberOfWarnings() + " warnings (see log)");
		}
			
		this.gp = gp;
		this.gmp = gmp;
		
		pack();
		setLocation(getParent().getX(), getParent().getY());
	}
	
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents()//GEN-BEGIN:initComponents
	{
		java.awt.GridBagConstraints gridBagConstraints;

		jPanel2 = new javax.swing.JPanel();
		jButton1 = new javax.swing.JButton();
		jPanel10 = new javax.swing.JPanel();
		jPanel1 = new javax.swing.JPanel();
		jLabel1 = new javax.swing.JLabel();

		Font cur = jLabel1.getFont();
		jLabel1.setFont(new Font(cur.getName(), Font.BOLD, cur.getSize()));
		propertyLabel = new javax.swing.JLabel();
		jLabel3 = new javax.swing.JLabel();
		cur = jLabel3.getFont();
		jLabel3.setFont(new Font(cur.getName(), Font.BOLD, cur.getSize()));
		constantsLabel = new javax.swing.JLabel();
		jLabel5 = new javax.swing.JLabel();
		cur = jLabel5.getFont();
		jLabel5.setFont(new Font(cur.getName(), Font.BOLD, cur.getSize()));
		jPanel3 = new javax.swing.JPanel();
		methodLabel = new javax.swing.JLabel();
		jPanel4 = new javax.swing.JPanel();
		jPanel5 = new javax.swing.JPanel();
		jPanel6 = new javax.swing.JPanel();
		jPanel7 = new javax.swing.JPanel();
		jLabel8 = new javax.swing.JLabel();
		cur = jLabel8.getFont();
		jLabel8.setFont(new Font(cur.getName(), Font.BOLD, cur.getSize()));
		resultLabel = new javax.swing.JLabel();
		jPanel8 = new javax.swing.JPanel();
		warningLabel = new javax.swing.JLabel();
		cur = warningLabel.getFont();
		warningLabel.setFont(new Font(cur.getName(), Font.BOLD, cur.getSize()));
		jPanel14 = new javax.swing.JPanel();
		jPanel9 = new javax.swing.JPanel();
		jPanel11 = new javax.swing.JPanel();
		jPanel12 = new javax.swing.JPanel();
		jPanel13 = new javax.swing.JPanel();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog();
            }
        });
        
		jPanel2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

		jButton1.setText("Okay");
		jButton1.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				jButton1ActionPerformed(evt);
			}
		});

		jPanel2.add(jButton1);

		getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);
		
		jPanel10.setLayout(new java.awt.GridBagLayout());

		jPanel1.setLayout(new java.awt.GridBagLayout());

		jPanel1.setBackground(new java.awt.Color(255, 255, 255));
		jPanel1.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0), 1, true));
		jLabel1.setText("Property:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel1.add(jLabel1, gridBagConstraints);

		propertyLabel.setText("dummydummydummydummydummydummy");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel1.add(propertyLabel, gridBagConstraints);

		jLabel3.setText("Defined constants:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 4;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel1.add(jLabel3, gridBagConstraints);

		constantsLabel.setText("dummy dummy dummy dummy dummy dummy dummy dummy dummy");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 5;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel1.add(constantsLabel, gridBagConstraints);

		jLabel5.setText("Method:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 7;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel1.add(jLabel5, gridBagConstraints);

		jPanel3.setBackground(new java.awt.Color(255, 255, 255));
		jPanel3.setPreferredSize(new java.awt.Dimension(20, 10));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel1.add(jPanel3, gridBagConstraints);

		methodLabel.setText("dummy dummy dummy dummy dummy dummy dummy dummy dummy");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 8;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel1.add(methodLabel, gridBagConstraints);

		jPanel4.setBackground(new java.awt.Color(255, 255, 255));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		jPanel1.add(jPanel4, gridBagConstraints);

		jPanel5.setBackground(new java.awt.Color(255, 255, 255));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3;
		jPanel1.add(jPanel5, gridBagConstraints);

		jPanel6.setBackground(new java.awt.Color(255, 255, 255));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 6;
		jPanel1.add(jPanel6, gridBagConstraints);

		jPanel7.setBackground(new java.awt.Color(255, 255, 255));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 3;
		gridBagConstraints.gridy = 0;
		jPanel1.add(jPanel7, gridBagConstraints);

		jLabel8.setText("Result:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 10;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel1.add(jLabel8, gridBagConstraints);

		resultLabel.setText("dummy dummy dummy dummy dummy dummy dummy dummy dummy");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 11;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel1.add(resultLabel, gridBagConstraints);

		jPanel8.setBackground(new java.awt.Color(255, 255, 255));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 9;
		jPanel1.add(jPanel8, gridBagConstraints);

		jPanel9.setBackground(new java.awt.Color(255, 255, 255));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 12;
		jPanel1.add(jPanel9, gridBagConstraints);
		
		warningLabel.setText("dummy dummy");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 13;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel1.add(warningLabel, gridBagConstraints);

		jPanel14.setBackground(new java.awt.Color(255, 255, 255));
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 14;
		jPanel1.add(jPanel14, gridBagConstraints);
		
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		jPanel10.add(jPanel1, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		jPanel10.add(jPanel11, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		jPanel10.add(jPanel12, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		jPanel10.add(jPanel13, gridBagConstraints);

		getContentPane().add(jPanel10, java.awt.BorderLayout.CENTER);

		pack();
	}//GEN-END:initComponents

	private void jButton1ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButton1ActionPerformed
	{//GEN-HEADEREND:event_jButton1ActionPerformed
		closeDialog();
	}//GEN-LAST:event_jButton1ActionPerformed
	
	/** Closes the dialog */
	private void closeDialog()
	{
		gp.setBeingEdited(false);
		gmp.repaintList();
		setVisible(false);
		dispose();
	}

	public void display()
	{
		noOpen++;
		setLocation(getX()+(noOpen*50), getY()+(noOpen*50));
		super.setVisible(true);
	}
	
	public void dispose()
	{
		noOpen--;
		super.dispose();
	}
	
	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JLabel constantsLabel;
	private javax.swing.JButton jButton1;
	private javax.swing.JLabel jLabel1;
	private javax.swing.JLabel jLabel3;
	private javax.swing.JLabel jLabel5;
	private javax.swing.JLabel jLabel8;
	private javax.swing.JLabel warningLabel;
	private javax.swing.JPanel jPanel1;
	private javax.swing.JPanel jPanel10;
	private javax.swing.JPanel jPanel11;
	private javax.swing.JPanel jPanel12;
	private javax.swing.JPanel jPanel13;
	private javax.swing.JPanel jPanel14;
	private javax.swing.JPanel jPanel2;
	private javax.swing.JPanel jPanel3;
	private javax.swing.JPanel jPanel4;
	private javax.swing.JPanel jPanel5;
	private javax.swing.JPanel jPanel6;
	private javax.swing.JPanel jPanel7;
	private javax.swing.JPanel jPanel8;
	private javax.swing.JPanel jPanel9;
	private javax.swing.JLabel methodLabel;
	private javax.swing.JLabel propertyLabel;
	private javax.swing.JLabel resultLabel;
	// End of variables declaration//GEN-END:variables
	
}
