/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.root;

import edu.jas.arith.BigDecimal;
import edu.jas.arith.Rational;
import edu.jas.poly.Complex;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import java.io.Serializable;
import java.util.List;

public class DecimalRoots<C extends GcdRingElem<C> & Rational>
implements Serializable {
    public final GenPolynomial<C> p;
    public final List<BigDecimal> real;
    public final GenPolynomial<Complex<C>> cp;
    public final List<Complex<BigDecimal>> complex;

    public DecimalRoots(GenPolynomial<C> genPolynomial, GenPolynomial<Complex<C>> genPolynomial2, List<BigDecimal> list, List<Complex<BigDecimal>> list2) {
        this.p = genPolynomial;
        this.cp = genPolynomial2;
        this.real = list;
        this.complex = list2;
    }

    public String toString() {
        return "[" + this.p + ", real=" + this.real + ", complex=" + this.complex + "]";
    }

    public String toScript() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.p.toScript());
        if (!this.real.isEmpty()) {
            stringBuffer.append(", real=[");
            bl = true;
            for (BigDecimal gcdRingElem : this.real) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(gcdRingElem.toScript());
            }
            stringBuffer.append("]");
        }
        if (!this.complex.isEmpty()) {
            stringBuffer.append(", complex=[");
            bl = true;
            for (Complex complex : this.complex) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(complex.toScript());
            }
            stringBuffer.append("]");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public DecimalRoots<C> copy() {
        return new DecimalRoots<C>(this.p, this.cp, this.real, this.complex);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DecimalRoots)) {
            return false;
        }
        DecimalRoots decimalRoots = null;
        try {
            decimalRoots = (DecimalRoots)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.p.equals(decimalRoots.p) && this.real.equals(decimalRoots.real) && this.complex.equals(decimalRoots.complex);
    }

    public int hashCode() {
        return (161 * this.p.hashCode() + 37) * this.real.hashCode() + this.complex.hashCode();
    }
}

