/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.arith.BigInteger;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.TermOrderByName;
import edu.jas.structure.Element;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TermOrderByNameCompatTest
extends TestCase {
    public static void main(String[] stringArray) {
        TestRunner.run((Test)TermOrderByNameCompatTest.suite());
    }

    public TermOrderByNameCompatTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(TermOrderByNameCompatTest.class);
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testTermOrderLexicographic() {
        BigInteger bigInteger = new BigInteger();
        String[] stringArray = new String[]{"x", "y", "z"};
        String string = "-10*x^5*y^4*z^2 + 7*x^2*y^5*z^3 - 10*x^2*y*z^5 - 7*x*y^5*z^4 + 6*x*y^4*z^3 + 6*x*y^3*z^3 + 3*x*y^2*z + y^4*z - 7*y^2*z + 2*z^5";
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, TermOrderByName.Lexicographic, stringArray);
        Element element = genPolynomialRing.parse(string);
        TermOrderByNameCompatTest.assertEquals((String)"( -10 ) x^5 * y^4 * z^2 + 7 x^2 * y^5 * z^3 - 10 x^2 * y * z^5 - 7 x * y^5 * z^4 + 6 x * y^4 * z^3 + 6 x * y^3 * z^3 + 3 x * y^2 * z + y^4 * z - 7 y^2 * z + 2 z^5", (String)((GenPolynomial)element).toString());
    }

    public void testTermOrderNegativeLexicographic() {
        BigInteger bigInteger = new BigInteger();
        String[] stringArray = new String[]{"x", "y", "z"};
        String string = "-10*x^5*y^4*z^2 + 7*x^2*y^5*z^3 - 10*x^2*y*z^5 - 7*x*y^5*z^4 + 6*x*y^4*z^3 + 6*x*y^3*z^3 + 3*x*y^2*z + y^4*z - 7*y^2*z + 2*z^5";
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, TermOrderByName.NegativeLexicographic, stringArray);
        Element element = genPolynomialRing.parse(string);
        TermOrderByNameCompatTest.assertEquals((String)"2 z^5 - 7 y^2 * z + y^4 * z + 3 x * y^2 * z + 6 x * y^3 * z^3 + 6 x * y^4 * z^3 - 7 x * y^5 * z^4 - 10 x^2 * y * z^5 + 7 x^2 * y^5 * z^3 - 10 x^5 * y^4 * z^2", (String)((GenPolynomial)element).toString());
    }

    public void testTermOrderDegreeLexicographic() {
        BigInteger bigInteger = new BigInteger();
        String[] stringArray = new String[]{"x", "y", "z"};
        String string = "-10*x^5*y^4*z^2 + 7*x^2*y^5*z^3 - 10*x^2*y*z^5 - 7*x*y^5*z^4 + 6*x*y^4*z^3 + 6*x*y^3*z^3 + 3*x*y^2*z + y^4*z - 7*y^2*z + 2*z^5";
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, TermOrderByName.DegreeLexicographic, stringArray);
        Element element = genPolynomialRing.parse(string);
        TermOrderByNameCompatTest.assertEquals((String)"( -10 ) x^5 * y^4 * z^2 + 7 x^2 * y^5 * z^3 - 7 x * y^5 * z^4 - 10 x^2 * y * z^5 + 6 x * y^4 * z^3 + 6 x * y^3 * z^3 + y^4 * z + 2 z^5 + 3 x * y^2 * z - 7 y^2 * z", (String)((GenPolynomial)element).toString());
    }

    public void testTermOrderNegativeDegreeReverseLexicographic() {
        BigInteger bigInteger = new BigInteger();
        String[] stringArray = new String[]{"x", "y", "z"};
        String string = "-10*x^5*y^4*z^2 + 7*x^2*y^5*z^3 - 10*x^2*y*z^5 - 7*x*y^5*z^4 + 6*x*y^4*z^3 + 6*x*y^3*z^3 + 3*x*y^2*z + y^4*z - 7*y^2*z + 2*z^5";
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, TermOrderByName.NegativeDegreeReverseLexicographic, stringArray);
        Element element = genPolynomialRing.parse(string);
        TermOrderByNameCompatTest.assertEquals((String)"( -7 ) y^2 * z + 3 x * y^2 * z + y^4 * z + 2 z^5 + 6 x * y^3 * z^3 + 6 x * y^4 * z^3 - 10 x^2 * y * z^5 + 7 x^2 * y^5 * z^3 - 7 x * y^5 * z^4 - 10 x^5 * y^4 * z^2", (String)((GenPolynomial)element).toString());
    }

    public void testTermOrderDegreeReverseLexicographic() {
        BigInteger bigInteger = new BigInteger();
        String[] stringArray = new String[]{"x", "y", "z"};
        String string = "-10*x^5*y^4*z^2 + 7*x^2*y^5*z^3 - 10*x^2*y*z^5 - 7*x*y^5*z^4 + 6*x*y^4*z^3 + 6*x*y^3*z^3 + 3*x*y^2*z + y^4*z - 7*y^2*z + 2*z^5";
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, TermOrderByName.DegreeReverseLexicographic, stringArray);
        Element element = genPolynomialRing.parse(string);
        TermOrderByNameCompatTest.assertEquals((String)"( -10 ) x^5 * y^4 * z^2 + 7 x^2 * y^5 * z^3 - 7 x * y^5 * z^4 + 6 x * y^4 * z^3 - 10 x^2 * y * z^5 + 6 x * y^3 * z^3 + y^4 * z + 2 z^5 + 3 x * y^2 * z - 7 y^2 * z", (String)((GenPolynomial)element).toString());
    }

    public void testTermOrderNegativeDegreeLexicographic() {
        BigInteger bigInteger = new BigInteger();
        String[] stringArray = new String[]{"x", "y", "z"};
        String string = "-10*x^5*y^4*z^2 + 7*x^2*y^5*z^3 - 10*x^2*y*z^5 - 7*x*y^5*z^4 + 6*x*y^4*z^3 + 6*x*y^3*z^3 + 3*x*y^2*z + y^4*z - 7*y^2*z + 2*z^5";
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, TermOrderByName.NegativeDegreeLexicographic, stringArray);
        Element element = genPolynomialRing.parse(string);
        TermOrderByNameCompatTest.assertEquals((String)"( -7 ) y^2 * z + 3 x * y^2 * z + y^4 * z + 2 z^5 + 6 x * y^3 * z^3 - 10 x^2 * y * z^5 + 6 x * y^4 * z^3 + 7 x^2 * y^5 * z^3 - 7 x * y^5 * z^4 - 10 x^5 * y^4 * z^2", (String)((GenPolynomial)element).toString());
    }
}

