/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.PrettyPrint;
import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.poly.GenSolvablePolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.RecSolvablePolynomial;
import edu.jas.poly.RelationTable;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecSolvablePolynomialRing<C extends RingElem<C>>
extends GenSolvablePolynomialRing<GenPolynomial<C>> {
    public final RelationTable<GenPolynomial<C>> coeffTable = new RelationTable(this, true);
    public final RecSolvablePolynomial<C> ZERO = new RecSolvablePolynomial(this);
    public final RecSolvablePolynomial<C> ONE;
    private static final Logger logger = LogManager.getLogger(RecSolvablePolynomialRing.class);

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> ringFactory, int n) {
        this(ringFactory, n, new TermOrder(), (String[])null, (RelationTable<GenPolynomial<C>>)null);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> ringFactory, int n, RelationTable<GenPolynomial<C>> relationTable) {
        this(ringFactory, n, new TermOrder(), (String[])null, relationTable);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> ringFactory, int n, TermOrder termOrder) {
        this(ringFactory, n, termOrder, (String[])null, (RelationTable<GenPolynomial<C>>)null);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> ringFactory, int n, TermOrder termOrder, RelationTable<GenPolynomial<C>> relationTable) {
        this(ringFactory, n, termOrder, (String[])null, relationTable);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> ringFactory, int n, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, n, termOrder, stringArray, (RelationTable<GenPolynomial<C>>)null);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> ringFactory, TermOrder termOrder, String[] stringArray) {
        this(ringFactory, stringArray.length, termOrder, stringArray, (RelationTable<GenPolynomial<C>>)null);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> ringFactory, String[] stringArray) {
        this(ringFactory, stringArray.length, new TermOrder(), stringArray, (RelationTable<GenPolynomial<C>>)null);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> ringFactory, int n, TermOrder termOrder, String[] stringArray, RelationTable<GenPolynomial<C>> relationTable) {
        super(ringFactory, n, termOrder, stringArray, relationTable);
        GenPolynomial genPolynomial = (GenPolynomial)this.coFac.getONE();
        this.ONE = new RecSolvablePolynomial(this, genPolynomial, this.evzero);
    }

    public RecSolvablePolynomialRing(RingFactory<GenPolynomial<C>> ringFactory, RecSolvablePolynomialRing recSolvablePolynomialRing) {
        this(ringFactory, recSolvablePolynomialRing.nvar, recSolvablePolynomialRing.tord, recSolvablePolynomialRing.getVars(), (RelationTable<GenPolynomial<C>>)null);
    }

    @Override
    public String toString() {
        Object object = super.toString();
        object = PrettyPrint.isTrue() ? (String)object + "\n" + this.coeffTable.toString(this.vars) : (String)object + ", #rel = " + this.table.size() + " + " + this.coeffTable.size();
        return object;
    }

    @Override
    public String toScript() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("SolvPolyRing.new(");
                break;
            }
            default: {
                stringBuffer.append("SolvPolyRing(");
            }
        }
        if (this.coFac instanceof RingElem) {
            stringBuffer.append(((RingElem)((Object)this.coFac)).toScriptFactory());
        } else {
            stringBuffer.append(this.coFac.toScript().trim());
        }
        stringBuffer.append(",\"" + this.varsToString() + "\",");
        String string2 = this.tord.toScript();
        stringBuffer.append(string2);
        if (this.table.size() > 0) {
            string = this.table.toScript();
            stringBuffer.append(",rel=");
            stringBuffer.append(string);
        }
        if (this.coeffTable.size() > 0) {
            string = this.coeffTable.toScript();
            stringBuffer.append(",coeffrel=");
            stringBuffer.append(string);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RecSolvablePolynomialRing)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RecSolvablePolynomialRing recSolvablePolynomialRing = (RecSolvablePolynomialRing)object;
        return this.coeffTable.equals(recSolvablePolynomialRing.coeffTable);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 37 * n + this.table.hashCode();
        n = 37 * n + this.coeffTable.hashCode();
        return n;
    }

    @Override
    public RecSolvablePolynomial<C> getZERO() {
        return this.ZERO;
    }

    @Override
    public RecSolvablePolynomial<C> getONE() {
        return this.ONE;
    }

    @Override
    public boolean isCommutative() {
        if (this.coeffTable.isEmpty()) {
            return super.isCommutative();
        }
        return false;
    }

    @Override
    public boolean isAssociative() {
        if (!this.coFac.isAssociative()) {
            return false;
        }
        List list = this.generators();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            RecSolvablePolynomial recSolvablePolynomial = (RecSolvablePolynomial)list.get(i);
            for (int j = i + 1; j < n; ++j) {
                RecSolvablePolynomial recSolvablePolynomial2 = (RecSolvablePolynomial)list.get(j);
                for (int k = j + 1; k < n; ++k) {
                    RecSolvablePolynomial recSolvablePolynomial3;
                    RecSolvablePolynomial recSolvablePolynomial4 = (RecSolvablePolynomial)list.get(k);
                    RecSolvablePolynomial recSolvablePolynomial5 = recSolvablePolynomial4.multiply(recSolvablePolynomial2).multiply(recSolvablePolynomial);
                    if (recSolvablePolynomial5.equals(recSolvablePolynomial3 = recSolvablePolynomial4.multiply(recSolvablePolynomial2.multiply(recSolvablePolynomial)))) continue;
                    if (logger.isInfoEnabled()) {
                        logger.info("Xk = " + recSolvablePolynomial4 + ", Xj = " + recSolvablePolynomial2 + ", Xi = " + recSolvablePolynomial);
                        logger.info("p = ( Xk * Xj ) * Xi = {}", recSolvablePolynomial5);
                        logger.info("q = Xk * ( Xj * Xi ) = {}", recSolvablePolynomial3);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public RecSolvablePolynomial<C> valueOf(GenPolynomial<C> genPolynomial) {
        return new RecSolvablePolynomial<C>(this, genPolynomial);
    }

    @Override
    public RecSolvablePolynomial<C> valueOf(ExpVector expVector) {
        return new RecSolvablePolynomial(this, (GenPolynomial)this.coFac.getONE(), expVector);
    }

    @Override
    public RecSolvablePolynomial<C> valueOf(GenPolynomial<C> genPolynomial, ExpVector expVector) {
        return new RecSolvablePolynomial<C>(this, genPolynomial, expVector);
    }

    @Override
    public RecSolvablePolynomial<C> fromInteger(long l) {
        return new RecSolvablePolynomial(this, (GenPolynomial)this.coFac.fromInteger(l), this.evzero);
    }

    @Override
    public RecSolvablePolynomial<C> fromInteger(BigInteger bigInteger) {
        return new RecSolvablePolynomial(this, (GenPolynomial)this.coFac.fromInteger(bigInteger), this.evzero);
    }

    @Override
    public RecSolvablePolynomial<C> random(int n) {
        return this.random(n, random);
    }

    @Override
    public RecSolvablePolynomial<C> random(int n, Random random) {
        if (this.nvar == 1) {
            return this.random(5, n, n, 0.7f, random);
        }
        return this.random(5, n, 3, 0.3f, random);
    }

    @Override
    public RecSolvablePolynomial<C> random(int n, int n2, int n3, float f) {
        return this.random(n, n2, n3, f, random);
    }

    @Override
    public RecSolvablePolynomial<C> random(int n, int n2, int n3, float f, Random random) {
        GenSolvablePolynomial genSolvablePolynomial = this.getZERO();
        for (int i = 0; i < n2; ++i) {
            ExpVector expVector = ExpVector.random(this.nvar, n3, f, random);
            GenPolynomial genPolynomial = (GenPolynomial)this.coFac.random(n, random);
            genSolvablePolynomial = (RecSolvablePolynomial)genSolvablePolynomial.sum(genPolynomial, expVector);
        }
        return genSolvablePolynomial;
    }

    @Override
    public RecSolvablePolynomial<C> copy(RecSolvablePolynomial<C> recSolvablePolynomial) {
        return new RecSolvablePolynomial(this, recSolvablePolynomial.val);
    }

    @Override
    public RecSolvablePolynomial<C> parse(String string) {
        return this.parse(new StringReader(string));
    }

    @Override
    public RecSolvablePolynomial<C> parse(Reader reader) {
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(this, reader);
        RecSolvablePolynomial recSolvablePolynomial = null;
        try {
            GenSolvablePolynomial genSolvablePolynomial = genPolynomialTokenizer.nextSolvablePolynomial();
            recSolvablePolynomial = new RecSolvablePolynomial(this, genSolvablePolynomial);
        }
        catch (IOException iOException) {
            logger.error("{} parse {}", (Object)iOException, (Object)this);
            recSolvablePolynomial = this.ZERO;
        }
        return recSolvablePolynomial;
    }

    @Override
    public RecSolvablePolynomial<C> univariate(int n) {
        return (RecSolvablePolynomial)super.univariate(n);
    }

    @Override
    public RecSolvablePolynomial<C> univariate(int n, long l) {
        return (RecSolvablePolynomial)super.univariate(n, l);
    }

    @Override
    public RecSolvablePolynomial<C> univariate(int n, int n2, long l) {
        return (RecSolvablePolynomial)super.univariate(n, n2, l);
    }

    @Override
    public List<RecSolvablePolynomial<C>> univariateList() {
        return this.univariateList(0, 1L);
    }

    @Override
    public List<RecSolvablePolynomial<C>> univariateList(int n) {
        return this.univariateList(n, 1L);
    }

    @Override
    public List<RecSolvablePolynomial<C>> univariateList(int n, long l) {
        ArrayList<RecSolvablePolynomial<C>> arrayList = new ArrayList<RecSolvablePolynomial<C>>(this.nvar);
        int n2 = this.nvar - n;
        for (int i = 0; i < n2; ++i) {
            GenSolvablePolynomial genSolvablePolynomial = this.univariate(n, n2 - 1 - i, l);
            arrayList.add((RecSolvablePolynomial<C>)genSolvablePolynomial);
        }
        return arrayList;
    }

    @Override
    public RecSolvablePolynomialRing<C> extend(int n) {
        return this.extend(n, false);
    }

    @Override
    public RecSolvablePolynomialRing<C> extend(int n, boolean bl) {
        GenPolynomialRing genPolynomialRing = super.extend(n, bl);
        RecSolvablePolynomialRing<C> recSolvablePolynomialRing = new RecSolvablePolynomialRing<C>(((GenSolvablePolynomialRing)genPolynomialRing).coFac, ((GenSolvablePolynomialRing)genPolynomialRing).nvar, ((GenSolvablePolynomialRing)genPolynomialRing).tord, ((GenSolvablePolynomialRing)genPolynomialRing).vars, ((GenSolvablePolynomialRing)genPolynomialRing).table);
        recSolvablePolynomialRing.coeffTable.extend(this.coeffTable);
        return recSolvablePolynomialRing;
    }

    @Override
    public RecSolvablePolynomialRing<C> extend(String[] stringArray) {
        return this.extend(stringArray, false);
    }

    @Override
    public RecSolvablePolynomialRing<C> extend(String[] stringArray, boolean bl) {
        GenPolynomialRing genPolynomialRing = super.extend(stringArray, bl);
        RecSolvablePolynomialRing<C> recSolvablePolynomialRing = new RecSolvablePolynomialRing<C>(((GenSolvablePolynomialRing)genPolynomialRing).coFac, ((GenSolvablePolynomialRing)genPolynomialRing).nvar, ((GenSolvablePolynomialRing)genPolynomialRing).tord, ((GenSolvablePolynomialRing)genPolynomialRing).vars, ((GenSolvablePolynomialRing)genPolynomialRing).table);
        recSolvablePolynomialRing.coeffTable.extend(this.coeffTable);
        return recSolvablePolynomialRing;
    }

    @Override
    public RecSolvablePolynomialRing<C> contract(int n) {
        GenPolynomialRing genPolynomialRing = super.contract(n);
        RecSolvablePolynomialRing<C> recSolvablePolynomialRing = new RecSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.vars);
        recSolvablePolynomialRing.table.contract(this.table);
        recSolvablePolynomialRing.coeffTable.contract(this.coeffTable);
        return recSolvablePolynomialRing;
    }

    @Override
    public RecSolvablePolynomialRing<C> reverse() {
        return this.reverse(false);
    }

    @Override
    public RecSolvablePolynomialRing<C> reverse(boolean bl) {
        GenPolynomialRing genPolynomialRing = super.reverse(bl);
        RecSolvablePolynomialRing<C> recSolvablePolynomialRing = new RecSolvablePolynomialRing<C>(genPolynomialRing.coFac, genPolynomialRing.nvar, genPolynomialRing.tord, genPolynomialRing.vars);
        recSolvablePolynomialRing.partial = bl;
        recSolvablePolynomialRing.table.reverse(this.table);
        recSolvablePolynomialRing.coeffTable.reverse(this.coeffTable);
        return recSolvablePolynomialRing;
    }

    public static <C extends RingElem<C>> GenSolvablePolynomialRing<C> distribute(RecSolvablePolynomialRing<C> recSolvablePolynomialRing) {
        RecSolvablePolynomialRing<C> recSolvablePolynomialRing2 = recSolvablePolynomialRing;
        GenPolynomialRing genPolynomialRing = recSolvablePolynomialRing2.distribute();
        List<GenPolynomial<GenPolynomial<C>>> list = PolynomialList.castToList(recSolvablePolynomialRing.coeffTable.relationList());
        List<GenPolynomial<C>> list2 = PolyUtil.distribute(genPolynomialRing, list);
        ((GenSolvablePolynomialRing)genPolynomialRing).table.addRelations(list2);
        return genPolynomialRing;
    }

    @Override
    public GenSolvablePolynomialRing<GenPolynomial<C>> permutation(List<Integer> list) {
        if (!this.coeffTable.isEmpty()) {
            throw new UnsupportedOperationException("permutation with coeff relations: " + this);
        }
        GenSolvablePolynomialRing genSolvablePolynomialRing = (GenSolvablePolynomialRing)super.permutation(list);
        return genSolvablePolynomialRing;
    }
}

