/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.ComprehensiveGroebnerBaseSeq;
import edu.jas.arith.BigRational;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.GenPolynomialTokenizer;
import edu.jas.poly.PolynomialList;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CGBSeqTest
extends TestCase {
    GenPolynomialRing<BigRational> cfac;
    GenPolynomialRing<GenPolynomial<BigRational>> fac;
    List<GenPolynomial<GenPolynomial<BigRational>>> L;
    ComprehensiveGroebnerBaseSeq<BigRational> bb;
    GenPolynomial<GenPolynomial<BigRational>> a;
    GenPolynomial<GenPolynomial<BigRational>> b;
    GenPolynomial<GenPolynomial<BigRational>> c;
    GenPolynomial<GenPolynomial<BigRational>> d;
    GenPolynomial<GenPolynomial<BigRational>> e;
    int rl = 2;
    int kl = 2;
    int ll = 3;
    int el = 3;
    float q = 0.2f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)CGBSeqTest.suite());
        ComputerThreads.terminate();
    }

    public CGBSeqTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(CGBSeqTest.class);
        return testSuite;
    }

    protected void setUp() {
        BigRational bigRational = new BigRational(this.kl);
        String[] stringArray = new String[]{"a"};
        this.cfac = new GenPolynomialRing<BigRational>(bigRational, 1, stringArray);
        String[] stringArray2 = new String[]{"x"};
        this.fac = new GenPolynomialRing<BigRational>(this.cfac, 1, stringArray2);
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.bb = new ComprehensiveGroebnerBaseSeq<BigRational>(bigRational);
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.cfac = null;
        this.bb = null;
    }

    public void testSequentialCGB() {
        this.L = new ArrayList<GenPolynomial<GenPolynomial<BigRational>>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.a;
        this.d = this.c;
        this.e = this.d;
        if (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO()) {
            return;
        }
        CGBSeqTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L.add(this.a);
        this.L = this.bb.GB(this.L);
        CGBSeqTest.assertTrue((String)"isGB( { a } )", (boolean)this.bb.isGB(this.L));
        CGBSeqTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.L = this.bb.GB(this.L);
        CGBSeqTest.assertTrue((String)"isGB( { a, b } )", (boolean)this.bb.isGB(this.L));
        CGBSeqTest.assertTrue((String)"not isZERO( c )", (!this.c.isZERO() ? 1 : 0) != 0);
        this.L.add(this.c);
        this.L = this.bb.GB(this.L);
        CGBSeqTest.assertTrue((String)"isGB( { a, b, c } )", (boolean)this.bb.isGB(this.L));
    }

    public void testTrinks7GBase() {
        PolynomialList polynomialList = null;
        List list = null;
        String string = "IntFunc(b) (S,T,Z,P,W) L ( ( 45 P + 35 S - { 165 b + 36 } ), ( 35 P + 40 Z + 25 T - 27 S ), ( 15 W + 25 S P + 30 Z - 18 T - { 165 b**2 } ), ( - 9 W + 15 T P + 20 S Z ), ( P W + 2 T Z - { 11 b**3 } ), ( 99 W - { 11 b } S + { 3 b**2 } ), ( { b**2 + 33/50 b + 2673/10000 } ) ) ";
        StringReader stringReader = new StringReader(string);
        GenPolynomialTokenizer genPolynomialTokenizer = new GenPolynomialTokenizer(stringReader);
        try {
            polynomialList = genPolynomialTokenizer.nextPolynomialSet();
        }
        catch (ClassCastException classCastException) {
            CGBSeqTest.fail((String)("" + classCastException));
        }
        catch (IOException iOException) {
            CGBSeqTest.fail((String)("" + iOException));
        }
        list = this.bb.GB(polynomialList.list);
        CGBSeqTest.assertTrue((String)"isGB( GB(Trinks7) )", (boolean)this.bb.isGB(list));
    }
}

