/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties.computation;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import parser.State;
import parser.Values;
import parser.ast.Expression;
import parser.ast.PropertiesFile;
import prism.ModelType;
import prism.PrismException;
import prism.Result;
import simulator.method.SimulationMethod;
import userinterface.GUIComputationThread;
import userinterface.GUIPrism;
import userinterface.SimulationInformation;
import userinterface.properties.GUIMultiProperties;
import userinterface.properties.GUIPropertiesEvent;
import userinterface.properties.GUIProperty;
import userinterface.util.GUIComputationEvent;

public class SimulateModelCheckThread
extends GUIComputationThread {
    private GUIMultiProperties parent;
    private PropertiesFile pf;
    private ArrayList<GUIProperty> guiProps;
    private Values definedPFConstants;
    private long maxPathLength;
    private SimulationInformation info;

    public SimulateModelCheckThread(GUIMultiProperties gUIMultiProperties, PropertiesFile propertiesFile, ArrayList<GUIProperty> arrayList, Values values, SimulationInformation simulationInformation) {
        super(gUIMultiProperties);
        this.parent = gUIMultiProperties;
        this.pf = propertiesFile;
        this.guiProps = arrayList;
        this.definedPFConstants = values;
        this.info = simulationInformation;
        this.maxPathLength = simulationInformation.getMaxPathLength();
    }

    @Override
    public void run() {
        Object object;
        boolean bl = this.prism.getSettings().getBoolean("simulator.simultaneous");
        SimulationMethod simulationMethod = this.info.createSimulationMethod();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimulateModelCheckThread.this.parent.startProgress();
                SimulateModelCheckThread.this.parent.setTaskBarText("Checking properties using simulation...");
                SimulateModelCheckThread.this.parent.notifyEventListeners(new GUIComputationEvent(0, SimulateModelCheckThread.this.parent));
            }
        });
        for (int i = 0; i < this.guiProps.size(); ++i) {
            object = this.guiProps.get(i);
            ((GUIProperty)object).setStatus(1);
            this.parent.repaintList();
        }
        if (bl) {
            Object object2;
            Result[] resultArray = null;
            object = null;
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            ArrayList<IconThread> arrayList2 = new ArrayList<IconThread>();
            for (int i = 0; i < this.guiProps.size(); ++i) {
                object2 = this.guiProps.get(i);
                arrayList.add(((GUIProperty)object2).getProperty());
                IconThread iconThread = new IconThread((GUIProperty)object2);
                iconThread.start();
                arrayList2.add(iconThread);
            }
            try {
                State state = this.info.getInitialState() == null ? null : new State(this.info.getInitialState(), this.prism.getPRISMModel());
                resultArray = this.prism.modelCheckSimulatorSimultaneously(this.pf, arrayList, this.definedPFConstants, state, this.maxPathLength, simulationMethod);
                simulationMethod.reset();
            }
            catch (Exception exception) {
                object = exception;
                this.error(exception);
            }
            catch (StackOverflowError stackOverflowError) {
                object = new PrismException("Stack overflow");
                this.error(stackOverflowError);
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                object2 = (IconThread)arrayList2.get(i);
                ((Thread)object2).interrupt();
                while (!((IconThread)object2).canContinue) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
            ModelType modelType = this.prism.getModelType();
            object2 = "Simulation";
            if (modelType.nondeterministic() && modelType.removeNondeterminism() != modelType) {
                object2 = (String)object2 + " (nondeterminism in " + modelType.name() + " resolved uniformly)";
            }
            for (int i = 0; i < this.guiProps.size(); ++i) {
                GUIProperty gUIProperty = this.guiProps.get(i);
                gUIProperty.setResult(resultArray == null ? new Result(object) : resultArray[i]);
                gUIProperty.setMethodString((String)object2);
                gUIProperty.setNumberOfWarnings(this.prism.getMainLog().getNumberOfWarnings());
            }
        } else {
            Result result = null;
            for (int i = 0; i < this.pf.getNumProperties(); ++i) {
                GUIProperty gUIProperty = this.guiProps.get(i);
                IconThread iconThread = new IconThread(gUIProperty);
                iconThread.start();
                try {
                    State state = this.info.getInitialState() == null ? null : new State(this.info.getInitialState(), this.prism.getPRISMModel());
                    result = this.prism.modelCheckSimulator(this.pf, this.pf.getProperty(i), this.definedPFConstants, state, this.maxPathLength, simulationMethod);
                    simulationMethod.reset();
                }
                catch (Exception exception) {
                    result = new Result(exception);
                    this.error(exception);
                }
                catch (StackOverflowError stackOverflowError) {
                    result = new Result(new PrismException("Stack overflow"));
                    this.error(stackOverflowError);
                }
                iconThread.interrupt();
                while (!iconThread.canContinue) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                gUIProperty.setResult(result);
                gUIProperty.setMethodString("Simulation");
                this.parent.repaintList();
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimulateModelCheckThread.this.parent.stopProgress();
                SimulateModelCheckThread.this.parent.setTaskBarText("Checking properties using simulation... done.");
                SimulateModelCheckThread.this.parent.notifyEventListeners(new GUIComputationEvent(1, SimulateModelCheckThread.this.parent));
                SimulateModelCheckThread.this.parent.notifyEventListeners(new GUIPropertiesEvent(6));
            }
        });
    }

    class IconThread
    extends Thread {
        GUIProperty gp;
        ImageIcon[] images;
        boolean canContinue = false;

        public IconThread(GUIProperty gUIProperty) {
            this.gp = gUIProperty;
            this.images = new ImageIcon[8];
            this.images[0] = GUIPrism.getIconFromImage("smallClockAnim1.png");
            this.images[1] = GUIPrism.getIconFromImage("smallClockAnim2.png");
            this.images[2] = GUIPrism.getIconFromImage("smallClockAnim3.png");
            this.images[3] = GUIPrism.getIconFromImage("smallClockAnim4.png");
            this.images[4] = GUIPrism.getIconFromImage("smallClockAnim5.png");
            this.images[5] = GUIPrism.getIconFromImage("smallClockAnim6.png");
            this.images[6] = GUIPrism.getIconFromImage("smallClockAnim7.png");
            this.images[7] = GUIPrism.getIconFromImage("smallClockAnim8.png");
        }

        @Override
        public void run() {
            try {
                int n = 0;
                while (!IconThread.interrupted() && this.gp != null) {
                    ++n;
                    this.gp.setDoingImage(this.images[n %= 8]);
                    SimulateModelCheckThread.this.parent.repaintList();
                    IconThread.sleep(150L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.canContinue = true;
            }
        }
    }
}

