/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import parser.PrismParser;
import parser.ast.PropertiesFile;
import prism.Prism;
import userinterface.properties.GUIMultiProperties;
import userinterface.properties.GUIPropConstantList;
import userinterface.properties.GUIPropLabelList;
import userinterface.properties.GUIProperty;

public class GUIPropertiesList
extends JList
implements KeyListener {
    private static int counter = 0;
    private Prism prism;
    private GUIMultiProperties parent;
    private DefaultListModel listModel;
    private PictureCellRenderer rend;

    public GUIPropertiesList(Prism prism, GUIMultiProperties gUIMultiProperties) {
        this.prism = prism;
        this.parent = gUIMultiProperties;
        this.listModel = new DefaultListModel();
        this.setModel(this.listModel);
        this.rend = new PictureCellRenderer();
        this.setCellRenderer(this.rend);
        this.addKeyListener(this);
        this.setSelectionMode(2);
        this.getInputMap().put(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "none");
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (font != null) {
            this.setFixedCellHeight(Math.max(20, this.getFontMetrics(font).getHeight() + 4));
        }
    }

    public int getNumProperties() {
        return this.listModel.size();
    }

    public GUIProperty getProperty(int n) {
        return (GUIProperty)this.listModel.getElementAt(n);
    }

    public List<GUIProperty> getAllNamedProperties() {
        ArrayList<GUIProperty> arrayList = new ArrayList<GUIProperty>();
        for (int i = 0; i < this.getNumProperties(); ++i) {
            if (this.getProperty(i).getName() == null) continue;
            arrayList.add(this.getProperty(i));
        }
        return arrayList;
    }

    public GUIProperty getPropertyByName(String string) {
        for (int i = 0; i < this.getNumProperties(); ++i) {
            GUIProperty gUIProperty = this.getProperty(i);
            if (gUIProperty.getName() == null || !gUIProperty.getName().equals(string)) continue;
            return gUIProperty;
        }
        return null;
    }

    public boolean allPropertiesAreValid() {
        for (int i = 0; i < this.getNumProperties(); ++i) {
            if (this.getProperty(i).isValid()) continue;
            return false;
        }
        return true;
    }

    public int getNumSelectedProperties() {
        return this.getSelectedIndices().length;
    }

    public ArrayList<GUIProperty> getSelectedProperties() {
        ArrayList<GUIProperty> arrayList = new ArrayList<GUIProperty>();
        int[] nArray = this.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.getProperty(nArray[i]));
        }
        return arrayList;
    }

    public boolean existsValidSelectedProperties() {
        if (this.parent.getParsedModel() == null) {
            return false;
        }
        int[] nArray = this.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.getProperty(nArray[i]).isValid()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<GUIProperty> getValidSelectedProperties() {
        ArrayList<GUIProperty> arrayList = new ArrayList<GUIProperty>();
        if (this.parent.getParsedModel() == null) {
            return arrayList;
        }
        int[] nArray = this.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            GUIProperty gUIProperty = this.getProperty(nArray[i]);
            if (!gUIProperty.isValid()) continue;
            arrayList.add(gUIProperty);
        }
        return arrayList;
    }

    public String getValidSelectedAndReferencedString() {
        Object object;
        Object object3 = "";
        ArrayList<GUIProperty> arrayList = this.getValidSelectedProperties();
        Vector<String> vector = new Vector<String>();
        for (GUIProperty gUIProperty : arrayList) {
            vector.add(gUIProperty.getName());
        }
        for (GUIProperty gUIProperty : arrayList) {
            for (String object22 : gUIProperty.getReferencedNames()) {
                if (vector.contains(object22)) continue;
                vector.add(object22);
            }
        }
        Vector vector2 = new Vector();
        for (int i = arrayList.size(); i < vector.size(); ++i) {
            object = this.getPropertyByName((String)vector.get(i));
            if (object == null) continue;
            vector2.add(object);
            for (String string : ((GUIProperty)object).getReferencedNames()) {
                if (vector.contains(string)) continue;
                vector.add(string);
            }
        }
        object = "";
        Iterator iterator = vector2.iterator();
        while (iterator.hasNext()) {
            GUIProperty gUIProperty = (GUIProperty)iterator.next();
            object = (String)object + "\"" + gUIProperty.getName() + "\" : " + gUIProperty.getPropString() + "\n";
        }
        for (GUIProperty gUIProperty : arrayList) {
            if (gUIProperty.getName() != null) {
                object3 = (String)object3 + "\"" + gUIProperty.getName() + "\" : ";
            }
            object3 = (String)object3 + gUIProperty.getPropString() + "\n";
        }
        return (String)object + (String)object3;
    }

    public boolean existsValidSimulatableSelectedProperties() {
        if (this.parent.getParsedModel() == null) {
            return false;
        }
        int[] nArray = this.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.getProperty(nArray[i]).isValidForSimulation()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<GUIProperty> getValidSimulatableSelectedProperties() {
        ArrayList<GUIProperty> arrayList = new ArrayList<GUIProperty>();
        if (this.parent.getParsedModel() == null) {
            return arrayList;
        }
        int[] nArray = this.getSelectedIndices();
        for (int i = 0; i < nArray.length; ++i) {
            GUIProperty gUIProperty = this.getProperty(nArray[i]);
            if (!gUIProperty.isValidForSimulation()) continue;
            arrayList.add(gUIProperty);
        }
        return arrayList;
    }

    public int getIndexOf(String string) {
        int n = -1;
        for (int i = 0; i < this.getNumProperties(); ++i) {
            String string2 = this.getProperty(i).getID();
            if (!string.equals(string2)) continue;
            n = i;
            break;
        }
        return n;
    }

    public String getClipboardString() {
        int[] nArray = this.getSelectedIndices();
        Object object = "";
        for (int i = 0; i < nArray.length; ++i) {
            GUIProperty gUIProperty = this.getProperty(i);
            object = (String)object + gUIProperty.getPropString();
            if (i == nArray.length - 1) continue;
            object = (String)object + "\n";
        }
        return object;
    }

    public void addProperty(String string, String string2) {
        if (string.matches("\"[^\"]*\"[ ]*:.*")) {
            int n = string.indexOf(34) + 1;
            int n2 = string.indexOf(34, n);
            String string3 = string.substring(n, n2);
            int n3 = string.indexOf(58) + 1;
            String string4 = string.substring(n3).trim();
            this.addProperty(string3, string4, string2);
        } else {
            this.addProperty(null, string, string2);
        }
    }

    public void addProperty(String string, String string2, String string3) {
        GUIProperty gUIProperty = new GUIProperty(this.prism, this, "PROPERTY" + ++counter, string2, string, string3);
        this.listModel.addElement(gUIProperty);
        this.validateProperties();
    }

    public void setProperty(int n, String string, String string2, String string3) {
        GUIProperty gUIProperty = new GUIProperty(this.prism, this, "PROPERTY" + ++counter, string2, string, string3);
        this.listModel.setElementAt(gUIProperty, n);
        this.validateProperties();
    }

    public void pastePropertiesString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf("//") == 0) continue;
            this.addProperty(string2, "");
        }
    }

    public void addPropertiesFile(PropertiesFile propertiesFile) {
        for (int i = 0; i < propertiesFile.getNumProperties(); ++i) {
            String string = propertiesFile.getPropertyName(i);
            String string2 = propertiesFile.getProperty(i).toString();
            String string3 = propertiesFile.getPropertyComment(i);
            this.addProperty(string, string2, string3);
        }
    }

    public boolean deleteProperty(int n) {
        GUIProperty gUIProperty = this.getProperty(n);
        if (!gUIProperty.isBeingEdited()) {
            this.listModel.removeElementAt(n);
            this.validateProperties();
            return true;
        }
        return false;
    }

    public void deleteSelected() {
        while (!this.isSelectionEmpty()) {
            boolean bl = this.deleteProperty(this.getSelectedIndex());
            if (bl) continue;
            int[] nArray = this.getSelectedIndices();
            int[] nArray2 = new int[nArray.length - 1];
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == this.getSelectedIndex()) continue;
                nArray2[n] = nArray[i];
                ++n;
            }
            this.setSelectedIndices(nArray2);
        }
    }

    public void deleteAll() {
        this.selectAll();
        this.deleteSelected();
    }

    public void selectAll() {
        if (this.getNumProperties() > 0) {
            this.setSelectionInterval(0, this.getNumProperties() - 1);
        }
    }

    public void validateProperties() {
        int n;
        ArrayList<GUIProperty> arrayList = new ArrayList<GUIProperty>();
        for (n = 0; n < this.getNumProperties(); ++n) {
            GUIProperty gUIProperty = this.getProperty(n);
            gUIProperty.makeInvalid();
            arrayList.add(gUIProperty);
        }
        do {
            n = 0;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                GUIProperty gUIProperty = (GUIProperty)arrayList.get(n2);
                gUIProperty.parse(this.parent.getConstantsString(), this.parent.getLabelsString());
                if (gUIProperty.isValid()) {
                    arrayList.remove(n2);
                    n = 1;
                    continue;
                }
                ++n2;
            }
        } while (n != 0 && arrayList.size() > 0);
        this.repaint();
    }

    public String toFileString(File file, GUIPropConstantList gUIPropConstantList, GUIPropLabelList gUIPropLabelList) {
        Object object = "";
        if (gUIPropConstantList.getNumConstants() > 0) {
            object = (String)object + gUIPropConstantList.getConstantsString() + "\n";
        }
        if (gUIPropLabelList.getNumLabels() > 0) {
            object = (String)object + gUIPropLabelList.getLabelsString() + "\n";
        }
        int n = this.getNumProperties();
        for (int i = 0; i < n; ++i) {
            GUIProperty gUIProperty = this.getProperty(i);
            if (gUIProperty.getComment().length() > 0) {
                object = (String)object + PrismParser.slashCommentBlock(gUIProperty.getComment());
            }
            object = (String)object + gUIProperty.getPropString() + "\n\n";
        }
        return object;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getModifiers() == 2) {
            if (keyEvent.getKeyCode() == 67) {
                this.parent.a_copy();
            } else if (keyEvent.getKeyCode() == 86) {
                this.parent.a_paste();
            } else if (keyEvent.getKeyCode() == 88) {
                this.parent.a_cut();
            } else if (keyEvent.getKeyCode() == 68) {
                this.parent.a_delete();
            } else if (keyEvent.getKeyCode() == 65) {
                this.parent.a_selectAll();
            }
        }
        if (keyEvent.getKeyCode() == 127) {
            this.parent.a_delete();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    class PictureCellRenderer
    extends JLabel
    implements ListCellRenderer {
        String toolTip = "";

        public PictureCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public String getToolTipText() {
            return this.toolTip;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBorder(new BottomBorder());
            GUIProperty gUIProperty = GUIPropertiesList.this.getProperty(n);
            this.toolTip = gUIProperty.getToolTipText();
            this.setText(gUIProperty.toString());
            this.setIcon(gUIProperty.getImage());
            if (bl) {
                this.setBackground(GUIPropertiesList.this.parent.getSelectionColor());
                this.setForeground(gUIProperty.isValid() ? Color.black : Color.red);
            } else if (!gUIProperty.isValid()) {
                this.setBackground(GUIPropertiesList.this.parent.getWarningColor());
                this.setForeground(Color.red);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            if (gUIProperty.isBeingEdited()) {
                this.setBackground(Color.lightGray);
            }
            return this;
        }
    }

    class BottomBorder
    implements Border {
        BottomBorder() {
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
        }
    }
}

