/*
 * Decompiled with CFR 0.152.
 */
package userinterface.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import userinterface.GUIPrism;
import userinterface.graph.Graph;

public class GUIImageExportDialog
extends JDialog
implements DocumentListener {
    private Action okAction;
    private Action cancelAction;
    private GUIPrism gui;
    private int exportWidth;
    private int exportHeight;
    private boolean cancelled;
    public static final int JPEG = 0;
    public static final int PNG = 1;
    public static final int EPS = 2;
    private JPanel allPanel;
    private JCheckBox alphaInputField;
    private JLabel alphaInputLabel;
    private JPanel bottomPanel;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JTextField heightInputField;
    private JLabel heightInputLabel;
    private JComboBox imageTypeInputField;
    private JLabel imageTypeInputLabel;
    private JPanel innerTopPanel;
    private JButton okayButton;
    private JPanel topPanel;
    private JLabel warningLabel;
    private JTextField widthInputField;
    private JLabel widthInputLabel;

    public GUIImageExportDialog(GUIPrism gUIPrism, Graph graph, int n) {
        super(gUIPrism, "Provide rendering information", true);
        this.exportWidth = graph.getWidth();
        this.exportHeight = graph.getHeight();
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okayButton);
        this.cancelled = false;
        this.warningLabel.setIcon(GUIPrism.getIconFromImage("smallError.png"));
        this.warningLabel.setVisible(false);
        this.widthInputField.getDocument().addDocumentListener(this);
        this.heightInputField.getDocument().addDocumentListener(this);
        this.widthInputField.setText("" + this.exportWidth);
        this.heightInputField.setText("" + this.exportHeight);
        this.imageTypeInputField.setSelectedIndex(n);
        this.alphaInputField.setSelected(false);
        this.alphaInputField.setEnabled(n == 1);
        this.alphaInputLabel.setEnabled(n == 1);
        super.setBounds(new Rectangle(550, 300));
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    private void initComponents() {
        this.allPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.warningLabel = new JLabel();
        this.buttonPanel = new JPanel();
        this.okayButton = new JButton();
        this.cancelButton = new JButton();
        this.topPanel = new JPanel();
        this.innerTopPanel = new JPanel();
        this.widthInputLabel = new JLabel();
        this.widthInputField = new JTextField();
        this.heightInputLabel = new JLabel();
        this.heightInputField = new JTextField();
        this.imageTypeInputLabel = new JLabel();
        this.imageTypeInputField = new JComboBox();
        this.alphaInputLabel = new JLabel();
        this.alphaInputField = new JCheckBox();
        this.setMinimumSize(new Dimension(550, 350));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIImageExportDialog.this.closeDialog(windowEvent);
            }
        });
        this.allPanel.setLayout(new BorderLayout());
        this.allPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.bottomPanel.setLayout(new BorderLayout());
        this.warningLabel.setText("Please enter positive integers for width and height.");
        this.warningLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.bottomPanel.add((Component)this.warningLabel, "Center");
        this.warningLabel.getAccessibleContext().setAccessibleName("Please enter a positive integer for both width and height.");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIImageExportDialog.this.okayButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okayButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIImageExportDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.bottomPanel.add((Component)this.buttonPanel, "East");
        this.allPanel.add((Component)this.bottomPanel, "South");
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.setBorder(BorderFactory.createTitledBorder("Image properties"));
        this.topPanel.setMinimumSize(new Dimension(400, 200));
        this.topPanel.setPreferredSize(new Dimension(400, 200));
        this.innerTopPanel.setLayout(new GridLayout(4, 2, 5, 5));
        this.innerTopPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.widthInputLabel.setText("Width:");
        this.innerTopPanel.add(this.widthInputLabel);
        this.innerTopPanel.add(this.widthInputField);
        this.heightInputLabel.setText("Height:");
        this.innerTopPanel.add(this.heightInputLabel);
        this.innerTopPanel.add(this.heightInputField);
        this.imageTypeInputLabel.setText("Image format:");
        this.innerTopPanel.add(this.imageTypeInputLabel);
        this.imageTypeInputField.setModel(new DefaultComboBoxModel<String>(new String[]{"JPEG", "PNG", "EPS"}));
        this.imageTypeInputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIImageExportDialog.this.imageTypeInputFieldActionPerformed(actionEvent);
            }
        });
        this.innerTopPanel.add(this.imageTypeInputField);
        this.alphaInputLabel.setText("Transparent background:");
        this.innerTopPanel.add(this.alphaInputLabel);
        this.alphaInputField.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.alphaInputField.setMargin(new Insets(0, 0, 0, 0));
        this.innerTopPanel.add(this.alphaInputField);
        this.topPanel.add((Component)this.innerTopPanel, "North");
        this.allPanel.add((Component)this.topPanel, "Center");
        this.getContentPane().add((Component)this.allPanel, "Center");
    }

    private void imageTypeInputFieldActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.imageTypeInputField.getSelectedIndex() == 1;
        this.alphaInputField.setEnabled(bl);
        this.alphaInputLabel.setEnabled(bl);
    }

    private void okayButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancelled = true;
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public int getImageType() {
        return this.imageTypeInputField.getSelectedIndex();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getExportWidth() {
        return this.exportWidth;
    }

    public int getExportHeight() {
        return this.exportHeight;
    }

    public boolean getAlpha() {
        return this.alphaInputField.isSelected();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        try {
            this.exportWidth = Integer.parseInt(this.widthInputField.getText());
            if (this.exportWidth <= 0) {
                throw new NumberFormatException();
            }
            this.exportHeight = Integer.parseInt(this.heightInputField.getText());
            if (this.exportHeight <= 0) {
                throw new NumberFormatException();
            }
            this.warningLabel.setVisible(false);
            this.okayButton.setEnabled(true);
        }
        catch (NumberFormatException numberFormatException) {
            this.warningLabel.setVisible(true);
            this.okayButton.setEnabled(false);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }
}

