/*
 * Decompiled with CFR 0.152.
 */
package userinterface;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import prism.PrismSettings;
import userinterface.GUIClipboardEvent;
import userinterface.GUIPlugin;
import userinterface.GUIPrism;
import userinterface.util.GUIEvent;
import userinterface.util.GUIEventListener;
import userinterface.util.GUIUndoManager;
import userinterface.util.GUIUndoManagerEvent;

public class GUIClipboard
extends GUIPlugin {
    private GUIPrism prism;
    private GUIPlugin plugin;
    private GUIUndoManager undoManager;
    private JMenu editMenu;
    private JToolBar editToolBar;
    private Action actionUndo;
    private Action actionRedo;
    private Action actionCut;
    private Action actionCopy;
    private Action actionPaste;
    private Action actionDelete;
    private Action actionSelectAll;

    public GUIClipboard(GUIPrism gUIPrism) {
        super(gUIPrism, false);
        this.prism = gUIPrism;
        this.initComponents();
        this.doUndoManagerEnables();
        this.doClipboardEnables();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.addFlavorListener(new FlavorListener(){

            @Override
            public void flavorsChanged(FlavorEvent flavorEvent) {
                GUIClipboard.this.doClipboardEnables();
            }
        });
    }

    public void pluginChanged(GUIPlugin gUIPlugin) {
        if (gUIPlugin != null) {
            gUIPlugin.getSelectionChangeHandler().clear();
        }
        if (this.undoManager != null) {
            this.undoManager.clear();
        }
        this.plugin = null;
        this.undoManager = null;
        if (gUIPlugin != null) {
            this.plugin = gUIPlugin;
            this.plugin.getSelectionChangeHandler().addListener(new GUIEventListener(){

                @Override
                public boolean processGUIEvent(GUIEvent gUIEvent) {
                    GUIClipboard.this.doClipboardEnables();
                    return true;
                }
            });
            if (gUIPlugin.getUndoManager() != null) {
                this.undoManager = gUIPlugin.getUndoManager();
                this.undoManager.addListener(new GUIEventListener(){

                    @Override
                    public boolean processGUIEvent(GUIEvent gUIEvent) {
                        if (gUIEvent instanceof GUIUndoManagerEvent) {
                            GUIClipboard.this.doUndoManagerEnables();
                            return true;
                        }
                        return false;
                    }
                });
            }
        }
        this.doUndoManagerEnables();
        this.doClipboardEnables();
    }

    private void doClipboardEnables() {
        this.actionCopy.setEnabled(this.plugin != null && this.plugin.canDoClipBoardAction(this.actionCopy));
        this.actionCut.setEnabled(this.plugin != null && this.plugin.canDoClipBoardAction(this.actionCut));
        this.actionPaste.setEnabled(this.plugin != null && this.plugin.canDoClipBoardAction(this.actionPaste));
        this.actionDelete.setEnabled(this.plugin != null && this.plugin.canDoClipBoardAction(this.actionDelete));
        this.actionSelectAll.setEnabled(this.plugin != null && this.plugin.canDoClipBoardAction(this.actionSelectAll));
    }

    @Override
    public void takeCLArgs(String[] stringArray) {
    }

    @Override
    public boolean displaysTab() {
        return false;
    }

    @Override
    public JMenu getMenu() {
        return this.editMenu;
    }

    @Override
    public String getTabText() {
        return "";
    }

    @Override
    public JToolBar getToolBar() {
        return this.editToolBar;
    }

    @Override
    public String getXMLIDTag() {
        return null;
    }

    @Override
    public Object getXMLSaveTree() {
        return null;
    }

    @Override
    public void loadXML(Object object) {
    }

    @Override
    public boolean processGUIEvent(GUIEvent gUIEvent) {
        return false;
    }

    public void doUndoManagerEnables() {
        this.actionUndo.setEnabled(this.undoManager != null && this.undoManager.canUndo());
        this.actionRedo.setEnabled(this.undoManager != null && this.undoManager.canRedo());
    }

    private void initComponents() {
        this.setupActions();
        this.editMenu = new JMenu();
        this.editMenu.setMnemonic(69);
        this.editMenu.setText("Edit");
        this.editMenu.add(new JMenuItem(this.actionUndo));
        this.editMenu.add(new JMenuItem(this.actionRedo));
        this.editMenu.add(new JSeparator());
        this.editMenu.add(new JMenuItem(this.actionCut));
        this.editMenu.add(new JMenuItem(this.actionCopy));
        this.editMenu.add(new JMenuItem(this.actionPaste));
        this.editMenu.add(new JMenuItem(this.actionDelete));
        this.editMenu.add(new JSeparator());
        this.editMenu.add(new JMenuItem(this.actionSelectAll));
        this.editToolBar = new JToolBar();
        JButton jButton = new JButton(this.actionUndo);
        jButton.setToolTipText("Undo");
        jButton.setText("");
        this.editToolBar.add(jButton);
        JButton jButton2 = new JButton(this.actionRedo);
        jButton2.setToolTipText("Redo");
        jButton2.setText("");
        this.editToolBar.add(jButton2);
        JButton jButton3 = new JButton(this.actionCut);
        jButton3.setToolTipText("Cut");
        jButton3.setText("");
        this.editToolBar.add(jButton3);
        JButton jButton4 = new JButton(this.actionCopy);
        jButton4.setToolTipText("Copy");
        jButton4.setText("");
        this.editToolBar.add(jButton4);
        JButton jButton5 = new JButton(this.actionPaste);
        jButton5.setToolTipText("Paste");
        jButton5.setText("");
        this.editToolBar.add(jButton5);
        JButton jButton6 = new JButton(this.actionDelete);
        jButton6.setToolTipText("Delete");
        jButton6.setText("");
        this.editToolBar.add(jButton6);
        JButton jButton7 = new JButton(this.actionSelectAll);
        jButton7.setToolTipText("Select all");
        jButton7.setText("");
        this.editToolBar.add(jButton7);
        this.editToolBar.setFloatable(false);
    }

    private void setupActions() {
        this.actionUndo = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIClipboard.this.notifyEventListeners(new GUIClipboardEvent(5, GUIClipboard.this.getFocussedComponent()));
            }
        };
        this.actionUndo.putValue("LongDescription", "Undo the last edit.");
        this.actionUndo.putValue("MnemonicKey", 85);
        this.actionUndo.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.actionUndo.putValue("Name", "Undo");
        this.actionUndo.putValue("SmallIcon", GUIPrism.getIconFromImage("smallUndo.png"));
        this.actionRedo = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIClipboard.this.notifyEventListeners(new GUIClipboardEvent(6, GUIClipboard.this.getFocussedComponent()));
            }
        };
        this.actionRedo.putValue("LongDescription", "Redo the last edit.");
        this.actionRedo.putValue("MnemonicKey", 82);
        this.actionRedo.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.actionRedo.putValue("Name", "Redo");
        this.actionRedo.putValue("SmallIcon", GUIPrism.getIconFromImage("smallRedo.png"));
        this.actionCut = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIClipboard.this.notifyEventListeners(new GUIClipboardEvent(1, GUIClipboard.this.getFocussedComponent()));
            }
        };
        this.actionCut.putValue("LongDescription", "Copys the currently selected item/text to the clipboard and then removes it.");
        this.actionCut.putValue("MnemonicKey", 67);
        this.actionCut.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.actionCut.putValue("Name", "Cut");
        this.actionCut.putValue("SmallIcon", GUIPrism.getIconFromImage("smallCut.png"));
        this.actionCopy = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIClipboard.this.notifyEventListeners(new GUIClipboardEvent(0, GUIClipboard.this.getFocussedComponent()));
            }
        };
        this.actionCopy.putValue("LongDescription", "Copys the currently selected item/text to the clipboard.");
        this.actionCopy.putValue("MnemonicKey", 79);
        this.actionCopy.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.actionCopy.putValue("Name", "Copy");
        this.actionCopy.putValue("SmallIcon", GUIPrism.getIconFromImage("smallCopy.png"));
        this.actionPaste = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIClipboard.this.notifyEventListeners(new GUIClipboardEvent(2, GUIClipboard.this.getFocussedComponent()));
            }
        };
        this.actionPaste.putValue("LongDescription", "Pastes the contents of the clipboard.");
        this.actionPaste.putValue("MnemonicKey", 80);
        this.actionPaste.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.actionPaste.putValue("Name", "Paste");
        this.actionPaste.putValue("SmallIcon", GUIPrism.getIconFromImage("smallPaste.png"));
        this.actionDelete = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIClipboard.this.notifyEventListeners(new GUIClipboardEvent(3, GUIClipboard.this.getFocussedComponent()));
            }
        };
        this.actionDelete.putValue("LongDescription", "Removes the currently selected item");
        this.actionDelete.putValue("MnemonicKey", 68);
        this.actionDelete.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.actionDelete.putValue("Name", "Delete");
        this.actionDelete.putValue("SmallIcon", GUIPrism.getIconFromImage("smallDelete.png"));
        this.actionSelectAll = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIClipboard.this.notifyEventListeners(new GUIClipboardEvent(4, GUIClipboard.this.getFocussedComponent()));
            }
        };
        this.actionSelectAll.putValue("LongDescription", "Selects all items of the focussed component.");
        this.actionSelectAll.putValue("MnemonicKey", 83);
        this.actionSelectAll.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.actionSelectAll.putValue("Name", "Select all");
        this.actionSelectAll.putValue("SmallIcon", GUIPrism.getIconFromImage("smallSelectAll.png"));
    }

    @Override
    public void notifySettings(PrismSettings prismSettings) {
    }

    public Action getUndoAction() {
        return this.actionUndo;
    }

    public Action getRedoAction() {
        return this.actionRedo;
    }

    public Action getCutAction() {
        return this.actionCut;
    }

    public Action getCopyAction() {
        return this.actionCopy;
    }

    public Action getPasteAction() {
        return this.actionPaste;
    }

    public Action getDeleteAction() {
        return this.actionDelete;
    }

    public Action getSelectAllAction() {
        return this.actionSelectAll;
    }
}

