/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import parser.EvaluateContextState;
import parser.State;
import parser.VarList;
import parser.ast.Command;
import parser.ast.Expression;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.Update;
import parser.ast.Updates;
import parser.type.TypeClock;
import prism.Evaluator;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import simulator.ChoiceListFlexi;
import simulator.TransitionList;

public class Updater<Value>
extends PrismComponent {
    public Evaluator<Value> eval;
    protected EvaluateContextState ec;
    protected boolean doProbChecks = true;
    protected ModulesFile modulesFile;
    protected ModelType modelType;
    protected int numModules;
    protected VarList varList;
    protected List<String> synchs;
    protected int numSynchs;
    protected int[] synchModuleCounts;
    protected int numRewardStructs;
    protected BitSet clockVars;
    protected List<List<List<Updates>>> updateLists;
    protected BitSet enabledSynchs;
    protected BitSet[] enabledModules;
    protected Map<Updates, Expression> clockGuards;

    public Updater(ModulesFile modulesFile, VarList varList, Evaluator<Value> evaluator) {
        this(modulesFile, varList, evaluator, null);
    }

    public Updater(ModulesFile modulesFile, VarList varList, Evaluator<Value> evaluator, PrismComponent prismComponent) {
        int n;
        this.doProbChecks = prismComponent.getSettings().getBoolean("prism.doProbChecks");
        this.modulesFile = modulesFile;
        this.modelType = modulesFile.getModelType();
        this.numModules = modulesFile.getNumModules();
        this.synchs = modulesFile.getSynchs();
        this.numSynchs = this.synchs.size();
        this.numRewardStructs = modulesFile.getNumRewardStructs();
        this.varList = varList;
        this.eval = evaluator;
        this.ec = new EvaluateContextState(modulesFile.getConstantValues(), new State(modulesFile.getNumVars()));
        this.ec.setEvaluationMode(evaluator.evalMode());
        if (this.modelType.realTime()) {
            int n2 = varList.getNumVars();
            this.clockVars = new BitSet();
            for (n = 0; n < n2; ++n) {
                if (!(varList.getType(n) instanceof TypeClock)) continue;
                this.clockVars.set(n);
            }
        }
        ArrayList<HashSet<String>> arrayList = new ArrayList<HashSet<String>>(this.numModules);
        for (n = 0; n < this.numModules; ++n) {
            arrayList.add(new HashSet<String>(modulesFile.getModule(n).getAllSynchs()));
        }
        this.synchModuleCounts = new int[this.numSynchs];
        for (n = 0; n < this.numSynchs; ++n) {
            this.synchModuleCounts[n] = 0;
            String string = this.synchs.get(n);
            for (int i = 0; i < this.numModules; ++i) {
                if (!((HashSet)arrayList.get(i)).contains(string)) continue;
                int n3 = n;
                this.synchModuleCounts[n3] = this.synchModuleCounts[n3] + 1;
            }
        }
        this.updateLists = new ArrayList<List<List<Updates>>>(this.numModules);
        for (n = 0; n < this.numModules; ++n) {
            this.updateLists.add(new ArrayList(this.numSynchs + 1));
            for (int i = 0; i < this.numSynchs + 1; ++i) {
                this.updateLists.get(n).add(new ArrayList());
            }
        }
        this.enabledSynchs = new BitSet(this.numSynchs + 1);
        this.enabledModules = new BitSet[this.numSynchs + 1];
        for (n = 0; n < this.numSynchs + 1; ++n) {
            this.enabledModules[n] = new BitSet(this.numModules);
        }
        this.clockGuards = new HashMap<Updates, Expression>();
    }

    public void calculateTransitions(State state, TransitionList<Value> transitionList) throws PrismException {
        Object object;
        ChoiceListFlexi<Value> choiceListFlexi3;
        int n;
        int n2;
        transitionList.clear();
        for (n2 = 0; n2 < this.numModules; ++n2) {
            for (n = 0; n < this.numSynchs + 1; ++n) {
                this.updateLists.get(n2).get(n).clear();
            }
        }
        this.enabledSynchs.clear();
        for (n2 = 0; n2 < this.numSynchs + 1; ++n2) {
            this.enabledModules[n2].clear();
        }
        this.clockGuards.clear();
        for (n2 = 0; n2 < this.numModules; ++n2) {
            this.calculateUpdatesForModule(n2, state);
        }
        n2 = this.enabledModules[0].nextSetBit(0);
        while (n2 >= 0) {
            for (Updates object2 : this.updateLists.get(n2).get(0)) {
                choiceListFlexi3 = this.processUpdatesAndCreateNewChoice(-(n2 + 1), object2, state);
                if (choiceListFlexi3.size() <= 0) continue;
                transitionList.add(choiceListFlexi3);
            }
            n2 = this.enabledModules[0].nextSetBit(n2 + 1);
        }
        ArrayList arrayList = new ArrayList();
        n2 = this.enabledSynchs.nextSetBit(1);
        while (n2 >= 0) {
            arrayList.clear();
            if (this.enabledModules[n2].cardinality() >= this.synchModuleCounts[n2 - 1]) {
                n = this.enabledModules[n2].nextSetBit(0);
                while (n >= 0) {
                    int n3 = this.updateLists.get(n).get(n2).size();
                    if (n3 == 1) {
                        object = this.updateLists.get(n).get(n2).get(0);
                        if (arrayList.size() == 0) {
                            ChoiceListFlexi<Value> choiceListFlexi2 = this.processUpdatesAndCreateNewChoice(n2, (Updates)object, state);
                            if (choiceListFlexi2.size() > 0) {
                                arrayList.add(choiceListFlexi2);
                            }
                        } else {
                            for (ChoiceListFlexi<Value> choiceListFlexi3 : arrayList) {
                                this.processUpdatesAndAddToProduct((Updates)object, state, choiceListFlexi3);
                            }
                        }
                    } else if (arrayList.size() == 0) {
                        for (Updates updates : this.updateLists.get(n).get(n2)) {
                            choiceListFlexi3 = this.processUpdatesAndCreateNewChoice(n2, updates, state);
                            if (choiceListFlexi3.size() <= 0) continue;
                            arrayList.add(choiceListFlexi3);
                        }
                    } else {
                        int n4;
                        int n5;
                        int n6 = arrayList.size();
                        for (n5 = 0; n5 < n3 - 1; ++n5) {
                            for (n4 = 0; n4 < n6; ++n4) {
                                arrayList.add(new ChoiceListFlexi((ChoiceListFlexi)arrayList.get(n4)));
                            }
                        }
                        for (n5 = 0; n5 < n3; ++n5) {
                            object = this.updateLists.get(n).get(n2).get(n5);
                            for (n4 = 0; n4 < n6; ++n4) {
                                this.processUpdatesAndAddToProduct((Updates)object, state, (ChoiceListFlexi)arrayList.get(n5 * n6 + n4));
                            }
                        }
                    }
                    n = this.enabledModules[n2].nextSetBit(n + 1);
                }
                for (ChoiceListFlexi choiceListFlexi4 : arrayList) {
                    transitionList.add(choiceListFlexi4);
                }
            }
            n2 = this.enabledSynchs.nextSetBit(n2 + 1);
        }
        if (this.modelType == ModelType.DTMC) {
            object = transitionList.getProbabilitySum();
            transitionList.scaleProbabilitiesBy(this.eval.divide((Iterator<Updates>)this.eval.one(), (Iterator<Updates>)object));
        }
    }

    protected void calculateUpdatesForModule(int n, State state) throws PrismLangException {
        Module module = this.modulesFile.getModule(n);
        int n2 = module.getNumCommands();
        for (int i = 0; i < n2; ++i) {
            Command command = module.getCommand(i);
            boolean bl = false;
            Expression expression = null;
            if (this.modelType.realTime()) {
                State state2 = new State(state);
                int n3 = this.clockVars.nextSetBit(0);
                while (n3 >= 0) {
                    state2.varValues[n3] = null;
                    n3 = this.clockVars.nextSetBit(n3 + 1);
                }
                expression = command.getGuard().deepCopy();
                if (!Expression.isFalse(expression = (Expression)expression.evaluatePartially(this.ec.setState(state2)).simplify())) {
                    bl = true;
                }
            } else {
                bl = command.getGuard().evaluateBoolean(this.ec.setState(state));
            }
            if (!bl) continue;
            int n4 = command.getSynchIndex();
            this.updateLists.get(n).get(n4).add(command.getUpdates());
            this.enabledSynchs.set(n4);
            this.enabledModules[n4].set(n);
            if (!this.modelType.realTime()) continue;
            this.clockGuards.put(command.getUpdates(), expression);
        }
    }

    protected Value getProbabilityInState(Updates updates, int n, State state) throws PrismLangException {
        Expression expression = updates.getProbability(n);
        if (expression == null) {
            return this.eval.one();
        }
        return this.eval.evaluate(expression, state);
    }

    private ChoiceListFlexi<Value> processUpdatesAndCreateNewChoice(int n, Updates updates, State state) throws PrismLangException {
        ChoiceListFlexi<Value> choiceListFlexi = new ChoiceListFlexi<Value>(this.eval);
        choiceListFlexi.setModuleOrActionIndex(n);
        int n2 = updates.getNumUpdates();
        Value Value2 = this.eval.zero();
        for (int i = 0; i < n2; ++i) {
            Value Value3 = this.getProbabilityInState(updates, i, state);
            if (!this.eval.isSymbolic()) {
                if (!this.eval.isFinite(Value3)) {
                    String string = this.modelType.probabilityOrRate() + " is not finite in state " + state.toString(this.modulesFile);
                    throw new PrismLangException(string, updates);
                }
                if (!this.eval.geq(Value3, this.eval.zero())) {
                    String string = this.modelType.probabilityOrRate() + " is negative in state " + state.toString(this.modulesFile);
                    throw new PrismLangException(string, updates);
                }
            }
            if (this.eval.isZero(Value3)) continue;
            Value2 = this.eval.add(Value2, Value3);
            ArrayList<Update> arrayList = new ArrayList<Update>();
            arrayList.add(updates.getUpdate(i));
            choiceListFlexi.add(Value3, arrayList);
        }
        if (choiceListFlexi.size() == 0) {
            Object object = this.modelType.probabilityOrRate();
            object = (String)object + (updates.getNumUpdates() > 1 ? " values sum to " : " is ");
            object = (String)object + "zero for updates in state " + state.toString(this.modulesFile);
            throw new PrismLangException((String)object, updates);
        }
        if (this.doProbChecks && choiceListFlexi.size() > 0 && this.modelType.choicesSumToOne() && !this.eval.isSymbolic()) {
            try {
                this.eval.checkProbabilitySum(Value2);
            }
            catch (PrismException prismException) {
                throw new PrismLangException(prismException.getMessage() + " in state " + state.toString(this.modulesFile), updates);
            }
        }
        if (this.modelType.realTime() && this.clockGuards.containsKey(updates)) {
            choiceListFlexi.setClockGuard(this.clockGuards.get(updates));
        }
        return choiceListFlexi;
    }

    private void processUpdatesAndAddToProduct(Updates updates, State state, ChoiceListFlexi<Value> choiceListFlexi) throws PrismLangException {
        ChoiceListFlexi<Value> choiceListFlexi2 = this.processUpdatesAndCreateNewChoice(0, updates, state);
        choiceListFlexi.productWith(choiceListFlexi2);
    }
}

