/*
 * Decompiled with CFR 0.152.
 */
package settings;

import settings.LongEditor;
import settings.LongRenderer;
import settings.NumericConstraint;
import settings.Setting;
import settings.SettingEditor;
import settings.SettingException;
import settings.SettingOwner;
import settings.SettingRenderer;

public class LongSetting
extends Setting {
    private static LongRenderer renderer;
    private static LongEditor editor;

    public LongSetting(String string, Long l, String string2, SettingOwner settingOwner, boolean bl) {
        super(string, (Object)l, string2, settingOwner, bl);
    }

    public LongSetting(String string, Long l, String string2, SettingOwner settingOwner, boolean bl, NumericConstraint numericConstraint) {
        super(string, l, string2, settingOwner, bl, numericConstraint);
    }

    @Override
    public SettingEditor getSettingEditor() {
        if (editor == null) {
            editor = new LongEditor();
        }
        return editor;
    }

    @Override
    public SettingRenderer getSettingRenderer() {
        if (renderer == null) {
            renderer = new LongRenderer();
        }
        return renderer;
    }

    @Override
    public Class getValueClass() {
        return Long.class;
    }

    public long getLongValue() {
        return (Long)this.getValue();
    }

    @Override
    public Object parseStringValue(String string) throws SettingException {
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SettingException("Error when parsing: " + string + " as a Long value.");
        }
    }

    @Override
    public String toString() {
        return "" + this.getLongValue();
    }
}

