/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import settings.FileSetting;
import settings.Setting;
import settings.SettingRenderer;
import userinterface.GUIPrism;

public class FileRenderer
implements SettingRenderer {
    private JLabel renderer;
    private JPanel panel;
    private ImageIcon warningIcon = GUIPrism.getIconFromImage("smallError.png");

    public FileRenderer() {
        this.panel = new JPanel(new BorderLayout());
        this.renderer = new JLabel();
        this.panel.add((Component)this.renderer, "Center");
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Setting setting, Object object, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        ArrayList arrayList;
        if (bl) {
            this.renderer.setForeground(jTable.getSelectionForeground());
            this.panel.setBackground(jTable.getSelectionBackground());
        } else {
            this.renderer.setForeground(jTable.getForeground());
            this.panel.setBackground(jTable.getBackground());
        }
        if (bl2) {
            this.renderer.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.renderer.setBorder(new EmptyBorder(1, 2, 2, 1));
        }
        if (object instanceof File) {
            File file = (File)object;
            this.renderer.setText(file.toString());
            this.renderer.setEnabled(bl3);
            if (setting instanceof FileSetting) {
                FileSetting fileSetting = (FileSetting)setting;
                if (!fileSetting.isValidFile()) {
                    this.renderer.setIcon(this.warningIcon);
                } else {
                    this.renderer.setIcon(null);
                }
            }
        } else if (object instanceof ArrayList && (arrayList = (ArrayList)object).size() > 0) {
            Object object2;
            File file = null;
            boolean bl4 = true;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(arrayList.get(i) instanceof File)) continue;
                object2 = (File)arrayList.get(i);
                if (file != null) {
                    if (!((File)object2).equals(file)) {
                        bl4 = false;
                        break;
                    }
                    file = object2;
                    continue;
                }
                file = object2;
            }
            if (bl4) {
                File file2 = file;
                this.renderer.setText(file2.toString());
                this.renderer.setEnabled(bl3);
                if (setting instanceof FileSetting) {
                    object2 = (FileSetting)setting;
                    if (!((FileSetting)object2).isValidFile()) {
                        this.renderer.setIcon(this.warningIcon);
                    } else {
                        this.renderer.setIcon(null);
                    }
                }
            } else {
                this.renderer.setText("(Different values)");
                this.renderer.setEnabled(bl3);
                this.renderer.setBackground(Color.lightGray);
                this.panel.setBackground(Color.lightGray);
            }
        }
        return this.panel;
    }
}

