/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import settings.Setting;
import settings.SettingRenderer;

public class ColorRenderer
implements SettingRenderer {
    private JLabel renderer;
    private JPanel panel;
    private Font font = new Font("monospaced", 2, 12);
    private JPanel colourPanel;
    private JPanel blank1;
    private JPanel blank2;

    public ColorRenderer() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.renderer = new JLabel();
        this.colourPanel = new JPanel();
        this.renderer = new JLabel();
        this.blank2 = new JPanel();
        this.blank1 = new JPanel();
        this.panel.add((Component)this.renderer, "Center");
        this.blank2.setLayout(new FlowLayout(1, 0, 0));
        this.blank2.setPreferredSize(new Dimension(20, 2));
        this.colourPanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
        this.colourPanel.setPreferredSize(new Dimension(12, 12));
        this.blank2.add(this.colourPanel);
        this.panel.add((Component)this.blank2, "West");
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Setting setting, Object object, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        ArrayList arrayList;
        if (bl) {
            this.renderer.setForeground(jTable.getSelectionForeground());
            this.panel.setBackground(jTable.getSelectionBackground());
            this.blank1.setBackground(jTable.getSelectionBackground());
            this.blank2.setBackground(jTable.getSelectionBackground());
        } else {
            this.renderer.setForeground(jTable.getForeground());
            this.panel.setBackground(jTable.getBackground());
            this.blank1.setBackground(jTable.getBackground());
            this.blank2.setBackground(jTable.getBackground());
        }
        if (bl2) {
            this.panel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        } else {
            this.panel.setBorder(new EmptyBorder(1, 2, 2, 1));
        }
        if (object instanceof Color) {
            Color color = (Color)object;
            this.renderer.setText("[" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "]");
            this.renderer.setEnabled(bl3);
            this.renderer.setFont(this.font);
            this.colourPanel.setBackground(color);
        } else if (object instanceof ArrayList && (arrayList = (ArrayList)object).size() > 0) {
            Color color = null;
            boolean bl4 = true;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(arrayList.get(i) instanceof Color)) continue;
                Color color2 = (Color)arrayList.get(i);
                if (color != null) {
                    if (!color2.equals(color)) {
                        bl4 = false;
                        break;
                    }
                    color = color2;
                    continue;
                }
                color = color2;
            }
            if (bl4) {
                this.renderer.setText("[" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "]");
                this.renderer.setEnabled(bl3);
                this.renderer.setFont(this.font);
                this.colourPanel.setBackground(color);
            } else {
                this.renderer.setText("(Different values)");
                this.renderer.setEnabled(bl3);
                this.renderer.setFont(this.font);
                this.colourPanel.setBackground(Color.lightGray);
                this.panel.setBackground(Color.lightGray);
                this.blank1.setBackground(Color.lightGray);
                this.blank2.setBackground(Color.lightGray);
            }
        }
        return this.panel;
    }
}

