/*
 * Decompiled with CFR 0.152.
 */
package prism;

import parser.Values;
import parser.ast.ExpressionTemporal;
import prism.PrismException;

public class IntegerBound {
    private Integer lowest;
    private Integer highest;

    public IntegerBound(Integer n, boolean bl, Integer n2, boolean bl2) {
        this.lowest = bl && n != null ? Integer.valueOf(n + 1) : n;
        this.highest = bl2 && n2 != null ? Integer.valueOf(n2 - 1) : n2;
    }

    public static IntegerBound fromExpressionTemporal(ExpressionTemporal expressionTemporal, boolean bl) throws PrismException {
        return IntegerBound.fromExpressionTemporal(expressionTemporal, null, bl);
    }

    public static IntegerBound fromExpressionTemporal(ExpressionTemporal expressionTemporal, Values values, boolean bl) throws PrismException {
        IntegerBound integerBound = new IntegerBound(expressionTemporal.getLowerBound() == null ? null : Integer.valueOf(expressionTemporal.getLowerBound().evaluateInt(values)), expressionTemporal.lowerBoundIsStrict(), expressionTemporal.getUpperBound() == null ? null : Integer.valueOf(expressionTemporal.getUpperBound().evaluateInt(values)), expressionTemporal.upperBoundIsStrict());
        if (bl) {
            if (integerBound.hasNegativeBound()) {
                throw new PrismException("Negative bound in " + expressionTemporal.toString());
            }
            if (integerBound.isEmpty()) {
                throw new PrismException("Empty bound in " + expressionTemporal.toString());
            }
        }
        return integerBound;
    }

    public boolean hasLowerBound() {
        return this.lowest != null;
    }

    public boolean hasUpperBound() {
        return this.highest != null;
    }

    public Integer getLowestInteger() {
        return this.lowest;
    }

    public Integer getHighestInteger() {
        return this.highest;
    }

    public boolean hasNegativeBound() {
        return this.lowest != null && this.lowest < 0 || this.highest != null && this.highest < 0;
    }

    public boolean isEmpty() {
        if (this.hasLowerBound() && this.hasUpperBound()) {
            return this.getLowestInteger() > this.getHighestInteger();
        }
        return false;
    }

    public boolean isInBounds(int n) {
        if (this.lowest != null && n < this.lowest) {
            return false;
        }
        if (this.highest != null) {
            return n <= this.highest;
        }
        return true;
    }

    public int getMaximalInterestingValue() {
        int n = 0;
        if (this.isEmpty()) {
            return 0;
        }
        if (this.lowest != null) {
            n = this.lowest;
        }
        if (this.highest != null) {
            n = this.highest + 1;
        }
        return n;
    }

    public String toString() {
        if (this.hasLowerBound()) {
            if (this.hasUpperBound()) {
                if (this.getLowestInteger().equals(this.getHighestInteger())) {
                    return "=" + this.getLowestInteger();
                }
                return "[" + this.getLowestInteger() + "," + this.getHighestInteger() + "]";
            }
            return ">=" + this.getLowestInteger();
        }
        if (this.hasUpperBound()) {
            return "<=" + this.getHighestInteger();
        }
        return "";
    }

    public static void main(String[] stringArray) {
        System.out.println(new IntegerBound(1, true, 3, false));
    }
}

