/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import parser.ast.ModulesFile;
import parser.ast.SystemDefn;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class SystemFullParallel
extends SystemDefn {
    private ArrayList<SystemDefn> operands = new ArrayList();

    public void addOperand(SystemDefn systemDefn) {
        this.operands.add(systemDefn);
    }

    public void setOperand(int n, SystemDefn systemDefn) {
        this.operands.set(n, systemDefn);
    }

    public int getNumOperands() {
        return this.operands.size();
    }

    public SystemDefn getOperand(int n) {
        return this.operands.get(n);
    }

    @Override
    public void getModules(List<String> list) {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            this.getOperand(i).getModules(list);
        }
    }

    @Override
    public void getModules(List<String> list, ModulesFile modulesFile) {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            this.getOperand(i).getModules(list, modulesFile);
        }
    }

    @Override
    public void getSynchs(List<String> list) {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            this.getOperand(i).getSynchs(list);
        }
    }

    @Override
    public void getSynchs(List<String> list, ModulesFile modulesFile) {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            this.getOperand(i).getSynchs(list, modulesFile);
        }
    }

    @Override
    public void getReferences(List<String> list) {
        int n = this.getNumOperands();
        for (int i = 0; i < n; ++i) {
            this.getOperand(i).getReferences(list);
        }
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        Object object = "";
        int n = this.getNumOperands();
        for (int i = 0; i < n - 1; ++i) {
            object = (String)object + String.valueOf(this.getOperand(i)) + " || ";
        }
        if (n > 0) {
            object = (String)object + String.valueOf(this.getOperand(n - 1));
        }
        return object;
    }

    @Override
    public SystemFullParallel deepCopy(DeepCopy deepCopy) throws PrismLangException {
        deepCopy.copyAll(this.operands);
        return this;
    }

    @Override
    public SystemFullParallel clone() {
        SystemFullParallel systemFullParallel = (SystemFullParallel)super.clone();
        systemFullParallel.operands = (ArrayList)this.operands.clone();
        return systemFullParallel;
    }
}

