/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionLiteral;
import parser.type.TypeInt;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class ForLoop
extends ASTElement {
    private String lhs = null;
    private Expression from = null;
    private Expression to = null;
    private Expression step = null;
    private int pc = 0;
    private String between = "";

    public void setLHS(String string) {
        this.lhs = string;
    }

    public void setFrom(Expression expression) {
        this.from = expression;
    }

    public void setTo(Expression expression) {
        this.to = expression;
    }

    public void setStep(Expression expression) {
        this.step = expression;
    }

    public void setPC(int n) {
        this.pc = n;
    }

    public void setBetween(String string) {
        this.between = string;
    }

    public String getLHS() {
        return this.lhs;
    }

    public Expression getFrom() {
        return this.from;
    }

    public Expression getTo() {
        return this.to;
    }

    public Expression getStep() {
        return this.step != null ? this.step : new ExpressionLiteral(TypeInt.getInstance(), 1);
    }

    public int getPC() {
        return this.pc;
    }

    public String getBetween() {
        return this.between;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public String toString() {
        String string = this.lhs + "=" + String.valueOf(this.from);
        if (this.step != null) {
            string = string + ":" + String.valueOf(this.step);
        }
        string = string + ":" + String.valueOf(this.to);
        return string;
    }

    @Override
    public ForLoop deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.to = deepCopy.copy(this.to);
        this.from = deepCopy.copy(this.from);
        this.step = deepCopy.copy(this.step);
        return this;
    }

    @Override
    public ForLoop clone() {
        return (ForLoop)super.clone();
    }
}

