/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.util.BitSet;
import java.util.Vector;
import jltl2ba.APElement;
import jltl2ba.MyBitSet;
import jltl2dstar.NBA;
import jltl2dstar.NBAAnalysis;
import jltl2dstar.Options_Safra;
import jltl2dstar.RabinAcceptance;
import jltl2dstar.SafraTree;
import jltl2dstar.SafraTreeNode;
import jltl2dstar.SafraTreeTemplate;
import prism.PrismException;

public class SafrasAlgorithm {
    private Options_Safra _options;
    private NBAAnalysis _nba_analysis;
    private NBA _nba;
    private int _NODES;
    private Vector<MyBitSet> _next;
    private STVReorderChildren stv_reorder;

    public SafrasAlgorithm(NBA nBA, Options_Safra options_Safra) throws PrismException {
        this._options = options_Safra;
        this._nba_analysis = new NBAAnalysis(nBA);
        this._nba = nBA;
        if (this._nba.getFailIfDisjoint() && this._nba_analysis.isNBADisjoint()) {
            throw new PrismException("The NBA generated for the LTL formula was discovered to be disjoint,\ni.e., some states were not reachable from the initial state. This likely\nindicates a problem in the translation. Please report the formula to the\nPRISM developers");
        }
        this._NODES = 2 * nBA.getStateCount();
        this.stv_reorder = null;
        this._next = new Vector();
        this._next.setSize(nBA.getStateCount());
    }

    public SafraTreeTemplate delta(SafraTree safraTree, APElement aPElement) throws PrismException {
        return this.process(safraTree, aPElement);
    }

    public SafraTree getStartState() {
        SafraTree safraTree = new SafraTree(this._NODES);
        if (this._nba.getStartState() != null) {
            safraTree.getRootNode().getLabeling().set(this._nba.getStartState().getName());
        }
        return safraTree;
    }

    public void prepareAcceptance(RabinAcceptance rabinAcceptance) {
        rabinAcceptance.newAcceptancePairs(this._NODES);
    }

    public boolean checkEmpty() {
        return this._nba.size() == 0 || this._nba.getStartState() == null;
    }

    public SafraTreeTemplate process(SafraTree safraTree, APElement aPElement) {
        Object object;
        SafraTree safraTree2 = new SafraTree(safraTree);
        SafraTreeTemplate safraTreeTemplate = new SafraTreeTemplate(safraTree2);
        STVResetFinalFlag sTVResetFinalFlag = new STVResetFinalFlag();
        safraTree2.walkTreePostOrder(sTVResetFinalFlag);
        STVCheckFinalSet sTVCheckFinalSet = new STVCheckFinalSet(this._nba_analysis.getFinalStates(), safraTreeTemplate);
        safraTree2.walkTreePostOrder(sTVCheckFinalSet);
        STVPowerset sTVPowerset = new STVPowerset(this._nba, aPElement);
        safraTree2.walkTreePostOrder(sTVPowerset);
        if (this._options.opt_accloop && safraTree2.getRootNode() != null) {
            object = safraTree2.getRootNode();
            if (this._nba_analysis.getStatesWithAcceptingTrueLoops().intersects(((SafraTreeNode)object).getLabeling())) {
                STVRemoveSubtree sTVRemoveSubtree = new STVRemoveSubtree(safraTreeTemplate);
                safraTree2.walkChildrenPostOrder(sTVRemoveSubtree, (SafraTreeNode)object);
                ((SafraTreeNode)object).getLabeling().clear();
                int n = this._nba_analysis.getStatesWithAcceptingTrueLoops().nextSetBit(0);
                ((SafraTreeNode)object).getLabeling().set(n);
                ((SafraTreeNode)object).setFinalFlag(true);
                return safraTreeTemplate;
            }
        }
        object = new STVCheckChildrenHorizontal();
        safraTree2.walkTreePostOrder(object);
        STVRemoveEmpty sTVRemoveEmpty = new STVRemoveEmpty(safraTreeTemplate);
        safraTree2.walkTreePostOrder(sTVRemoveEmpty);
        STVCheckChildrenVertical sTVCheckChildrenVertical = new STVCheckChildrenVertical(safraTreeTemplate);
        safraTree2.walkTreePostOrder(sTVCheckChildrenVertical);
        if (this._options.opt_reorder) {
            if (this.stv_reorder == null) {
                this.stv_reorder = new STVReorderChildren(this._nba_analysis.getReachability(), safraTree2.getNodeMax());
            }
            safraTree2.walkTreePostOrder(this.stv_reorder);
        }
        if (this._options.opt_accsucc) {
            STVCheckForFinalSucc sTVCheckForFinalSucc = new STVCheckForFinalSucc(this._nba_analysis.getStatesWithAllSuccAccepting(), safraTreeTemplate);
            safraTree2.walkTreePostOrder(sTVCheckForFinalSucc);
        }
        return safraTreeTemplate;
    }

    public class STVReorderChildren
    implements SafraTreeVisitor {
        private Vector<MyBitSet> _nba_reachability;
        private MyBitSet[] _node_reachability;
        private int[] _node_order;

        public STVReorderChildren(Vector<MyBitSet> vector, int n) {
            this._nba_reachability = vector;
            this._node_order = new int[n];
            this._node_reachability = new MyBitSet[n];
            for (int i = 0; i < n; ++i) {
                this._node_reachability[i] = new MyBitSet();
            }
        }

        @Override
        public void visit(SafraTree safraTree, SafraTreeNode safraTreeNode) {
            MyBitSet myBitSet;
            Iterable<Integer> iterable;
            if (safraTreeNode.getChildCount() <= 1) {
                return;
            }
            int n = 0;
            for (Iterable<SafraTreeNode> iterable2 : safraTreeNode) {
                iterable = this._node_reachability[iterable2.getID()];
                ((BitSet)((Object)iterable)).clear();
                this._node_order[iterable2.getID()] = n++;
                myBitSet = iterable2.getLabeling();
                int n2 = myBitSet.nextSetBit(0);
                while (n2 >= 0) {
                    ((BitSet)((Object)iterable)).or(this._nba_reachability.get(n2));
                    n2 = myBitSet.nextSetBit(n2 + 1);
                }
            }
            boolean bl = false;
            while (!bl) {
                bl = true;
                for (Iterable<SafraTreeNode> iterable2 = safraTreeNode.getOldestChild(); iterable2 != null && iterable2.getYoungerBrother() != null; iterable2 = iterable2.getYoungerBrother()) {
                    MyBitSet myBitSet2;
                    iterable = iterable2.getYoungerBrother();
                    myBitSet = this._node_reachability[iterable2.getID()];
                    if (myBitSet.intersects(myBitSet2 = this._node_reachability[((SafraTreeNode)iterable).getID()])) {
                        assert (this._node_order[iterable2.getID()] < this._node_order[((SafraTreeNode)iterable).getID()]);
                        continue;
                    }
                    if (iterable2.getLabeling().compareTo(((SafraTreeNode)iterable).getLabeling()) < 0) continue;
                    safraTreeNode.swapChildren((SafraTreeNode)iterable2, (SafraTreeNode)iterable);
                    iterable2 = iterable;
                    bl = false;
                }
            }
        }
    }

    public class STVResetFinalFlag
    implements SafraTreeVisitor {
        @Override
        public void visit(SafraTree safraTree, SafraTreeNode safraTreeNode) {
            safraTreeNode.setFinalFlag(false);
        }
    }

    public static interface SafraTreeVisitor {
        public void visit(SafraTree var1, SafraTreeNode var2);
    }

    public class STVCheckFinalSet
    implements SafraTreeVisitor {
        private MyBitSet _final_states;
        private SafraTreeTemplate _tree_template;

        public STVCheckFinalSet(MyBitSet myBitSet, SafraTreeTemplate safraTreeTemplate) {
            this._final_states = myBitSet;
            this._tree_template = safraTreeTemplate;
        }

        @Override
        public void visit(SafraTree safraTree, SafraTreeNode safraTreeNode) {
            if (this._final_states.intersects(safraTreeNode.getLabeling())) {
                MyBitSet myBitSet = (MyBitSet)this._final_states.clone();
                myBitSet.and(safraTreeNode.getLabeling());
                SafraTreeNode safraTreeNode2 = safraTree.newNode();
                safraTreeNode.addAsYoungestChild(safraTreeNode2);
                this._tree_template.setRenameable(safraTreeNode2.getID(), true);
                safraTreeNode2.setLabeling(myBitSet);
            }
        }
    }

    public class STVPowerset
    implements SafraTreeVisitor {
        private NBA _nba;
        private APElement _elem;

        public STVPowerset(NBA nBA, APElement aPElement) {
            this._nba = nBA;
            this._elem = aPElement;
        }

        @Override
        public void visit(SafraTree safraTree, SafraTreeNode safraTreeNode) {
            MyBitSet myBitSet = safraTreeNode.getLabeling();
            MyBitSet myBitSet2 = new MyBitSet(myBitSet.size());
            int n = myBitSet.nextSetBit(0);
            while (n >= 0) {
                myBitSet2.or(this._nba.get(n).getEdge(this._elem));
                n = myBitSet.nextSetBit(n + 1);
            }
            safraTreeNode.setLabeling(myBitSet2);
        }
    }

    public class STVRemoveSubtree
    implements SafraTreeVisitor {
        private SafraTreeTemplate _tree_template;

        public STVRemoveSubtree(SafraTreeTemplate safraTreeTemplate) {
            this._tree_template = safraTreeTemplate;
        }

        @Override
        public void visit(SafraTree safraTree, SafraTreeNode safraTreeNode) {
            int n = safraTreeNode.getID();
            if (this._tree_template.isRenameable(n)) {
                this._tree_template.setRenameable(n, false);
            } else {
                this._tree_template.setRestricted(n, true);
            }
            safraTree.remove(safraTreeNode);
        }
    }

    public class STVCheckChildrenHorizontal
    implements SafraTreeVisitor {
        @Override
        public void visit(SafraTree safraTree, SafraTreeNode safraTreeNode) {
            if (safraTreeNode.getChildCount() <= 1) {
                return;
            }
            MyBitSet myBitSet = new MyBitSet();
            boolean bl = true;
            for (SafraTreeNode safraTreeNode2 : safraTreeNode) {
                if (bl) {
                    myBitSet = (MyBitSet)safraTreeNode2.getLabeling().clone();
                    bl = false;
                    continue;
                }
                MyBitSet myBitSet2 = safraTreeNode2.getLabeling();
                MyBitSet myBitSet3 = (MyBitSet)myBitSet.clone();
                if (myBitSet3.intersects(myBitSet2)) {
                    STVSubstractLabeling sTVSubstractLabeling = new STVSubstractLabeling(myBitSet3);
                    safraTree.walkSubTreePostOrder(sTVSubstractLabeling, safraTreeNode2);
                }
                myBitSet.or(myBitSet2);
            }
        }
    }

    public class STVRemoveEmpty
    implements SafraTreeVisitor {
        private SafraTreeTemplate _tree_template;

        public STVRemoveEmpty(SafraTreeTemplate safraTreeTemplate) {
            this._tree_template = safraTreeTemplate;
        }

        @Override
        public void visit(SafraTree safraTree, SafraTreeNode safraTreeNode) {
            if (safraTreeNode.getLabeling().isEmpty()) {
                int n = safraTreeNode.getID();
                if (this._tree_template.isRenameable(n)) {
                    this._tree_template.setRenameable(n, false);
                } else {
                    this._tree_template.setRestricted(n, true);
                }
                safraTree.remove(safraTreeNode);
            }
        }
    }

    public class STVCheckChildrenVertical
    implements SafraTreeVisitor {
        private SafraTreeTemplate _tree_template;

        public STVCheckChildrenVertical(SafraTreeTemplate safraTreeTemplate) {
            this._tree_template = safraTreeTemplate;
        }

        @Override
        public void visit(SafraTree safraTree, SafraTreeNode safraTreeNode) {
            if (safraTreeNode.getChildCount() == 0) {
                return;
            }
            MyBitSet myBitSet = new MyBitSet();
            for (SafraTreeNode safraTreeNode2 : safraTreeNode) {
                myBitSet.or(safraTreeNode2.getLabeling());
            }
            if (myBitSet.equals(safraTreeNode.getLabeling())) {
                STVRemoveSubtree sTVRemoveSubtree = new STVRemoveSubtree(this._tree_template);
                safraTree.walkChildrenPostOrder(sTVRemoveSubtree, safraTreeNode);
                safraTreeNode.setFinalFlag(true);
            }
        }
    }

    public class STVCheckForFinalSucc
    implements SafraTreeVisitor {
        private boolean _success = false;
        private MyBitSet _nba_states_with_all_succ_final;
        private SafraTreeTemplate _tree_template;

        public STVCheckForFinalSucc(MyBitSet myBitSet, SafraTreeTemplate safraTreeTemplate) {
            this._nba_states_with_all_succ_final = myBitSet;
            this._tree_template = safraTreeTemplate;
        }

        public boolean wasSuccessful() {
            return this._success;
        }

        @Override
        public void visit(SafraTree safraTree, SafraTreeNode safraTreeNode) {
            boolean bl = true;
            int n = safraTreeNode.getLabeling().nextSetBit(0);
            while (n >= 0) {
                if (!this._nba_states_with_all_succ_final.get(n)) {
                    bl = false;
                    break;
                }
                n = safraTreeNode.getLabeling().nextSetBit(n + 1);
            }
            if (bl) {
                STVRemoveSubtree sTVRemoveSubtree = new STVRemoveSubtree(this._tree_template);
                safraTree.walkChildrenPostOrder(sTVRemoveSubtree, safraTreeNode);
                safraTreeNode.setFinalFlag(true);
                this._success = true;
            }
        }
    }

    public class STVSubstractLabeling
    implements SafraTreeVisitor {
        private MyBitSet _bitset;

        public STVSubstractLabeling(MyBitSet myBitSet) {
            this._bitset = myBitSet;
        }

        @Override
        public void visit(SafraTree safraTree, SafraTreeNode safraTreeNode) {
            safraTreeNode.getLabeling().andNot(this._bitset);
        }
    }
}

