/*
 * Decompiled with CFR 0.152.
 */
package io.github.pmctools.umbj;

import io.github.pmctools.umbj.UMBBitPacking;
import io.github.pmctools.umbj.UMBBitString;
import io.github.pmctools.umbj.UMBException;
import io.github.pmctools.umbj.UMBFormat;
import io.github.pmctools.umbj.UMBIndex;
import io.github.pmctools.umbj.UMBType;
import io.github.pmctools.umbj.UMBUtils;
import it.unimi.dsi.fastutil.doubles.DoubleIterators;
import it.unimi.dsi.fastutil.longs.LongIterators;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.PrimitiveIterator;
import java.util.StringJoiner;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

public class UMBWriter {
    private final UMBIndex umbIndex;
    private final List<UMBDataFile> umbDataFiles = new ArrayList<UMBDataFile>();
    private static int BUFFER_SIZE = 65536;
    public static final int FORMAT_DOUBLE_PRECISION = 14;

    public UMBWriter() {
        this.umbIndex = new UMBIndex();
    }

    public UMBIndex getUmbIndex() {
        return this.umbIndex;
    }

    public void addStateChoiceOffsets(PrimitiveIterator.OfLong ofLong) {
        this.addLongArray("state-to-choices.bin", ofLong, this.umbIndex.getNumStates() + 1L);
    }

    public void addStateChoiceOffsets(PrimitiveIterator.OfInt ofInt) {
        this.addLongArray("state-to-choices.bin", new UMBUtils.IntToLongIteratorAdapter(ofInt), this.umbIndex.getNumStates() + 1L);
    }

    public void addStatePlayers(PrimitiveIterator.OfInt ofInt) {
        this.addIntArray("state-to-player.bin", ofInt, this.umbIndex.getNumStates());
    }

    public void addInitialStates(BitSet bitSet) throws UMBException {
        this.addBooleanArray("state-is-initial.bin", bitSet, this.umbIndex.getNumStates());
    }

    public void addInitialStates(PrimitiveIterator.OfLong ofLong) throws UMBException {
        BitSet bitSet = new BitSet();
        ofLong.forEachRemaining(l -> bitSet.set((int)l));
        this.addBooleanArray("state-is-initial.bin", bitSet, this.umbIndex.getNumStates());
    }

    public void addInitialStates(PrimitiveIterator.OfInt ofInt) throws UMBException {
        BitSet bitSet = new BitSet();
        ofInt.forEachRemaining(n -> bitSet.set(n));
        this.addBooleanArray("state-is-initial.bin", bitSet, this.umbIndex.getNumStates());
    }

    public void addMarkovianStates(BitSet bitSet) throws UMBException {
        this.addBooleanArray("state-is-markovian.bin", bitSet, this.umbIndex.getNumStates());
    }

    public void addMarkovianStates(PrimitiveIterator.OfLong ofLong) throws UMBException {
        BitSet bitSet = new BitSet();
        ofLong.forEachRemaining(l -> bitSet.set((int)l));
        this.addBooleanArray("state-is-markovian.bin", bitSet, this.umbIndex.getNumStates());
    }

    public void addMarkovianStates(PrimitiveIterator.OfInt ofInt) throws UMBException {
        BitSet bitSet = new BitSet();
        ofInt.forEachRemaining(n -> bitSet.set(n));
        this.addBooleanArray("state-is-markovian.bin", bitSet, this.umbIndex.getNumStates());
    }

    public void addExitRates(Iterator<?> iterator) throws UMBException {
        this.addContinuousNumericArray("state-to-exit-rate.bin", iterator, this.umbIndex.getExitRateType(), this.umbIndex.getNumStates());
    }

    public void addChoiceBranchOffsets(PrimitiveIterator.OfLong ofLong) {
        this.addLongArray("choice-to-branches.bin", ofLong, this.umbIndex.getNumChoices() + 1L);
    }

    public void addChoiceBranchOffsets(PrimitiveIterator.OfInt ofInt) {
        this.addLongArray("choice-to-branches.bin", new UMBUtils.IntToLongIteratorAdapter(ofInt), this.umbIndex.getNumChoices() + 1L);
    }

    public void addBranchTargets(PrimitiveIterator.OfLong ofLong) {
        this.addLongArray("branch-to-target.bin", ofLong, this.umbIndex.getNumBranches());
    }

    public void addBranchTargets(PrimitiveIterator.OfInt ofInt) {
        this.addLongArray("branch-to-target.bin", new UMBUtils.IntToLongIteratorAdapter(ofInt), this.umbIndex.getNumBranches());
    }

    public void addBranchProbabilities(Iterator<?> iterator) throws UMBException {
        this.addContinuousNumericArray("branch-to-probability.bin", iterator, this.umbIndex.getBranchProbabilityType(), this.umbIndex.getNumBranches());
    }

    public void addChoiceActions(PrimitiveIterator.OfInt ofInt, List<String> list) throws UMBException {
        this.addStringDataToAnnotation(this.umbIndex.actionsAnnotation, UMBIndex.UMBEntity.CHOICES, ofInt, list);
    }

    public void addChoiceActions(PrimitiveIterator.OfInt ofInt) throws UMBException {
        this.addIntDataToAnnotation(this.umbIndex.actionsAnnotation, UMBIndex.UMBEntity.CHOICES, ofInt);
    }

    public void addSingleChoiceAction(String string) throws UMBException {
        this.addChoiceActions(null, Collections.singletonList(string));
    }

    public void addBranchActions(PrimitiveIterator.OfInt ofInt, List<String> list) throws UMBException {
        this.addStringDataToAnnotation(this.umbIndex.actionsAnnotation, UMBIndex.UMBEntity.BRANCHES, ofInt, list);
    }

    public void addBranchActions(PrimitiveIterator.OfInt ofInt) throws UMBException {
        this.addIntDataToAnnotation(this.umbIndex.actionsAnnotation, UMBIndex.UMBEntity.BRANCHES, ofInt);
    }

    public void addSingleBranchAction(String string) throws UMBException {
        this.addBranchActions(null, Collections.singletonList(string));
    }

    public void addStateObservations(PrimitiveIterator.OfLong ofLong) throws UMBException {
        this.addObservations(UMBIndex.UMBEntity.STATES, ofLong);
    }

    public void addStateObservations(PrimitiveIterator.OfInt ofInt) throws UMBException {
        this.addObservations(UMBIndex.UMBEntity.STATES, ofInt);
    }

    public void addBranchObservations(PrimitiveIterator.OfLong ofLong) throws UMBException {
        this.addObservations(UMBIndex.UMBEntity.BRANCHES, ofLong);
    }

    public void addBranchObservations(PrimitiveIterator.OfInt ofInt) throws UMBException {
        this.addObservations(UMBIndex.UMBEntity.BRANCHES, ofInt);
    }

    public void addObservations(UMBIndex.UMBEntity uMBEntity, PrimitiveIterator.OfLong ofLong) throws UMBException {
        this.addLongDataToAnnotation(this.umbIndex.observationsAnnotation, uMBEntity, ofLong);
    }

    public void addObservations(UMBIndex.UMBEntity uMBEntity, PrimitiveIterator.OfInt ofInt) throws UMBException {
        this.addLongDataToAnnotation(this.umbIndex.observationsAnnotation, uMBEntity, new UMBUtils.IntToLongIteratorAdapter(ofInt));
    }

    public void addStateAP(String string, BitSet bitSet) throws UMBException {
        UMBIndex.Annotation annotation = this.umbIndex.addAnnotation("aps", string, UMBType.create(UMBType.Type.BOOL));
        this.addBooleanDataToAnnotation(annotation, UMBIndex.UMBEntity.STATES, bitSet);
    }

    public String addRewards(String string, boolean bl) throws UMBException {
        UMBType uMBType = UMBType.contNum(bl);
        UMBIndex.Annotation annotation = this.umbIndex.addAnnotation("rewards", string, uMBType);
        return annotation.id;
    }

    public void addStateRewardsByID(String string, Iterator<?> iterator) throws UMBException {
        UMBIndex.Annotation annotation = this.umbIndex.getAnnotation("rewards", string);
        this.addContinuousNumericDataToAnnotation(annotation, UMBIndex.UMBEntity.STATES, iterator, annotation.getType());
    }

    public void addChoiceRewardsByID(String string, Iterator<?> iterator) throws UMBException {
        UMBIndex.Annotation annotation = this.umbIndex.getAnnotation("rewards", string);
        this.addContinuousNumericDataToAnnotation(annotation, UMBIndex.UMBEntity.CHOICES, iterator, annotation.getType());
    }

    public void addBranchRewardsByID(String string, Iterator<?> iterator) throws UMBException {
        UMBIndex.Annotation annotation = this.umbIndex.getAnnotation("rewards", string);
        this.addContinuousNumericDataToAnnotation(annotation, UMBIndex.UMBEntity.BRANCHES, iterator, annotation.getType());
    }

    public void addStateRewards(String string, boolean bl, Iterator<?> iterator) throws UMBException {
        this.addStateRewardsByID(this.addRewards(string, bl), iterator);
    }

    public void addChoiceRewards(String string, boolean bl, Iterator<?> iterator) throws UMBException {
        this.addChoiceRewardsByID(this.addRewards(string, bl), iterator);
    }

    public void addBranchRewards(String string, boolean bl, Iterator<?> iterator) throws UMBException {
        this.addBranchRewardsByID(this.addRewards(string, bl), iterator);
    }

    public UMBIndex.Annotation addAnnotation(String string, String string2, UMBType uMBType) throws UMBException {
        return this.umbIndex.addAnnotation(string, string2, uMBType);
    }

    public void addBooleanAnnotation(String string, String string2, UMBIndex.UMBEntity uMBEntity, BitSet bitSet) throws UMBException {
        UMBIndex.Annotation annotation = this.addAnnotation(string, string2, UMBType.create(UMBType.Type.BOOL));
        this.addBooleanDataToAnnotation(annotation, uMBEntity, bitSet);
    }

    public void addDoubleAnnotation(String string, String string2, UMBIndex.UMBEntity uMBEntity, PrimitiveIterator.OfDouble ofDouble) throws UMBException {
        UMBIndex.Annotation annotation = this.addAnnotation(string, string2, UMBType.create(UMBType.Type.DOUBLE));
        this.addDoubleDataToAnnotation(annotation, uMBEntity, ofDouble);
    }

    public void addBooleanDataToAnnotation(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, BitSet bitSet) throws UMBException {
        if (annotation.appliesTo(uMBEntity)) {
            throw new UMBException("Duplicate data for " + String.valueOf(uMBEntity) + "s in annotation \"" + annotation.id + "\" in group \"" + annotation.group + "\"");
        }
        annotation.addAppliesTo(uMBEntity);
        long l = this.umbIndex.getEntityCount(uMBEntity);
        this.addBooleanArray(annotation.getFilename(uMBEntity), bitSet, l);
    }

    public void addIntDataToAnnotation(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, PrimitiveIterator.OfInt ofInt) throws UMBException {
        if (annotation.appliesTo(uMBEntity)) {
            throw new UMBException("Duplicate data for " + String.valueOf(uMBEntity) + "s in annotation \"" + annotation.id + "\" in group \"" + annotation.group + "\"");
        }
        annotation.addAppliesTo(uMBEntity);
        long l = this.umbIndex.getEntityCount(uMBEntity);
        this.addIntArray(annotation.getFilename(uMBEntity), ofInt, l);
    }

    public void addLongDataToAnnotation(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, PrimitiveIterator.OfLong ofLong) throws UMBException {
        if (annotation.appliesTo(uMBEntity)) {
            throw new UMBException("Duplicate data for " + String.valueOf(uMBEntity) + "s in annotation \"" + annotation.id + "\" in group \"" + annotation.group + "\"");
        }
        annotation.addAppliesTo(uMBEntity);
        long l = this.umbIndex.getEntityCount(uMBEntity);
        this.addLongArray(annotation.getFilename(uMBEntity), ofLong, l);
    }

    public void addDoubleDataToAnnotation(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, PrimitiveIterator.OfDouble ofDouble) throws UMBException {
        if (annotation.appliesTo(uMBEntity)) {
            throw new UMBException("Duplicate data for " + String.valueOf(uMBEntity) + "s in annotation \"" + annotation.id + "\" in group \"" + annotation.group + "\"");
        }
        annotation.addAppliesTo(uMBEntity);
        long l = this.umbIndex.getEntityCount(uMBEntity);
        this.addDoubleArray(annotation.getFilename(uMBEntity), ofDouble, l);
    }

    public void addContinuousNumericDataToAnnotation(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, Iterator<?> iterator, UMBType uMBType) throws UMBException {
        if (annotation.appliesTo(uMBEntity)) {
            throw new UMBException("Duplicate data for " + String.valueOf(uMBEntity) + "s in annotation \"" + annotation.id + "\" in group \"" + annotation.group + "\"");
        }
        annotation.addAppliesTo(uMBEntity);
        long l = this.umbIndex.getEntityCount(uMBEntity);
        this.addContinuousNumericArray(annotation.getFilename(uMBEntity), iterator, uMBType, l);
    }

    public void addStringDataToAnnotation(UMBIndex.Annotation annotation, UMBIndex.UMBEntity uMBEntity, PrimitiveIterator.OfInt ofInt, List<String> list) throws UMBException {
        if (annotation.appliesTo(uMBEntity)) {
            throw new UMBException("Duplicate data for " + String.valueOf(uMBEntity) + "s in annotation \"" + annotation.id + "\" in group \"" + annotation.group + "\"");
        }
        annotation.addAppliesTo(uMBEntity);
        String string = annotation.getFolderName(uMBEntity);
        this.addStringsFiles(list, UMBFormat.stringOffsetsFile(string), UMBFormat.stringsFile(string));
        if (ofInt != null) {
            long l = this.umbIndex.getEntityCount(uMBEntity);
            this.addIntArray(annotation.getFilename(uMBEntity), ofInt, l);
        }
    }

    private void addStringsFiles(List<String> list, String string, String string2) throws UMBException {
        int n = list.size();
        long[] lArray = new long[n + 1];
        lArray[0] = 0L;
        for (int i = 0; i < n; ++i) {
            lArray[i + 1] = lArray[i] + (long)list.get(i).getBytes().length;
        }
        PrimitiveIterator.OfLong ofLong = Arrays.stream(lArray).iterator();
        this.addLongArray(string, ofLong, list.size() + 1);
        this.addStringList(string2, list);
    }

    public void addStateValuationDescription(boolean bl, UMBBitPacking uMBBitPacking) throws UMBException {
        this.addValuationDescription(UMBIndex.UMBEntity.STATES, bl, uMBBitPacking);
    }

    public void addStateValuations(Iterator<UMBBitString> iterator, int n) throws UMBException {
        this.addValuations(UMBIndex.UMBEntity.STATES, iterator, n);
    }

    public void addStateValuations(Iterator<UMBBitString> iterator, UMBBitPacking uMBBitPacking) throws UMBException {
        this.addValuations(UMBIndex.UMBEntity.STATES, iterator, uMBBitPacking);
    }

    public void addObservationValuationDescription(boolean bl, UMBBitPacking uMBBitPacking) throws UMBException {
        this.addValuationDescription(UMBIndex.UMBEntity.OBSERVATIONS, bl, uMBBitPacking);
    }

    public void addObservationValuations(Iterator<UMBBitString> iterator, int n) throws UMBException {
        this.addValuations(UMBIndex.UMBEntity.OBSERVATIONS, iterator, n);
    }

    public void addObservationValuations(Iterator<UMBBitString> iterator, UMBBitPacking uMBBitPacking) throws UMBException {
        this.addValuations(UMBIndex.UMBEntity.OBSERVATIONS, iterator, uMBBitPacking);
    }

    public void addValuationDescription(UMBIndex.UMBEntity uMBEntity, boolean bl, UMBBitPacking uMBBitPacking) throws UMBException {
        this.umbIndex.addSingleValuationDescription(uMBEntity, bl, uMBBitPacking);
    }

    public void addValuations(UMBIndex.UMBEntity uMBEntity, Iterator<UMBBitString> iterator, int n) throws UMBException {
        this.addBitStringArray(UMBFormat.valuationsFile(uMBEntity), iterator, n, this.umbIndex.getEntityCount(uMBEntity));
    }

    public void addValuations(UMBIndex.UMBEntity uMBEntity, Iterator<UMBBitString> iterator, UMBBitPacking uMBBitPacking) throws UMBException {
        this.addBitStringArray(UMBFormat.valuationsFile(uMBEntity), iterator, uMBBitPacking, this.umbIndex.getEntityCount(uMBEntity));
    }

    public void addBooleanArray(String string, BitSet bitSet, long l) {
        this.umbDataFiles.add(new BooleanArray(bitSet, l, string));
    }

    public void addCharArray(String string, PrimitiveIterator.OfLong ofLong, long l) {
        this.umbDataFiles.add(new LongArray(ofLong, l, string));
    }

    public void addIntArray(String string, PrimitiveIterator.OfInt ofInt, long l) {
        this.umbDataFiles.add(new IntArray(ofInt, l, string));
    }

    public void addLongArray(String string, PrimitiveIterator.OfLong ofLong, long l) {
        this.umbDataFiles.add(new LongArray(ofLong, l, string));
    }

    public void addDoubleArray(String string, PrimitiveIterator.OfDouble ofDouble, long l) {
        this.umbDataFiles.add(new DoubleArray(ofDouble, l, string));
    }

    public void addBigIntegerArray(String string, Iterator<BigInteger> iterator, int n, long l) {
        this.umbDataFiles.add(new BigIntegerArray(iterator, n, l, string));
    }

    private void addContinuousNumericArray(String string, Iterator<?> iterator, UMBType uMBType, long l) throws UMBException {
        long l2;
        long l3 = l2 = uMBType.type.isInterval() ? l * 2L : l;
        if (uMBType.type.isDouble()) {
            this.addDoubleArray(string, (PrimitiveIterator.OfDouble)DoubleIterators.asDoubleIterator(iterator), l2);
        } else if (uMBType.type.isRational()) {
            this.addLongArray(string, (PrimitiveIterator.OfLong)LongIterators.asLongIterator(iterator), l2 * 2L);
        } else {
            throw new UMBException("Unsupported continuous numeric type " + String.valueOf(uMBType));
        }
    }

    public void addBitStringArray(String string, Iterator<UMBBitString> iterator, int n, long l) {
        this.umbDataFiles.add(new BitStringArray(iterator, n, l, string));
    }

    public void addBitStringArray(String string, Iterator<UMBBitString> iterator, UMBBitPacking uMBBitPacking, long l) {
        this.umbDataFiles.add(new BitStringArray(iterator, uMBBitPacking, l, string));
    }

    public void addStringList(String string, List<String> list) {
        this.umbDataFiles.add(new StringListFile(list, string));
    }

    public void export(File file) throws UMBException {
        this.export(file, true);
    }

    public void export(File file, boolean bl) throws UMBException {
        this.export(file, bl, null);
    }

    public void export(File file, boolean bl, UMBFormat.CompressionFormat compressionFormat) throws UMBException {
        UMBOut uMBOut = new UMBOut(file, bl, compressionFormat);
        this.exportIndex(uMBOut);
        for (UMBDataFile uMBDataFile : this.umbDataFiles) {
            this.exportUMBFile(uMBDataFile, uMBOut);
        }
        uMBOut.close();
    }

    public void exportAsText(StringBuffer stringBuffer) throws UMBException {
        this.exportIndexToText(stringBuffer);
        for (UMBDataFile uMBDataFile : this.umbDataFiles) {
            this.exportUMBFileToText(uMBDataFile, stringBuffer);
        }
    }

    private void exportIndex(UMBOut uMBOut) throws UMBException {
        this.exportTextToTar(this.umbIndex.toJSON(), "index.json", uMBOut);
    }

    private void exportIndexToText(StringBuffer stringBuffer) {
        this.exportTextToText(this.umbIndex.toJSON(), new File("index.json"), stringBuffer);
    }

    private void exportTextToTar(String string, String string2, UMBOut uMBOut) throws UMBException {
        byte[] byArray = string.getBytes();
        uMBOut.createArchiveEntry(string2, byArray.length);
        uMBOut.write(byArray, 0, byArray.length);
        uMBOut.closeArchiveEntry();
    }

    private void exportUMBFile(UMBDataFile uMBDataFile, UMBOut uMBOut) throws UMBException {
        try {
            uMBOut.createArchiveEntry(uMBDataFile.name, uMBDataFile.totalBytes());
            Iterator<ByteBuffer> iterator = uMBDataFile.byteIterator();
            while (iterator.hasNext()) {
                ByteBuffer byteBuffer = iterator.next();
                uMBOut.write(byteBuffer.array(), 0, byteBuffer.position());
            }
            uMBOut.closeArchiveEntry();
        }
        catch (RuntimeException runtimeException) {
            throw new UMBException("Error exporting UMB file: " + runtimeException.getMessage());
        }
    }

    private void exportTextToText(String string, File file, StringBuffer stringBuffer) {
        stringBuffer.append("/" + file.getName() + ":\n");
        stringBuffer.append(string);
        stringBuffer.append("\n");
    }

    private void exportUMBFileToText(UMBDataFile uMBDataFile, StringBuffer stringBuffer) throws UMBException {
        try {
            stringBuffer.append("/" + uMBDataFile.name + ":\n");
            stringBuffer.append(uMBDataFile.toText());
            stringBuffer.append("\n");
        }
        catch (RuntimeException runtimeException) {
            throw new UMBException("Error exporting UMB file: " + runtimeException.getMessage());
        }
    }

    private static String toArrayString(Iterator<?> iterator) {
        StringJoiner stringJoiner = new StringJoiner(",", "[", "]");
        iterator.forEachRemaining(object -> stringJoiner.add(object.toString()));
        return stringJoiner.toString();
    }

    public String formatDouble(double d) {
        return this.formatDouble(d, 14);
    }

    public String formatDouble(double d, int n) {
        String string = String.format((Locale)null, "%." + n + "g", d);
        string = string.replaceFirst("(\\.[0-9]*?)0+(e|$)", "$1$2");
        return string.replaceFirst("\\.(e|$)", ".0$1");
    }

    static class BooleanArray
    extends Array {
        protected BitSet booleanValues;
        protected long[] booleanLongs;
        protected int posn;

        public BooleanArray(BitSet bitSet, long l, String string) {
            this.booleanValues = bitSet;
            this.booleanLongs = bitSet.toLongArray();
            this.size = l;
            this.name = string;
            this.posn = 0;
        }

        @Override
        public long totalBytes() {
            return 8L * ((this.size - 1L) / 64L + 1L);
        }

        public Iterator<Boolean> iterator() {
            return new Iterator<Boolean>(){

                @Override
                public boolean hasNext() {
                    return (long)posn < size;
                }

                @Override
                public Boolean next() {
                    return booleanValues.get(posn++);
                }
            };
        }

        @Override
        public int numBytes() {
            return 8;
        }

        @Override
        public boolean hasNextBytes() {
            return (long)this.posn < this.size;
        }

        @Override
        public void encodeNextBytes() {
            while ((long)this.posn < this.size && this.buffer.remaining() >= this.numBytes()) {
                int n = this.posn / 64;
                this.buffer.putLong(this.booleanLongs.length > n ? this.booleanLongs[n] : 0L);
                this.posn += 64;
            }
        }

        @Override
        public String toText() {
            StringJoiner stringJoiner = new StringJoiner("", "[", "]");
            this.iterator().forEachRemaining(bl -> stringJoiner.add(bl != false ? "1" : "0"));
            return stringJoiner.toString();
        }
    }

    static class LongArray
    extends Array {
        protected PrimitiveIterator.OfLong longValues;

        public LongArray(PrimitiveIterator.OfLong ofLong, long l, String string) {
            this.longValues = ofLong;
            this.size = l;
            this.name = string;
        }

        public PrimitiveIterator.OfLong iterator() {
            return this.longValues;
        }

        @Override
        public int numBytes() {
            return 8;
        }

        @Override
        public boolean hasNextBytes() {
            return this.longValues.hasNext();
        }

        @Override
        public void encodeNextBytes() {
            while (this.longValues.hasNext() && this.buffer.remaining() >= this.numBytes()) {
                this.buffer.putLong(this.longValues.nextLong());
            }
        }
    }

    static class IntArray
    extends Array {
        protected PrimitiveIterator.OfInt intValues;

        public IntArray(PrimitiveIterator.OfInt ofInt, long l, String string) {
            this.intValues = ofInt;
            this.size = l;
            this.name = string;
        }

        public PrimitiveIterator.OfInt iterator() {
            return this.intValues;
        }

        @Override
        public int numBytes() {
            return 4;
        }

        @Override
        public boolean hasNextBytes() {
            return this.intValues.hasNext();
        }

        @Override
        public void encodeNextBytes() {
            while (this.intValues.hasNext() && this.buffer.remaining() >= this.numBytes()) {
                this.buffer.putInt(this.intValues.nextInt());
            }
        }
    }

    class DoubleArray
    extends Array {
        protected PrimitiveIterator.OfDouble doubleValues;

        public DoubleArray(PrimitiveIterator.OfDouble ofDouble, long l, String string) {
            this.doubleValues = ofDouble;
            this.size = l;
            this.name = string;
        }

        public PrimitiveIterator.OfDouble iterator() {
            return this.doubleValues;
        }

        @Override
        public int numBytes() {
            return 8;
        }

        @Override
        public boolean hasNextBytes() {
            return this.doubleValues.hasNext();
        }

        @Override
        public String nextAsText() {
            return UMBWriter.this.formatDouble(this.doubleValues.nextDouble());
        }

        @Override
        public void encodeNextBytes() {
            while (this.doubleValues.hasNext() && this.buffer.remaining() >= this.numBytes()) {
                this.buffer.putDouble(this.doubleValues.nextDouble());
            }
        }
    }

    static class BigIntegerArray
    extends Array {
        protected Iterator<BigInteger> bigIntegerValues;
        protected int intSize;

        public BigIntegerArray(Iterator<BigInteger> iterator, int n, long l, String string) {
            this.bigIntegerValues = iterator;
            this.intSize = n;
            this.size = l;
            this.name = string;
        }

        public Iterator<BigInteger> iterator() {
            return this.bigIntegerValues;
        }

        @Override
        public int numBytes() {
            return this.intSize * 8;
        }

        @Override
        public boolean hasNextBytes() {
            return this.bigIntegerValues.hasNext();
        }

        @Override
        public void encodeNextBytes() {
            while (this.bigIntegerValues.hasNext() && this.buffer.remaining() >= this.numBytes()) {
                BigInteger bigInteger = this.bigIntegerValues.next();
                for (int i = 0; i < this.intSize; ++i) {
                    this.buffer.putLong(bigInteger.longValue());
                    bigInteger = bigInteger.shiftRight(64);
                }
            }
        }
    }

    class BitStringArray
    extends Array {
        protected Iterator<UMBBitString> bitStrings;
        protected UMBBitPacking bitPacking;
        protected int numBytes;

        public BitStringArray(Iterator<UMBBitString> iterator, int n, long l, String string) {
            this.bitStrings = iterator;
            this.bitPacking = null;
            this.numBytes = n;
            this.size = l;
            this.name = string;
        }

        public BitStringArray(Iterator<UMBBitString> iterator, UMBBitPacking uMBBitPacking, long l, String string) {
            this.bitStrings = iterator;
            this.bitPacking = uMBBitPacking;
            this.numBytes = uMBBitPacking.getTotalNumBytes();
            this.size = l;
            this.name = string;
        }

        public Iterator<UMBBitString> iterator() {
            return this.bitStrings;
        }

        @Override
        public int numBytes() {
            return this.numBytes;
        }

        @Override
        public boolean hasNextBytes() {
            return this.bitStrings.hasNext();
        }

        @Override
        public String nextAsText() throws UMBException {
            UMBBitString uMBBitString = this.bitStrings.next();
            return this.bitPacking == null ? uMBBitString.toString() : this.bitPacking.decodeBitString(uMBBitString);
        }

        @Override
        public void encodeNextBytes() {
            while (this.bitStrings.hasNext() && this.buffer.remaining() >= this.numBytes()) {
                this.buffer.put(this.bitStrings.next().bytes);
            }
        }
    }

    static class StringListFile
    extends UMBDataFile {
        protected List<String> strings;
        protected int totalBytes;
        protected byte[] stringBytes;

        public StringListFile(List<String> list, String string) {
            int n;
            this.name = string;
            this.strings = list;
            int n2 = list.size();
            byte[][] byArrayArray = new byte[n2][];
            this.totalBytes = 0;
            for (n = 0; n < n2; ++n) {
                byArrayArray[n] = list.get(n).getBytes(StandardCharsets.UTF_8);
                this.totalBytes += byArrayArray[n].length;
            }
            this.stringBytes = new byte[this.totalBytes];
            n = 0;
            for (int i = 0; i < n2; ++i) {
                System.arraycopy(byArrayArray[i], 0, this.stringBytes, n, byArrayArray[i].length);
                n += byArrayArray[i].length;
            }
        }

        @Override
        public long totalBytes() {
            return this.totalBytes;
        }

        @Override
        public Iterator<ByteBuffer> byteIterator() {
            return new Iterator<ByteBuffer>(){
                boolean hasNext = true;
                {
                    buffer = ByteBuffer.wrap(stringBytes);
                    buffer.position(totalBytes);
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }

                @Override
                public ByteBuffer next() {
                    this.hasNext = false;
                    return buffer;
                }
            };
        }

        @Override
        public String toText() {
            return "[" + String.join((CharSequence)",", this.strings) + "]";
        }
    }

    private static class UMBOut {
        private final OutputStream fsOut;
        private final CompressorOutputStream zipOut;
        private final ArchiveOutputStream tarOut;

        public UMBOut(File file) throws UMBException {
            this(file, true);
        }

        public UMBOut(File file, boolean bl) throws UMBException {
            this(file, bl, null);
        }

        public UMBOut(File file, boolean bl, UMBFormat.CompressionFormat compressionFormat) throws UMBException {
            try {
                this.fsOut = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));
                if (bl) {
                    if (compressionFormat == null) {
                        compressionFormat = UMBFormat.DEFAULT_COMPRESSION_FORMAT;
                    }
                    this.zipOut = new CompressorStreamFactory().createCompressorOutputStream(compressionFormat.extension(), this.fsOut);
                    this.tarOut = new TarArchiveOutputStream((OutputStream)this.zipOut);
                } else {
                    this.zipOut = null;
                    this.tarOut = new TarArchiveOutputStream(this.fsOut);
                }
            }
            catch (IOException iOException) {
                throw new UMBException("Could not create UMB file: " + iOException.getMessage());
            }
            catch (CompressorException compressorException) {
                throw new UMBException("Could not create zip for UMB file: " + compressorException.getMessage());
            }
        }

        public void createArchiveEntry(String string, long l) throws UMBException {
            try {
                File file = new File(string);
                TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(file);
                tarArchiveEntry.setSize(l);
                this.tarOut.putArchiveEntry((ArchiveEntry)tarArchiveEntry);
            }
            catch (IOException iOException) {
                throw new UMBException("I/O error writing \"" + string + "\" to UMB file: " + iOException.getMessage());
            }
        }

        public void closeArchiveEntry() throws UMBException {
            try {
                this.tarOut.closeArchiveEntry();
            }
            catch (IOException iOException) {
                throw new UMBException("I/O error writing to UMB file: " + iOException.getMessage());
            }
        }

        public void write(byte[] byArray, int n, int n2) throws UMBException {
            try {
                this.tarOut.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                throw new UMBException("I/O error writing to UMB file");
            }
        }

        public void close() throws UMBException {
            try {
                if (this.tarOut != null) {
                    this.tarOut.finish();
                }
                if (this.zipOut != null) {
                    this.zipOut.close();
                }
                if (this.fsOut != null) {
                    this.fsOut.close();
                }
            }
            catch (IOException iOException) {
                throw new UMBException("I/O error closing UMB file");
            }
        }
    }

    static abstract class UMBDataFile {
        protected String name;
        protected ByteBuffer buffer;

        UMBDataFile() {
        }

        public abstract long totalBytes();

        public abstract Iterator<ByteBuffer> byteIterator();

        public abstract String toText() throws UMBException;
    }

    static abstract class Array
    extends UMBDataFile {
        protected long size;
        protected int bufferSize;

        Array() {
        }

        public abstract int numBytes();

        public abstract boolean hasNextBytes();

        public abstract void encodeNextBytes();

        @Override
        public long totalBytes() {
            return this.size * (long)this.numBytes();
        }

        public abstract Iterator<? extends Object> iterator();

        @Override
        public Iterator<ByteBuffer> byteIterator() {
            return new Iterator<ByteBuffer>(){
                {
                    buffer = ByteBuffer.allocate(BUFFER_SIZE).order(ByteOrder.LITTLE_ENDIAN);
                }

                @Override
                public boolean hasNext() {
                    return this.hasNextBytes();
                }

                @Override
                public ByteBuffer next() {
                    buffer.clear();
                    this.encodeNextBytes();
                    return buffer;
                }
            };
        }

        public String nextAsText() throws UMBException {
            return this.iterator().next().toString();
        }

        @Override
        public String toText() throws UMBException {
            StringJoiner stringJoiner = new StringJoiner(",", "[", "]");
            while (this.hasNextBytes()) {
                stringJoiner.add(this.nextAsText());
            }
            return stringJoiner.toString();
        }
    }
}

