/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.ModelExportFormat;
import io.github.pmctools.umbj.UMBFormat;
import java.util.Optional;

public class ModelExportOptions
implements Cloneable {
    private Optional<ModelExportFormat> format = Optional.empty();
    private Optional<Integer> modelPrecision = Optional.empty();
    private Optional<Boolean> showLabels = Optional.empty();
    private Optional<Boolean> showRewards = Optional.empty();
    private Optional<Boolean> showStates = Optional.empty();
    private Optional<Boolean> showObservations = Optional.empty();
    private Optional<Boolean> showActions = Optional.empty();
    private Optional<Boolean> printHeaders = Optional.empty();
    private Optional<Boolean> explicitRows = Optional.empty();
    private Optional<Boolean> binaryAsText = Optional.empty();
    private Optional<Boolean> zipped = Optional.empty();
    private Optional<CompressionFormat> zipFormat = Optional.empty();

    public ModelExportOptions() {
    }

    public ModelExportOptions(ModelExportFormat modelExportFormat) {
        this.setFormat(modelExportFormat);
    }

    public ModelExportOptions(ModelExportOptions modelExportOptions) {
        this.apply(modelExportOptions);
    }

    public ModelExportOptions setFormat(ModelExportFormat modelExportFormat) {
        this.format = Optional.of(modelExportFormat);
        return this;
    }

    public ModelExportOptions setModelPrecision(int n) {
        this.modelPrecision = Optional.of(n);
        return this;
    }

    public ModelExportOptions setShowLabels(boolean bl) {
        this.showLabels = Optional.of(bl);
        return this;
    }

    public ModelExportOptions setShowRewards(boolean bl) {
        this.showRewards = Optional.of(bl);
        return this;
    }

    public ModelExportOptions setShowStates(boolean bl) {
        this.showStates = Optional.of(bl);
        return this;
    }

    public ModelExportOptions setShowObservations(boolean bl) {
        this.showObservations = Optional.of(bl);
        return this;
    }

    public ModelExportOptions setShowActions(boolean bl) {
        this.showActions = Optional.of(bl);
        return this;
    }

    public ModelExportOptions setPrintHeaders(boolean bl) {
        this.printHeaders = Optional.of(bl);
        return this;
    }

    public ModelExportOptions setExplicitRows(boolean bl) {
        this.explicitRows = Optional.of(bl);
        return this;
    }

    public ModelExportOptions setBinaryAsText(boolean bl) {
        this.binaryAsText = Optional.of(bl);
        return this;
    }

    public ModelExportOptions setZipped(boolean bl) {
        this.zipped = Optional.of(bl);
        return this;
    }

    public ModelExportOptions setCompressionFormat(CompressionFormat compressionFormat) {
        this.zipFormat = Optional.of(compressionFormat);
        return this;
    }

    public void apply(ModelExportOptions modelExportOptions) {
        if (modelExportOptions.format.isPresent()) {
            this.setFormat(modelExportOptions.getFormat());
        }
        if (modelExportOptions.modelPrecision.isPresent()) {
            this.setModelPrecision(modelExportOptions.getModelPrecision());
        }
        if (modelExportOptions.showLabels.isPresent()) {
            this.setShowLabels(modelExportOptions.getShowLabels());
        }
        if (modelExportOptions.showRewards.isPresent()) {
            this.setShowRewards(modelExportOptions.getShowRewards());
        }
        if (modelExportOptions.showStates.isPresent()) {
            this.setShowStates(modelExportOptions.getShowStates());
        }
        if (modelExportOptions.showObservations.isPresent()) {
            this.setShowObservations(modelExportOptions.getShowObservations());
        }
        if (modelExportOptions.showActions.isPresent()) {
            this.setShowActions(modelExportOptions.getShowActions());
        }
        if (modelExportOptions.printHeaders.isPresent()) {
            this.setPrintHeaders(modelExportOptions.getPrintHeaders());
        }
        if (modelExportOptions.explicitRows.isPresent()) {
            this.setExplicitRows(modelExportOptions.getExplicitRows());
        }
        if (modelExportOptions.binaryAsText.isPresent()) {
            this.setBinaryAsText(modelExportOptions.getBinaryAsText());
        }
        if (modelExportOptions.zipped.isPresent()) {
            this.setZipped(modelExportOptions.getZipped());
        }
        if (modelExportOptions.zipFormat.isPresent()) {
            this.setCompressionFormat(modelExportOptions.getCompressionFormat());
        }
    }

    public ModelExportOptions applyTo(ModelExportOptions modelExportOptions) {
        ModelExportOptions modelExportOptions2 = modelExportOptions.clone();
        modelExportOptions2.apply(this);
        return modelExportOptions2;
    }

    public ModelExportFormat getFormat() {
        return this.format.orElse(ModelExportFormat.EXPLICIT);
    }

    public int getModelPrecision() {
        return this.modelPrecision.orElse(16);
    }

    public boolean getShowLabels() {
        return this.showLabels.orElse(true);
    }

    public boolean getShowRewards() {
        return this.showRewards.orElse(true);
    }

    public boolean getShowStates() {
        return this.showStates.orElse(true);
    }

    public boolean getShowObservations() {
        return this.showObservations.orElse(true);
    }

    public boolean getShowActions() {
        return this.showActions.orElse(true);
    }

    public boolean getShowActions(boolean bl) {
        return this.showActions.orElse(bl);
    }

    public boolean getPrintHeaders() {
        return this.printHeaders.orElse(true);
    }

    public boolean getExplicitRows() {
        return this.explicitRows.orElse(false);
    }

    public boolean getBinaryAsText() {
        return this.binaryAsText.orElse(false);
    }

    public boolean getZipped() {
        return this.zipped.orElse(this.getFormat() == ModelExportFormat.UMB);
    }

    public CompressionFormat getCompressionFormat() {
        return this.getCompressionFormat(CompressionFormat.GZIP);
    }

    public CompressionFormat getCompressionFormat(CompressionFormat compressionFormat) {
        return this.zipFormat.orElse(CompressionFormat.GZIP);
    }

    public ModelExportOptions clone() {
        try {
            return (ModelExportOptions)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Object#clone is expected to work for Cloneable objects", cloneNotSupportedException);
        }
    }

    public static enum CompressionFormat {
        GZIP,
        XZ;


        public String extension() {
            switch (this.ordinal()) {
                case 0: {
                    return "gz";
                }
                case 1: {
                    return "xz";
                }
            }
            throw new IllegalStateException("Unknown compression format: " + String.valueOf((Object)this));
        }

        public static CompressionFormat fromUMB(UMBFormat.CompressionFormat compressionFormat) {
            switch (compressionFormat) {
                case GZIP: {
                    return GZIP;
                }
                case XZ: {
                    return XZ;
                }
            }
            throw new IllegalStateException("Unknown compression format: " + String.valueOf((Object)compressionFormat));
        }

        public UMBFormat.CompressionFormat toUMB() {
            switch (this.ordinal()) {
                case 0: {
                    return UMBFormat.CompressionFormat.GZIP;
                }
                case 1: {
                    return UMBFormat.CompressionFormat.XZ;
                }
            }
            throw new IllegalStateException("Unknown compression format: " + String.valueOf((Object)this));
        }
    }
}

