/*
 * Decompiled with CFR 0.152.
 */
package io;

import common.Interval;
import io.ModelAccess;
import it.unimi.dsi.fastutil.longs.LongConsumer;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import param.BigRational;

public class ModelAccessIterators {

    public static class PackBigRationals
    implements LongConsumer {
        Consumer<BigRational> cons;
        long num;
        boolean first = true;

        public PackBigRationals(Consumer<BigRational> consumer) {
            this.cons = consumer;
        }

        public void accept(long l) {
            if (this.first) {
                this.num = l;
                this.first = false;
            } else {
                this.first = true;
                this.cons.accept(new BigRational(this.num, l));
            }
        }
    }

    public static class UnpackBigRationals
    implements PrimitiveIterator.OfLong {
        Iterator<BigRational> iter;
        BigRational next;
        boolean first = true;

        public UnpackBigRationals(Iterator<BigRational> iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return !this.first || this.iter.hasNext();
        }

        @Override
        public long nextLong() {
            if (this.first) {
                this.next = this.iter.next();
                this.first = false;
                return this.next.getNum().longValueExact();
            }
            this.first = true;
            return this.next.getDen().longValueExact();
        }
    }

    public static class UnpackIntervals<V>
    implements Iterator<V> {
        Iterator<Interval<V>> iter;
        Interval<V> next;
        boolean first = true;

        public UnpackIntervals(Iterator<Interval<V>> iterator) {
            this.iter = iterator;
        }

        @Override
        public boolean hasNext() {
            return !this.first || this.iter.hasNext();
        }

        @Override
        public V next() {
            if (this.first) {
                this.next = this.iter.next();
                this.first = false;
                return this.next.getLower();
            }
            this.first = true;
            return this.next.getUpper();
        }
    }

    public static abstract class GetTransitionIntValues<Value>
    extends GetTransitionValues<Value, Integer>
    implements PrimitiveIterator.OfInt {
        int intValue;

        GetTransitionIntValues(ModelAccess<Value> modelAccess) {
            super(modelAccess);
        }

        GetTransitionIntValues(ModelAccess<Value> modelAccess, boolean bl) {
            super(modelAccess, bl);
        }

        protected abstract int getIntValue();

        @Override
        public Integer getValue() {
            return this.getIntValue();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.transition = (Map.Entry)this.itTransitions.next();
            if (this.storeActions) {
                this.actionIndex = this.itActionIndices.next();
            }
            this.intValue = this.getIntValue();
            if (!this.itTransitions.hasNext()) {
                this.incr();
                this.skipEmpty();
            }
            return this.intValue;
        }
    }

    public static abstract class GetTransitionValues<Value, E>
    implements Iterator<E> {
        final ModelAccess<Value> model;
        final boolean storeActions;
        final int numStates;
        int s;
        int numChoices;
        int i;
        Iterator<Map.Entry<Integer, Value>> itTransitions;
        PrimitiveIterator.OfInt itActionIndices;
        int j;
        Map.Entry<Integer, Value> transition;
        int actionIndex;
        boolean hasNext;
        E value;

        GetTransitionValues(ModelAccess<Value> modelAccess) {
            this(modelAccess, false);
        }

        GetTransitionValues(ModelAccess<Value> modelAccess, boolean bl) {
            this.model = modelAccess;
            this.storeActions = bl;
            this.numStates = modelAccess.getNumStates();
            this.numChoices = this.numStates > 0 ? modelAccess.getNumChoices(0) : 0;
            Iterator<Map.Entry<Integer, Value>> iterator = this.itTransitions = this.numChoices > 0 ? modelAccess.getTransitionsIterator(this.s, this.i) : null;
            if (bl) {
                this.itActionIndices = this.numChoices > 0 ? modelAccess.getTransitionActionIndicesIterator(this.s, this.i) : null;
            }
            this.hasNext = this.numStates > 0;
            this.skipEmpty();
        }

        protected void skipEmpty() {
            while (this.hasNext) {
                if (this.s < this.numStates && this.numChoices > 0 && this.itTransitions.hasNext()) {
                    return;
                }
                this.incr();
            }
        }

        protected void incr() {
            ++this.i;
            if (this.i >= this.numChoices) {
                ++this.s;
                if (this.s >= this.numStates) {
                    this.hasNext = false;
                    return;
                }
                this.numChoices = this.model.getNumChoices(this.s);
                this.i = 0;
            }
            Iterator<Map.Entry<Integer, Value>> iterator = this.itTransitions = this.numChoices > 0 ? this.model.getTransitionsIterator(this.s, this.i) : null;
            if (this.storeActions) {
                this.itActionIndices = this.numChoices > 0 ? this.model.getTransitionActionIndicesIterator(this.s, this.i) : null;
            }
            this.j = 0;
        }

        protected abstract E getValue();

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.transition = this.itTransitions.next();
            if (this.storeActions) {
                this.actionIndex = this.itActionIndices.next();
            }
            this.value = this.getValue();
            if (!this.itTransitions.hasNext()) {
                this.incr();
                this.skipEmpty();
            } else {
                ++this.j;
            }
            return this.value;
        }
    }

    public static class GetChoiceTransitionCounts<Value>
    extends GetChoiceIntValues<Value> {
        GetChoiceTransitionCounts(ModelAccess<Value> modelAccess) {
            super(modelAccess);
        }

        @Override
        public int getIntValue() {
            return this.model.getNumTransitions(this.s, this.i);
        }
    }

    public static abstract class GetChoiceIntValues<Value>
    extends GetChoiceValues<Value, Integer>
    implements PrimitiveIterator.OfInt {
        int intValue;

        GetChoiceIntValues(ModelAccess<Value> modelAccess) {
            super(modelAccess);
        }

        protected abstract int getIntValue();

        @Override
        public Integer getValue() {
            return this.getIntValue();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.intValue = this.getIntValue();
            this.incr();
            return this.intValue;
        }
    }

    public static abstract class GetChoiceValues<Value, E>
    implements Iterator<E> {
        final ModelAccess<Value> model;
        final int numStates;
        int s;
        int numChoices;
        int i;
        boolean hasNext;
        E value;

        GetChoiceValues(ModelAccess<Value> modelAccess) {
            this.model = modelAccess;
            this.numStates = modelAccess.getNumStates();
            this.numChoices = this.numStates > 0 ? modelAccess.getNumChoices(0) : 0;
            this.hasNext = this.numStates > 0;
            this.skipEmpty();
        }

        protected void skipEmpty() {
            while (this.hasNext) {
                if (this.s < this.numStates && this.numChoices > 0) {
                    return;
                }
                this.incr();
            }
        }

        protected void incr() {
            ++this.i;
            if (this.i >= this.numChoices) {
                ++this.s;
                if (this.s >= this.numStates) {
                    this.hasNext = false;
                    return;
                }
                this.numChoices = this.model.getNumChoices(this.s);
                this.i = 0;
            }
        }

        protected abstract E getValue();

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.value = this.getValue();
            this.incr();
            this.skipEmpty();
            return this.value;
        }
    }

    public static class GetStateTransitionCounts<Value>
    extends GetStateIntValues<Value> {
        GetStateTransitionCounts(ModelAccess<Value> modelAccess) {
            super(modelAccess);
        }

        @Override
        public int getIntValue() {
            return this.model.getNumTransitions(this.s);
        }
    }

    public static class GetStateChoiceCounts<Value>
    extends GetStateIntValues<Value> {
        GetStateChoiceCounts(ModelAccess<Value> modelAccess) {
            super(modelAccess);
        }

        @Override
        public int getIntValue() {
            return this.model.getNumChoices(this.s);
        }
    }

    public static abstract class GetStateIntValues<Value>
    extends GetStateValues<Value, Integer>
    implements PrimitiveIterator.OfInt {
        int intValue;

        GetStateIntValues(ModelAccess<Value> modelAccess) {
            super(modelAccess);
        }

        protected abstract int getIntValue();

        @Override
        public Integer getValue() {
            return this.getIntValue();
        }

        @Override
        public int nextInt() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.intValue = this.getIntValue();
            this.incr();
            return this.intValue;
        }
    }

    public static abstract class GetStateValues<Value, E>
    implements Iterator<E> {
        final ModelAccess<Value> model;
        final int numStates;
        int s;
        boolean hasNext;
        int numChoices;
        E value;

        GetStateValues(ModelAccess<Value> modelAccess) {
            this.model = modelAccess;
            this.numStates = modelAccess.getNumStates();
            this.hasNext = this.numStates > 0;
        }

        protected void incr() {
            ++this.s;
            if (this.s >= this.numStates) {
                this.hasNext = false;
            }
        }

        protected abstract E getValue();

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            this.value = this.getValue();
            this.incr();
            return this.value;
        }
    }
}

