/*
 * Decompiled with CFR 0.152.
 */
package explicit.modelviews;

import common.IterableBitSet;
import common.functions.PairPredicateInt;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class EquivalenceRelationInteger
implements PairPredicateInt {
    protected final Map<Integer, BitSet> classes = new HashMap<Integer, BitSet>();
    protected final BitSet nonRepresentatives = new BitSet();

    public EquivalenceRelationInteger() {
    }

    public EquivalenceRelationInteger(Iterable<BitSet> iterable) {
        block4: for (BitSet bitSet : iterable) {
            switch (bitSet.cardinality()) {
                case 0: {
                    throw new IllegalArgumentException("expected non-empty classes");
                }
                case 1: {
                    continue block4;
                }
            }
            for (Integer n : new IterableBitSet(bitSet)) {
                if (this.classes.put(n, bitSet) == null) continue;
                throw new IllegalArgumentException("expected disjoint classes");
            }
            this.nonRepresentatives.or(bitSet);
            this.nonRepresentatives.clear(bitSet.nextSetBit(0));
        }
    }

    @Override
    public boolean test(int n, int n2) {
        if (n == n2) {
            return true;
        }
        BitSet bitSet = this.classes.get(n);
        return bitSet != null && bitSet.get(n2);
    }

    public int getRepresentative(int n) {
        BitSet bitSet = this.classes.get(n);
        return bitSet == null ? n : bitSet.nextSetBit(0);
    }

    public BitSet getEquivalenceClass(int n) {
        BitSet bitSet = this.getEquivalenceClassOrNull(n);
        if (bitSet == null) {
            bitSet = new BitSet(n + 1);
            bitSet.set(n);
        }
        return bitSet;
    }

    public BitSet getEquivalenceClassOrNull(int n) {
        return this.classes.get(n);
    }

    public BitSet getNonRepresentatives() {
        return this.nonRepresentatives;
    }

    public boolean isRepresentative(int n) {
        return !this.nonRepresentatives.get(n);
    }

    public static class KeepSingletons
    extends EquivalenceRelationInteger {
        public KeepSingletons(Iterable<BitSet> iterable) {
            for (BitSet bitSet : iterable) {
                switch (bitSet.cardinality()) {
                    case 0: {
                        throw new IllegalArgumentException("expected non-empty classes");
                    }
                }
                for (Integer n : new IterableBitSet(bitSet)) {
                    if (this.classes.put(n, bitSet) == null) continue;
                    throw new IllegalArgumentException("expected disjoint classes");
                }
                this.nonRepresentatives.or(bitSet);
                this.nonRepresentatives.clear(bitSet.nextSetBit(0));
            }
        }

        @Override
        public BitSet getEquivalenceClassOrNull(int n) {
            BitSet bitSet = super.getEquivalenceClassOrNull(n);
            if (bitSet == null) {
                return null;
            }
            return bitSet.cardinality() == 1 ? null : bitSet;
        }

        public BitSet getOriginalEquivalenceClass(int n) {
            return (BitSet)this.classes.get(n);
        }
    }
}

