/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.Model;
import explicit.SuccessorsIterator;
import explicit.graphviz.Decoration;
import explicit.graphviz.Decorator;
import io.ModelExportOptions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.IntPredicate;
import prism.ActionList;
import prism.PrismException;
import prism.PrismLog;
import strat.MDStrategy;

public interface NondetModel<Value>
extends Model<Value> {
    @Override
    default public List<Object> findActionsUsed() {
        if (this.onlyNullActionUsed()) {
            return Collections.singletonList(null);
        }
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getNumChoices(i);
            for (int j = 0; j < n2; ++j) {
                linkedHashSet.add(this.getAction(i, j));
            }
        }
        return new ArrayList<Object>(linkedHashSet);
    }

    public int getNumChoices(int var1);

    default public int getMaxNumChoices() {
        int n = 0;
        int n2 = this.getNumStates();
        for (int i = 0; i < n2; ++i) {
            n = Math.max(n, this.getNumChoices(i));
        }
        return n;
    }

    default public int getNumChoices() {
        int n = 0;
        int n2 = this.getNumStates();
        for (int i = 0; i < n2; ++i) {
            n += this.getNumChoices(i);
        }
        return n;
    }

    public Object getAction(int var1, int var2);

    default public String getActionString(int n, int n2) {
        return ActionList.actionString(this.getAction(n, n2));
    }

    default public int getActionIndex(int n, int n2) {
        return this.actionIndex(this.getAction(n, n2));
    }

    default public List<Object> getAvailableActions(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n2 = this.getNumChoices(n);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(this.getAction(n, i));
        }
        return arrayList;
    }

    default public int getChoiceByAction(int n, Object object) {
        int n2 = this.getNumChoices(n);
        for (int i = 0; i < n2; ++i) {
            if (!Objects.equals(this.getAction(n, i), object)) continue;
            return i;
        }
        return -1;
    }

    default public boolean areAllChoiceActionsUnique() {
        int n = this.getNumStates();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < n; ++i) {
            int n2 = this.getNumChoices(i);
            if (n2 <= 1) continue;
            hashSet.clear();
            for (int j = 0; j < n2; ++j) {
                if (hashSet.add(this.getAction(i, j))) continue;
                return false;
            }
        }
        return true;
    }

    default public void checkActionsMatchExactly(int n, int n2) throws PrismException {
        int n3 = this.getNumChoices(n);
        if (n3 != this.getNumChoices(n2)) {
            throw new PrismException("Differing actions found in states: " + String.valueOf(this.getAvailableActions(n)) + " vs. " + String.valueOf(this.getAvailableActions(n2)));
        }
        for (int i = 0; i < n3; ++i) {
            Object object = this.getAction(n, i);
            Object object2 = this.getAction(n2, i);
            if (!(object == null ? object2 != null : !object.equals(object2))) continue;
            throw new PrismException("Differing actions found in states: " + String.valueOf(this.getAvailableActions(n)) + " vs. " + String.valueOf(this.getAvailableActions(n2)));
        }
    }

    default public void checkActionsMatch(int n, int n2) throws PrismException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            Object object = this.getAction(n, i);
            arrayList.add(object == null ? "" : object.toString());
        }
        Collections.sort(arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        n3 = this.getNumChoices(n2);
        for (int i = 0; i < n3; ++i) {
            Object object = this.getAction(n2, i);
            arrayList2.add(object == null ? "" : object.toString());
        }
        Collections.sort(arrayList2);
        if (!arrayList.equals(arrayList2)) {
            throw new PrismException("Differing actions found in states: " + String.valueOf(arrayList) + " vs. " + String.valueOf(arrayList2));
        }
    }

    public int getNumTransitions(int var1, int var2);

    @Override
    default public int getNumTransitions(int n) {
        int n2 = 0;
        int n3 = this.getNumChoices(n);
        for (int i = 0; i < n3; ++i) {
            n2 += this.getNumTransitions(n, i);
        }
        return n2;
    }

    default public boolean allSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.allSuccessorsMatch(n, n2, bitSet::get);
    }

    default public boolean someSuccessorsInSet(int n, int n2, BitSet bitSet) {
        return this.someSuccessorsMatch(n, n2, bitSet::get);
    }

    default public boolean successorsSafeAndCanReach(int n, int n2, BitSet bitSet, BitSet bitSet2) {
        return this.successorsSafeAndCanReach(n, n2, bitSet::get, bitSet2::get);
    }

    default public boolean allSuccessorsMatch(int n, int n2, IntPredicate intPredicate) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n, n2);
        while (successorsIterator.hasNext()) {
            int n3 = successorsIterator.nextInt();
            if (intPredicate.test(n3)) continue;
            return false;
        }
        return true;
    }

    default public boolean someSuccessorsMatch(int n, int n2, IntPredicate intPredicate) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n, n2);
        while (successorsIterator.hasNext()) {
            int n3 = successorsIterator.nextInt();
            if (!intPredicate.test(n3)) continue;
            return true;
        }
        return false;
    }

    default public boolean successorsSafeAndCanReach(int n, int n2, IntPredicate intPredicate, IntPredicate intPredicate2) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n, n2);
        boolean bl = false;
        while (successorsIterator.hasNext()) {
            int n3 = successorsIterator.nextInt();
            if (!intPredicate.test(n3)) {
                return false;
            }
            if (bl) continue;
            bl = intPredicate2.test(n3);
        }
        return bl;
    }

    default public Iterator<Integer> getSuccessorsIterator(int n, int n2) {
        SuccessorsIterator successorsIterator = this.getSuccessors(n, n2);
        return successorsIterator.distinct();
    }

    public SuccessorsIterator getSuccessors(int var1, int var2);

    @Override
    default public SuccessorsIterator getSuccessors(final int n) {
        return SuccessorsIterator.chain(new Iterator<SuccessorsIterator>(){
            private int choice = 0;
            private final int choices = NondetModel.this.getNumChoices(n);

            @Override
            public boolean hasNext() {
                return this.choice < this.choices;
            }

            @Override
            public SuccessorsIterator next() {
                return NondetModel.this.getSuccessors(n, this.choice++);
            }
        });
    }

    default public void prob0step(BitSet bitSet, BitSet bitSet2, boolean bl, BitSet bitSet3) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            boolean bl2 = bl;
            int n2 = this.getNumChoices(n);
            for (int i = 0; i < n2; ++i) {
                boolean bl3 = this.someSuccessorsInSet(n, i, bitSet2);
                if (bl) {
                    if (bl3) continue;
                    bl2 = false;
                    break;
                }
                if (!bl3) continue;
                bl2 = true;
                break;
            }
            bitSet3.set(n, bl2);
        }
    }

    default public void prob1Astep(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            boolean bl = true;
            int n2 = this.getNumChoices(n);
            for (int i = 0; i < n2; ++i) {
                if (this.successorsSafeAndCanReach(n, i, bitSet2, bitSet3)) continue;
                bl = false;
                break;
            }
            bitSet4.set(n, bl);
        }
    }

    default public void prob1Estep(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4, int[] nArray) {
        int n = -1;
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n2 = ofInt.nextInt();
            boolean bl = false;
            int n3 = this.getNumChoices(n2);
            for (int i = 0; i < n3; ++i) {
                if (!this.successorsSafeAndCanReach(n2, i, bitSet2, bitSet3)) continue;
                bl = true;
                if (nArray == null) break;
                n = i;
                break;
            }
            if (nArray != null & bl & !bitSet4.get(n2)) {
                nArray[n2] = n;
            }
            bitSet4.set(n2, bl);
        }
    }

    default public void prob1step(BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl, BitSet bitSet4) {
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            boolean bl2 = bl;
            int n2 = this.getNumChoices(n);
            for (int i = 0; i < n2; ++i) {
                boolean bl3 = this.successorsSafeAndCanReach(n, i, bitSet2, bitSet3);
                if (bl) {
                    if (bl3) continue;
                    bl2 = false;
                    break;
                }
                if (!bl3) continue;
                bl2 = true;
                break;
            }
            bitSet4.set(n, bl2);
        }
    }

    default public boolean prob1stepSingle(int n, int n2, BitSet bitSet, BitSet bitSet2) {
        return this.successorsSafeAndCanReach(n, n2, bitSet, bitSet2);
    }

    public Model<Value> constructInducedModel(MDStrategy<Value> var1);

    default public void exportToDotFileWithStrat(PrismLog prismLog, BitSet bitSet, int[] nArray) throws PrismException {
        this.exportToDotFileWithStrat(prismLog, bitSet, nArray, 16);
    }

    default public void exportToDotFileWithStrat(PrismLog prismLog, final BitSet bitSet, final int[] nArray, int n) throws PrismException {
        ArrayList<Decorator> arrayList = new ArrayList<Decorator>();
        if (bitSet != null) {
            arrayList.add(new Decorator(){

                @Override
                public Decoration decorateState(int n, Decoration decoration) {
                    if (bitSet.get(n)) {
                        decoration.attributes().put("style", "filled");
                        decoration.attributes().put("fillcolor", "#cccccc");
                    }
                    return decoration;
                }
            });
        }
        if (nArray != null) {
            arrayList.add(new Decorator(){

                @Override
                public Decoration decorateTransition(int n, int n2, Decoration decoration) {
                    if (nArray[n] == n2) {
                        decoration.attributes().put("color", "#ff0000");
                        decoration.attributes().put("fontcolor", "#ff0000");
                    }
                    return decoration;
                }
            });
        }
        this.exportToDotFile(prismLog, new ModelExportOptions().setModelPrecision(n), arrayList);
    }
}

