/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IterableStateSet;
import common.iterable.FunctionalIterator;
import common.iterable.PrimitiveIterable;
import common.iterable.Reducible;
import explicit.Model;
import explicit.rewards.MCRewards;
import java.io.FileWriter;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.TreeMap;
import java.util.function.Function;
import prism.ActionList;
import prism.ModelType;
import prism.Pair;
import prism.PrismException;

public interface DTMC<Value>
extends Model<Value> {
    @Override
    default public ModelType getModelType() {
        return ModelType.DTMC;
    }

    @Override
    default public void exportToPrismLanguage(String string, int n) throws PrismException {
        try (FileWriter fileWriter = new FileWriter(string);){
            fileWriter.write(this.getModelType().keyword() + "\n");
            fileWriter.write("module M\nx : [0.." + (this.getNumStates() - 1) + "];\n");
            TreeMap<Integer, Pair<Value, Object>> treeMap = new TreeMap<Integer, Pair<Value, Object>>();
            int n2 = this.getNumStates();
            for (int i = 0; i < n2; ++i) {
                Iterator<Map.Entry<Integer, Pair<Object, Object>>> iterator = this.getTransitionsAndActionsIterator(i);
                while (iterator.hasNext()) {
                    Map.Entry<Integer, Pair<Value, Object>> entry = iterator.next();
                    treeMap.put(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<Integer, Pair<Object, Object>> entry : treeMap.entrySet()) {
                    String string2 = entry.getValue().second == null ? "" : entry.getValue().second.toString();
                    fileWriter.write("[" + string2 + "]x=" + i + "->");
                    fileWriter.write(this.getEvaluator().toStringPrism(entry.getValue().first, n) + ":(x'=" + String.valueOf(entry.getKey()) + ")");
                    fileWriter.write(";\n");
                }
                treeMap.clear();
            }
            fileWriter.write("endmodule\n");
        }
        catch (IOException iOException) {
            throw new PrismException("Could not export " + String.valueOf((Object)this.getModelType()) + " to file \"" + string + "\"" + String.valueOf(iOException));
        }
    }

    @Override
    default public List<Object> findActionsUsed() {
        if (this.onlyNullActionUsed()) {
            return Collections.singletonList(null);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        int n = this.getNumStates();
        for (int i = 0; i < n; ++i) {
            Iterator<Map.Entry<Integer, Pair<Value, Object>>> iterator = this.getTransitionsAndActionsIterator(i);
            while (iterator.hasNext()) {
                Map.Entry<Integer, Pair<Value, Object>> entry = iterator.next();
                linkedHashSet.add(entry.getValue().second);
            }
        }
        return new ArrayList<Object>(linkedHashSet);
    }

    public Iterator<Map.Entry<Integer, Value>> getTransitionsIterator(int var1);

    default public Iterator<Map.Entry<Integer, Pair<Value, Object>>> getTransitionsAndActionsIterator(int n) {
        Iterator<Map.Entry<Integer, Value>> iterator = this.getTransitionsIterator(n);
        return Reducible.extend(iterator).map(entry -> DTMC.attachAction(entry, null));
    }

    default public Iterator<Object> getActionsIterator(int n) {
        return Collections.nCopies(this.getNumTransitions(n), null).iterator();
    }

    default public PrimitiveIterator.OfInt getActionIndicesIterator(final int n) {
        return new PrimitiveIterator.OfInt(){
            private final Iterator<Object> iter;
            {
                this.iter = DTMC.this.getActionsIterator(n);
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public int nextInt() {
                return DTMC.this.actionIndex(this.iter.next());
            }
        };
    }

    default public Iterator<String> getActionStringsIterator(final int n) {
        return new Iterator<String>(){
            private final Iterator<Object> iter;
            {
                this.iter = DTMC.this.getActionsIterator(n);
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public String next() {
                return ActionList.actionString(this.iter.next());
            }
        };
    }

    default public int getTransitionByAction(int n, Object object) {
        Iterator<Object> iterator = this.getActionsIterator(n);
        int n2 = 0;
        while (iterator.hasNext()) {
            if (Objects.equals(iterator.next(), object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    default public <T> FunctionalIterator<Map.Entry<Integer, T>> getTransitionsMappedIterator(int n, Function<? super Value, ? extends T> function) {
        return Reducible.extend(this.getTransitionsIterator(n)).map(entry -> new AbstractMap.SimpleImmutableEntry((Integer)entry.getKey(), function.apply((Object)entry.getValue())));
    }

    public static <Value> Map.Entry<Integer, Pair<Value, Object>> attachAction(Map.Entry<Integer, Value> entry, Object object) {
        Integer n = entry.getKey();
        Value Value2 = entry.getValue();
        return new AbstractMap.SimpleImmutableEntry<Integer, Pair<Value, Object>>(n, new Pair<Value, Object>(Value2, object));
    }

    default public void forEachTransition(int n, TransitionConsumer<Value> transitionConsumer) {
        Iterator<Map.Entry<Integer, Value>> iterator = this.getTransitionsIterator(n);
        while (iterator.hasNext()) {
            Map.Entry<Integer, Value> entry = iterator.next();
            transitionConsumer.accept(n, entry.getKey(), entry.getValue());
        }
    }

    default public Value sumOverTransitions(int n, final TransitionToValueFunction<Value> transitionToValueFunction) {
        class Sum {
            Value sum;

            Sum() {
                this.sum = DTMC.this.getEvaluator().zero();
            }

            void accept(int n, int n2, Value Value2) {
                this.sum = DTMC.this.getEvaluator().add(this.sum, transitionToValueFunction.apply(n, n2, Value2));
            }
        }
        Sum sum = new Sum();
        this.forEachTransition(n, sum::accept);
        return sum.sum;
    }

    default public void forEachDoubleTransition(int n, DoubleTransitionConsumer doubleTransitionConsumer) {
        Iterator<Map.Entry<Integer, Value>> iterator = this.getTransitionsIterator(n);
        while (iterator.hasNext()) {
            Map.Entry<Integer, Value> entry = iterator.next();
            doubleTransitionConsumer.accept(n, entry.getKey(), this.getEvaluator().toDouble(entry.getValue()));
        }
    }

    default public double sumOverDoubleTransitions(int n, final DoubleTransitionToDoubleFunction doubleTransitionToDoubleFunction) {
        class Sum {
            double sum = 0.0;

            Sum() {
            }

            void accept(int n, int n2, double d) {
                this.sum += doubleTransitionToDoubleFunction.apply(n, n2, d);
            }
        }
        Sum sum = new Sum();
        this.forEachDoubleTransition(n, sum::accept);
        return sum.sum;
    }

    default public void mvMult(double[] dArray, double[] dArray2, BitSet bitSet, boolean bl) {
        this.mvMult(dArray, dArray2, new IterableStateSet(bitSet, this.getNumStates(), bl).iterator());
    }

    default public void mvMult(double[] dArray, double[] dArray2, PrimitiveIterator.OfInt ofInt) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultSingle(n, dArray);
        }
    }

    default public double mvMultSingle(int n3, double[] dArray) {
        return this.sumOverDoubleTransitions(n3, (n, n2, d) -> d * dArray[n2]);
    }

    default public double mvMultGS(double[] dArray, BitSet bitSet, boolean bl, boolean bl2) {
        return this.mvMultGS(dArray, new IterableStateSet(bitSet, this.getNumStates(), bl).iterator(), bl2);
    }

    default public double mvMultGS(double[] dArray, PrimitiveIterator.OfInt ofInt, boolean bl) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultJacSingle(n, dArray);
            double d3 = bl ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    default public void mvMultGSIntervalIter(double[] dArray, PrimitiveIterator.OfInt ofInt, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d = this.mvMultJacSingle(n, dArray);
            if (bl) {
                if (bl3) {
                    if (dArray[n] > d) {
                        d = dArray[n];
                    }
                } else if (dArray[n] < d) {
                    d = dArray[n];
                }
            }
            if (bl2) {
                if (bl3) {
                    if (dArray[n] > d) {
                        throw new PrismException("Monotonicity violated (from below): old value " + dArray[n] + " > new value " + d);
                    }
                } else if (dArray[n] < d) {
                    throw new PrismException("Monotonicity violated (from above): old value " + dArray[n] + " < new value " + d);
                }
            }
            dArray[n] = d;
        }
    }

    default public void mvMultJac(double[] dArray, double[] dArray2, PrimitiveIterator.OfInt ofInt) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultJacSingle(n, dArray);
        }
    }

    default public double mvMultJacSingle(int n, final double[] dArray) {
        class Jacobi {
            double diag = 1.0;
            double d = 0.0;

            Jacobi() {
            }

            void accept(int n, int n2, double d) {
                if (n2 != n) {
                    this.d += d * dArray[n2];
                } else {
                    this.diag -= d;
                }
            }
        }
        Jacobi jacobi = new Jacobi();
        this.forEachDoubleTransition(n, jacobi::accept);
        double d = jacobi.d;
        double d2 = jacobi.diag;
        if (d2 > 0.0) {
            d /= d2;
        }
        return d;
    }

    default public void mvMultRew(double[] dArray, MCRewards<Double> mCRewards, double[] dArray2, BitSet bitSet, boolean bl) {
        this.mvMultRew(dArray, mCRewards, dArray2, new IterableStateSet(bitSet, this.getNumStates(), bl).iterator());
    }

    default public void mvMultRew(double[] dArray, MCRewards<Double> mCRewards, double[] dArray2, PrimitiveIterator.OfInt ofInt) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultRewSingle(n, dArray, mCRewards);
        }
    }

    default public void mvMultRewJac(double[] dArray, MCRewards<Double> mCRewards, double[] dArray2, PrimitiveIterator.OfInt ofInt) {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            dArray2[n] = this.mvMultRewJacSingle(n, dArray, mCRewards);
        }
    }

    default public double mvMultRewGS(double[] dArray, MCRewards<Double> mCRewards, PrimitiveIterator.OfInt ofInt, boolean bl) {
        double d = 0.0;
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d2 = this.mvMultRewJacSingle(n, dArray, mCRewards);
            double d3 = bl ? Math.abs(d2 - dArray[n]) : Math.abs(d2 - dArray[n]) / d2;
            d = d3 > d ? d3 : d;
            dArray[n] = d2;
        }
        return d;
    }

    default public void mvMultRewGSIntervalIter(double[] dArray, MCRewards<Double> mCRewards, PrimitiveIterator.OfInt ofInt, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            double d = this.mvMultRewJacSingle(n, dArray, mCRewards);
            if (bl) {
                if (bl3) {
                    if (dArray[n] > d) {
                        d = dArray[n];
                    }
                } else if (dArray[n] < d) {
                    d = dArray[n];
                }
            }
            if (bl2) {
                if (bl3) {
                    if (dArray[n] > d) {
                        throw new PrismException("Monotonicity violated (from below): old value " + dArray[n] + " > new value " + d);
                    }
                } else if (dArray[n] < d) {
                    throw new PrismException("Monotonicity violated (from above): old value " + dArray[n] + " < new value " + d);
                }
            }
            dArray[n] = d;
        }
    }

    default public double mvMultRewSingle(int n3, double[] dArray, MCRewards<Double> mCRewards) {
        double d2 = (Double)mCRewards.getStateReward(n3);
        return d2 += this.sumOverDoubleTransitions(n3, (n, n2, d) -> d * dArray[n2]);
    }

    default public double mvMultRewJacSingle(final int n, final double[] dArray, final MCRewards<Double> mCRewards) {
        class Jacobi {
            double diag = 1.0;
            double d = (Double)mCRewards.getStateReward(n);
            boolean onlySelfLoops = true;

            Jacobi() {
            }

            void accept(int n3, int n2, double d) {
                if (n2 != n3) {
                    this.d += d * dArray[n2];
                    this.onlySelfLoops = false;
                } else {
                    this.diag -= d;
                }
            }
        }
        Jacobi jacobi = new Jacobi();
        this.forEachDoubleTransition(n, jacobi::accept);
        double d = jacobi.d;
        double d2 = jacobi.diag;
        if (jacobi.onlySelfLoops) {
            d = d != 0.0 ? (d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : 0.0;
        } else if (d2 > 0.0) {
            d /= d2;
        }
        return d;
    }

    default public void vmMult(double[] dArray, double[] dArray2) {
        Arrays.fill(dArray2, 0.0);
        int n3 = this.getNumStates();
        for (int i = 0; i < n3; ++i) {
            this.forEachDoubleTransition(i, (n, n2, d) -> {
                int n3 = n2;
                dArray[n3] = dArray2[n3] + d * dArray[n];
            });
        }
    }

    default public void vmMultPowerSteadyState(double[] dArray, double[] dArray2, double[] dArray3, double d, PrimitiveIterable.OfInt ofInt) {
        int n3;
        PrimitiveIterator.OfInt ofInt2 = ofInt.iterator();
        while (ofInt2.hasNext()) {
            n3 = ofInt2.nextInt();
            dArray2[n3] = dArray[n3] * (d * dArray3[n3] + 1.0);
        }
        ofInt2 = ofInt.iterator();
        while (ofInt2.hasNext()) {
            n3 = ofInt2.nextInt();
            this.forEachDoubleTransition(n3, (n, n2, d2) -> {
                if (n != n2) {
                    int n3 = n2;
                    dArray[n3] = dArray2[n3] + d * d2 * dArray[n];
                }
            });
        }
    }

    @FunctionalInterface
    public static interface TransitionConsumer<Value> {
        public void accept(int var1, int var2, Value var3);
    }

    @FunctionalInterface
    public static interface TransitionToValueFunction<Value> {
        public Value apply(int var1, int var2, Value var3);
    }

    @FunctionalInterface
    public static interface DoubleTransitionConsumer {
        public void accept(int var1, int var2, double var3);
    }

    @FunctionalInterface
    public static interface DoubleTransitionToDoubleFunction {
        public double apply(int var1, int var2, double var3);
    }
}

