/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.iterable.FunctionalIterable;
import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.SingletonIterator;

public abstract class SingletonIterable<E>
implements FunctionalIterable<E> {
    @Override
    public long count() {
        return 1L;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public SingletonIterable<E> dedupe() {
        return this;
    }

    @Override
    public SingletonIterable<E> distinct() {
        return this;
    }

    public static class OfLong
    extends SingletonIterable<Long>
    implements FunctionalPrimitiveIterable.OfLong {
        protected final long element;

        public OfLong(long l) {
            this.element = l;
        }

        @Override
        public SingletonIterator.OfLong iterator() {
            return new SingletonIterator.OfLong(this.element);
        }

        @Override
        public OfLong dedupe() {
            return this;
        }

        @Override
        public OfLong distinct() {
            return this;
        }

        @Override
        public boolean contains(long l) {
            return this.element == l;
        }
    }

    public static class OfInt
    extends SingletonIterable<Integer>
    implements FunctionalPrimitiveIterable.OfInt {
        protected final int element;

        public OfInt(int n) {
            this.element = n;
        }

        @Override
        public SingletonIterator.OfInt iterator() {
            return new SingletonIterator.OfInt(this.element);
        }

        @Override
        public OfInt dedupe() {
            return this;
        }

        @Override
        public OfInt distinct() {
            return this;
        }

        @Override
        public boolean contains(int n) {
            return this.element == n;
        }
    }

    public static class OfDouble
    extends SingletonIterable<Double>
    implements FunctionalPrimitiveIterable.OfDouble {
        protected final double element;

        public OfDouble(double d) {
            this.element = d;
        }

        @Override
        public SingletonIterator.OfDouble iterator() {
            return new SingletonIterator.OfDouble(this.element);
        }

        @Override
        public OfDouble dedupe() {
            return this;
        }

        @Override
        public OfDouble distinct() {
            return this;
        }

        @Override
        public boolean contains(double d) {
            return this.element == d;
        }
    }

    public static class Of<E>
    extends SingletonIterable<E> {
        protected final E element;

        public Of(E e) {
            this.element = e;
        }

        @Override
        public FunctionalIterator<E> iterator() {
            return new SingletonIterator.Of<E>(this.element);
        }

        @Override
        public boolean contains(Object object) {
            return this.element == null ? object == null : this.element.equals(object);
        }
    }
}

