/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.kern.Scripting;
import edu.jas.poly.ExpVector;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TermOrder
implements Serializable {
    private static final Logger logger = LogManager.getLogger(TermOrder.class);
    private static final boolean debug = logger.isDebugEnabled();
    public static final int LEX = 1;
    public static final int MIN_EVORD = 1;
    public static final int INVLEX = 2;
    public static final int GRLEX = 3;
    public static final int IGRLEX = 4;
    public static final int REVLEX = 5;
    public static final int REVILEX = 6;
    public static final int REVTDEG = 7;
    public static final int REVITDG = 8;
    public static final int ITDEGLEX = 9;
    public static final int REVITDEG = 10;
    public static final int MAX_EVORD = 10;
    public static final int DEFAULT_EVORD = 4;
    private final int evord;
    private final int evord2;
    private final int evbeg1;
    private final int evend1;
    private final int evbeg2;
    private final int evend2;
    private final long[][] weight;
    private final EVComparator horder;
    private final EVComparator lorder;
    private final EVComparator sugar;
    public final boolean TOP;

    public TermOrder() {
        this(4);
    }

    public TermOrder(int n) {
        if (n < 1 || 10 < n) {
            throw new IllegalArgumentException("invalid term order: " + n);
        }
        this.evord = n;
        this.evord2 = 0;
        this.weight = null;
        this.evbeg1 = 0;
        this.evbeg2 = this.evend1 = Integer.MAX_VALUE;
        this.evend2 = this.evend1;
        this.TOP = false;
        switch (n) {
            case 1: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return expVector.invLexCompareTo(expVector2);
                    }
                };
                break;
            }
            case 2: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return -expVector.invLexCompareTo(expVector2);
                    }
                };
                break;
            }
            case 3: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return expVector.invGradCompareTo(expVector2);
                    }
                };
                break;
            }
            case 4: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return -expVector.invGradCompareTo(expVector2);
                    }
                };
                break;
            }
            case 5: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return expVector.revInvLexCompareTo(expVector2);
                    }
                };
                break;
            }
            case 6: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return -expVector.revInvLexCompareTo(expVector2);
                    }
                };
                break;
            }
            case 7: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return expVector.revInvGradCompareTo(expVector2);
                    }
                };
                break;
            }
            case 8: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return -expVector.revInvGradCompareTo(expVector2);
                    }
                };
                break;
            }
            case 9: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return -expVector.invTdegCompareTo(expVector2);
                    }
                };
                break;
            }
            case 10: {
                this.horder = new EVComparator(){

                    @Override
                    public int compare(ExpVector expVector, ExpVector expVector2) {
                        return expVector.revLexInvTdegCompareTo(expVector2);
                    }
                };
                break;
            }
            default: {
                this.horder = null;
            }
        }
        if (this.horder == null) {
            throw new IllegalArgumentException("invalid term order: " + n);
        }
        this.lorder = new EVComparator(){

            @Override
            public int compare(ExpVector expVector, ExpVector expVector2) {
                return -TermOrder.this.horder.compare(expVector, expVector2);
            }
        };
        this.sugar = new EVComparator(){

            @Override
            public int compare(ExpVector expVector, ExpVector expVector2) {
                return expVector.invGradCompareTo(expVector2);
            }
        };
    }

    public TermOrder(long[] lArray) {
        this(new long[][]{lArray});
    }

    public TermOrder(long[][] lArray) {
        if (lArray == null || lArray.length == 0) {
            throw new IllegalArgumentException("invalid term order weight");
        }
        this.weight = (long[][])Arrays.copyOf(lArray, lArray.length);
        this.evord = 0;
        this.evord2 = 0;
        this.evbeg1 = 0;
        this.evbeg2 = this.evend1 = this.weight[0].length;
        this.evend2 = this.evend1;
        this.TOP = false;
        this.horder = new EVComparator(){

            @Override
            public int compare(ExpVector expVector, ExpVector expVector2) {
                return -expVector.invWeightCompareTo(TermOrder.this.weight, expVector2);
            }
        };
        this.lorder = new EVComparator(){

            @Override
            public int compare(ExpVector expVector, ExpVector expVector2) {
                return expVector.invWeightCompareTo(TermOrder.this.weight, expVector2);
            }
        };
        this.sugar = this.horder;
    }

    public boolean isSplit() {
        return this.evend2 != this.evbeg2 && this.evend1 != Integer.MAX_VALUE;
    }

    public TermOrder(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, false);
    }

    public TermOrder(int n, int n2, int n3, int n4, boolean bl) {
        if (n < 1 || 8 < n) {
            throw new IllegalArgumentException("invalid split term order 1: " + n);
        }
        if (n2 < 1 || 8 < n2) {
            throw new IllegalArgumentException("invalid split term order 2: " + n2);
        }
        this.evord = n;
        this.evord2 = n2;
        this.weight = null;
        this.evbeg1 = 0;
        this.evend1 = n4;
        this.evbeg2 = n4;
        this.evend2 = n3;
        if (this.evbeg2 < 0 || this.evbeg2 > this.evend2) {
            throw new IllegalArgumentException("invalid term order split, r = " + n3 + ", split = " + n4);
        }
        this.TOP = bl;
        if (debug) {
            logger.info("module TermOrder is " + (this.TOP ? "TOP" : "POT") + ", split = " + n4 + ", evord = " + this.toScriptOrder(this.evord) + ", evord2 = " + this.toScriptOrder(this.evord2));
        }
        block0 : switch (this.evord) {
            case 1: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 2: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        if (!this.TOP) {
                            this.horder = new EVComparator(){

                                @Override
                                public int compare(ExpVector expVector, ExpVector expVector2) {
                                    int n = -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                    if (n != 0) {
                                        return n;
                                    }
                                    return -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                                }
                            };
                            break block0;
                        }
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        if (!this.TOP) {
                            this.horder = new EVComparator(){

                                @Override
                                public int compare(ExpVector expVector, ExpVector expVector2) {
                                    int n = -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                    if (n != 0) {
                                        return n;
                                    }
                                    return -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                                }
                            };
                            break block0;
                        }
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 3: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 4: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        if (!this.TOP) {
                            this.horder = new EVComparator(){

                                @Override
                                public int compare(ExpVector expVector, ExpVector expVector2) {
                                    int n = -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                    if (n != 0) {
                                        return n;
                                    }
                                    return -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                                }
                            };
                            break block0;
                        }
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        if (!this.TOP) {
                            this.horder = new EVComparator(){

                                @Override
                                public int compare(ExpVector expVector, ExpVector expVector2) {
                                    int n = -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                    if (n != 0) {
                                        return n;
                                    }
                                    return -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                                }
                            };
                            break block0;
                        }
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 5: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 6: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 7: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            case 8: {
                switch (this.evord2) {
                    case 1: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 2: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 3: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 4: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.invGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 5: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 6: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.revInvLexCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 7: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                    case 8: {
                        this.horder = new EVComparator(){

                            @Override
                            public int compare(ExpVector expVector, ExpVector expVector2) {
                                int n = -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg1, TermOrder.this.evend1);
                                if (n != 0) {
                                    return n;
                                }
                                return -expVector.revInvGradCompareTo(expVector2, TermOrder.this.evbeg2, TermOrder.this.evend2);
                            }
                        };
                        break block0;
                    }
                }
                this.horder = null;
                break;
            }
            default: {
                this.horder = null;
            }
        }
        if (this.horder == null) {
            throw new IllegalArgumentException("invalid term order: " + this.evord + " 2 " + this.evord2);
        }
        this.lorder = new EVComparator(){

            @Override
            public int compare(ExpVector expVector, ExpVector expVector2) {
                return -TermOrder.this.horder.compare(expVector, expVector2);
            }
        };
        this.sugar = new EVComparator(){

            @Override
            public int compare(ExpVector expVector, ExpVector expVector2) {
                return expVector.invGradCompareTo(expVector2);
            }
        };
    }

    public TermOrder blockOrder(int n) {
        return this.blockOrder(n, Integer.MAX_VALUE);
    }

    public TermOrder blockOrder(int n, int n2) {
        return new TermOrder(this.evord, this.evord, n2, n);
    }

    public TermOrder blockOrder(int n, TermOrder termOrder) {
        return this.blockOrder(n, termOrder, Integer.MAX_VALUE);
    }

    public TermOrder blockOrder(int n, TermOrder termOrder, int n2) {
        return new TermOrder(this.evord, termOrder.evord, n2, n);
    }

    public int getEvord() {
        return this.evord;
    }

    public int getEvord2() {
        return this.evord2;
    }

    public int getSplit() {
        return this.evend1;
    }

    public int getSize() {
        return this.evend2;
    }

    public long[][] getWeight() {
        if (this.weight == null) {
            return null;
        }
        return (long[][])Arrays.copyOf(this.weight, this.weight.length);
    }

    public EVComparator getDescendComparator() {
        return this.horder;
    }

    public EVComparator getAscendComparator() {
        return this.lorder;
    }

    public EVComparator getSugarComparator() {
        return this.sugar;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof TermOrder)) {
            return false;
        }
        TermOrder termOrder = (TermOrder)object;
        boolean bl2 = bl = this.evord == termOrder.getEvord() && this.evord2 == termOrder.evord2 && this.evbeg1 == termOrder.evbeg1 && this.evend1 == termOrder.evend1 && this.evbeg2 == termOrder.evbeg2 && this.evend2 == termOrder.evend2;
        if (!bl) {
            return bl;
        }
        return Arrays.deepEquals((Object[])this.weight, (Object[])termOrder.weight);
    }

    public int hashCode() {
        int n = this.evord;
        n = (n << 3) + this.evord2;
        n = (n << 4) + this.evbeg1;
        n = (n << 4) + this.evend1;
        n = (n << 4) + this.evbeg2;
        n = (n << 4) + this.evend2;
        if (this.weight == null) {
            return n;
        }
        n = n * 7 + Arrays.deepHashCode((Object[])this.weight);
        return n;
    }

    public String weightToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.weight != null) {
            stringBuffer.append("(");
            for (int i = 0; i < this.weight.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                long[] lArray = this.weight[i];
                stringBuffer.append("(");
                for (int j = 0; j < lArray.length; ++j) {
                    if (j > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(String.valueOf(lArray[lArray.length - 1 - j]));
                }
                stringBuffer.append(")");
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String weightToScript() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.weight != null) {
            stringBuffer.append("[");
            for (int i = 0; i < this.weight.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                long[] lArray = this.weight[i];
                stringBuffer.append("[");
                for (int j = 0; j < lArray.length; ++j) {
                    if (j > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(String.valueOf(lArray[lArray.length - 1 - j]));
                }
                stringBuffer.append("]");
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public String toScript() {
        if (this.weight != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.weightToScript());
            if (this.evend1 == this.evend2) {
                return stringBuffer.toString();
            }
            stringBuffer.append("[" + this.evbeg1 + "," + this.evend1 + "]");
            stringBuffer.append("[" + this.evbeg2 + "," + this.evend2 + "]");
            return stringBuffer.toString();
        }
        return this.toScriptPlain();
    }

    public String toString() {
        if (this.weight != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("W( ");
            stringBuffer.append(this.weightToString());
            if (this.evend1 == this.evend2) {
                stringBuffer.append(" )");
                return stringBuffer.toString();
            }
            stringBuffer.append("[" + this.evbeg1 + "," + this.evend1 + "]");
            stringBuffer.append("[" + this.evbeg2 + "," + this.evend2 + "]");
            stringBuffer.append(" )");
            return stringBuffer.toString();
        }
        return this.toStringPlain();
    }

    public String toStringPlain() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.weight != null) {
            return stringBuffer.toString();
        }
        stringBuffer.append(this.toScriptOrder(this.evord));
        if (this.evord2 <= 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append("[" + this.evbeg1 + "," + this.evend1 + "]");
        stringBuffer.append(this.toScriptOrder(this.evord2));
        stringBuffer.append("[" + this.evbeg2 + "," + this.evend2 + "]");
        return stringBuffer.toString();
    }

    public String toScriptPlain() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.weight != null) {
            return this.toScript();
        }
        stringBuffer.append("Order");
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("::");
                break;
            }
            default: {
                stringBuffer.append(".");
            }
        }
        stringBuffer.append(this.toScriptOrder(this.evord));
        if (this.evord2 <= 0) {
            return stringBuffer.toString();
        }
        if (this.evord == this.evord2) {
            stringBuffer.append(".blockOrder(" + this.evend1 + ")");
            return stringBuffer.toString();
        }
        stringBuffer.append(".blockOrder(");
        stringBuffer.append(this.evend1 + ",");
        stringBuffer.append("Order");
        switch (Scripting.getLang()) {
            case Ruby: {
                stringBuffer.append("::");
                break;
            }
            default: {
                stringBuffer.append(".");
            }
        }
        stringBuffer.append(this.toScriptOrder(this.evord2));
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String toScriptOrder(int n) {
        switch (Scripting.getCAS()) {
            case Math: {
                switch (n) {
                    case 1: {
                        return "NegativeReverseLexicographic";
                    }
                    case 2: {
                        return "ReverseLexicographic";
                    }
                    case 3: {
                        return "NegativeDegreeReverseLexicographic";
                    }
                    case 9: {
                        return "DegreeReverseLexicographic";
                    }
                    case 5: {
                        return "NegativeLexicographic";
                    }
                    case 6: {
                        return "Lexicographic";
                    }
                    case 10: {
                        return "NegativeDegreeLexicographic";
                    }
                    case 8: {
                        return "DegreeLexicographic";
                    }
                }
                return "invalid(" + n + ")";
            }
            case Sage: {
                switch (n) {
                    case 1: {
                        return "negrevlex";
                    }
                    case 2: {
                        return "invlex";
                    }
                    case 3: {
                        return "negdegrevlex";
                    }
                    case 9: {
                        return "degrevlex";
                    }
                    case 5: {
                        return "neglex";
                    }
                    case 6: {
                        return "lex";
                    }
                    case 10: {
                        return "negdeglex";
                    }
                    case 8: {
                        return "deglex";
                    }
                }
                return "invalid(" + n + ")";
            }
            case Singular: {
                switch (n) {
                    case 2: {
                        return "rp";
                    }
                    case 3: {
                        return "ds";
                    }
                    case 9: {
                        return "dp";
                    }
                    case 5: {
                        return "ls";
                    }
                    case 6: {
                        return "lp";
                    }
                    case 10: {
                        return "Ds";
                    }
                    case 8: {
                        return "Dp";
                    }
                }
                return "invalid(" + n + ")";
            }
        }
        switch (n) {
            case 1: {
                return "LEX";
            }
            case 2: {
                return "INVLEX";
            }
            case 3: {
                return "GRLEX";
            }
            case 4: {
                return "IGRLEX";
            }
            case 5: {
                return "REVLEX";
            }
            case 6: {
                return "REVILEX";
            }
            case 7: {
                return "REVTDEG";
            }
            case 8: {
                return "REVITDG";
            }
            case 9: {
                return "ITDEGLEX";
            }
            case 10: {
                return "REVITDEG";
            }
        }
        return "invalid(" + n + ")";
    }

    public TermOrder extend(int n, int n2) {
        return this.extend(n, n2, false);
    }

    public TermOrder extend(int n, int n2, boolean bl) {
        if (this.weight != null) {
            long[][] lArrayArray = new long[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                long[] lArray = this.weight[i];
                long l = 0L;
                for (int j = 0; j < lArray.length; ++j) {
                    if (lArray[j] <= l) continue;
                    l = lArray[j];
                }
                ++l;
                long[] lArray2 = new long[lArray.length + n2];
                for (int j = 0; j < n2; ++j) {
                    lArray2[j] = l;
                }
                System.arraycopy(lArray, 0, lArray2, n2, lArray.length);
                lArrayArray[i] = lArray2;
            }
            return new TermOrder(lArrayArray);
        }
        if (this.evord2 != 0) {
            logger.debug("warn: TermOrder is already extended");
            if (debug) {
                throw new IllegalArgumentException("TermOrder is already extended: " + this);
            }
            return new TermOrder(this.evord, this.evord2, n + n2, this.evend1 + n2, bl);
        }
        return new TermOrder(4, this.evord, n + n2, n2, bl);
    }

    public TermOrder extendLower(int n, int n2) {
        return this.extendLower(n, n2, false);
    }

    public TermOrder extendLower(int n, int n2, boolean bl) {
        if (this.weight != null) {
            long[][] lArrayArray = new long[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                long[] lArray = this.weight[i];
                long l = Long.MAX_VALUE;
                for (int j = 0; j < lArray.length; ++j) {
                    if (lArray[j] >= l) continue;
                    l = lArray[j];
                }
                long[] lArray2 = new long[lArray.length + n2];
                for (int j = 0; j < n2; ++j) {
                    lArray2[lArray.length + j] = l;
                }
                System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
                lArrayArray[i] = lArray2;
            }
            return new TermOrder(lArrayArray);
        }
        if (this.evord2 != 0) {
            if (debug) {
                logger.warn("TermOrder is already extended");
            }
            return new TermOrder(this.evord, this.evord2, n + n2, this.evend1 + n2, bl);
        }
        return new TermOrder(this.evord, 4, n + n2, n, bl);
    }

    public TermOrder contract(int n, int n2) {
        if (this.weight != null) {
            long[][] lArrayArray = new long[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                long[] lArray = this.weight[i];
                long[] lArray2 = new long[n2];
                System.arraycopy(lArray, n, lArray2, 0, n2);
                lArrayArray[i] = lArray2;
            }
            return new TermOrder(lArrayArray);
        }
        if (this.evord2 == 0) {
            if (debug) {
                logger.warn("TermOrder is already contracted");
            }
            return new TermOrder(this.evord);
        }
        if (this.evend1 > n) {
            int n3;
            for (n3 = this.evend1 - n; n3 > n2; n3 -= n2) {
            }
            if ((long)n3 == 0L) {
                return new TermOrder(this.evord);
            }
            if (n3 == n2) {
                return new TermOrder(this.evord);
            }
            return new TermOrder(this.evord, this.evord2, n2, n3);
        }
        return new TermOrder(this.evord2);
    }

    public TermOrder reverse() {
        return this.reverse(false);
    }

    public TermOrder reverse(boolean bl) {
        if (this.weight != null) {
            if (bl) {
                logger.error("partial reversed weight order not implemented");
            }
            long[][] lArrayArray = new long[this.weight.length][];
            for (int i = 0; i < this.weight.length; ++i) {
                long[] lArray = this.weight[i];
                long[] lArray2 = new long[lArray.length];
                for (int j = 0; j < lArray2.length; ++j) {
                    lArray2[j] = lArray[lArray2.length - 1 - j];
                }
                lArrayArray[i] = lArray2;
            }
            TermOrder termOrder = new TermOrder(lArrayArray);
            logger.info("reverse = {}, from = {}", (Object)termOrder, (Object)this);
            return termOrder;
        }
        if (this.evord2 == 0) {
            TermOrder termOrder = new TermOrder(TermOrder.revert(this.evord));
            return termOrder;
        }
        TermOrder termOrder = bl ? new TermOrder(TermOrder.revert(this.evord), TermOrder.revert(this.evord2), this.evend2, this.evend1) : new TermOrder(TermOrder.revert(this.evord2), TermOrder.revert(this.evord), this.evend2, this.evend2 - this.evbeg2);
        logger.info("reverse = {}, from = {}", (Object)termOrder, (Object)this);
        return termOrder;
    }

    public static int revert(int n) {
        int n2 = n;
        switch (n) {
            case 1: {
                n2 = 5;
                break;
            }
            case 2: {
                n2 = 6;
                break;
            }
            case 3: {
                n2 = 7;
                break;
            }
            case 4: {
                n2 = 8;
                break;
            }
            case 5: {
                n2 = 1;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 4;
                break;
            }
            default: {
                logger.error("can not revert {}", (Object)n);
            }
        }
        return n2;
    }

    public static long[] longArrayPermutation(List<Integer> list, long[] lArray) {
        if (lArray == null || lArray.length <= 1) {
            return lArray;
        }
        long[] lArray2 = new long[lArray.length];
        int n = 0;
        for (Integer n2 : list) {
            lArray2[n] = lArray[n2];
            ++n;
        }
        return lArray2;
    }

    public TermOrder permutation(List<Integer> list) {
        long[][] lArray;
        TermOrder termOrder = this;
        if (this.getEvord2() != 0) {
            termOrder = new TermOrder(this.getEvord2());
            logger.warn("split term order '{}' not permutable, resetting to most base term order {}", (Object)this, (Object)termOrder);
        }
        if ((lArray = this.getWeight()) != null) {
            long[][] lArrayArray = new long[lArray.length][];
            for (int i = 0; i < lArray.length; ++i) {
                lArrayArray[i] = TermOrder.longArrayPermutation(list, lArray[i]);
            }
            termOrder = new TermOrder(lArrayArray);
        }
        return termOrder;
    }

    public static TermOrder reverseWeight(long[][] lArray) {
        if (lArray == null) {
            logger.warn("null weight matrix ignored");
            return new TermOrder();
        }
        long[][] lArrayArray = new long[lArray.length][];
        for (int i = 0; i < lArray.length; ++i) {
            long[] lArray2 = lArray[i];
            long[] lArray3 = new long[lArray2.length];
            for (int j = 0; j < lArray2.length; ++j) {
                lArray3[j] = lArray2[lArray2.length - 1 - j];
            }
            lArrayArray[i] = lArray3;
        }
        return new TermOrder(lArrayArray);
    }

    public static abstract class EVComparator
    implements Comparator<ExpVector>,
    Serializable {
        @Override
        public abstract int compare(ExpVector var1, ExpVector var2);
    }
}

