/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SizeSequence;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import prism.PrismSettings;
import userinterface.GUIPrism;

public class GUITextModelEditorGutter
extends JPanel
implements PropertyChangeListener,
DocumentListener {
    private FontMetrics fontMetrics;
    private JTextComponent textPane;
    private final int PADDING_LEFT = 20;
    private final int PADDING_RIGHT = 4;
    private static final Color BORDER_COLOR = Color.GRAY;
    private static final Color BACKGROUND_COLOR = new Color(204, 204, 204);
    private int textPaneTopPadding;
    private int textFontAscent;
    private int textHeight;
    private int panelWidth;
    private int requiredLineNumbersWidth;
    private SizeSequence lineHeights;
    private int lineCount = 1;
    private int updatedLine = 0;
    private boolean multipleLinesChanged = true;
    private Map<Integer, String> errorMessages;
    private ImageIcon errorIcon = GUIPrism.getIconFromImage("tinyError.png");

    public GUITextModelEditorGutter(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            throw new IllegalArgumentException("The given text pane cannot be null.");
        }
        this.textPane = jTextComponent;
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, BORDER_COLOR));
        this.updatePaintingCache();
        jTextComponent.addPropertyChangeListener(this);
        jTextComponent.getDocument().addDocumentListener(this);
        this.setToolTipText("dummy");
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (this.errorMessages != null) {
            int n = mouseEvent.getY();
            int n2 = this.lineHeights.getIndex(n);
            if (this.errorMessages.containsKey(n2 + 1)) {
                return this.errorMessages.get(n2 + 1);
            }
            return null;
        }
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.panelWidth, this.textPane.getHeight());
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(BACKGROUND_COLOR);
        graphics.fillRect(rectangle.x, rectangle.y, this.panelWidth, rectangle.height);
        graphics.setColor(this.getForeground());
        int n = rectangle.y - this.textPaneTopPadding;
        int n2 = this.lineHeights.getIndex(n);
        int n3 = this.lineHeights.getIndex(n + rectangle.height);
        String string = "";
        for (int i = n2; i <= n3; ++i) {
            string = String.valueOf(i + 1);
            int n4 = 20 + this.requiredLineNumbersWidth - this.fontMetrics.stringWidth(string);
            int n5 = this.lineHeights.getPosition(i) + this.textFontAscent + this.textPaneTopPadding;
            boolean bl = false;
            if (this.errorMessages != null && this.errorMessages.containsKey(i + 1)) {
                bl = true;
            }
            graphics.setColor(Color.black);
            graphics.drawString(string, n4, n5);
            if (!bl) continue;
            graphics.drawImage(this.errorIcon.getImage(), rectangle.x, this.lineHeights.getPosition(i) + 3, this.errorIcon.getImageObserver());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if ("document".equals(propertyChangeEvent.getPropertyName())) {
            if (object != null && object instanceof Document) {
                ((Document)object).removeDocumentListener(this);
            }
            if (object2 != null && object2 instanceof Document) {
                ((Document)object2).addDocumentListener(this);
            }
        }
        this.updatePaintingCache();
        this.updatePanel(0, true);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentUpdated(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentUpdated(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private int getLineHeight(int n) {
        int n2 = this.lineHeights.getPosition(n) + this.textPaneTopPadding;
        int n3 = this.textHeight;
        try {
            Element element = this.textPane.getDocument().getDefaultRootElement();
            int n4 = element.getElement(n).getEndOffset() - 1;
            Rectangle rectangle = this.textPane.modelToView(n4);
            n3 = rectangle.y - n2 + rectangle.height;
        }
        catch (BadLocationException badLocationException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return n3;
    }

    private int getAdjustedLineCount() {
        int n;
        Element element = this.textPane.getDocument().getDefaultRootElement();
        Element element2 = element.getElement((n = element.getElementCount()) - 1);
        if (element2.getEndOffset() - element2.getStartOffset() > 1) {
            return n;
        }
        return n - 1;
    }

    private void updateLineHeights() {
        if (this.updatedLine < 0) {
            return;
        }
        if (this.multipleLinesChanged) {
            int n = this.getAdjustedLineCount();
            this.lineHeights = new SizeSequence(n);
            for (int i = 0; i < n; ++i) {
                this.lineHeights.setSize(i, this.getLineHeight(i));
            }
            this.multipleLinesChanged = false;
        } else {
            this.lineHeights.setSize(this.updatedLine, this.getLineHeight(this.updatedLine));
        }
        this.updatedLine = -1;
    }

    private void updatePaintingCache() {
        this.updateLineHeights();
        this.lineCount = this.getAdjustedLineCount();
        this.textPaneTopPadding = this.textPane.getInsets().top;
        this.setFont(this.textPane.getFont());
        this.fontMetrics = this.getFontMetrics(this.getFont());
        this.textHeight = this.fontMetrics.getHeight();
        this.textFontAscent = this.fontMetrics.getAscent();
        this.requiredLineNumbersWidth = this.fontMetrics.stringWidth(String.valueOf(this.lineCount));
        this.panelWidth = 20 + this.requiredLineNumbersWidth + 4;
    }

    private void documentUpdated(DocumentEvent documentEvent) {
        Element element = this.textPane.getDocument().getDefaultRootElement();
        int n = element.getElementIndex(documentEvent.getOffset());
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        this.updatePanel(n, elementChange != null);
    }

    private void updatePanel(int n, boolean bl) {
        this.updatedLine = n;
        this.multipleLinesChanged = bl;
        this.updatePaintingCache();
        this.revalidate();
        this.repaint();
    }

    public boolean displaysTab() {
        return false;
    }

    public JMenu getMenu() {
        return null;
    }

    public String getTabText() {
        return null;
    }

    public JToolBar getToolBar() {
        return null;
    }

    public String getXMLIDTag() {
        return null;
    }

    public Object getXMLSaveTree() {
        return null;
    }

    public void loadXML(Object object) {
    }

    public void takeCLArgs(String[] stringArray) {
    }

    public void notifySettings(PrismSettings prismSettings) {
    }

    public void setParseErrors(Map<Integer, String> map) {
        this.errorMessages = map;
        this.repaint();
    }
}

