/*
 * Decompiled with CFR 0.152.
 */
package userinterface;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.net.URL;
import prism.Prism;

public class GUIPrismSplash
extends Frame {
    private String filename;
    private MediaTracker mt;
    private Image image;

    public GUIPrismSplash(String string) {
        this.filename = string;
    }

    public void display() {
        this.mt = new MediaTracker(this);
        URL uRL = GUIPrismSplash.class.getClassLoader().getResource(this.filename);
        if (uRL == null) {
            System.out.println("Warning: Failed to load icon file \"" + this.filename + "\"");
        }
        this.image = Toolkit.getDefaultToolkit().getImage(uRL);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        this.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        this.mt.addImage(this.image, 0);
        try {
            this.mt.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Error in media tracker");
        }
        SplashWindow splashWindow = new SplashWindow(this, this.image);
    }

    private class SplashWindow
    extends Window {
        private Image fImage;

        SplashWindow(Frame frame, Image image) {
            super(frame);
            this.fImage = image;
            this.setSize(this.fImage.getWidth(null), this.fImage.getHeight(null));
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle rectangle = this.getBounds();
            this.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
            this.setVisible(true);
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.fImage != null) {
                graphics.drawImage(this.fImage, 0, 0, this);
                Font font = new Font("monospaced", 1, 10);
                graphics.setFont(font);
                int n = (int)((double)this.getBounds().width - (double)(font.getSize2D() * (float)(Prism.getVersion().length() + 1)) * 0.625 - 10.0);
                int n2 = (int)((float)this.getBounds().height - font.getSize2D() - 10.0f);
                graphics.drawString(Prism.getVersion() + " ", n, n2);
            }
        }
    }
}

