/*
 * Decompiled with CFR 0.152.
 */
package symbolic.comp;

import dv.DoubleVector;
import hybrid.PrismHybrid;
import java.io.File;
import jdd.JDD;
import jdd.JDDNode;
import mtbdd.PrismMTBDD;
import parser.ast.Expression;
import parser.ast.ExpressionTemporal;
import parser.ast.PropertiesFile;
import prism.Prism;
import prism.PrismException;
import sparse.PrismSparse;
import symbolic.comp.ProbModelChecker;
import symbolic.model.Model;
import symbolic.model.ProbModel;
import symbolic.model.StochModel;
import symbolic.states.StateValues;
import symbolic.states.StateValuesDV;
import symbolic.states.StateValuesMTBDD;

public class StochModelChecker
extends ProbModelChecker {
    public StochModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        super(prism, model, propertiesFile);
    }

    @Override
    public ProbModelChecker createNewModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        return new StochModelChecker(prism, model, propertiesFile);
    }

    @Override
    protected StateValues checkProbBoundedUntil(ExpressionTemporal expressionTemporal, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2;
        double d;
        double d2;
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        JDD.Deref(jDDNode);
        Expression expression = expressionTemporal.getLowerBound();
        if (expression != null) {
            d2 = expression.evaluateDouble(this.constantValues);
            if (d2 < 0.0) {
                throw new PrismException("Invalid lower bound " + d2 + " in time-bounded until formula");
            }
        } else {
            d2 = 0.0;
        }
        if ((expression = expressionTemporal.getUpperBound()) != null) {
            d = expression.evaluateDouble(this.constantValues);
            if (d < 0.0 || d == 0.0 && expressionTemporal.upperBoundIsStrict()) {
                String string = (expressionTemporal.upperBoundIsStrict() ? "<" : "<=") + d;
                throw new PrismException("Invalid upper bound " + string + " in time-bounded until formula");
            }
            if (d < d2) {
                throw new PrismException("Upper bound must exceed lower bound in time-bounded until formula");
            }
        } else {
            d = -1.0;
        }
        JDDNode jDDNode3 = this.checkExpressionDD(expressionTemporal.getOperand1(), this.model.getReach().copy());
        try {
            jDDNode2 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode3);
            throw prismException;
        }
        if (d2 == 0.0 && d == 0.0) {
            JDD.Ref(jDDNode2);
            stateValues2 = new StateValuesMTBDD(jDDNode2, this.model);
        } else if (d == -1.0) {
            if (d2 == 0.0) {
                try {
                    stateValues2 = this.computeUntilProbs(this.trans, this.trans01, jDDNode3, jDDNode2);
                }
                catch (PrismException prismException) {
                    JDD.Deref(jDDNode3);
                    JDD.Deref(jDDNode2);
                    throw prismException;
                }
            }
            try {
                stateValues = this.computeUntilProbs(this.trans, this.trans01, jDDNode3, jDDNode2);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode3);
                JDD.Deref(jDDNode2);
                throw prismException;
            }
            try {
                stateValues2 = this.computeBoundedUntilProbs(this.trans, this.trans01, jDDNode3, jDDNode3, d2, stateValues);
            }
            catch (PrismException prismException) {
                stateValues.clear();
                JDD.Deref(jDDNode3);
                JDD.Deref(jDDNode2);
                throw prismException;
            }
            stateValues.clear();
        } else if (d2 == 0.0) {
            JDD.Ref(jDDNode3);
            JDD.Ref(jDDNode2);
            JDDNode jDDNode4 = JDD.And(jDDNode3, JDD.Not(jDDNode2));
            try {
                stateValues2 = this.computeBoundedUntilProbs(this.trans, this.trans01, jDDNode2, jDDNode4, d, null);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode4);
                JDD.Deref(jDDNode3);
                JDD.Deref(jDDNode2);
                throw prismException;
            }
            JDD.Deref(jDDNode4);
            stateValues2.maxMTBDD(jDDNode2);
        } else {
            JDD.Ref(jDDNode3);
            JDD.Ref(jDDNode2);
            JDDNode jDDNode5 = JDD.And(jDDNode3, JDD.Not(jDDNode2));
            try {
                stateValues = this.computeBoundedUntilProbs(this.trans, this.trans01, jDDNode2, jDDNode5, d - d2, null);
            }
            catch (PrismException prismException) {
                JDD.Deref(jDDNode5);
                JDD.Deref(jDDNode3);
                JDD.Deref(jDDNode2);
                throw prismException;
            }
            JDD.Deref(jDDNode5);
            try {
                stateValues2 = this.computeBoundedUntilProbs(this.trans, this.trans01, jDDNode3, jDDNode3, d2, stateValues);
            }
            catch (PrismException prismException) {
                stateValues.clear();
                JDD.Deref(jDDNode3);
                JDD.Deref(jDDNode2);
                throw prismException;
            }
            stateValues.clear();
        }
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode2);
        return stateValues2;
    }

    @Override
    protected StateValues checkRewardCumul(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        StateValues stateValues = null;
        JDD.Deref(jDDNode3);
        double d = expressionTemporal.getUpperBound().evaluateDouble(this.constantValues);
        if (d < 0.0) {
            throw new PrismException("Invalid time bound " + d + " in cumulative reward formula");
        }
        if (d == 0.0) {
            stateValues = new StateValuesMTBDD(JDD.Constant(0.0), this.model);
        } else {
            stateValues = this.computeCumulRewards(this.trans, this.trans01, jDDNode, jDDNode2, d);
        }
        return stateValues;
    }

    @Override
    protected StateValues checkRewardInst(ExpressionTemporal expressionTemporal, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        StateValues stateValues = null;
        StateValues stateValues2 = null;
        JDD.Deref(jDDNode3);
        double d = expressionTemporal.getUpperBound().evaluateDouble(this.constantValues);
        if (d < 0.0) {
            throw new PrismException("Invalid bound " + d + " in instantaneous reward property");
        }
        if (d == 0.0) {
            JDD.Ref(jDDNode);
            stateValues2 = new StateValuesMTBDD(jDDNode, this.model);
        } else {
            switch (this.engine) {
                case 1: {
                    JDD.Ref(jDDNode);
                    stateValues = new StateValuesMTBDD(jDDNode, this.model);
                    break;
                }
                case 2: {
                    stateValues = new StateValuesDV(jDDNode, (Model)this.model);
                    break;
                }
                case 3: {
                    stateValues = new StateValuesDV(jDDNode, (Model)this.model);
                }
            }
            try {
                stateValues2 = this.computeBoundedUntilProbs(this.trans, this.trans01, this.reach, this.reach, d, stateValues);
            }
            catch (PrismException prismException) {
                stateValues.clear();
                throw prismException;
            }
            stateValues.clear();
        }
        return stateValues2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateValues checkRewardCoSafeLTL(Expression expression, JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3) throws PrismException {
        StateValues stateValues;
        block3: {
            expression = this.handleMaximalStateFormulas(expression);
            ProbModel probModel = ((StochModel)this.model).getEmbeddedDTMC(this.mainLog, false);
            JDDNode jDDNode4 = null;
            try {
                JDDNode jDDNode5 = JDD.SumAbstract(this.trans.copy(), this.allDDColVars);
                jDDNode4 = JDD.Apply(4, jDDNode.copy(), jDDNode5);
                ProbModelChecker probModelChecker = (ProbModelChecker)this.createModelChecker(probModel);
                StateValues stateValues2 = probModelChecker.checkRewardCoSafeLTL(expression, jDDNode4, jDDNode2, jDDNode3);
                stateValues2.switchModel(this.model);
                stateValues = stateValues2;
                probModel.clear();
                if (jDDNode4 == null) break block3;
            }
            catch (Throwable throwable) {
                probModel.clear();
                if (jDDNode4 != null) {
                    JDD.Deref(jDDNode4);
                }
                throw throwable;
            }
            JDD.Deref(jDDNode4);
        }
        return stateValues;
    }

    public StateValues doTransient(double d) throws PrismException {
        return this.doTransient(d, (StateValues)null);
    }

    public StateValues doTransient(double d, File file) throws PrismException {
        StateValues stateValues = null;
        if (file != null) {
            this.mainLog.println("\nImporting initial probability distribution from file \"" + String.valueOf(file) + "\"...");
            stateValues = this.engine == 1 ? new StateValuesMTBDD(JDD.Constant(0.0), this.model) : new StateValuesDV(new DoubleVector(this.model.getNumStates()), (Model)this.model);
            stateValues.readFromFile(file);
        }
        return this.doTransient(d, stateValues);
    }

    public StateValues doTransient(double d, StateValues stateValues) throws PrismException {
        StateValues stateValues2 = null;
        StateValues stateValues3 = null;
        if (stateValues == null) {
            JDDNode jDDNode = this.model.getStart();
            JDD.Ref(jDDNode);
            JDDNode jDDNode2 = JDD.Apply(4, jDDNode, JDD.Constant(JDD.GetNumMinterms(jDDNode, this.allDDRowVars.n())));
            if (this.engine == 1) {
                stateValues2 = new StateValuesMTBDD(jDDNode2, this.model);
            } else {
                stateValues2 = new StateValuesDV(jDDNode2, (Model)this.model);
                JDD.Deref(jDDNode2);
            }
        } else {
            stateValues2 = stateValues;
        }
        stateValues3 = this.computeTransientProbs(this.trans, stateValues2, d);
        return stateValues3;
    }

    @Override
    protected StateValues computeNextProbs(JDDNode jDDNode, JDDNode jDDNode2) {
        StateValues stateValues = null;
        JDD.Ref(jDDNode);
        JDDNode jDDNode3 = JDD.SumAbstract(jDDNode, this.allDDColVars);
        JDD.Ref(jDDNode);
        JDD.Ref(jDDNode3);
        JDDNode jDDNode4 = JDD.Apply(4, this.trans, jDDNode3);
        this.mainLog.println("\nDiagonals vector: " + JDD.GetInfoString(jDDNode3, this.allDDRowVars.n()));
        this.mainLog.println("Embedded Markov chain: " + JDD.GetInfoString(jDDNode4, this.allDDRowVars.n() * 2));
        stateValues = super.computeNextProbs(jDDNode4, jDDNode2);
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode4);
        return stateValues;
    }

    protected StateValues computeBoundedUntilProbs(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, double d, StateValues stateValues) throws PrismException {
        StateValues stateValues2 = null;
        if (jDDNode4.equals(JDD.ZERO) && stateValues == null || d == 0.0) {
            switch (this.engine) {
                case 1: {
                    JDD.Ref(jDDNode3);
                    stateValues2 = new StateValuesMTBDD(jDDNode3, this.model);
                    break;
                }
                case 2: 
                case 3: {
                    stateValues2 = new StateValuesDV(jDDNode3, (Model)this.model);
                }
            }
        } else {
            this.mainLog.println("\nComputing probabilities...");
            this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
            switch (this.engine) {
                case 1: {
                    JDDNode jDDNode5 = stateValues == null ? null : ((StateValuesMTBDD)stateValues).getJDDNode();
                    JDDNode jDDNode6 = PrismMTBDD.StochBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode3, jDDNode4, d, jDDNode5);
                    stateValues2 = new StateValuesMTBDD(jDDNode6, this.model);
                    break;
                }
                case 2: {
                    DoubleVector doubleVector = stateValues == null ? null : ((StateValuesDV)stateValues).getDoubleVector();
                    DoubleVector doubleVector2 = PrismSparse.StochBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode3, jDDNode4, d, doubleVector);
                    stateValues2 = new StateValuesDV(doubleVector2, (Model)this.model);
                    break;
                }
                case 3: {
                    DoubleVector doubleVector = stateValues == null ? null : ((StateValuesDV)stateValues).getDoubleVector();
                    DoubleVector doubleVector3 = PrismHybrid.StochBoundedUntil(jDDNode, this.odd, this.allDDRowVars, this.allDDColVars, jDDNode3, jDDNode4, d, doubleVector);
                    stateValues2 = new StateValuesDV(doubleVector3, (Model)this.model);
                }
            }
        }
        return stateValues2;
    }

    @Override
    protected StateValues computeUntilProbs(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4) throws PrismException {
        StateValues stateValues = null;
        JDD.Ref(jDDNode);
        JDDNode jDDNode5 = JDD.SumAbstract(jDDNode, this.allDDColVars);
        JDD.Ref(jDDNode);
        JDD.Ref(jDDNode5);
        JDDNode jDDNode6 = JDD.Apply(4, this.trans, jDDNode5);
        this.mainLog.println("\nDiagonals vector: " + JDD.GetInfoString(jDDNode5, this.allDDRowVars.n()));
        this.mainLog.println("Embedded Markov chain: " + JDD.GetInfoString(jDDNode6, this.allDDRowVars.n() * 2));
        stateValues = super.computeUntilProbs(jDDNode6, jDDNode2, jDDNode3, jDDNode4);
        JDD.Deref(jDDNode5);
        JDD.Deref(jDDNode6);
        return stateValues;
    }

    protected StateValues computeCumulRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, double d) throws PrismException {
        StateValues stateValues = null;
        this.mainLog.println("\nComputing rewards...");
        this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
        switch (this.engine) {
            case 1: {
                JDDNode jDDNode5 = PrismMTBDD.StochCumulReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, d);
                stateValues = new StateValuesMTBDD(jDDNode5, this.model);
                break;
            }
            case 2: {
                DoubleVector doubleVector = PrismSparse.StochCumulReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, d);
                stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            case 3: {
                DoubleVector doubleVector = PrismHybrid.StochCumulReward(jDDNode, jDDNode3, jDDNode4, this.odd, this.allDDRowVars, this.allDDColVars, d);
                stateValues = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            default: {
                throw new PrismException("Unknown engine");
            }
        }
        return stateValues;
    }

    @Override
    protected StateValues computeTotalRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4) throws PrismException {
        StateValues stateValues = null;
        JDD.Ref(jDDNode);
        JDDNode jDDNode5 = JDD.SumAbstract(jDDNode, this.allDDColVars);
        JDD.Ref(jDDNode);
        JDD.Ref(jDDNode5);
        JDDNode jDDNode6 = JDD.Apply(4, this.trans, jDDNode5);
        this.mainLog.println("\nDiagonals vector: " + JDD.GetInfoString(jDDNode5, this.allDDRowVars.n()));
        this.mainLog.println("Embedded Markov chain: " + JDD.GetInfoString(jDDNode6, this.allDDRowVars.n() * 2));
        JDD.Ref(jDDNode3);
        JDD.Ref(jDDNode5);
        JDDNode jDDNode7 = JDD.Apply(4, jDDNode3, jDDNode5);
        stateValues = super.computeTotalRewards(jDDNode6, jDDNode2, jDDNode7, jDDNode4);
        JDD.Deref(jDDNode5);
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode7);
        return stateValues;
    }

    @Override
    protected StateValues computeReachRewards(JDDNode jDDNode, JDDNode jDDNode2, JDDNode jDDNode3, JDDNode jDDNode4, JDDNode jDDNode5) throws PrismException {
        StateValues stateValues = null;
        JDD.Ref(jDDNode);
        JDDNode jDDNode6 = JDD.SumAbstract(jDDNode, this.allDDColVars);
        JDD.Ref(jDDNode);
        JDD.Ref(jDDNode6);
        JDDNode jDDNode7 = JDD.Apply(4, this.trans, jDDNode6);
        this.mainLog.println("\nDiagonals vector: " + JDD.GetInfoString(jDDNode6, this.allDDRowVars.n()));
        this.mainLog.println("Embedded Markov chain: " + JDD.GetInfoString(jDDNode7, this.allDDRowVars.n() * 2));
        JDD.Ref(jDDNode3);
        JDD.Ref(jDDNode6);
        JDDNode jDDNode8 = JDD.Apply(4, jDDNode3, jDDNode6);
        stateValues = super.computeReachRewards(jDDNode7, jDDNode2, jDDNode8, jDDNode4, jDDNode5);
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode7);
        JDD.Deref(jDDNode8);
        return stateValues;
    }

    protected StateValues computeTransientProbs(JDDNode jDDNode, StateValues stateValues, double d) throws PrismException {
        StateValues stateValues2 = null;
        if (d == 0.0) {
            return stateValues;
        }
        this.mainLog.println("\nComputing probabilities...");
        this.mainLog.println("Engine: " + Prism.getEngineString(this.engine));
        switch (this.engine) {
            case 1: {
                JDDNode jDDNode2 = PrismMTBDD.StochTransient(jDDNode, this.odd, ((StateValuesMTBDD)stateValues).getJDDNode(), this.allDDRowVars, this.allDDColVars, d);
                stateValues2 = new StateValuesMTBDD(jDDNode2, this.model);
                break;
            }
            case 2: {
                DoubleVector doubleVector = PrismSparse.StochTransient(jDDNode, this.odd, ((StateValuesDV)stateValues).getDoubleVector(), this.allDDRowVars, this.allDDColVars, d);
                stateValues2 = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            case 3: {
                DoubleVector doubleVector = PrismHybrid.StochTransient(jDDNode, this.odd, ((StateValuesDV)stateValues).getDoubleVector(), this.allDDRowVars, this.allDDColVars, d);
                stateValues2 = new StateValuesDV(doubleVector, (Model)this.model);
                break;
            }
            default: {
                throw new PrismException("Unknown engine");
            }
        }
        return stateValues2;
    }
}

