/*
 * Decompiled with CFR 0.152.
 */
package symbolic.comp;

import cex.CexPathStates;
import java.util.ArrayList;
import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionExists;
import parser.ast.ExpressionForAll;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.ast.PropertiesFile;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.PrismNotSupportedException;
import symbolic.comp.SCCComputer;
import symbolic.comp.StateModelChecker;
import symbolic.model.Model;
import symbolic.model.NondetModel;
import symbolic.states.StateValues;
import symbolic.states.StateValuesMTBDD;

public class NonProbModelChecker
extends StateModelChecker {
    private boolean doGenCex = true;

    public NonProbModelChecker(Prism prism, Model model, PropertiesFile propertiesFile) throws PrismException {
        super(prism, model, propertiesFile);
    }

    @Override
    public StateValues checkExpression(Expression expression, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = expression instanceof ExpressionExists ? this.checkExpressionExists(((ExpressionExists)expression).getExpression(), jDDNode) : (expression instanceof ExpressionForAll ? this.checkExpressionForAll(((ExpressionForAll)expression).getExpression(), jDDNode) : super.checkExpression(expression, jDDNode));
        if (stateValues instanceof StateValuesMTBDD) {
            stateValues.filter(this.reach);
        }
        return stateValues;
    }

    protected StateValues checkExpressionExists(Expression expression, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = null;
        if (!expression.isSimplePathFormula()) {
            JDD.Deref(jDDNode);
            throw new PrismNotSupportedException("(Non-probabilistic) LTL model checking is not supported");
        }
        if (this.prism.getFairness()) {
            JDD.Deref(jDDNode);
            throw new PrismNotSupportedException("Non-probabilistic CTL model checking is not supported with fairness");
        }
        if (expression instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
            if (expressionUnaryOp.getOperator() == 3) {
                stateValues = this.checkExpressionExists(expressionUnaryOp.getOperand(), jDDNode);
            } else if (expressionUnaryOp.getOperator() == 1) {
                stateValues = this.checkExpressionForAll(expressionUnaryOp.getOperand(), jDDNode);
                stateValues.subtractFromOne();
            }
        } else if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.hasBounds()) {
                JDD.Deref(jDDNode);
                throw new PrismNotSupportedException("Model checking of bounded CTL operators is not supported");
            }
            stateValues = expressionTemporal.getOperator() == 1 ? this.checkNext(expressionTemporal, false, jDDNode) : (expressionTemporal.getOperator() == 2 ? this.checkExistsUntil(expressionTemporal, jDDNode) : (expressionTemporal.getOperator() == 4 ? this.checkExistsGlobally(expressionTemporal, jDDNode) : this.checkExpressionExists(expressionTemporal.convertToUntilForm(), jDDNode)));
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised path operator in E operator");
        }
        return stateValues;
    }

    protected StateValues checkExpressionForAll(Expression expression, JDDNode jDDNode) throws PrismException {
        StateValues stateValues = null;
        if (!expression.isSimplePathFormula()) {
            JDD.Deref(jDDNode);
            throw new PrismNotSupportedException("(Non-probabilistic) LTL model checking is not supported");
        }
        if (this.prism.getFairness()) {
            JDD.Deref(jDDNode);
            throw new PrismNotSupportedException("Non-probabilistic CTL model checking is not supported with fairness");
        }
        if (expression instanceof ExpressionUnaryOp) {
            ExpressionUnaryOp expressionUnaryOp = (ExpressionUnaryOp)expression;
            if (expressionUnaryOp.getOperator() == 3) {
                stateValues = this.checkExpressionForAll(expressionUnaryOp.getOperand(), jDDNode);
            } else if (expressionUnaryOp.getOperator() == 1) {
                stateValues = this.checkExpressionExists(expressionUnaryOp.getOperand(), jDDNode);
                stateValues.subtractFromOne();
            }
        } else if (expression instanceof ExpressionTemporal) {
            ExpressionTemporal expressionTemporal = (ExpressionTemporal)expression;
            if (expressionTemporal.hasBounds()) {
                JDD.Deref(jDDNode);
                throw new PrismNotSupportedException("Model checking of bounded CTL operators is not supported");
            }
            if (expressionTemporal.getOperator() == 1) {
                stateValues = this.checkNext(expressionTemporal, true, jDDNode);
            } else if (expressionTemporal.getOperator() == 2) {
                ExpressionUnaryOp expressionUnaryOp = Expression.Not(expressionTemporal.getOperand1().deepCopy());
                ExpressionUnaryOp expressionUnaryOp2 = Expression.Not(expressionTemporal.getOperand2().deepCopy());
                ExpressionBinaryOp expressionBinaryOp = Expression.And(expressionUnaryOp.deepCopy(), expressionUnaryOp2.deepCopy());
                Expression expression2 = new ExpressionTemporal(2, expressionUnaryOp2, expressionBinaryOp);
                expression2 = Expression.Not(new ExpressionExists(expression2));
                Expression expression3 = new ExpressionTemporal(4, null, expressionUnaryOp2);
                expression3 = Expression.Not(new ExpressionExists(expression3));
                ExpressionBinaryOp expressionBinaryOp2 = Expression.And(expression2, expression3);
                stateValues = this.checkExpression(expressionBinaryOp2, jDDNode);
            } else if (expressionTemporal.getOperator() == 3) {
                ExpressionTemporal expressionTemporal2 = (ExpressionTemporal)expressionTemporal.deepCopy();
                expressionTemporal2.setOperator(4);
                expressionTemporal2.setOperand2(Expression.Not(expressionTemporal2.getOperand2()));
                stateValues = this.checkExpressionExists(expressionTemporal2, jDDNode);
                stateValues.subtractFromOne();
            } else {
                stateValues = this.checkExpressionForAll(expressionTemporal.convertToUntilForm(), jDDNode);
            }
        }
        if (stateValues == null) {
            throw new PrismException("Unrecognised path operator in E operator");
        }
        return stateValues;
    }

    protected StateValues checkNext(ExpressionTemporal expressionTemporal, boolean bl, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2;
        JDD.Deref(jDDNode);
        JDDNode jDDNode3 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        if (this.model.getModelType() == ModelType.MDP) {
            JDD.Ref(this.trans01);
            jDDNode2 = JDD.ThereExists(this.trans01, ((NondetModel)this.model).getAllDDNondetVars());
        } else {
            JDD.Ref(this.trans01);
            jDDNode2 = this.trans01;
        }
        JDD.Ref(jDDNode3);
        JDD.Ref(jDDNode2);
        JDDNode jDDNode4 = bl ? JDD.ForAll(JDD.Implies(jDDNode2, JDD.PermuteVariables(jDDNode3, this.allDDRowVars, this.allDDColVars)), this.allDDColVars) : JDD.ThereExists(JDD.And(JDD.PermuteVariables(jDDNode3, this.allDDRowVars, this.allDDColVars), jDDNode2), this.allDDColVars);
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode2);
        return new StateValuesMTBDD(jDDNode4, this.model);
    }

    protected StateValues checkExistsUntil(ExpressionTemporal expressionTemporal, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2;
        JDDNode jDDNode3;
        JDDNode jDDNode4 = null;
        ArrayList<JDDNode> arrayList = null;
        JDDNode jDDNode5 = null;
        boolean bl = false;
        JDD.Deref(jDDNode);
        JDDNode jDDNode6 = this.checkExpressionDD(expressionTemporal.getOperand1(), this.model.getReach().copy());
        try {
            jDDNode3 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        }
        catch (PrismException prismException) {
            JDD.Deref(jDDNode6);
            throw prismException;
        }
        long l = System.currentTimeMillis();
        if (this.doGenCex) {
            arrayList = new ArrayList<JDDNode>();
            bl = false;
            jDDNode4 = this.model.getStart();
        }
        if (this.model.getModelType() == ModelType.MDP) {
            JDD.Ref(this.trans01);
            jDDNode2 = JDD.ThereExists(this.trans01, ((NondetModel)this.model).getAllDDNondetVars());
        } else {
            JDD.Ref(this.trans01);
            jDDNode2 = this.trans01;
        }
        boolean bl2 = false;
        int n = 0;
        JDDNode jDDNode7 = JDD.Constant(0.0);
        while (!bl2) {
            ++n;
            JDD.Ref(jDDNode7);
            JDDNode jDDNode8 = JDD.PermuteVariables(jDDNode7, this.allDDRowVars, this.allDDColVars);
            JDD.Ref(jDDNode2);
            jDDNode8 = JDD.And(jDDNode8, jDDNode2);
            jDDNode8 = JDD.ThereExists(jDDNode8, this.allDDColVars);
            JDD.Ref(jDDNode6);
            jDDNode8 = JDD.And(jDDNode6, jDDNode8);
            JDD.Ref(jDDNode3);
            jDDNode8 = JDD.Or(jDDNode3, jDDNode8);
            if (jDDNode8.equals(jDDNode7)) {
                bl2 = true;
            }
            if (this.doGenCex && !bl) {
                JDD.Ref(jDDNode7);
                JDD.Ref(jDDNode8);
                arrayList.add(JDD.And(jDDNode8, JDD.Not(jDDNode7)));
                if (JDD.AreIntersecting(jDDNode8, jDDNode4)) {
                    bl = true;
                    JDD.Ref(jDDNode8);
                    JDD.Ref(jDDNode4);
                    jDDNode5 = JDD.And(jDDNode8, jDDNode4);
                    jDDNode5 = JDD.RestrictToFirst(jDDNode5, this.allDDRowVars);
                }
            }
            JDD.Deref(jDDNode7);
            jDDNode7 = jDDNode8;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("\nCTL EU fixpoint: " + n + " iterations in " + (double)l / 1000.0 + " seconds");
        if (this.doGenCex) {
            if (!bl) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    JDD.Deref((JDDNode)arrayList.get(i));
                }
            } else {
                int n2;
                this.mainLog.println("Processing counterexample trace (" + arrayList.size() + " states long)...");
                JDD.Deref((JDDNode)arrayList.get(arrayList.size() - 1));
                arrayList.set(arrayList.size() - 1, jDDNode5);
                for (n2 = arrayList.size() - 2; n2 >= 0; --n2) {
                    JDD.Ref((JDDNode)arrayList.get(n2 + 1));
                    JDD.Ref(jDDNode2);
                    JDDNode jDDNode9 = JDD.And((JDDNode)arrayList.get(n2 + 1), jDDNode2);
                    jDDNode9 = JDD.ThereExists(jDDNode9, this.allDDRowVars);
                    jDDNode9 = JDD.PermuteVariables(jDDNode9, this.allDDColVars, this.allDDRowVars);
                    JDD.Ref((JDDNode)arrayList.get(n2));
                    jDDNode9 = JDD.And(jDDNode9, (JDDNode)arrayList.get(n2));
                    jDDNode9 = JDD.PermuteVariables(JDD.RestrictToFirst(jDDNode9, this.allDDColVars), this.allDDColVars, this.allDDRowVars);
                    JDD.Deref((JDDNode)arrayList.get(n2));
                    arrayList.set(n2, jDDNode9);
                }
                CexPathStates cexPathStates = new CexPathStates(this.model);
                for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                    cexPathStates.addState(this.model.convertBddToState((JDDNode)arrayList.get(n2)));
                    JDD.Deref((JDDNode)arrayList.get(n2));
                }
                this.result.setCounterexample(cexPathStates);
            }
        }
        JDD.Deref(jDDNode6);
        JDD.Deref(jDDNode3);
        JDD.Deref(jDDNode2);
        return new StateValuesMTBDD(jDDNode7, this.model);
    }

    protected StateValues checkExistsGlobally(ExpressionTemporal expressionTemporal, JDDNode jDDNode) throws PrismException {
        int n;
        JDDNode jDDNode2;
        List<JDDNode> list = null;
        JDDNode jDDNode3 = null;
        int n2 = 0;
        JDD.Deref(jDDNode);
        JDDNode jDDNode4 = this.checkExpressionDD(expressionTemporal.getOperand2(), this.model.getReach().copy());
        long l = System.currentTimeMillis();
        if (this.model.getModelType() == ModelType.MDP) {
            JDD.Ref(this.trans01);
            jDDNode2 = JDD.ThereExists(this.trans01, ((NondetModel)this.model).getAllDDNondetVars());
        } else {
            JDD.Ref(this.trans01);
            jDDNode2 = this.trans01;
        }
        JDD.Ref(jDDNode4);
        jDDNode2 = JDD.And(jDDNode2, jDDNode4);
        JDD.Ref(jDDNode4);
        jDDNode2 = JDD.And(jDDNode2, JDD.PermuteVariables(jDDNode4, this.allDDRowVars, this.allDDColVars));
        SCCComputer sCCComputer = this.prism.getSCCComputer(this.reach, jDDNode2, this.allDDRowVars, this.allDDColVars);
        sCCComputer.computeSCCs();
        list = sCCComputer.getSCCs();
        jDDNode3 = sCCComputer.getNotInSCCs();
        n2 = list.size();
        JDDNode jDDNode5 = JDD.Create();
        for (n = 0; n < n2; ++n) {
            JDDNode jDDNode6 = list.get(n);
            if (jDDNode6 == null || !JDD.AreIntersecting(jDDNode6, jDDNode2)) continue;
            JDD.Ref(jDDNode6);
            jDDNode5 = JDD.Or(jDDNode5, jDDNode6);
        }
        this.mainLog.println("\nCTL EG non-trivial SCC states: " + JDD.GetNumMintermsString(jDDNode5, this.allDDRowVars.n()));
        boolean bl = false;
        int n3 = 0;
        JDDNode jDDNode7 = JDD.Constant(0.0);
        while (!bl) {
            ++n3;
            JDD.Ref(jDDNode7);
            JDDNode jDDNode8 = JDD.PermuteVariables(jDDNode7, this.allDDRowVars, this.allDDColVars);
            JDD.Ref(jDDNode2);
            jDDNode8 = JDD.And(jDDNode8, jDDNode2);
            jDDNode8 = JDD.ThereExists(jDDNode8, this.allDDColVars);
            JDD.Ref(jDDNode5);
            jDDNode8 = JDD.Or(jDDNode5, jDDNode8);
            if (jDDNode8.equals(jDDNode7)) {
                bl = true;
            }
            JDD.Deref(jDDNode7);
            jDDNode7 = jDDNode8;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("CTL EG reachability fixpoint: " + n3 + " iterations in " + (double)l / 1000.0 + " seconds");
        JDD.Deref(jDDNode4);
        JDD.Deref(jDDNode5);
        JDD.Deref(jDDNode2);
        for (n = 0; n < n2; ++n) {
            if (list.get(n) == null) continue;
            JDD.Deref(list.get(n));
        }
        if (jDDNode3 != null) {
            JDD.Deref(jDDNode3);
        }
        return new StateValuesMTBDD(jDDNode7, this.model);
    }
}

