/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import settings.Setting;
import settings.SettingEditor;

public class BooleanEditor
implements SettingEditor,
ActionListener {
    private JCheckBox renderer;
    private JPanel panel = new JPanel();
    private JTable lastTable = null;
    private int tableCol = -1;
    private int tableRow = -1;
    private boolean modified = false;

    public BooleanEditor() {
        this.panel.setLayout(new BorderLayout());
        this.renderer = new JCheckBox();
        this.renderer.setPreferredSize(new Dimension(17, 12));
        this.panel.add(this.renderer);
        this.renderer.addActionListener(this);
    }

    @Override
    public Object getEditorValue() {
        if (this.modified) {
            this.modified = false;
            return this.renderer.isSelected();
        }
        return "$%^&*NOTCHANGED*&^%$";
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Setting setting, Object object, boolean bl, int n, int n2) {
        ArrayList arrayList;
        if (bl) {
            this.panel.setBackground(jTable.getSelectionBackground());
            this.renderer.setBackground(jTable.getSelectionBackground());
        } else {
            this.panel.setBackground(jTable.getBackground());
            this.renderer.setBackground(jTable.getBackground());
        }
        this.panel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        if (object instanceof Boolean) {
            Boolean bl2 = (Boolean)object;
            this.renderer.setSelected(bl2);
        } else if (object instanceof ArrayList && (arrayList = (ArrayList)object).size() > 0) {
            Boolean bl3 = null;
            boolean bl4 = true;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(arrayList.get(i) instanceof Boolean)) continue;
                Boolean bl5 = (Boolean)arrayList.get(i);
                if (bl3 != null) {
                    if (!bl5.equals(bl3)) {
                        bl4 = false;
                        break;
                    }
                    bl3 = bl5;
                    continue;
                }
                bl3 = bl5;
            }
            if (bl4) {
                this.renderer.setSelected(bl3);
            } else {
                this.renderer.setSelected(false);
                this.renderer.setBackground(Color.lightGray);
            }
        }
        this.renderer.setOpaque(true);
        this.lastTable = jTable;
        this.tableRow = n;
        this.tableCol = n2;
        return this.panel;
    }

    @Override
    public void stopEditing() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.modified = true;
        if (this.lastTable != null) {
            this.lastTable.editingStopped(new ChangeEvent(this));
        }
        this.lastTable.getSelectionModel().setSelectionInterval(this.tableRow, this.tableRow);
        this.lastTable.getColumnModel().getSelectionModel().setSelectionInterval(this.tableCol, this.tableCol);
    }
}

