/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import parser.ast.Coalition;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionStrategy;
import parser.ast.ExpressionTemporal;
import parser.ast.RelOp;
import parser.type.TypeInt;
import parser.visitor.ASTTraverse;
import prism.ModelType;
import prism.PrismLangException;

public class CheckValid
extends ASTTraverse {
    private ModelType modelType = null;

    public CheckValid(ModelType modelType) {
        this.modelType = modelType;
    }

    @Override
    public void visitPost(ExpressionTemporal expressionTemporal) throws PrismLangException {
        if (this.modelType == ModelType.MDP) {
            if (expressionTemporal.getOperator() == 14) {
                throw new PrismLangException("Steady-state reward properties cannot be used for MDPs");
            }
        } else if (this.modelType.realTime() && (expressionTemporal.getOperator() == 11 || expressionTemporal.getOperator() == 12 || expressionTemporal.getOperator() == 14)) {
            throw new PrismLangException("Only reachability (F) reward properties can be used for " + String.valueOf((Object)this.modelType) + "s");
        }
        if (expressionTemporal.getLowerBound() != null && this.modelType.realTime()) {
            throw new PrismLangException("Only upper time bounds are allowed on the " + expressionTemporal.getOperatorSymbol() + " operator for " + String.valueOf((Object)this.modelType) + "s");
        }
        if ((expressionTemporal.getUpperBound() != null && !(expressionTemporal.getUpperBound().getType() instanceof TypeInt) || expressionTemporal.getLowerBound() != null && !(expressionTemporal.getLowerBound().getType() instanceof TypeInt)) && this.modelType != ModelType.CTMC) {
            throw new PrismLangException("Time bounds on the " + expressionTemporal.getOperatorSymbol() + " operator must be integers for " + String.valueOf((Object)this.modelType) + "s");
        }
        if (expressionTemporal.getOperator() == 5 && expressionTemporal.getLowerBound() != null) {
            throw new PrismLangException("The weak until operator (W) with lower bounds is not yet supported");
        }
    }

    @Override
    public void visitPost(ExpressionProb expressionProb) throws PrismLangException {
        if (this.modelType.nondeterministic() && expressionProb.getRelOp() == RelOp.EQ) {
            throw new PrismLangException("Can't use \"P=?\" for nondeterministic models; use \"Pmin=?\" or \"Pmax=?\"");
        }
    }

    @Override
    public void visitPost(ExpressionReward expressionReward) throws PrismLangException {
        if (this.modelType.nondeterministic() && expressionReward.getRelOp() == RelOp.EQ) {
            throw new PrismLangException("Can't use \"R=?\" for nondeterministic models; use \"Rmin=?\" or \"Rmax=?\"");
        }
        if (expressionReward.getRewardStructIndexDiv() != null) {
            throw new PrismLangException("No support for ratio reward objectives yet");
        }
    }

    @Override
    public void visitPost(ExpressionSS expressionSS) throws PrismLangException {
        if (this.modelType == ModelType.MDP || this.modelType.realTime()) {
            throw new PrismLangException("The S operator cannot be used for " + String.valueOf((Object)this.modelType) + "s");
        }
    }

    @Override
    public void visitPost(ExpressionStrategy expressionStrategy) throws PrismLangException {
        if (!this.modelType.nondeterministic()) {
            throw new PrismLangException("The " + expressionStrategy.getOperatorString() + " operator is only meaningful for models with nondeterminism");
        }
        Coalition coalition = expressionStrategy.getCoalition();
        if (!coalition.isAllPlayers() && !coalition.isEmpty()) {
            throw new PrismLangException("The " + expressionStrategy.getOperatorString() + " operator must contain either \"*\" or be empty for an " + String.valueOf((Object)this.modelType));
        }
    }
}

