/*
 * Decompiled with CFR 0.152.
 */
package param;

import edu.jas.arith.BigInteger;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.Quotient;
import edu.jas.ufd.QuotientRing;
import java.util.Arrays;
import java.util.Collections;
import param.BigRational;
import param.Function;
import param.FunctionFactory;
import param.JasFunction;

final class JasFunctionFactory
extends FunctionFactory {
    private GenPolynomialRing<BigInteger> jasPolyRing;
    private QuotientRing<BigInteger> jasQuotRing;
    private JasFunction zero;
    private JasFunction one;
    private JasFunction nan;
    private JasFunction inf;
    private JasFunction minf;
    private JasFunction[] parameters;

    JasFunctionFactory(String[] stringArray, BigRational[] bigRationalArray, BigRational[] bigRationalArray2) {
        super(stringArray, bigRationalArray, bigRationalArray2);
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        Collections.reverse(Arrays.asList(stringArray2));
        this.parameterNames = stringArray;
        BigInteger bigInteger = new BigInteger();
        this.jasPolyRing = new GenPolynomialRing((RingFactory)bigInteger, stringArray2.length, stringArray2);
        this.jasQuotRing = new QuotientRing(this.jasPolyRing);
        this.one = new JasFunction(this, (Quotient<BigInteger>)this.jasQuotRing.getONE(), 0);
        this.zero = new JasFunction(this, (Quotient<BigInteger>)this.jasQuotRing.getZERO(), 0);
        this.nan = new JasFunction(this, (Quotient<BigInteger>)this.jasQuotRing.getZERO(), 3);
        this.inf = new JasFunction(this, (Quotient<BigInteger>)this.jasQuotRing.getZERO(), 1);
        this.minf = new JasFunction(this, (Quotient<BigInteger>)this.jasQuotRing.getZERO(), 2);
        this.parameters = new JasFunction[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.parameters[i] = new JasFunction(this, (Quotient<BigInteger>)this.jasQuotRing.parse(stringArray[i]), 0);
        }
    }

    @Override
    public Function getOne() {
        return this.one;
    }

    @Override
    public Function getZero() {
        return this.zero;
    }

    @Override
    public Function getNaN() {
        return this.nan;
    }

    @Override
    public Function getInf() {
        return this.inf;
    }

    @Override
    public Function getMInf() {
        return this.minf;
    }

    QuotientRing<BigInteger> getJasQuotRing() {
        return this.jasQuotRing;
    }

    GenPolynomialRing<BigInteger> getJasPolyRing() {
        return this.jasPolyRing;
    }

    @Override
    public Function fromBigRational(BigRational bigRational) {
        if (bigRational.isSpecial()) {
            if (bigRational.isInf()) {
                return this.getInf();
            }
            if (bigRational.isMInf()) {
                return this.getMInf();
            }
            if (bigRational.isNaN()) {
                return this.getNaN();
            }
            throw new RuntimeException("Implementation error");
        }
        Quotient quotient = this.jasQuotRing.fromInteger(bigRational.getNum());
        Quotient quotient2 = this.jasQuotRing.fromInteger(bigRational.getDen());
        quotient = quotient.divide(quotient2);
        return new JasFunction(this, (Quotient<BigInteger>)quotient, 0);
    }

    @Override
    public Function getVar(int n) {
        return this.parameters[n];
    }
}

