/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import explicit.Model;
import explicit.SCCConsumerBitSet;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class SCCConsumerStore
extends SCCConsumerBitSet {
    private List<BitSet> sccs = new ArrayList<BitSet>();
    private List<BitSet> bsccs;
    private BitSet notInBSCCs;
    private BitSet notInSCCs;
    private boolean finished = false;
    private Model<?> model = null;

    @Override
    public void notifyStart(Model<?> model) {
        this.model = model;
    }

    @Override
    public void notifyNextSCC(BitSet bitSet) {
        this.sccs.add(bitSet);
    }

    @Override
    public void notifyDone() {
        this.finished = true;
    }

    public List<BitSet> getSCCs() {
        if (!this.finished) {
            throw new UnsupportedOperationException("SCC computation is not yet finished.");
        }
        return this.sccs;
    }

    public List<BitSet> getBSCCs() {
        if (!this.finished) {
            throw new UnsupportedOperationException("SCC computation is not yet finished.");
        }
        if (this.bsccs == null) {
            this.computeBSCCs();
        }
        return this.bsccs;
    }

    public BitSet getNotInBSCCs() {
        if (!this.finished) {
            throw new UnsupportedOperationException("SCC computation is not yet finished.");
        }
        if (this.notInBSCCs == null) {
            this.computeBSCCs();
        }
        return this.notInBSCCs;
    }

    private void computeBSCCs() {
        if (!this.finished) {
            throw new UnsupportedOperationException("SCC computation is not yet finished.");
        }
        this.bsccs = new ArrayList<BitSet>();
        this.notInBSCCs = (BitSet)this.getNotInSCCs().clone();
        for (BitSet bitSet : this.sccs) {
            boolean bl = true;
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                if (!this.model.allSuccessorsInSet(n, bitSet)) {
                    bl = false;
                    break;
                }
                n = bitSet.nextSetBit(n + 1);
            }
            if (bl) {
                this.bsccs.add(bitSet);
                continue;
            }
            this.notInBSCCs.or(bitSet);
        }
    }

    public BitSet getNotInSCCs() {
        if (!this.finished) {
            throw new UnsupportedOperationException("SCC computation is not yet finished.");
        }
        if (this.notInSCCs != null) {
            return this.notInSCCs;
        }
        BitSet bitSet = new BitSet();
        for (BitSet bitSet2 : this.getSCCs()) {
            bitSet.or(bitSet2);
        }
        bitSet.flip(0, this.model.getNumStates());
        this.notInSCCs = bitSet;
        return this.notInSCCs;
    }
}

