/*
 * Decompiled with CFR 0.152.
 */
package dv;

import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import odd.ODDNode;
import odd.ODDUtils;
import parser.ast.RelOp;
import prism.PrismException;
import prism.PrismLog;

public class DoubleVector {
    private long v;
    private int n;

    public static void setCUDDManager() {
        DoubleVector.DV_SetCUDDManager(JDD.GetCUDDManager());
    }

    private static native void DV_SetCUDDManager(long var0);

    public DoubleVector(int n) throws PrismException {
        this.v = this.DV_CreateZeroVector(n);
        if (this.v == 0L) {
            throw new PrismException("Out of memory");
        }
        this.n = n;
    }

    private native long DV_CreateZeroVector(int var1);

    public DoubleVector(long l, int n) {
        this.v = l;
        this.n = n;
    }

    public DoubleVector(JDDNode jDDNode, JDDVars jDDVars, ODDNode oDDNode) throws PrismException {
        ODDUtils.checkInt(oDDNode, "Can not create DoubleVector");
        this.v = this.DV_ConvertMTBDD(jDDNode.ptr(), jDDVars.array(), jDDVars.n(), oDDNode.ptr());
        this.n = (int)oDDNode.getNumStates();
    }

    private native long DV_ConvertMTBDD(long var1, long var3, int var5, long var6);

    public long getPtr() {
        return this.v;
    }

    public int getSize() {
        return this.n;
    }

    public double getElement(int n) {
        return this.DV_GetElement(this.v, this.n, n);
    }

    private native double DV_GetElement(long var1, int var3, int var4);

    public void setElement(int n, double d) {
        this.DV_SetElement(this.v, this.n, n, d);
    }

    private native void DV_SetElement(long var1, int var3, int var4, double var5);

    public void setAllElements(double d) {
        this.DV_SetAllElements(this.v, this.n, d);
    }

    private native void DV_SetAllElements(long var1, int var3, double var4);

    private native void DV_RoundOff(long var1, int var3, int var4);

    public void roundOff(int n) {
        this.DV_RoundOff(this.v, this.n, n);
    }

    private native void DV_SubtractFromOne(long var1, int var3);

    public void subtractFromOne() {
        this.DV_SubtractFromOne(this.v, this.n);
    }

    private native void DV_Add(long var1, int var3, long var4);

    public void add(DoubleVector doubleVector) {
        this.DV_Add(this.v, this.n, doubleVector.v);
    }

    private native void DV_TimesConstant(long var1, int var3, double var4);

    public void timesConstant(double d) {
        this.DV_TimesConstant(this.v, this.n, d);
    }

    private native double DV_DotProduct(long var1, int var3, long var4);

    public double dotProduct(DoubleVector doubleVector) {
        return this.DV_DotProduct(this.v, this.n, doubleVector.v);
    }

    private native void DV_Filter(long var1, long var3, double var5, long var7, int var9, long var10);

    public void filter(JDDNode jDDNode, double d, JDDVars jDDVars, ODDNode oDDNode) {
        this.DV_Filter(this.v, jDDNode.ptr(), d, jDDVars.array(), jDDVars.n(), oDDNode.ptr());
    }

    public void filter(JDDNode jDDNode, JDDVars jDDVars, ODDNode oDDNode) {
        this.DV_Filter(this.v, jDDNode.ptr(), 0.0, jDDVars.array(), jDDVars.n(), oDDNode.ptr());
    }

    private native void DV_MaxMTBDD(long var1, long var3, long var5, int var7, long var8);

    public void maxMTBDD(JDDNode jDDNode, JDDVars jDDVars, ODDNode oDDNode) {
        this.DV_MaxMTBDD(this.v, jDDNode.ptr(), jDDVars.array(), jDDVars.n(), oDDNode.ptr());
    }

    private native void DV_Clear(long var1);

    public void clear() {
        this.DV_Clear(this.v);
    }

    private native int DV_GetNNZ(long var1, int var3);

    public int getNNZ() {
        return this.DV_GetNNZ(this.v, this.n);
    }

    private native double DV_FirstFromBDD(long var1, long var3, long var5, int var7, long var8);

    public double firstFromBDD(JDDNode jDDNode, JDDVars jDDVars, ODDNode oDDNode) {
        return this.DV_FirstFromBDD(this.v, jDDNode.ptr(), jDDVars.array(), jDDVars.n(), oDDNode.ptr());
    }

    private native double DV_MinOverBDD(long var1, long var3, long var5, int var7, long var8);

    public double minOverBDD(JDDNode jDDNode, JDDVars jDDVars, ODDNode oDDNode) {
        return this.DV_MinOverBDD(this.v, jDDNode.ptr(), jDDVars.array(), jDDVars.n(), oDDNode.ptr());
    }

    private native double DV_MaxOverBDD(long var1, long var3, long var5, int var7, long var8);

    public double maxOverBDD(JDDNode jDDNode, JDDVars jDDVars, ODDNode oDDNode) {
        return this.DV_MaxOverBDD(this.v, jDDNode.ptr(), jDDVars.array(), jDDVars.n(), oDDNode.ptr());
    }

    private native double DV_MaxFiniteOverBDD(long var1, long var3, long var5, int var7, long var8);

    public double maxFiniteOverBDD(JDDNode jDDNode, JDDVars jDDVars, ODDNode oDDNode) {
        return this.DV_MaxOverBDD(this.v, jDDNode.ptr(), jDDVars.array(), jDDVars.n(), oDDNode.ptr());
    }

    private native double DV_SumOverBDD(long var1, long var3, long var5, int var7, long var8);

    public double sumOverBDD(JDDNode jDDNode, JDDVars jDDVars, ODDNode oDDNode) {
        return this.DV_SumOverBDD(this.v, jDDNode.ptr(), jDDVars.array(), jDDVars.n(), oDDNode.ptr());
    }

    private native double DV_SumOverMTBDD(long var1, long var3, long var5, int var7, long var8);

    public double sumOverMTBDD(JDDNode jDDNode, JDDVars jDDVars, ODDNode oDDNode) {
        return this.DV_SumOverMTBDD(this.v, jDDNode.ptr(), jDDVars.array(), jDDVars.n(), oDDNode.ptr());
    }

    private native void DV_SumOverDDVars(long var1, long var3, long var5, int var7, int var8, int var9, long var10, long var12);

    public DoubleVector sumOverDDVars(JDDVars jDDVars, ODDNode oDDNode, ODDNode oDDNode2, int n, int n2) throws PrismException {
        DoubleVector doubleVector = new DoubleVector((int)(oDDNode2.getEOff() + oDDNode2.getTOff()));
        this.DV_SumOverDDVars(this.v, doubleVector.v, jDDVars.array(), jDDVars.n(), n, n2, oDDNode.ptr(), oDDNode2.ptr());
        return doubleVector;
    }

    public JDDNode getBDDFromInterval(String string, double d, JDDVars jDDVars, ODDNode oDDNode) {
        return this.getBDDFromInterval(RelOp.parseSymbol(string), d, jDDVars, oDDNode);
    }

    public JDDNode getBDDFromInterval(RelOp relOp, double d, JDDVars jDDVars, ODDNode oDDNode) {
        JDDNode jDDNode = null;
        switch (relOp) {
            case GEQ: {
                jDDNode = JDD.ptrToNode(this.DV_BDDGreaterThanEquals(this.v, d, jDDVars.array(), jDDVars.n(), oDDNode.ptr()));
                break;
            }
            case GT: {
                jDDNode = JDD.ptrToNode(this.DV_BDDGreaterThan(this.v, d, jDDVars.array(), jDDVars.n(), oDDNode.ptr()));
                break;
            }
            case LEQ: {
                jDDNode = JDD.ptrToNode(this.DV_BDDLessThanEquals(this.v, d, jDDVars.array(), jDDVars.n(), oDDNode.ptr()));
                break;
            }
            case LT: {
                jDDNode = JDD.ptrToNode(this.DV_BDDLessThan(this.v, d, jDDVars.array(), jDDVars.n(), oDDNode.ptr()));
                break;
            }
        }
        return jDDNode;
    }

    private native long DV_BDDGreaterThanEquals(long var1, double var3, long var5, int var7, long var8);

    private native long DV_BDDGreaterThan(long var1, double var3, long var5, int var7, long var8);

    private native long DV_BDDLessThanEquals(long var1, double var3, long var5, int var7, long var8);

    private native long DV_BDDLessThan(long var1, double var3, long var5, int var7, long var8);

    public JDDNode getBDDFromInterval(double d, double d2, JDDVars jDDVars, ODDNode oDDNode) {
        JDDNode jDDNode = JDD.ptrToNode(this.DV_BDDInterval(this.v, d, d2, jDDVars.array(), jDDVars.n(), oDDNode.ptr()));
        return jDDNode;
    }

    private native long DV_BDDInterval(long var1, double var3, double var5, long var7, int var9, long var10);

    public JDDNode getBDDFromCloseValueAbs(double d, double d2, JDDVars jDDVars, ODDNode oDDNode) {
        JDDNode jDDNode = JDD.ptrToNode(this.DV_BDDCloseValueAbs(this.v, d, d2, jDDVars.array(), jDDVars.n(), oDDNode.ptr()));
        return jDDNode;
    }

    private native long DV_BDDCloseValueAbs(long var1, double var3, double var5, long var7, int var9, long var10);

    public JDDNode getBDDFromCloseValueRel(double d, double d2, JDDVars jDDVars, ODDNode oDDNode) {
        JDDNode jDDNode = JDD.ptrToNode(this.DV_BDDCloseValueRel(this.v, d, d2, jDDVars.array(), jDDVars.n(), oDDNode.ptr()));
        return jDDNode;
    }

    private native long DV_BDDCloseValueRel(long var1, double var3, double var5, long var7, int var9, long var10);

    private native long DV_ConvertToMTBDD(long var1, long var3, int var5, long var6);

    public JDDNode convertToMTBDD(JDDVars jDDVars, ODDNode oDDNode) {
        JDDNode jDDNode = JDD.ptrToNode(this.DV_ConvertToMTBDD(this.v, jDDVars.array(), jDDVars.n(), oDDNode.ptr()));
        return jDDNode;
    }

    public void print(PrismLog prismLog) {
        for (int i = 0; i < this.n; ++i) {
            double d = this.DV_GetElement(this.v, this.n, i);
            prismLog.print(d + " ");
        }
        prismLog.println();
    }

    static {
        try {
            System.loadLibrary("dv");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println(unsatisfiedLinkError);
            System.exit(1);
        }
    }
}

