/*
 * Decompiled with CFR 0.152.
 */
package common.iterable;

import common.functions.DoubleObjToDoubleFunction;
import common.functions.IntObjToIntFunction;
import common.functions.LongObjToLongFunction;
import common.iterable.ChainedIterable;
import common.iterable.ChainedIterator;
import common.iterable.Distinct;
import common.iterable.FunctionalIterable;
import common.iterable.FunctionalIterator;
import common.iterable.FunctionalPrimitiveIterable;
import common.iterable.FunctionalPrimitiveIterator;
import common.iterable.IterableAdaptor;
import common.iterable.IteratorAdaptor;
import common.iterable.PrimitiveIterable;
import common.iterable.PrimitiveReducible;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public interface Reducible<E, E_CAT> {
    public static <E> FunctionalIterable<E> extend(Iterable<E> iterable) {
        if (iterable instanceof FunctionalIterable) {
            return (FunctionalIterable)iterable;
        }
        if (iterable instanceof PrimitiveIterable.OfDouble) {
            return Reducible.extend((PrimitiveIterable.OfDouble)iterable);
        }
        if (iterable instanceof PrimitiveIterable.OfInt) {
            return Reducible.extend((PrimitiveIterable.OfInt)iterable);
        }
        if (iterable instanceof PrimitiveIterable.OfLong) {
            return Reducible.extend((PrimitiveIterable.OfLong)iterable);
        }
        return new IterableAdaptor.Of<E>(iterable);
    }

    public static <E> FunctionalIterator<E> extend(Iterator<E> iterator) {
        if (iterator instanceof FunctionalIterator) {
            return (FunctionalIterator)iterator;
        }
        if (iterator instanceof PrimitiveIterator.OfDouble) {
            return Reducible.extend((PrimitiveIterator.OfDouble)iterator);
        }
        if (iterator instanceof PrimitiveIterator.OfInt) {
            return Reducible.extend((PrimitiveIterator.OfInt)iterator);
        }
        if (iterator instanceof PrimitiveIterator.OfLong) {
            return Reducible.extend((PrimitiveIterator.OfLong)iterator);
        }
        return new IteratorAdaptor.Of<E>(iterator);
    }

    public static FunctionalPrimitiveIterable.OfDouble extend(PrimitiveIterable.OfDouble ofDouble) {
        if (ofDouble instanceof FunctionalPrimitiveIterable.OfDouble) {
            return (FunctionalPrimitiveIterable.OfDouble)ofDouble;
        }
        return new IterableAdaptor.OfDouble(ofDouble);
    }

    public static FunctionalPrimitiveIterator.OfDouble extend(PrimitiveIterator.OfDouble ofDouble) {
        if (ofDouble instanceof FunctionalPrimitiveIterator.OfDouble) {
            return (FunctionalPrimitiveIterator.OfDouble)ofDouble;
        }
        return new IteratorAdaptor.OfDouble(ofDouble);
    }

    public static FunctionalPrimitiveIterable.OfInt extend(PrimitiveIterable.OfInt ofInt) {
        if (ofInt instanceof FunctionalPrimitiveIterable.OfInt) {
            return (FunctionalPrimitiveIterable.OfInt)ofInt;
        }
        return new IterableAdaptor.OfInt(ofInt);
    }

    public static FunctionalPrimitiveIterator.OfInt extend(PrimitiveIterator.OfInt ofInt) {
        if (ofInt instanceof FunctionalPrimitiveIterator.OfInt) {
            return (FunctionalPrimitiveIterator.OfInt)ofInt;
        }
        return new IteratorAdaptor.OfInt(ofInt);
    }

    public static FunctionalPrimitiveIterable.OfLong extend(PrimitiveIterable.OfLong ofLong) {
        if (ofLong instanceof FunctionalPrimitiveIterable.OfLong) {
            return (FunctionalPrimitiveIterable.OfLong)ofLong;
        }
        return new IterableAdaptor.OfLong(ofLong);
    }

    public static FunctionalPrimitiveIterator.OfLong extend(PrimitiveIterator.OfLong ofLong) {
        if (ofLong instanceof FunctionalPrimitiveIterator.OfLong) {
            return (FunctionalPrimitiveIterator.OfLong)ofLong;
        }
        return new IteratorAdaptor.OfLong(ofLong);
    }

    public static <E> FunctionalIterable<E> concat(Iterable<? extends Iterable<? extends E>> iterable) {
        return new ChainedIterable.Of(iterable);
    }

    public static <E> FunctionalIterator<E> concat(Iterator<? extends Iterator<? extends E>> iterator) {
        return new ChainedIterator.Of(iterator);
    }

    public static FunctionalPrimitiveIterable.OfDouble concatDouble(Iterable<? extends PrimitiveIterable.OfDouble> iterable) {
        return new ChainedIterable.OfDouble(iterable);
    }

    public static FunctionalPrimitiveIterator.OfDouble concatDouble(Iterator<? extends PrimitiveIterator.OfDouble> iterator) {
        return new ChainedIterator.OfDouble(iterator);
    }

    public static FunctionalPrimitiveIterable.OfInt concatInt(Iterable<? extends PrimitiveIterable.OfInt> iterable) {
        return new ChainedIterable.OfInt(iterable);
    }

    public static FunctionalPrimitiveIterator.OfInt concatInt(Iterator<? extends PrimitiveIterator.OfInt> iterator) {
        return new ChainedIterator.OfInt(iterator);
    }

    public static FunctionalPrimitiveIterable.OfLong concatLong(Iterable<? extends PrimitiveIterable.OfLong> iterable) {
        return new ChainedIterable.OfLong(iterable);
    }

    public static FunctionalPrimitiveIterator.OfLong concatLong(Iterator<? extends PrimitiveIterator.OfLong> iterator) {
        return new ChainedIterator.OfLong(iterator);
    }

    public static FunctionalPrimitiveIterable.OfDouble unboxDouble(Iterable<Double> iterable) {
        if (iterable instanceof FunctionalPrimitiveIterable.OfDouble) {
            return (FunctionalPrimitiveIterable.OfDouble)iterable;
        }
        return Reducible.extend(PrimitiveIterable.unboxDouble(iterable));
    }

    public static FunctionalPrimitiveIterator.OfDouble unboxDouble(Iterator<Double> iterator) {
        if (iterator instanceof PrimitiveIterator.OfDouble) {
            return Reducible.extend((PrimitiveIterator.OfDouble)iterator);
        }
        return Reducible.extend(PrimitiveIterable.unboxDouble(iterator));
    }

    public static FunctionalPrimitiveIterable.OfInt unboxInt(Iterable<Integer> iterable) {
        if (iterable instanceof FunctionalPrimitiveIterable.OfInt) {
            return (FunctionalPrimitiveIterable.OfInt)iterable;
        }
        return Reducible.extend(PrimitiveIterable.unboxInt(iterable));
    }

    public static FunctionalPrimitiveIterator.OfInt unboxInt(Iterator<Integer> iterator) {
        if (iterator instanceof PrimitiveIterator.OfInt) {
            return Reducible.extend((PrimitiveIterator.OfInt)iterator);
        }
        return Reducible.extend(PrimitiveIterable.unboxInt(iterator));
    }

    public static FunctionalPrimitiveIterable.OfLong unboxLong(Iterable<Long> iterable) {
        if (iterable instanceof FunctionalPrimitiveIterable.OfLong) {
            return (FunctionalPrimitiveIterable.OfLong)iterable;
        }
        return Reducible.extend(PrimitiveIterable.unboxLong(iterable));
    }

    public static FunctionalPrimitiveIterator.OfLong unboxLong(Iterator<Long> iterator) {
        if (iterator instanceof PrimitiveIterator.OfLong) {
            return Reducible.extend((PrimitiveIterator.OfLong)iterator);
        }
        return Reducible.extend(PrimitiveIterable.unboxLong(iterator));
    }

    public void forEach(Consumer<? super E> var1);

    public boolean isEmpty();

    public Reducible<E, E_CAT> concat(E_CAT var1);

    default public Reducible<E, E_CAT> dedupe() {
        Predicate predicate = new Predicate<E>(){
            Object previous = new Object();

            @Override
            public boolean test(E e) {
                if (Objects.equals(this.previous, e)) {
                    return false;
                }
                this.previous = e;
                return true;
            }
        };
        return this.filter(predicate);
    }

    default public Reducible<E, E_CAT> distinct() {
        return this.filter(new Distinct.Of());
    }

    public Reducible<E, E_CAT> filter(Predicate<? super E> var1);

    public <T> Reducible<T, ?> map(Function<? super E, ? extends T> var1);

    public PrimitiveReducible.OfDouble<?> mapToDouble(ToDoubleFunction<? super E> var1);

    public PrimitiveReducible.OfInt<?> mapToInt(ToIntFunction<? super E> var1);

    public PrimitiveReducible.OfLong<?> mapToLong(ToLongFunction<? super E> var1);

    default public Reducible<E, E_CAT> nonNull() {
        return this.filter(Objects::nonNull);
    }

    default public Reducible<E, E_CAT> consume() {
        this.forEach(object -> {});
        return this;
    }

    default public boolean allMatch(Predicate<? super E> predicate) {
        return !this.anyMatch(predicate.negate());
    }

    default public boolean anyMatch(Predicate<? super E> predicate) {
        return !this.filter(predicate).isEmpty();
    }

    default public boolean noneMatch(Predicate<? super E> predicate) {
        return !this.anyMatch(predicate);
    }

    default public String asString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        this.forEach(object -> {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(object);
        });
        return stringBuilder.append("]").toString();
    }

    default public <C extends Collection<? super E>> C collect(Supplier<? extends C> supplier) {
        Objects.requireNonNull(supplier);
        Collection collection = (Collection)supplier.get();
        this.collect(collection);
        return (C)collection;
    }

    default public <C extends Collection<? super E>> C collect(C c) {
        Objects.requireNonNull(c);
        this.forEach(c::add);
        return c;
    }

    default public E[] collect(E[] EArray) {
        return this.collect(EArray, 0);
    }

    default public E[] collect(E[] EArray, int n) {
        this.collectAndCount(EArray, n);
        return EArray;
    }

    default public long collectAndCount(Collection<? super E> collection) {
        Objects.requireNonNull(collection);
        return this.reduce(0L, (long l, ? super E object) -> {
            collection.add(object);
            return l + 1L;
        });
    }

    default public int collectAndCount(E[] EArray) {
        return this.collectAndCount(EArray, 0);
    }

    default public int collectAndCount(E[] EArray, int n2) {
        Objects.requireNonNull(EArray);
        int n3 = this.reduce(n2, (int n, ? super E object) -> {
            objectArray[n] = object;
            return n + 1;
        });
        return n3 - n2;
    }

    default public FunctionalIterable<E> collectDistinct() {
        Distinct.Of of = new Distinct.Of();
        this.filter(of).consume();
        return of.getSeen();
    }

    default public boolean contains(Object object) {
        return this.anyMatch(object == null ? Objects::isNull : object::equals);
    }

    default public long count() {
        return this.reduce(0L, (long l, ? super E object) -> l + 1L);
    }

    default public long count(Predicate<? super E> predicate) {
        return this.filter(predicate).count();
    }

    public E detect(Predicate<? super E> var1);

    public Optional<E> reduce(BinaryOperator<E> var1);

    public <T> T reduce(T var1, BiFunction<T, ? super E, T> var2);

    public double reduce(double var1, DoubleObjToDoubleFunction<? super E> var3);

    public int reduce(int var1, IntObjToIntFunction<? super E> var2);

    public long reduce(long var1, LongObjToLongFunction<? super E> var3);
}

