/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ps;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.ps.MultiVarCoefficients;
import edu.jas.ps.MultiVarPowerSeries;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReductionSeq<C extends RingElem<C>> {
    private static final Logger logger = LogManager.getLogger(ReductionSeq.class);
    private static final boolean debug = logger.isDebugEnabled();

    public boolean moduleCriterion(int n, MultiVarPowerSeries<C> multiVarPowerSeries, MultiVarPowerSeries<C> multiVarPowerSeries2) {
        if (n == 0) {
            return true;
        }
        ExpVector expVector = multiVarPowerSeries.orderExpVector();
        ExpVector expVector2 = multiVarPowerSeries2.orderExpVector();
        return this.moduleCriterion(n, expVector, expVector2);
    }

    public boolean moduleCriterion(int n, ExpVector expVector, ExpVector expVector2) {
        if (n == 0) {
            return true;
        }
        return expVector.invLexCompareTo(expVector2, 0, n) == 0;
    }

    public boolean criterion4(MultiVarPowerSeries<C> multiVarPowerSeries, MultiVarPowerSeries<C> multiVarPowerSeries2, ExpVector expVector) {
        ExpVector expVector2;
        ExpVector expVector3;
        ExpVector expVector4;
        ExpVector expVector5;
        int n;
        if (logger.isInfoEnabled()) {
            if (!multiVarPowerSeries.ring.equals(multiVarPowerSeries2.ring)) {
                logger.error("rings not equal: {} != {}", multiVarPowerSeries.ring, multiVarPowerSeries2.ring);
            }
            if (!multiVarPowerSeries.ring.isCommutative()) {
                logger.error("GBCriterion4 not applicabable to non-commutative power series");
                return true;
            }
        }
        return (n = (expVector5 = (expVector4 = (expVector3 = multiVarPowerSeries.orderExpVector()).sum(expVector2 = multiVarPowerSeries2.orderExpVector())).subtract(expVector)).signum()) != 0;
    }

    public MultiVarPowerSeries<C> SPolynomial(MultiVarPowerSeries<C> multiVarPowerSeries, MultiVarPowerSeries<C> multiVarPowerSeries2) {
        if (multiVarPowerSeries2 == null || multiVarPowerSeries2.isZERO()) {
            if (multiVarPowerSeries == null) {
                return multiVarPowerSeries2;
            }
            return multiVarPowerSeries.ring.getZERO();
        }
        if (multiVarPowerSeries == null || multiVarPowerSeries.isZERO()) {
            return multiVarPowerSeries2.ring.getZERO();
        }
        if (debug && !multiVarPowerSeries.ring.equals(multiVarPowerSeries2.ring)) {
            logger.error("rings not equal: {} != {}", multiVarPowerSeries.ring, multiVarPowerSeries2.ring);
        }
        Map.Entry<ExpVector, C> entry = multiVarPowerSeries.orderMonomial();
        Map.Entry<ExpVector, C> entry2 = multiVarPowerSeries2.orderMonomial();
        ExpVector expVector = entry.getKey();
        ExpVector expVector2 = entry2.getKey();
        ExpVector expVector3 = expVector.lcm(expVector2);
        ExpVector expVector4 = expVector3.subtract(expVector);
        ExpVector expVector5 = expVector3.subtract(expVector2);
        RingElem ringElem = (RingElem)entry.getValue();
        RingElem ringElem2 = (RingElem)entry2.getValue();
        MultiVarPowerSeries<RingElem> multiVarPowerSeries3 = multiVarPowerSeries.multiply(ringElem2, expVector4);
        MultiVarPowerSeries<RingElem> multiVarPowerSeries4 = multiVarPowerSeries2.multiply(ringElem, expVector5);
        MultiVarPowerSeries<RingElem> multiVarPowerSeries5 = multiVarPowerSeries3.subtract(multiVarPowerSeries4);
        return multiVarPowerSeries5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiVarPowerSeries<C> normalform(List<MultiVarPowerSeries<C>> list, MultiVarPowerSeries<C> multiVarPowerSeries) {
        Map.Entry<ExpVector, Object> entry;
        if (list == null || list.isEmpty()) {
            return multiVarPowerSeries;
        }
        if (multiVarPowerSeries == null || multiVarPowerSeries.isZERO()) {
            return multiVarPowerSeries;
        }
        if (!multiVarPowerSeries.ring.coFac.isField()) {
            throw new IllegalArgumentException("coefficients not from a field");
        }
        ArrayList<MultiVarPowerSeries<C>> arrayList = new ArrayList<MultiVarPowerSeries<C>>(list.size());
        List<MultiVarPowerSeries<C>> list2 = list;
        synchronized (list2) {
            arrayList.addAll(list);
        }
        list2 = new ArrayList<MultiVarPowerSeries<C>>(arrayList.size());
        ArrayList<RingElem> arrayList2 = new ArrayList<RingElem>(arrayList.size());
        ArrayList<MultiVarPowerSeries<RingElem>> arrayList3 = new ArrayList<MultiVarPowerSeries<RingElem>>(arrayList.size());
        ArrayList<Long> arrayList4 = new ArrayList<Long>(arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            entry = ((MultiVarPowerSeries)arrayList.get(i)).orderMonomial();
            if (entry == null) continue;
            arrayList3.add((MultiVarPowerSeries)arrayList.get(i));
            ((ArrayList)list2).add((MultiVarPowerSeries<C>)((Object)entry.getKey()));
            arrayList2.add((RingElem)entry.getValue());
            arrayList4.add(((MultiVarPowerSeries)arrayList.get(i)).ecart());
        }
        MultiVarPowerSeries<Object> multiVarPowerSeries2 = multiVarPowerSeries;
        entry = multiVarPowerSeries2.orderMonomial();
        while (entry != null) {
            int n;
            if (multiVarPowerSeries2.isZERO()) {
                return multiVarPowerSeries2;
            }
            ExpVector expVector = entry.getKey();
            if (debug) {
                logger.debug("e = " + expVector.toString(multiVarPowerSeries.ring.vars));
            }
            ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
            for (n = 0; n < ((ArrayList)list2).size(); ++n) {
                if (!expVector.multipleOf((ExpVector)((ArrayList)list2).get(n))) continue;
                arrayList5.add(n);
            }
            if (arrayList5.isEmpty()) {
                return multiVarPowerSeries2;
            }
            long l = Long.MAX_VALUE;
            for (int i = 0; i < arrayList5.size(); ++i) {
                int n2 = (Integer)arrayList5.get(i);
                long l2 = (Long)arrayList4.get(n2);
                if (l2 >= l) continue;
                l = l2;
                n = n2;
            }
            long l3 = multiVarPowerSeries2.ecart();
            if (l > l3) {
                arrayList3.add(multiVarPowerSeries2);
                ((ArrayList)list2).add((MultiVarPowerSeries<C>)((Object)entry.getKey()));
                arrayList2.add((RingElem)entry.getValue());
                arrayList4.add(l3);
            }
            expVector = expVector.subtract((ExpVector)((ArrayList)list2).get(n));
            RingElem ringElem = ((RingElem)entry.getValue()).divide((RingElem)arrayList2.get(n));
            MultiVarPowerSeries<RingElem> multiVarPowerSeries3 = ((MultiVarPowerSeries)arrayList3.get(n)).multiply(ringElem, expVector);
            multiVarPowerSeries2 = multiVarPowerSeries2.subtract(multiVarPowerSeries3);
            entry = multiVarPowerSeries2.orderMonomial();
        }
        return multiVarPowerSeries2;
    }

    public MultiVarPowerSeries<C> totalNormalform(List<MultiVarPowerSeries<C>> list, MultiVarPowerSeries<C> multiVarPowerSeries) {
        Map.Entry<ExpVector, C> entry;
        if (list == null || list.isEmpty()) {
            return multiVarPowerSeries;
        }
        if (multiVarPowerSeries == null) {
            return multiVarPowerSeries;
        }
        MultiVarPowerSeries<C> multiVarPowerSeries2 = this.normalform(list, multiVarPowerSeries);
        if (multiVarPowerSeries2.isZERO()) {
            return multiVarPowerSeries2;
        }
        MultiVarCoefficients multiVarCoefficients = new MultiVarCoefficients<C>(multiVarPowerSeries.ring){

            @Override
            public C generate(ExpVector expVector) {
                return (RingElem)this.pfac.coFac.getZERO();
            }
        };
        GenPolynomialRing genPolynomialRing = multiVarPowerSeries.lazyCoeffs.pfac;
        while (!multiVarPowerSeries2.isZERO() && (entry = multiVarPowerSeries2.orderMonomial()) != null) {
            multiVarPowerSeries2 = multiVarPowerSeries2.reductum();
            ExpVector expVector = entry.getKey();
            long l = expVector.totalDeg();
            AbelianGroupElem abelianGroupElem = multiVarCoefficients.coeffCache.get(l);
            if (abelianGroupElem == null) {
                abelianGroupElem = genPolynomialRing.getZERO();
            }
            abelianGroupElem = abelianGroupElem.sum((RingElem)entry.getValue(), expVector);
            multiVarCoefficients.coeffCache.put(l, abelianGroupElem);
            multiVarPowerSeries2 = this.normalform(list, multiVarPowerSeries2);
        }
        multiVarPowerSeries2 = multiVarPowerSeries2.sum(multiVarCoefficients);
        return multiVarPowerSeries2;
    }

    public List<MultiVarPowerSeries<C>> totalNormalform(List<MultiVarPowerSeries<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<MultiVarPowerSeries<C>> arrayList = new ArrayList<MultiVarPowerSeries<C>>(list.size());
        ArrayList<MultiVarPowerSeries<C>> arrayList2 = new ArrayList<MultiVarPowerSeries<C>>(list);
        for (MultiVarPowerSeries<C> multiVarPowerSeries : list) {
            Map.Entry<ExpVector, C> entry = multiVarPowerSeries.orderMonomial();
            if (entry == null) continue;
            MultiVarPowerSeries<C> multiVarPowerSeries2 = multiVarPowerSeries.reductum();
            MultiVarPowerSeries<C> multiVarPowerSeries3 = this.normalform(arrayList2, multiVarPowerSeries2);
            if ((multiVarPowerSeries3 = multiVarPowerSeries3.sum(entry)).isZERO()) continue;
            arrayList.add(multiVarPowerSeries3);
        }
        return arrayList;
    }

    public boolean isTopReducible(List<MultiVarPowerSeries<C>> list, MultiVarPowerSeries<C> multiVarPowerSeries) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        if (multiVarPowerSeries == null) {
            return false;
        }
        ExpVector expVector = multiVarPowerSeries.orderExpVector();
        if (expVector == null) {
            return false;
        }
        for (MultiVarPowerSeries<C> multiVarPowerSeries2 : list) {
            ExpVector expVector2 = multiVarPowerSeries2.orderExpVector();
            if (expVector2 == null || !expVector.multipleOf(expVector2)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(List<MultiVarPowerSeries<C>> list, List<MultiVarPowerSeries<C>> list2) {
        if (list2 == null || list2.size() == 0) {
            return true;
        }
        if (list == null || list.size() == 0) {
            return true;
        }
        for (MultiVarPowerSeries<C> multiVarPowerSeries : list2) {
            MultiVarPowerSeries<C> multiVarPowerSeries2;
            if (multiVarPowerSeries == null || (multiVarPowerSeries2 = this.normalform(list, multiVarPowerSeries)).isZERO()) continue;
            System.out.println("contains nf(b) != 0: " + multiVarPowerSeries + ", z = " + multiVarPowerSeries2);
            return false;
        }
        return true;
    }
}

