/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.application;

import edu.jas.application.LocalRing;
import edu.jas.kern.PrettyPrint;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.QuotPair;
import edu.jas.structure.RingElem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Local<C extends GcdRingElem<C>>
implements RingElem<Local<C>>,
QuotPair<GenPolynomial<C>> {
    private static final Logger logger = LogManager.getLogger(Local.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final LocalRing<C> ring;
    protected final GenPolynomial<C> num;
    protected final GenPolynomial<C> den;
    protected int isunit = -1;

    public Local(LocalRing<C> localRing) {
        this(localRing, (GenPolynomial<C>)localRing.ring.getZERO());
    }

    public Local(LocalRing<C> localRing, GenPolynomial<C> genPolynomial) {
        this(localRing, genPolynomial, (GenPolynomial<C>)localRing.ring.getONE(), true);
    }

    public Local(LocalRing<C> localRing, GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        this(localRing, genPolynomial, genPolynomial2, false);
    }

    protected Local(LocalRing<C> localRing, GenPolynomial<C> abelianGroupElem, GenPolynomial<C> abelianGroupElem2, boolean bl) {
        if (abelianGroupElem2 == null || ((GenPolynomial)abelianGroupElem2).isZERO()) {
            throw new IllegalArgumentException("denominator may not be zero");
        }
        this.ring = localRing;
        if (((GenPolynomial)abelianGroupElem2).signum() < 0) {
            abelianGroupElem = ((GenPolynomial)abelianGroupElem).negate();
            abelianGroupElem2 = ((GenPolynomial)abelianGroupElem2).negate();
        }
        if (bl) {
            this.num = abelianGroupElem;
            this.den = abelianGroupElem2;
            return;
        }
        GenPolynomial genPolynomial = this.ring.ideal.normalform((GenPolynomial<GenPolynomial<C>>)abelianGroupElem2);
        if (genPolynomial == null || genPolynomial.isZERO()) {
            throw new IllegalArgumentException("denominator may not be in ideal");
        }
        GcdRingElem gcdRingElem = (GcdRingElem)((GenPolynomial)abelianGroupElem2).leadingBaseCoefficient();
        if (!gcdRingElem.isONE() && gcdRingElem.isUnit()) {
            gcdRingElem = (GcdRingElem)gcdRingElem.inverse();
            abelianGroupElem = ((GenPolynomial)abelianGroupElem).multiply((GenPolynomial<GcdRingElem>)((Object)gcdRingElem));
            abelianGroupElem2 = ((GenPolynomial)abelianGroupElem2).multiply((GenPolynomial<GcdRingElem>)((Object)gcdRingElem));
        }
        if (((GenPolynomial)abelianGroupElem).compareTo((GenPolynomial<GenPolynomial<GcdRingElem>>)abelianGroupElem2) == 0) {
            this.num = this.ring.ring.getONE();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)((GenPolynomial)abelianGroupElem).negate()).compareTo(abelianGroupElem2) == 0) {
            this.num = ((GenPolynomial)this.ring.ring.getONE()).negate();
            this.den = this.ring.ring.getONE();
            return;
        }
        if (((GenPolynomial)abelianGroupElem).isZERO()) {
            this.num = abelianGroupElem;
            this.den = this.ring.ring.getONE();
            return;
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.ring.engine.gcd((GenPolynomial<GenPolynomial<GcdRingElem>>)abelianGroupElem, (GenPolynomial<GenPolynomial<GcdRingElem>>)abelianGroupElem2);
        if (debug) {
            logger.info("gcd = " + genPolynomial2);
        }
        if (genPolynomial2.isONE()) {
            this.num = abelianGroupElem;
            this.den = abelianGroupElem2;
        } else {
            this.num = ((GenPolynomial)abelianGroupElem).divide(genPolynomial2);
            this.den = ((GenPolynomial)abelianGroupElem2).divide(genPolynomial2);
        }
    }

    @Override
    public LocalRing<C> factory() {
        return this.ring;
    }

    @Override
    public GenPolynomial<C> numerator() {
        return this.num;
    }

    @Override
    public GenPolynomial<C> denominator() {
        return this.den;
    }

    @Override
    public Local<C> copy() {
        return new Local<C>(this.ring, this.num, this.den, true);
    }

    @Override
    public boolean isZERO() {
        return this.num.isZERO();
    }

    @Override
    public boolean isONE() {
        return this.num.equals(this.den);
    }

    @Override
    public boolean isUnit() {
        if (this.isunit > 0) {
            return true;
        }
        if (this.isunit == 0) {
            return false;
        }
        if (this.num.isZERO()) {
            this.isunit = 0;
            return false;
        }
        GenPolynomial genPolynomial = this.ring.ideal.normalform(this.num);
        boolean bl = genPolynomial != null && !genPolynomial.isZERO();
        this.isunit = bl ? 1 : 0;
        return bl;
    }

    @Override
    public boolean isConstant() {
        return this.num.isConstant() && this.den.isConstant();
    }

    public String toString() {
        if (PrettyPrint.isTrue()) {
            String string = "{ " + this.num.toString(this.ring.ring.getVars());
            if (this.den.isONE()) {
                return string + " }";
            }
            return string + "| " + this.den.toString(this.ring.ring.getVars()) + " }";
        }
        return "Local[ " + this.num.toString() + " | " + this.den.toString() + " ]";
    }

    @Override
    public String toScript() {
        if (this.den.isONE()) {
            return this.num.toScript();
        }
        return this.num.toScript() + " / " + this.den.toScript();
    }

    @Override
    public String toScriptFactory() {
        return ((LocalRing)this.factory()).toScript();
    }

    @Override
    public int compareTo(Local<C> local) {
        int n;
        if (local == null || local.isZERO()) {
            return this.signum();
        }
        if (this.isZERO()) {
            return -local.signum();
        }
        int n2 = this.num.signum();
        int n3 = (n2 - (n = local.num.signum())) / 2;
        if (n3 != 0) {
            System.out.println("compareTo: t = " + n3);
            return n3;
        }
        if (this.den.compareTo(local.den) == 0) {
            return this.num.compareTo(local.num);
        }
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial = this.num.multiply(local.den);
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.den.multiply(local.num);
        return genPolynomial.compareTo((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)genPolynomial2);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Local)) {
            return false;
        }
        Local local = null;
        try {
            local = (Local)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (local == null) {
            return false;
        }
        return this.compareTo(local) == 0;
    }

    @Override
    public int hashCode() {
        int n = this.ring.hashCode();
        n = 37 * n + this.num.hashCode();
        n = 37 * n + this.den.hashCode();
        return n;
    }

    @Override
    public Local<C> abs() {
        return new Local<C>(this.ring, this.num.abs(), this.den, true);
    }

    @Override
    public Local<C> sum(Local<C> local) {
        if (local == null || local.isZERO()) {
            return this;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> genPolynomial = this.num.multiply(local.den);
        genPolynomial = genPolynomial.sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)this.den.multiply(local.num));
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.den.multiply(local.den);
        return new Local<GenPolynomial<C>>(this.ring, genPolynomial, genPolynomial2, false);
    }

    @Override
    public Local<C> negate() {
        return new Local<C>(this.ring, this.num.negate(), this.den, true);
    }

    @Override
    public int signum() {
        return this.num.signum();
    }

    @Override
    public Local<C> subtract(Local<C> local) {
        if (local == null || local.isZERO()) {
            return this;
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> genPolynomial = this.num.multiply(local.den);
        genPolynomial = genPolynomial.subtract((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)this.den.multiply(local.num));
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.den.multiply(local.den);
        return new Local<GenPolynomial<C>>(this.ring, genPolynomial, genPolynomial2, false);
    }

    @Override
    public Local<C> divide(Local<C> local) {
        return this.multiply((C)local.inverse());
    }

    @Override
    public Local<C> inverse() {
        if (this.isONE()) {
            return this;
        }
        if (this.isUnit()) {
            return new Local<C>(this.ring, this.den, this.num, true);
        }
        throw new ArithmeticException("element not invertible " + this);
    }

    @Override
    public Local<C> remainder(Local<C> local) {
        if (local.isUnit()) {
            return this.ring.getZERO();
        }
        throw new UnsupportedOperationException("remainder not implemented" + local);
    }

    @Override
    public Local<C> multiply(Local<C> local) {
        if (local == null || local.isZERO()) {
            return local;
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (local.isONE()) {
            return this;
        }
        if (this.isONE()) {
            return local;
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial = this.num.multiply(local.num);
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.den.multiply(local.den);
        return new Local<GenPolynomial<C>>(this.ring, genPolynomial, genPolynomial2, false);
    }

    @Override
    public Local<C> multiply(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (genPolynomial.isONE()) {
            return this;
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.num.multiply(genPolynomial);
        return new Local<GenPolynomial<C>>(this.ring, genPolynomial2, this.den, false);
    }

    @Override
    public Local<C> multiply(C c) {
        if (c == null || c.isZERO()) {
            return this.ring.getZERO();
        }
        if (this.num.isZERO()) {
            return this;
        }
        if (c.isONE()) {
            return this;
        }
        GenPolynomial<C> genPolynomial = this.num.multiply(c);
        return new Local<C>(this.ring, genPolynomial, this.den, false);
    }

    @Override
    public Local<C> multiply(ExpVector expVector) {
        if (expVector == null || expVector.isZERO()) {
            return this;
        }
        if (this.num.isZERO()) {
            return this;
        }
        GenPolynomial<C> genPolynomial = this.num.multiply(expVector);
        return new Local<C>(this.ring, genPolynomial, this.den, false);
    }

    public Local<C> monic() {
        if (this.num.isZERO()) {
            return this;
        }
        return this;
    }

    @Override
    public Local<C> gcd(Local<C> local) {
        GenPolynomial genPolynomial = this.ring.engine.gcd(this.num, local.num);
        GenPolynomial genPolynomial2 = this.ring.engine.gcd(this.den, local.den);
        return new Local<C>(this.ring, genPolynomial, genPolynomial2, true);
    }

    public Local<C>[] egcd(Local<C> local) {
        throw new UnsupportedOperationException("egcd not implemented " + this.getClass().getName());
    }
}

