/*
 * Decompiled with CFR 0.152.
 */
package userinterface.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import userinterface.util.BooleanProperty;
import userinterface.util.ChoiceProperty;
import userinterface.util.ColourProperty;
import userinterface.util.FontColorProperty;
import userinterface.util.MultipleProperty;
import userinterface.util.PropertyTableModel;
import userinterface.util.SingleProperty;

public class PropertyTable
extends JPanel
implements ListSelectionListener,
TableModelListener,
ItemListener {
    private PropertyTableModel theModel;
    private int lineWidth;
    private PropertyCellEditor ce;
    JLabel commentLabel;
    JTextArea commentText;
    JComboBox theCombo;
    JTable theTable;
    JPanel topPanel;

    public PropertyTable(PropertyTableModel propertyTableModel) {
        this.theModel = propertyTableModel;
        this.initComponents();
        propertyTableModel.setJTable(this.theTable);
        propertyTableModel.addTableModelListener(this);
        this.lineWidth = this.theTable.getRowHeight();
        this.theTable.setModel(propertyTableModel);
        this.theTable.setRowSelectionAllowed(true);
        this.theTable.setColumnSelectionAllowed(false);
        this.theTable.setCellSelectionEnabled(false);
        this.theTable.getSelectionModel().addListSelectionListener(this);
        this.theTable.setAutoResizeMode(3);
        this.theCombo.setModel(propertyTableModel.getComboModel());
        this.theCombo.addItemListener(this);
        this.theTable.getColumnModel().getColumn(0).setMinWidth(30);
        TableColumn tableColumn = this.theTable.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new PropertyCellRenderer());
        this.setCurrEditor(new PropertyCellEditor());
        for (int i = 0; i < propertyTableModel.getRowCount(); ++i) {
        }
        this.doChoiceBox();
        this.commentLabel.setFont(new Font("serif", 1, 12));
    }

    public void setNameColumnWidth(int n) {
    }

    private void doChoiceBox() {
        if (this.theModel.getNumGroups() == 0) {
            this.topPanel.removeAll();
            JLabel jLabel = new JLabel("");
            this.topPanel.setLayout(new BorderLayout());
            this.topPanel.add((Component)jLabel, "Center");
        } else if (this.theModel.getNumGroups() == 1) {
            this.topPanel.removeAll();
            JLabel jLabel = new JLabel(this.theCombo.getModel().getElementAt(0).toString());
            this.topPanel.setLayout(new BorderLayout());
            this.topPanel.add((Component)jLabel, "Center");
        } else {
            this.topPanel.removeAll();
            this.topPanel.setLayout(new BorderLayout());
            this.topPanel.add((Component)this.theCombo, "Center");
        }
        this.revalidate();
    }

    public void stopEditing() {
        if (this.ce != null) {
            this.ce.stopEditing();
        }
    }

    public void setCurrEditor(PropertyCellEditor propertyCellEditor) {
        TableColumn tableColumn = this.theTable.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(propertyCellEditor);
        this.ce = propertyCellEditor;
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JSplitPane jSplitPane = new JSplitPane();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setBackground(Color.white);
        this.theTable = new JTable(){};
        this.theTable.setModel(this.theModel);
        this.theTable.setSelectionMode(0);
        this.theTable.setRowSelectionAllowed(false);
        this.theTable.setColumnSelectionAllowed(false);
        this.theTable.setCellSelectionEnabled(true);
        JPanel jPanel2 = new JPanel();
        this.commentText = new JTextArea();
        this.commentLabel = new JLabel();
        this.topPanel = new JPanel();
        this.theCombo = new JComboBox();
        this.setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        jSplitPane.setBackground(new Color(255, 255, 255));
        jSplitPane.setBorder(null);
        jSplitPane.setDividerSize(3);
        jSplitPane.setOrientation(0);
        jSplitPane.setResizeWeight(1.0);
        jSplitPane.setOneTouchExpandable(true);
        jScrollPane.setBackground(new Color(255, 255, 255));
        jScrollPane.setBorder(new LineBorder(SystemColor.textInactiveText));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.theTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.theTable.setDoubleBuffered(true);
        this.theTable.setGridColor(new Color(198, 197, 197));
        jScrollPane.setViewportView(this.theTable);
        jSplitPane.setLeftComponent(jScrollPane);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new LineBorder(SystemColor.inactiveCaption));
        jPanel2.setMinimumSize(new Dimension(10, 75));
        jPanel2.setPreferredSize(new Dimension(100, 75));
        this.commentText.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.commentText.setColumns(1);
        this.commentText.setEditable(false);
        this.commentText.setLineWrap(true);
        this.commentText.setWrapStyleWord(true);
        this.commentText.setBorder(null);
        this.commentText.setDoubleBuffered(true);
        this.commentText.setFocusable(false);
        this.commentText.setMinimumSize(new Dimension(100, 75));
        this.commentText.setPreferredSize(new Dimension(100, 75));
        jPanel2.add((Component)this.commentText, "Center");
        jPanel2.add((Component)this.commentLabel, "North");
        jSplitPane.setRightComponent(jPanel2);
        jPanel.add((Component)jSplitPane, "Center");
        this.add((Component)jPanel, "Center");
        this.topPanel.setLayout(new BorderLayout());
        this.topPanel.add((Component)this.theCombo, "North");
        this.add((Component)this.topPanel, "North");
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        SingleProperty singleProperty = this.theModel.getSelectedProperty(this.theTable.getSelectedRow());
        if (singleProperty != null) {
            this.commentLabel.setText(singleProperty.getName());
            this.commentText.setText(singleProperty.getComment());
        } else {
            this.commentLabel.setText("");
            this.commentText.setText("");
        }
        for (int i = 0; i < this.theModel.getRowCount(); ++i) {
            int n = 1;
            if (this.theModel.getValueAt(i, 1) instanceof FontColorProperty) {
                int n2 = ((FontColorProperty)this.theModel.getValueAt((int)i, (int)1)).getFontColorPair().f.getSize();
                n2 = Math.max(n2, this.lineWidth - 2);
                this.theTable.setRowHeight(i, n2 * n + 4);
                continue;
            }
            if (!(this.theModel.getValueAt(i, 1) instanceof SingleProperty)) continue;
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        TableCellEditor tableCellEditor = this.theTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        this.theCombo.setModel(this.theModel.getComboModel());
        for (int i = 0; i < this.theModel.getRowCount(); ++i) {
            String string = this.theModel.getValueAt(i, 1).toString();
            int n = 1;
            if (this.theModel.getValueAt(i, 1) instanceof FontColorProperty) {
                int n2 = ((FontColorProperty)this.theModel.getValueAt((int)i, (int)1)).getFontColorPair().f.getSize();
                n2 = Math.max(n2, this.lineWidth - 2);
                this.theTable.setRowHeight(i, n2 * n + 4);
                continue;
            }
            if (this.theModel.getValueAt(i, 1) instanceof SingleProperty || !(this.theModel.getValueAt(i, 1) instanceof MultipleProperty)) continue;
            n = PropertyTable.getNumLines(string);
            this.theTable.setRowHeight(i, this.lineWidth * n + 2);
        }
        this.doChoiceBox();
    }

    public static int getNumLines(String string) {
        int n = 1;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\n') continue;
            ++n;
        }
        return n;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.theModel.setCurrentGroup(this.theCombo.getSelectedIndex());
    }

    class PropertyCellRenderer
    implements TableCellRenderer {
        JTextArea area = new JTextArea();
        JTextField field = new JTextField();

        public PropertyCellRenderer() {
            this.area.setLineWrap(false);
            this.area.setOpaque(true);
            this.field.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.area.setForeground(jTable.getSelectionForeground());
                this.area.setBackground(jTable.getSelectionBackground());
                this.field.setForeground(jTable.getSelectionForeground());
                this.field.setBackground(jTable.getSelectionBackground());
            } else {
                this.area.setForeground(jTable.getForeground());
                this.area.setBackground(Color.white);
                this.field.setForeground(jTable.getForeground());
                this.field.setBackground(Color.white);
            }
            if (object instanceof SingleProperty) {
                SingleProperty singleProperty = (SingleProperty)object;
                Component component = singleProperty.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component != null) {
                    return component;
                }
                if (!singleProperty.isEnabled()) {
                    this.field.setEnabled(false);
                    this.area.setEnabled(false);
                    this.field.setEditable(false);
                    this.area.setEditable(false);
                    this.field.setCaretColor(Color.white);
                    this.area.setCaretColor(Color.white);
                } else {
                    this.field.setEnabled(true);
                    this.area.setEnabled(true);
                    this.field.setEditable(true);
                    this.area.setEditable(true);
                    this.field.setCaretColor(Color.black);
                    this.area.setCaretColor(Color.black);
                }
                if (!singleProperty.isMultiline()) {
                    this.field.setFont(jTable.getFont());
                    if (bl2) {
                        this.field.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                        if (jTable.isCellEditable(n, n2)) {
                            this.field.setForeground(UIManager.getColor("Table.focusCellForeground"));
                            this.field.setBackground(UIManager.getColor("Table.focusCellBackground"));
                        }
                    } else {
                        this.field.setBorder(new EmptyBorder(1, 2, 2, 1));
                    }
                    this.field.setMargin(new Insets(0, 2, 4, 2));
                    this.field.setText(object == null ? "" : object.toString());
                    return this.field;
                }
                this.area.setFont(jTable.getFont());
                if (bl2) {
                    this.area.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                    if (jTable.isCellEditable(n, n2)) {
                        this.area.setForeground(UIManager.getColor("Table.focusCellForeground"));
                        this.area.setBackground(UIManager.getColor("Table.focusCellBackground"));
                    }
                } else {
                    this.area.setBorder(new EmptyBorder(0, 2, 2, 1));
                }
                this.area.setMargin(new Insets(0, 2, 4, 2));
                this.area.setText(object == null ? "" : object.toString());
                int n3 = (int)this.area.getPreferredSize().getHeight();
                if (n3 != PropertyTable.this.theTable.getRowHeight(n)) {
                    PropertyTable.this.theTable.setRowHeight(n, n3);
                }
                return this.area;
            }
            if (object instanceof MultipleProperty) {
                MultipleProperty multipleProperty = (MultipleProperty)object;
                Component component = multipleProperty.getTableCellRendererComponentMulti(jTable, object, bl, bl2, n, n2);
                if (component != null) {
                    return component;
                }
                if (!multipleProperty.isMultiline()) {
                    this.field.setFont(jTable.getFont());
                    if (bl2) {
                        this.field.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                        if (jTable.isCellEditable(n, n2)) {
                            this.field.setForeground(Color.lightGray);
                            this.field.setBackground(UIManager.getColor("Table.focusCellBackground"));
                        }
                    } else {
                        this.field.setBorder(new EmptyBorder(1, 2, 2, 1));
                    }
                    if (!multipleProperty.allTheSame()) {
                        this.field.setBackground(new Color(240, 240, 240));
                        this.field.setForeground(Color.lightGray);
                    } else {
                        this.field.setForeground(Color.black);
                    }
                    this.field.setMargin(new Insets(0, 2, 4, 2));
                    this.field.setText(object == null ? "" : object.toString());
                    return this.field;
                }
                this.area.setFont(jTable.getFont());
                if (bl2) {
                    this.area.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                    if (jTable.isCellEditable(n, n2)) {
                        this.area.setForeground(Color.lightGray);
                        this.area.setBackground(UIManager.getColor("Table.focusCellBackground"));
                    }
                } else {
                    this.area.setBorder(new EmptyBorder(0, 2, 2, 1));
                }
                if (!multipleProperty.allTheSame()) {
                    this.area.setBackground(new Color(240, 240, 240));
                    this.area.setForeground(Color.lightGray);
                } else {
                    this.area.setForeground(Color.black);
                }
                this.area.setMargin(new Insets(0, 2, 4, 2));
                this.area.setText(object == null ? "" : object.toString());
                return this.area;
            }
            this.field.setFont(jTable.getFont());
            if (bl2) {
                this.field.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (jTable.isCellEditable(n, n2)) {
                    this.field.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.field.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
            } else {
                this.field.setBorder(new EmptyBorder(1, 2, 2, 1));
            }
            this.field.setMargin(new Insets(0, 2, 4, 2));
            this.field.setText(object == null ? "" : object.toString());
            return this.field;
        }
    }

    public class PropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    CaretListener,
    KeyListener,
    ActionListener {
        JTextArea area = new JTextArea();
        JTextField field = new JTextField();
        boolean isMultiLine;
        int currentRow;
        BooleanProperty boolProp = null;
        FontColorProperty fcProp = null;
        ChoiceProperty chProp = null;
        ColourProperty colProp = null;

        public PropertyCellEditor() {
            this.area.setLineWrap(true);
            this.area.setWrapStyleWord(true);
            this.area.setOpaque(true);
            this.field.setOpaque(true);
            this.field.addCaretListener(this);
            this.area.addCaretListener(this);
            this.area.addKeyListener(this);
            this.area.setBackground(Color.white);
            PropertyTable.this.setCurrEditor(this);
        }

        public void stopEditing() {
            super.stopCellEditing();
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            this.area.selectAll();
            this.field.selectAll();
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.boolProp != null) {
                this.boolProp.removeListenerFromEditor(this);
                return this.boolProp.getEditorValue();
            }
            if (this.fcProp != null) {
                this.fcProp.removeListenerFromEditor(this);
                return this.fcProp.getEditorValue();
            }
            if (this.chProp != null) {
                this.chProp.removeListenerFromEditor(this);
                return this.chProp.getEditorValue();
            }
            if (this.colProp != null) {
                this.colProp.removeListenerFromEditor(this);
                return this.colProp.getEditorValue();
            }
            if (this.isMultiLine) {
                return this.area.getText();
            }
            return this.field.getText();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.currentRow = n;
            this.boolProp = null;
            this.fcProp = null;
            this.chProp = null;
            this.colProp = null;
            if (object instanceof BooleanProperty) {
                this.boolProp = (BooleanProperty)object;
                this.boolProp.addListenerToEditor(this);
                return this.boolProp.getTableCellEditorComponent(jTable, object, bl, n, n2);
            }
            if (object instanceof FontColorProperty) {
                this.fcProp = (FontColorProperty)object;
                this.fcProp.addListenerToEditor(this);
                return this.fcProp.getTableCellEditorComponent(jTable, object, bl, n, n2);
            }
            if (object instanceof ChoiceProperty) {
                this.chProp = (ChoiceProperty)object;
                this.chProp.addListenerToEditor(this);
                return this.chProp.getTableCellEditorComponent(jTable, object, bl, n, n2);
            }
            if (object instanceof ColourProperty) {
                this.colProp = (ColourProperty)object;
                this.colProp.addListenerToEditor(this);
                return this.colProp.getTableCellEditorComponent(jTable, object, bl, n, n2);
            }
            if (object instanceof SingleProperty) {
                SingleProperty singleProperty = (SingleProperty)object;
                if (!singleProperty.isMultiline()) {
                    if (!singleProperty.isEnabled()) {
                        this.field.setEnabled(false);
                        this.area.setEnabled(false);
                        this.field.setEditable(false);
                        this.area.setEditable(false);
                        this.field.setCaretColor(Color.white);
                        this.area.setCaretColor(Color.white);
                    } else {
                        this.field.setEnabled(true);
                        this.area.setEnabled(true);
                        this.field.setEditable(true);
                        this.area.setEditable(true);
                        this.field.setCaretColor(Color.black);
                        this.field.setCaretColor(Color.black);
                    }
                    this.field.setFont(jTable.getFont());
                    this.field.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                    this.field.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.field.setBackground(UIManager.getColor("Table.focusCellBackground"));
                    this.field.setMargin(new Insets(0, 2, 4, 2));
                    this.field.setText(object == null ? "" : object.toString());
                    this.isMultiLine = false;
                    return this.field;
                }
                if (!singleProperty.isEnabled()) {
                    this.field.setEnabled(false);
                    this.area.setEnabled(false);
                    this.field.setEditable(false);
                    this.area.setEditable(false);
                    this.field.setCaretColor(Color.white);
                    this.area.setCaretColor(Color.white);
                } else {
                    this.field.setEnabled(true);
                    this.area.setEnabled(true);
                    this.field.setEditable(true);
                    this.area.setEditable(true);
                    this.field.setCaretColor(Color.black);
                    this.area.setCaretColor(Color.black);
                }
                this.area.setFont(jTable.getFont());
                this.area.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                this.area.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.area.setBackground(UIManager.getColor("Table.focusCellBackground"));
                this.area.setMargin(new Insets(0, 2, 4, 2));
                this.area.setText(object == null ? "" : object.toString());
                PropertyTable.this.theTable.setEditingRow(n);
                this.isMultiLine = true;
                return this.area;
            }
            if (object instanceof MultipleProperty) {
                MultipleProperty multipleProperty = (MultipleProperty)object;
                if (multipleProperty.getProperty(0) instanceof BooleanProperty) {
                    this.boolProp = (BooleanProperty)multipleProperty.getProperty(0);
                    this.boolProp.addListenerToEditor(this);
                    return this.boolProp.getTableCellEditorComponentMulti(jTable, object, bl, n, n2, multipleProperty.allTheSame());
                }
                if (multipleProperty.getProperty(0) instanceof FontColorProperty) {
                    this.fcProp = (FontColorProperty)multipleProperty.getProperty(0);
                    this.fcProp.addListenerToEditor(this);
                    return this.fcProp.getTableCellEditorComponentMulti(jTable, object, bl, n, n2, multipleProperty.allTheSame());
                }
                if (multipleProperty.getProperty(0) instanceof ChoiceProperty) {
                    this.chProp = (ChoiceProperty)multipleProperty.getProperty(0);
                    this.chProp.addListenerToEditor(this);
                    return this.chProp.getTableCellEditorComponentMulti(jTable, object, bl, n, n2, multipleProperty.allTheSame());
                }
                if (multipleProperty.getProperty(0) instanceof ColourProperty) {
                    this.colProp = (ColourProperty)multipleProperty.getProperty(0);
                    this.colProp.addListenerToEditor(this);
                    return this.colProp.getTableCellEditorComponentMulti(jTable, object, bl, n, n2, multipleProperty.allTheSame());
                }
                if (!multipleProperty.isMultiline()) {
                    this.field.setFont(jTable.getFont());
                    this.field.setForeground(Color.lightGray);
                    this.field.setBackground(UIManager.getColor("Table.focusCellBackground"));
                    this.field.setForeground(Color.lightGray);
                    if (!multipleProperty.allTheSame()) {
                        this.field.setBackground(new Color(240, 240, 240));
                    }
                    this.field.setMargin(new Insets(0, 2, 4, 2));
                    this.field.setText(object == null ? "" : object.toString());
                    this.isMultiLine = false;
                    return this.field;
                }
                this.area.setFont(jTable.getFont());
                this.area.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                this.area.setForeground(Color.lightGray);
                this.area.setBackground(UIManager.getColor("Table.focusCellBackground"));
                this.area.setForeground(Color.lightGray);
                if (!multipleProperty.allTheSame()) {
                    this.area.setBackground(new Color(240, 240, 240));
                }
                this.area.setMargin(new Insets(0, 2, 4, 2));
                this.area.setText(object == null ? "" : object.toString());
                this.isMultiLine = true;
                return this.area;
            }
            return new JLabel("ERROR");
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            if (caretEvent.getSource() == this.field) {
                this.field.getCaret().setVisible(true);
            }
            if (caretEvent.getSource() == this.area) {
                this.area.getCaret().setVisible(true);
                int n = (int)this.area.getPreferredSize().getHeight();
                if (n != PropertyTable.this.theTable.getRowHeight(this.currentRow)) {
                    PropertyTable.this.theTable.setRowHeight(this.currentRow, n);
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getSource() == this.area) {
                try {
                    int n = this.area.getLineStartOffset(this.area.getLineCount() - 1);
                    int n2 = this.area.getLineEndOffset(0);
                    int n3 = this.area.getCaretPosition();
                    if (keyEvent.getKeyCode() == 38) {
                        if (n3 < n2) {
                            this.stopCellEditing();
                            int n4 = this.currentRow - 1;
                            if (n4 < 0) {
                                n4 = PropertyTable.this.theTable.getRowCount() - 1;
                            }
                            PropertyTable.this.theTable.getSelectionModel().setSelectionInterval(n4, n4);
                        } else if (this.area.getText().length() == 0) {
                            this.stopCellEditing();
                            int n5 = this.currentRow - 1;
                            if (n5 < 0) {
                                n5 = PropertyTable.this.theTable.getRowCount() - 1;
                            }
                            PropertyTable.this.theTable.getSelectionModel().setSelectionInterval(n5, n5);
                        }
                    } else if (keyEvent.getKeyCode() == 40) {
                        if (n3 > n) {
                            this.stopCellEditing();
                            int n6 = (this.currentRow + 1) % PropertyTable.this.theTable.getRowCount();
                            PropertyTable.this.theTable.getSelectionModel().setSelectionInterval(n6, n6);
                        } else if (this.area.getText().length() == 0) {
                            this.stopCellEditing();
                            int n7 = (this.currentRow + 1) % PropertyTable.this.theTable.getRowCount();
                            PropertyTable.this.theTable.getSelectionModel().setSelectionInterval(n7, n7);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.stopCellEditing();
        }
    }
}

