/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import userinterface.GUIPlugin;
import userinterface.model.GUIModelEditor;
import userinterface.model.GUIMultiModelHandler;
import userinterface.model.pepaModel.GUIPepaModelEditor;
import userinterface.util.GUIComputationEvent;

public class SavePEPAModelThread
extends Thread {
    private GUIModelEditor editor;
    private GUIMultiModelHandler handler;
    private File f;
    private GUIPlugin plug;
    private Exception ex;

    public SavePEPAModelThread(File file, GUIMultiModelHandler gUIMultiModelHandler, GUIModelEditor gUIModelEditor) {
        this.editor = gUIModelEditor;
        this.handler = gUIMultiModelHandler;
        this.f = file;
        this.plug = gUIMultiModelHandler.getGUIPlugin();
        this.ex = null;
    }

    @Override
    public void run() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        SavePEPAModelThread.this.plug.startProgress();
                        SavePEPAModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, SavePEPAModelThread.this.plug));
                        SavePEPAModelThread.this.plug.setTaskBarText("Saving model...");
                        ((GUIPepaModelEditor)SavePEPAModelThread.this.editor).write(new FileWriter(SavePEPAModelThread.this.f));
                    }
                    catch (IOException iOException) {
                        SavePEPAModelThread.this.ex = iOException;
                    }
                    catch (ClassCastException classCastException) {
                        SavePEPAModelThread.this.ex = classCastException;
                    }
                }
            });
            if (this.ex != null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        SavePEPAModelThread.this.plug.stopProgress();
                        SavePEPAModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, SavePEPAModelThread.this.plug));
                        SavePEPAModelThread.this.plug.setTaskBarText("Saving model... error.");
                        SavePEPAModelThread.this.plug.error("Could not save to file \"" + String.valueOf(SavePEPAModelThread.this.f) + "\"");
                    }
                });
                return;
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SavePEPAModelThread.this.plug.stopProgress();
                    SavePEPAModelThread.this.plug.setTaskBarText("Saving model... done.");
                    SavePEPAModelThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, SavePEPAModelThread.this.plug));
                    SavePEPAModelThread.this.handler.pepaFileWasSaved(SavePEPAModelThread.this.f);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

