/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import io.ModelExportTask;
import javax.swing.SwingUtilities;
import userinterface.GUIComputationThread;
import userinterface.model.GUIMultiModelHandler;
import userinterface.util.GUIComputationEvent;

public class ComputeSteadyStateThread
extends GUIComputationThread {
    private GUIMultiModelHandler handler;
    private ModelExportTask exportTask;

    public ComputeSteadyStateThread(GUIMultiModelHandler gUIMultiModelHandler, ModelExportTask modelExportTask) {
        super(gUIMultiModelHandler.getGUIPlugin());
        this.handler = gUIMultiModelHandler;
        this.exportTask = modelExportTask;
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComputeSteadyStateThread.this.plug.startProgress();
                ComputeSteadyStateThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, ComputeSteadyStateThread.this.plug));
                ComputeSteadyStateThread.this.plug.setTaskBarText("Computing steady-state probabilities...");
            }
        });
        try {
            this.prism.exportSteadyStateProbabilities(this.exportTask.getFile(), this.exportTask.getExportOptions(), null);
        }
        catch (Throwable throwable) {
            this.error(throwable);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComputeSteadyStateThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, ComputeSteadyStateThread.this.plug));
                    ComputeSteadyStateThread.this.plug.setTaskBarText("Computing steady-state probabilities... error.");
                    ComputeSteadyStateThread.this.plug.stopProgress();
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComputeSteadyStateThread.this.plug.setTaskBarText("Computing steady-state probabilities... done.");
                ComputeSteadyStateThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, ComputeSteadyStateThread.this.plug));
                ComputeSteadyStateThread.this.plug.stopProgress();
            }
        });
    }
}

