/*
 * Decompiled with CFR 0.152.
 */
package symbolic.model;

import io.ModelExportOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.SanityJDD;
import mtbdd.PrismMTBDD;
import parser.VarList;
import parser.ast.Declaration;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.PrismLog;
import sparse.PrismSparse;
import symbolic.model.ModelSymbolic;
import symbolic.model.ModelVariablesDD;
import symbolic.model.ProbModelTransformationOperator;

public class ProbModel
extends ModelSymbolic {
    protected JDDNode[] transPerAction;

    public ProbModel(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, ModelVariablesDD modelVariablesDD, VarList varList, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2) {
        super(jDDNode, jDDNode2, jDDVars, jDDVars2, modelVariablesDD, varList, jDDVarsArray, jDDVarsArray2);
    }

    public void setTransPerAction(JDDNode[] jDDNodeArray) {
        this.transPerAction = jDDNodeArray;
    }

    @Override
    public void filterReachableStates() {
        super.filterReachableStates();
        if (this.transPerAction != null) {
            for (int i = 0; i < this.numSynchs + 1; ++i) {
                JDD.Ref(this.reach);
                this.transPerAction[i] = JDD.Apply(3, this.reach, this.transPerAction[i]);
                JDD.Ref(this.reach);
                JDDNode jDDNode = JDD.PermuteVariables(this.reach, this.allDDRowVars, this.allDDColVars);
                this.transPerAction[i] = JDD.Apply(3, jDDNode, this.transPerAction[i]);
            }
        }
    }

    @Override
    public void findDeadlocks(boolean bl) {
        JDD.Ref(this.trans01);
        this.deadlocks = JDD.ThereExists(this.trans01, this.allDDColVars);
        JDD.Ref(this.reach);
        this.deadlocks = JDD.And(this.reach, JDD.Not(this.deadlocks));
        if (bl && !this.deadlocks.equals(JDD.ZERO)) {
            JDD.Ref(this.deadlocks);
            JDDNode jDDNode = JDD.And(this.deadlocks, JDD.Identity(this.allDDRowVars, this.allDDColVars));
            JDD.Ref(jDDNode);
            this.trans = JDD.Apply(1, this.trans, jDDNode);
            JDD.Ref(jDDNode);
            this.trans01 = JDD.Apply(1, this.trans01, jDDNode);
            if (this.transPerAction != null) {
                JDD.Ref(jDDNode);
                this.transPerAction[0] = JDD.Apply(1, this.transPerAction[0], jDDNode);
            }
            JDD.Deref(jDDNode);
            this.numTransitions = JDD.GetNumMinterms(this.trans01, this.getNumDDVarsInTrans());
        }
    }

    @Override
    public ModelType getModelType() {
        return ModelType.DTMC;
    }

    @Override
    public void printTransInfo(PrismLog prismLog, boolean bl) {
        super.printTransInfo(prismLog, bl);
        if (bl && this.transPerAction != null) {
            for (int i = 0; i < this.numSynchs + 1; ++i) {
                prismLog.print("Transition action info: ");
                prismLog.print((i == 0 ? "" : (String)this.synchs.get(i - 1)) + "): ");
                prismLog.println(JDD.GetInfoString(this.transPerAction[i], this.getNumDDVarsInTrans()));
            }
        }
    }

    @Override
    public void exportToFile(int n, boolean bl, File file, int n2) throws FileNotFoundException, PrismException {
        if (!bl) {
            PrismMTBDD.ExportMatrix(this.trans, this.getTransSymbol(), this.allDDRowVars, this.allDDColVars, this.odd, n, file != null ? file.getPath() : null, n2, null, true);
        } else {
            PrismSparse.ExportMatrix(this.trans, this.getTransSymbol(), this.allDDRowVars, this.allDDColVars, this.odd, n, file != null ? file.getPath() : null, n2, null, true);
        }
    }

    @Override
    public void exportToFile(File file, ModelExportOptions modelExportOptions) throws FileNotFoundException, PrismException {
        int n = Prism.convertExportTypeTrans(modelExportOptions);
        int n2 = modelExportOptions.getModelPrecision();
        if (modelExportOptions.getShowActions() && this.transPerAction != null) {
            PrismSparse.ExportMC(this.transPerAction, this.getSynchs(), this.getTransSymbol(), this.allDDRowVars, this.allDDColVars, this.odd, n, file != null ? file.getPath() : null, n2);
        } else {
            PrismSparse.ExportMatrix(this.trans, this.getTransSymbol(), this.allDDRowVars, this.allDDColVars, this.odd, n, file != null ? file.getPath() : null, n2, null, true);
        }
    }

    @Override
    public void exportTransRewardsToFile(int n, int n2, boolean bl, File file, int n3, boolean bl2) throws FileNotFoundException, PrismException {
        if (!bl) {
            PrismMTBDD.ExportMatrix(this.transRewards[n], "C" + (n + 1), this.allDDRowVars, this.allDDColVars, this.odd, n2, file == null ? null : file.getPath(), n3, this.rewardStructNames[n], bl2);
        } else {
            PrismSparse.ExportMatrix(this.transRewards[n], "C" + (n + 1), this.allDDRowVars, this.allDDColVars, this.odd, n2, file == null ? null : file.getPath(), n3, this.rewardStructNames[n], bl2);
        }
    }

    @Override
    public void exportTransRewardsToFile(int n, File file, ModelExportOptions modelExportOptions) throws FileNotFoundException, PrismException {
        int n2 = Prism.convertExportTypeTrans(modelExportOptions);
        int n3 = modelExportOptions.getModelPrecision();
        boolean bl = !modelExportOptions.getPrintHeaders();
        PrismSparse.ExportMatrix(this.transRewards[n], "C" + (n + 1), this.allDDRowVars, this.allDDColVars, this.odd, n2, file == null ? null : file.getPath(), n3, this.rewardStructNames[n], bl);
    }

    @Override
    public String getTransName() {
        return "Transition matrix";
    }

    @Override
    public String getTransSymbol() {
        return "P";
    }

    @Override
    public void clear() {
        super.clear();
        if (this.transPerAction != null) {
            for (int i = 0; i < this.numSynchs + 1; ++i) {
                JDD.Deref(this.transPerAction[i]);
            }
        }
    }

    public JDDNode[] getTransPerAction() {
        return this.transPerAction;
    }

    public ProbModel getTransformed(ProbModelTransformationOperator probModelTransformationOperator) throws PrismException {
        Object object;
        VarList varList;
        JDDVars jDDVars;
        JDDVars jDDVars2;
        JDDVars[] jDDVarsArray;
        JDDVars[] jDDVarsArray2;
        int n;
        Object object2 = probModelTransformationOperator.getExtraStateVariableName();
        while (this.varList.exists((String)object2)) {
            object2 = "_" + (String)object2;
        }
        ModelVariablesDD modelVariablesDD = this.getModelVariables().copy();
        int n2 = probModelTransformationOperator.getExtraStateVariableCount();
        boolean bl = modelVariablesDD.canPrependExtraStateVariable(n2);
        JDDVars jDDVars3 = new JDDVars();
        JDDVars jDDVars4 = new JDDVars();
        JDDVars jDDVars5 = modelVariablesDD.allocateExtraStateVariable(n2, (String)object2, bl);
        for (n = 0; n < n2; ++n) {
            jDDVars3.addVar(jDDVars5.getVar(2 * n));
            jDDVars4.addVar(jDDVars5.getVar(2 * n + 1));
        }
        probModelTransformationOperator.hookExtraStateVariableAllocation(jDDVars3.copy(), jDDVars4.copy());
        if (n2 == 0) {
            jDDVarsArray2 = JDDVars.copyArray(this.varDDRowVars);
            jDDVarsArray = JDDVars.copyArray(this.varDDColVars);
            jDDVars2 = this.allDDRowVars.copy();
            jDDVars = this.allDDColVars.copy();
            varList = (VarList)this.varList.clone();
        } else {
            jDDVarsArray2 = new JDDVars[this.varDDRowVars.length + 1];
            jDDVarsArray = new JDDVars[this.varDDRowVars.length + 1];
            jDDVarsArray2[bl ? 0 : this.varDDRowVars.length] = jDDVars3.copy();
            jDDVarsArray[bl ? 0 : this.varDDColVars.length] = jDDVars4.copy();
            for (n = 0; n < this.varDDRowVars.length; ++n) {
                jDDVarsArray2[bl ? n + 1 : n] = this.varDDRowVars[n].copy();
                jDDVarsArray[bl ? n + 1 : n] = this.varDDColVars[n].copy();
            }
            if (bl) {
                jDDVars2 = jDDVars3.copy();
                jDDVars = jDDVars4.copy();
                jDDVars2.copyVarsFrom(this.allDDRowVars);
                jDDVars.copyVarsFrom(this.allDDColVars);
            } else {
                jDDVars2 = this.allDDRowVars.copy();
                jDDVars = this.allDDColVars.copy();
                jDDVars2.copyVarsFrom(jDDVars3);
                jDDVars.copyVarsFrom(jDDVars4);
            }
            varList = (VarList)this.varList.clone();
            object = new Declaration((String)object2, new DeclarationInt(Expression.Int(0), Expression.Int((1 << n2) - 1)));
            if (bl) {
                varList.addVarAtStart((Declaration)object, 1);
            } else {
                varList.addVar((Declaration)object, 1);
            }
        }
        JDDNode jDDNode = probModelTransformationOperator.getTransformedTrans();
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars2, jDDVars);
        }
        JDDNode jDDNode2 = probModelTransformationOperator.getTransformedStart();
        if (SanityJDD.enabled) {
            SanityJDD.checkIsStateSet(jDDNode2, jDDVars2);
        }
        JDDNode[] jDDNodeArray = new JDDNode[this.stateRewards.length];
        for (n = 0; n < this.stateRewards.length; ++n) {
            jDDNodeArray[n] = probModelTransformationOperator.getTransformedStateReward(this.stateRewards[n]);
            if (!SanityJDD.enabled) continue;
            SanityJDD.checkIsDDOverVars(jDDNodeArray[n], jDDVars2);
        }
        JDDNode[] jDDNodeArray2 = new JDDNode[this.transRewards.length];
        for (n = 0; n < this.transRewards.length; ++n) {
            jDDNodeArray2[n] = probModelTransformationOperator.getTransformedTransReward(this.transRewards[n]);
            if (!SanityJDD.enabled) continue;
            SanityJDD.checkIsDDOverVars(jDDNodeArray2[n], jDDVars2, jDDVars);
        }
        object = new ProbModel(jDDNode, jDDNode2, jDDVars2, jDDVars, modelVariablesDD, varList, jDDVarsArray2, jDDVarsArray);
        ((ModelSymbolic)object).setRewards(jDDNodeArray, jDDNodeArray2, (String[])this.rewardStructNames.clone());
        ((ModelSymbolic)object).setConstantValues(this.getConstantValues());
        JDDNode jDDNode3 = probModelTransformationOperator.getReachableStates();
        if (jDDNode3 != null) {
            ((ModelSymbolic)object).setReach(jDDNode3);
        } else {
            jDDNode3 = probModelTransformationOperator.getReachableStateSeed();
            if (jDDNode3 != null) {
                ((ModelSymbolic)object).doReachability(jDDNode3);
            } else {
                ((ModelSymbolic)object).doReachability();
            }
        }
        ((ProbModel)object).filterReachableStates();
        if (!probModelTransformationOperator.deadlocksAreFine()) {
            ((ProbModel)object).findDeadlocks(false);
            if (object.getDeadlockStates().size() > 0) {
                throw new PrismException("Transformed model has deadlock states");
            }
        }
        for (Map.Entry entry : this.labelsDD.entrySet()) {
            JDDNode jDDNode4 = (JDDNode)entry.getValue();
            JDDNode jDDNode5 = probModelTransformationOperator.getTransformedLabelStates(jDDNode4, ((ModelSymbolic)object).getReach());
            ((ProbModel)object).labelsDD.put((String)entry.getKey(), jDDNode5);
        }
        jDDVars3.derefAll();
        jDDVars4.derefAll();
        return object;
    }
}

