/*
 * Decompiled with CFR 0.152.
 */
package symbolic.model;

import io.ModelExportOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Map;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.SanityJDD;
import mtbdd.PrismMTBDD;
import parser.VarList;
import parser.ast.Declaration;
import parser.ast.DeclarationInt;
import parser.ast.Expression;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;
import sparse.PrismSparse;
import symbolic.model.ModelSymbolic;
import symbolic.model.ModelVariablesDD;
import symbolic.model.NondetModelTransformationOperator;
import symbolic.model.ProbModelTransformationOperator;

public class NondetModel
extends ModelSymbolic {
    protected JDDNode nondetMask;
    protected JDDVars allDDNondetVars;
    protected JDDNode transInd;
    protected JDDNode[] transSynch;
    protected JDDNode transReln;
    protected JDDNode transActions;
    protected double numChoices;

    public NondetModel(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, JDDVars jDDVars3, ModelVariablesDD modelVariablesDD, VarList varList, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2) {
        super(jDDNode, jDDNode2, jDDVars, jDDVars2, modelVariablesDD, varList, jDDVarsArray, jDDVarsArray2);
        this.allDDNondetVars = jDDVars3;
    }

    public void setTransActions(JDDNode jDDNode) {
        this.transActions = jDDNode;
    }

    public void setTransInd(JDDNode jDDNode) {
        this.transInd = jDDNode;
    }

    public void setTransSynch(JDDNode[] jDDNodeArray) {
        this.transSynch = jDDNodeArray;
    }

    @Override
    public void doReachability() throws PrismException {
        JDD.Ref(this.trans01);
        JDDNode jDDNode = JDD.MaxAbstract(this.trans01, this.allDDNondetVars);
        JDDNode jDDNode2 = PrismMTBDD.Reachability(jDDNode, this.allDDRowVars, this.allDDColVars, this.start);
        JDD.Deref(jDDNode);
        this.setReach(jDDNode2);
    }

    @Override
    public void doReachability(JDDNode jDDNode) throws PrismException {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsStateSet(jDDNode, this.getAllDDRowVars());
        }
        JDD.Ref(this.trans01);
        JDDNode jDDNode2 = JDD.MaxAbstract(this.trans01, this.allDDNondetVars);
        JDDNode jDDNode3 = JDD.Or(this.start.copy(), jDDNode);
        JDDNode jDDNode4 = PrismMTBDD.Reachability(jDDNode2, this.allDDRowVars, this.allDDColVars, jDDNode3);
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode3);
        this.setReach(jDDNode4);
    }

    @Override
    public void filterReachableStates() {
        super.filterReachableStates();
        if (this.transInd != null) {
            JDD.Ref(this.reach);
            this.transInd = JDD.Apply(3, this.reach, this.transInd);
            for (int i = 0; i < this.numSynchs; ++i) {
                JDD.Ref(this.reach);
                this.transSynch[i] = JDD.Apply(3, this.reach, this.transSynch[i]);
            }
        }
        if (this.transReln != null) {
            JDD.Ref(this.reach);
            this.transReln = JDD.Apply(3, this.reach, this.transReln);
        }
        JDD.Ref(this.trans01);
        JDD.Ref(this.reach);
        if (this.nondetMask != null) {
            JDD.Deref(this.nondetMask);
        }
        this.nondetMask = JDD.And(JDD.ThereExists(this.trans01, this.allDDColVars), this.reach);
        this.numChoices = JDD.GetNumMinterms(this.nondetMask, this.getNumDDRowVars() + this.getNumDDNondetVars());
        JDD.Ref(this.reach);
        this.nondetMask = JDD.And(JDD.Not(this.nondetMask), this.reach);
        if (this.transActions != null) {
            JDD.Ref(this.reach);
            this.transActions = JDD.Apply(3, this.reach, this.transActions);
        }
    }

    @Override
    public void findDeadlocks(boolean bl) {
        JDD.Ref(this.trans01);
        this.deadlocks = JDD.ThereExists(this.trans01, this.allDDColVars);
        this.deadlocks = JDD.ThereExists(this.deadlocks, this.allDDNondetVars);
        JDD.Ref(this.reach);
        this.deadlocks = JDD.And(this.reach, JDD.Not(this.deadlocks));
        if (bl && !this.deadlocks.equals(JDD.ZERO)) {
            JDD.Ref(this.deadlocks);
            JDDNode jDDNode = JDD.SetVectorElement(JDD.Constant(0.0), this.allDDNondetVars, 0L, 1.0);
            jDDNode = JDD.And(jDDNode, JDD.Identity(this.allDDRowVars, this.allDDColVars));
            jDDNode = JDD.And(this.deadlocks, jDDNode);
            JDD.Ref(jDDNode);
            this.trans = JDD.Apply(1, this.trans, jDDNode);
            JDD.Ref(jDDNode);
            this.trans01 = JDD.Apply(1, this.trans01, jDDNode);
            if (this.transInd != null) {
                JDD.Ref(jDDNode);
                this.transInd = JDD.Or(this.transInd, JDD.ThereExists(jDDNode, this.allDDColVars));
            }
            JDD.Deref(jDDNode);
            if (this.transReln != null) {
                JDD.Deref(this.transReln);
                JDD.Ref(this.trans01);
                this.transReln = JDD.ThereExists(this.trans01, this.allDDNondetVars);
            }
            this.numTransitions = JDD.GetNumMinterms(this.trans01, this.getNumDDVarsInTrans());
            JDD.Ref(this.trans01);
            JDD.Ref(this.reach);
            if (this.nondetMask != null) {
                JDD.Deref(this.nondetMask);
            }
            this.nondetMask = JDD.And(JDD.ThereExists(this.trans01, this.allDDColVars), this.reach);
            this.numChoices = JDD.GetNumMinterms(this.nondetMask, this.getNumDDRowVars() + this.getNumDDNondetVars());
            JDD.Ref(this.reach);
            this.nondetMask = JDD.And(JDD.Not(this.nondetMask), this.reach);
        }
    }

    @Override
    public ModelType getModelType() {
        return ModelType.MDP;
    }

    @Override
    public JDDNode getTransReln() {
        if (this.transReln == null) {
            JDD.Ref(this.trans01);
            this.transReln = JDD.ThereExists(this.trans01, this.allDDNondetVars);
        }
        return this.transReln;
    }

    @Override
    public int getNumDDVarsInTrans() {
        return this.allDDRowVars.n() * 2 + this.allDDNondetVars.n();
    }

    @Override
    public void printTransInfo(PrismLog prismLog, boolean bl) {
        super.printTransInfo(prismLog, bl);
        if (bl && this.transActions != null) {
            prismLog.print("Choice action info: ");
            prismLog.println(JDD.GetInfoString(this.transActions, this.allDDRowVars.n() + this.allDDNondetVars.n()));
        }
    }

    @Override
    public String getTransDDVarSummary() {
        return super.getTransDDVarSummary() + "/" + this.getNumDDNondetVars() + "nd";
    }

    @Override
    public String getTransDDVarInfo() {
        Object object = "DD vars (nd):";
        int n = this.allDDNondetVars.getNumVars();
        for (int i = 0; i < n; ++i) {
            int n2 = this.allDDNondetVars.getVarIndex(i);
            object = (String)object + " " + n2 + ":" + this.getDDVarNames().get(n2);
        }
        object = (String)object + "\n" + super.getTransDDVarInfo();
        return object;
    }

    @Override
    public void exportToFile(int n, boolean bl, File file, int n2) throws FileNotFoundException, PrismException {
        if (bl) {
            PrismSparse.ExportMDP(this.trans, this.transActions, this.getSynchs(), this.getTransSymbol(), this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.odd, n, file != null ? file.getPath() : null, n2);
        }
    }

    @Override
    public void exportToFile(File file, ModelExportOptions modelExportOptions) throws FileNotFoundException, PrismException {
        int n = Prism.convertExportTypeTrans(modelExportOptions);
        int n2 = modelExportOptions.getModelPrecision();
        JDDNode jDDNode = modelExportOptions.getShowActions() ? this.transActions : null;
        PrismSparse.ExportMDP(this.trans, jDDNode, this.getSynchs(), this.getTransSymbol(), this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.odd, n, file != null ? file.getPath() : null, n2);
    }

    @Override
    public void exportTransRewardsToFile(int n, int n2, boolean bl, File file, int n3, boolean bl2) throws FileNotFoundException, PrismException {
        if (bl) {
            PrismSparse.ExportSubMDP(this.trans, this.transRewards[n], "C" + (n + 1), this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.odd, n2, file == null ? null : file.getPath(), n3, this.rewardStructNames[n], bl2);
        }
    }

    @Override
    public void exportTransRewardsToFile(int n, File file, ModelExportOptions modelExportOptions) throws FileNotFoundException, PrismException {
        int n2 = Prism.convertExportTypeTrans(modelExportOptions);
        int n3 = modelExportOptions.getModelPrecision();
        boolean bl = !modelExportOptions.getPrintHeaders();
        PrismSparse.ExportSubMDP(this.trans, this.transRewards[n], "C" + (n + 1), this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.odd, n2, file == null ? null : file.getPath(), n3, this.rewardStructNames[n], bl);
    }

    @Override
    public String getTransName() {
        return "Transition matrix";
    }

    @Override
    public String getTransSymbol() {
        return "S";
    }

    @Override
    public void clear() {
        super.clear();
        this.allDDNondetVars.derefAll();
        JDD.Deref(this.nondetMask);
        if (this.transInd != null) {
            JDD.Deref(this.transInd);
        }
        if (this.transSynch != null) {
            for (int i = 0; i < this.numSynchs; ++i) {
                JDD.Deref(this.transSynch[i]);
            }
        }
        if (this.transReln != null) {
            JDD.Deref(this.transReln);
        }
        if (this.transActions != null) {
            JDD.Deref(this.transActions);
        }
    }

    public long getNumChoices() {
        return this.numChoices > 9.223372036854776E18 ? -1L : Math.round(this.numChoices);
    }

    public String getNumChoicesString() {
        return PrismUtils.bigIntToString(this.numChoices);
    }

    public JDDNode getNondetMask() {
        return this.nondetMask;
    }

    public JDDVars getAllDDNondetVars() {
        return this.allDDNondetVars;
    }

    public int getNumDDNondetVars() {
        return this.allDDNondetVars.n();
    }

    public JDDNode getTransInd() {
        return this.transInd;
    }

    public JDDNode[] getTransSynch() {
        return this.transSynch;
    }

    public JDDNode getTransActions() {
        return this.transActions;
    }

    public boolean areAllChoiceActionsUnique() {
        for (int i = 0; i < this.numSynchs; ++i) {
            JDD.Ref(this.transActions);
            JDDNode jDDNode = JDD.Equals(this.transActions, i + 1);
            jDDNode = JDD.SumAbstract(jDDNode, this.allDDNondetVars);
            double d = JDD.FindMax(jDDNode);
            JDD.Deref(jDDNode);
            if (!(d > 1.0)) continue;
            return false;
        }
        JDD.Ref(this.reach);
        JDD.Ref(this.transActions);
        JDD.Ref(this.nondetMask);
        JDDNode jDDNode = JDD.And(this.reach, JDD.And(JDD.LessThanEquals(this.transActions, 0.0), JDD.Not(this.nondetMask)));
        jDDNode = JDD.SumAbstract(jDDNode, this.allDDNondetVars);
        double d = JDD.FindMax(jDDNode);
        JDD.Deref(jDDNode);
        return !(d > 1.0);
    }

    public NondetModel getTransformed(NondetModelTransformationOperator nondetModelTransformationOperator) throws PrismException {
        Object object;
        VarList varList;
        JDDVars jDDVars;
        JDDVars jDDVars2;
        JDDVars[] jDDVarsArray;
        JDDVars[] jDDVarsArray2;
        int n;
        Object object2 = nondetModelTransformationOperator.getExtraStateVariableName();
        while (this.varList.exists((String)object2)) {
            object2 = "_" + (String)object2;
        }
        Object object3 = nondetModelTransformationOperator.getExtraActionVariableName();
        while (this.varList.exists((String)object3)) {
            object3 = "_" + (String)object3;
        }
        ModelVariablesDD modelVariablesDD = this.getModelVariables().copy();
        int n2 = nondetModelTransformationOperator.getExtraStateVariableCount();
        boolean bl = modelVariablesDD.canPrependExtraStateVariable(n2);
        JDDVars jDDVars3 = new JDDVars();
        JDDVars jDDVars4 = new JDDVars();
        JDDVars jDDVars5 = modelVariablesDD.allocateExtraStateVariable(n2, (String)object2, bl);
        for (n = 0; n < n2; ++n) {
            jDDVars3.addVar(jDDVars5.getVar(2 * n));
            jDDVars4.addVar(jDDVars5.getVar(2 * n + 1));
        }
        nondetModelTransformationOperator.hookExtraStateVariableAllocation(jDDVars3.copy(), jDDVars4.copy());
        int n3 = nondetModelTransformationOperator.getExtraActionVariableCount();
        JDDVars jDDVars6 = modelVariablesDD.allocateExtraActionVariable(n3, (String)object3);
        nondetModelTransformationOperator.hookExtraActionVariableAllocation(jDDVars6.copy());
        JDDVars jDDVars7 = new JDDVars();
        jDDVars7.copyVarsFrom(jDDVars6);
        jDDVars7.copyVarsFrom(this.allDDNondetVars);
        if (n2 == 0) {
            jDDVarsArray2 = JDDVars.copyArray(this.varDDRowVars);
            jDDVarsArray = JDDVars.copyArray(this.varDDColVars);
            jDDVars2 = this.allDDRowVars.copy();
            jDDVars = this.allDDColVars.copy();
            varList = (VarList)this.varList.clone();
        } else {
            jDDVarsArray2 = new JDDVars[this.varDDRowVars.length + 1];
            jDDVarsArray = new JDDVars[this.varDDRowVars.length + 1];
            jDDVarsArray2[bl ? 0 : this.varDDRowVars.length] = jDDVars3.copy();
            jDDVarsArray[bl ? 0 : this.varDDColVars.length] = jDDVars4.copy();
            for (n = 0; n < this.varDDRowVars.length; ++n) {
                jDDVarsArray2[bl ? n + 1 : n] = this.varDDRowVars[n].copy();
                jDDVarsArray[bl ? n + 1 : n] = this.varDDColVars[n].copy();
            }
            if (bl) {
                jDDVars2 = jDDVars3.copy();
                jDDVars = jDDVars4.copy();
                jDDVars2.copyVarsFrom(this.allDDRowVars);
                jDDVars.copyVarsFrom(this.allDDColVars);
            } else {
                jDDVars2 = this.allDDRowVars.copy();
                jDDVars = this.allDDColVars.copy();
                jDDVars2.copyVarsFrom(jDDVars3);
                jDDVars.copyVarsFrom(jDDVars4);
            }
            varList = (VarList)this.varList.clone();
            object = new Declaration((String)object2, new DeclarationInt(Expression.Int(0), Expression.Int((1 << n2) - 1)));
            if (bl) {
                varList.addVarAtStart((Declaration)object, 1);
            } else {
                varList.addVar((Declaration)object, 1);
            }
        }
        JDDNode jDDNode = nondetModelTransformationOperator.getTransformedTrans();
        if (SanityJDD.enabled) {
            SanityJDD.checkIsDDOverVars(jDDNode, jDDVars2, jDDVars, jDDVars7);
        }
        JDDNode jDDNode2 = nondetModelTransformationOperator.getTransformedStart();
        if (SanityJDD.enabled) {
            SanityJDD.checkIsStateSet(jDDNode2, jDDVars2);
        }
        JDDNode[] jDDNodeArray = new JDDNode[this.stateRewards.length];
        for (n = 0; n < this.stateRewards.length; ++n) {
            jDDNodeArray[n] = nondetModelTransformationOperator.getTransformedStateReward(this.stateRewards[n]);
            if (!SanityJDD.enabled) continue;
            SanityJDD.checkIsDDOverVars(jDDNodeArray[n], jDDVars2);
        }
        JDDNode[] jDDNodeArray2 = new JDDNode[this.transRewards.length];
        for (n = 0; n < this.transRewards.length; ++n) {
            jDDNodeArray2[n] = nondetModelTransformationOperator.getTransformedTransReward(this.transRewards[n]);
            if (!SanityJDD.enabled) continue;
            SanityJDD.checkIsDDOverVars(jDDNodeArray2[n], jDDVars2, jDDVars, jDDVars7);
        }
        object = new NondetModel(jDDNode, jDDNode2, jDDVars2, jDDVars, jDDVars7, modelVariablesDD, varList, jDDVarsArray2, jDDVarsArray);
        ((ModelSymbolic)object).setRewards(jDDNodeArray, jDDNodeArray2, (String[])this.rewardStructNames.clone());
        ((ModelSymbolic)object).setConstantValues(this.getConstantValues());
        ((NondetModel)object).setTransActions(nondetModelTransformationOperator.getTransformedTransActions());
        ((ModelSymbolic)object).setSynchs(new ArrayList<String>(this.getSynchs()));
        JDDNode jDDNode3 = nondetModelTransformationOperator.getReachableStates();
        if (jDDNode3 != null) {
            ((ModelSymbolic)object).setReach(jDDNode3);
        } else {
            jDDNode3 = nondetModelTransformationOperator.getReachableStateSeed();
            if (jDDNode3 != null) {
                ((NondetModel)object).doReachability(jDDNode3);
            } else {
                ((NondetModel)object).doReachability();
            }
        }
        ((NondetModel)object).filterReachableStates();
        if (!nondetModelTransformationOperator.deadlocksAreFine()) {
            ((NondetModel)object).findDeadlocks(false);
            if (object.getDeadlockStates().size() > 0) {
                throw new PrismException("Transformed model has deadlock states");
            }
        }
        for (Map.Entry entry : this.labelsDD.entrySet()) {
            JDDNode jDDNode4 = (JDDNode)entry.getValue();
            JDDNode jDDNode5 = nondetModelTransformationOperator.getTransformedLabelStates(jDDNode4, ((ModelSymbolic)object).getReach());
            ((NondetModel)object).labelsDD.put((String)entry.getKey(), jDDNode5);
        }
        jDDVars3.derefAll();
        jDDVars4.derefAll();
        jDDVars6.derefAll();
        return object;
    }

    public NondetModel getTransformed(final ProbModelTransformationOperator probModelTransformationOperator) throws PrismException {
        NondetModelTransformationOperator nondetModelTransformationOperator = new NondetModelTransformationOperator(this){

            @Override
            public int getExtraStateVariableCount() {
                return probModelTransformationOperator.getExtraStateVariableCount();
            }

            @Override
            public int getExtraActionVariableCount() {
                return 0;
            }

            @Override
            public JDDNode getTransformedTrans() throws PrismException {
                return probModelTransformationOperator.getTransformedTrans();
            }

            @Override
            public JDDNode getTransformedStart() throws PrismException {
                return probModelTransformationOperator.getTransformedStart();
            }

            @Override
            public String getExtraStateVariableName() {
                return probModelTransformationOperator.getExtraStateVariableName();
            }

            @Override
            public void hookExtraStateVariableAllocation(JDDVars jDDVars, JDDVars jDDVars2) {
                probModelTransformationOperator.hookExtraStateVariableAllocation(jDDVars, jDDVars2);
            }

            @Override
            public void hookExtraActionVariableAllocation(JDDVars jDDVars) {
                if (jDDVars.n() != 0) {
                    throw new RuntimeException("NondetModel.getTransformed(ProbModelTransformation) has not requested action variables");
                }
            }

            @Override
            public JDDNode getTransformedStateReward(JDDNode jDDNode) throws PrismException {
                return probModelTransformationOperator.getTransformedStateReward(jDDNode);
            }

            @Override
            public JDDNode getTransformedTransReward(JDDNode jDDNode) throws PrismException {
                return probModelTransformationOperator.getTransformedTransReward(jDDNode);
            }
        };
        return this.getTransformed(nondetModelTransformationOperator);
    }
}

