/*
 * Decompiled with CFR 0.152.
 */
package simulator.method;

import cern.jet.stat.Probability;
import prism.PrismException;
import simulator.method.CIMethod;
import simulator.method.SimulationMethod;
import simulator.sampler.Sampler;

public final class ACIconfidence
extends CIMethod {
    private double varEstimator;

    public ACIconfidence(double d, int n) {
        this.width = d;
        this.numSamples = n;
        this.varEstimator = 0.0;
    }

    @Override
    public String getName() {
        return "ACI";
    }

    @Override
    public String getFullName() {
        return "Asymptotic Confidence Interval";
    }

    @Override
    public void computeMissingParameterAfterSim() {
        this.confidence = 2.0 * (1.0 - Probability.normal((double)(this.width * Math.sqrt((double)this.numSamples / this.varEstimator))));
        this.missingParameterComputed = true;
    }

    @Override
    public Object getMissingParameter() throws PrismException {
        if (!this.missingParameterComputed) {
            throw new PrismException("Missing parameter not computed yet");
        }
        return this.confidence;
    }

    @Override
    public String getParametersString() {
        if (!this.missingParameterComputed) {
            return "width=" + this.width + ", confidence=unknown, number of samples=" + this.numSamples;
        }
        return "width=" + this.width + ", confidence=" + this.confidence + ", number of samples=" + this.numSamples;
    }

    @Override
    public boolean shouldStopNow(int n, Sampler sampler) {
        if (n >= this.numSamples) {
            this.varEstimator = sampler.getVariance();
            return true;
        }
        return false;
    }

    @Override
    public int getProgress(int n, Sampler sampler) {
        return 10 * n / this.numSamples * 10;
    }

    @Override
    public SimulationMethod clone() {
        ACIconfidence aCIconfidence = new ACIconfidence(this.width, this.numSamples);
        aCIconfidence.confidence = this.confidence;
        aCIconfidence.missingParameterComputed = this.missingParameterComputed;
        aCIconfidence.prOp = this.prOp;
        aCIconfidence.theta = this.theta;
        aCIconfidence.varEstimator = this.varEstimator;
        return aCIconfidence;
    }
}

