/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import simulator.ModulesFileModelGenerator;
import simulator.SimulatorEngine;
import simulator.method.CIwidth;

public class TestSim {
    public static void main(String[] stringArray) {
        new TestSim().run();
    }

    public void run() {
        try {
            PrismFileLog prismFileLog = new PrismFileLog("stdout");
            Prism prism = new Prism(prismFileLog);
            prism.initialise();
            ModulesFile modulesFile = prism.parseModelFile(new File("../prism-examples/simple/dice/dice.pm"));
            PropertiesFile propertiesFile = prism.parsePropertiesFile(modulesFile, new File("../prism-examples/simple/dice/dice.pctl"));
            SimulatorEngine simulatorEngine = new SimulatorEngine(prism);
            ModulesFileModelGenerator<Double> modulesFileModelGenerator = new ModulesFileModelGenerator<Double>(modulesFile, prism);
            simulatorEngine.loadModel(modulesFileModelGenerator, modulesFileModelGenerator);
            CIwidth cIwidth = new CIwidth(0.01, 1000);
            simulatorEngine.modelCheckMultipleProperties(propertiesFile, Collections.singletonList(propertiesFile.getProperty(1)), null, 10000L, cIwidth);
            simulatorEngine.createNewOnTheFlyPath();
            simulatorEngine.initialisePath(null);
            simulatorEngine.automaticTransitions(100, false);
        }
        catch (PrismException prismException) {
            prismException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }
}

