/*
 * Decompiled with CFR 0.152.
 */
package prism;

import explicit.MinMax;
import parser.ast.RelOp;
import prism.Accuracy;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLangException;

public class OpRelOpBound {
    protected String op;
    protected RelOp relOp;
    protected boolean numeric;
    protected double bound;

    public OpRelOpBound(String string, RelOp relOp, Double d) {
        this.op = string;
        this.relOp = relOp;
        boolean bl = this.numeric = d == null;
        if (d != null) {
            this.bound = d;
        }
    }

    public boolean isProbabilistic() {
        return "P".equals(this.op);
    }

    public boolean isReward() {
        return "R".equals(this.op);
    }

    public RelOp getRelOp() {
        return this.relOp;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public double getBound() {
        return this.bound;
    }

    public boolean isQualitative() {
        return !this.isNumeric() && this.op.equals("P") && (this.bound == 0.0 || this.bound == 1.0);
    }

    public boolean isTriviallyTrue() {
        if (!this.isNumeric() && this.op.equals("P")) {
            if (this.bound == 0.0 && this.relOp == RelOp.GEQ) {
                return true;
            }
            if (this.bound == 1.0 && this.relOp == RelOp.LEQ) {
                return true;
            }
        }
        return false;
    }

    public boolean isTriviallyFalse() {
        if (!this.isNumeric() && this.op.equals("P")) {
            if (this.bound == 0.0 && this.relOp == RelOp.LT) {
                return true;
            }
            if (this.bound == 1.0 && this.relOp == RelOp.GT) {
                return true;
            }
        }
        return false;
    }

    public MinMax getMinMax(ModelType modelType) throws PrismLangException {
        return this.getMinMax(modelType, true);
    }

    public MinMax getMinMax(ModelType modelType, boolean bl) throws PrismLangException {
        MinMax minMax = MinMax.blank();
        int n = modelType.nondeterministic() ? 1 : 0;
        if ((n += modelType.uncertain() ? 1 : 0) > 0) {
            if (this.isNumeric()) {
                if (this.relOp == RelOp.EQ) {
                    throw new PrismLangException("Can't use \"" + this.op + "=?\" for nondeterministic models; use e.g. \"" + this.op + "min=?\" or \"" + this.op + "max=?\"");
                }
                if (n == 1) {
                    if (this.relOp == RelOp.MINMIN || this.relOp == RelOp.MINMAX || this.relOp == RelOp.MAXMIN || this.relOp == RelOp.MAXMAX) {
                        throw new PrismLangException("Can't use \"" + this.toString() + " for " + String.valueOf((Object)modelType) + "s");
                    }
                    minMax = modelType.uncertain() ? MinMax.blank().setMinUnc(this.relOp.isMin()) : (this.relOp.isMin() ? MinMax.min() : MinMax.max());
                } else {
                    minMax = this.relOp == RelOp.MIN || this.relOp == RelOp.MINMIN || this.relOp == RelOp.MINMAX ? MinMax.min() : MinMax.max();
                    minMax.setMinUnc(this.relOp == RelOp.MIN || this.relOp == RelOp.MINMIN || this.relOp == RelOp.MAXMIN);
                }
            } else {
                boolean bl2;
                boolean bl3 = bl2 = bl ? this.relOp.isLowerBound() : this.relOp.isUpperBound();
                if (!modelType.nondeterministic()) {
                    minMax = MinMax.blank();
                } else {
                    MinMax minMax2 = minMax = bl2 ? MinMax.min() : MinMax.max();
                }
                if (modelType.uncertain()) {
                    minMax.setMinUnc(bl2);
                }
            }
        }
        return minMax;
    }

    public String getTypeOfOperator() {
        Object object = "";
        object = (String)object + this.op + String.valueOf((Object)this.relOp);
        object = (String)object + (this.isNumeric() ? "?" : "p");
        return object;
    }

    public String relOpBoundString() {
        return this.relOp.toString() + this.bound;
    }

    public String toString() {
        return this.op + this.relOp.toString() + String.valueOf(this.isNumeric() ? "?" : Double.valueOf(this.bound));
    }

    public boolean apply(double d) throws PrismException {
        switch (this.relOp) {
            case GEQ: {
                return d >= this.bound;
            }
            case GT: {
                return d > this.bound;
            }
            case LEQ: {
                return d <= this.bound;
            }
            case LT: {
                return d < this.bound;
            }
        }
        throw new PrismException("Cannot apply relational operator " + String.valueOf((Object)this.relOp));
    }

    public boolean apply(double d, Accuracy accuracy) throws PrismException {
        boolean bl;
        boolean bl2;
        if (accuracy != null && (bl2 = this.apply(accuracy.getResultLowerBound(d))) != (bl = this.apply(accuracy.getResultUpperBound(d)))) {
            throw new PrismException("Accuracy of value " + d + " is not enough to compare to bound " + this.bound);
        }
        return this.apply(d);
    }
}

