/*
 * Decompiled with CFR 0.152.
 */
package parser.type;

import java.math.BigInteger;
import parser.EvaluateContext;
import parser.ast.DeclarationIntUnbounded;
import parser.ast.DeclarationType;
import parser.type.Type;
import prism.PrismLangException;

public class TypeInt
extends Type {
    private static TypeInt singleton = new TypeInt();

    private TypeInt() {
    }

    public static TypeInt getInstance() {
        return singleton;
    }

    @Override
    public String getTypeString() {
        return "int";
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    @Override
    public Object defaultValue() {
        return 0;
    }

    @Override
    public DeclarationType defaultDeclarationType() {
        return new DeclarationIntUnbounded();
    }

    @Override
    public boolean canCastTypeTo(Type type) {
        return type instanceof TypeInt;
    }

    @Override
    public Number castValueTo(Object object) throws PrismLangException {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        throw new PrismLangException("Can't convert " + String.valueOf(object.getClass()) + " to type " + this.getTypeString());
    }

    @Override
    public Number castValueTo(Object object, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        switch (evalMode) {
            case FP: {
                if (object instanceof Integer) {
                    return (Integer)object;
                }
                if (object instanceof BigInteger) {
                    return ((BigInteger)object).intValue();
                }
                throw new PrismLangException("Cannot convert " + String.valueOf(object.getClass()) + " to " + this.getTypeString());
            }
            case EXACT: {
                if (object instanceof BigInteger) {
                    return (BigInteger)object;
                }
                if (object instanceof Integer) {
                    return BigInteger.valueOf(((Integer)object).intValue());
                }
                throw new PrismLangException("Cannot convert " + String.valueOf(object.getClass()) + " to " + this.getTypeString());
            }
        }
        throw new PrismLangException("Unknown evaluation mode " + String.valueOf((Object)evalMode));
    }

    public boolean equals(Object object) {
        return object instanceof TypeInt;
    }
}

