/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.util.ArrayList;
import java.util.List;
import parser.EvaluateContext;
import parser.ast.Coalition;
import parser.ast.Expression;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class ExpressionStrategy
extends Expression {
    protected boolean thereExists = false;
    protected Coalition coalition = new Coalition();
    protected ArrayList<Expression> operands = new ArrayList();
    protected boolean singleOperand = false;

    public ExpressionStrategy() {
    }

    public ExpressionStrategy(boolean bl) {
        this.thereExists = bl;
    }

    public ExpressionStrategy(boolean bl, Expression expression) {
        this.thereExists = bl;
        this.operands.add(expression);
        this.singleOperand = true;
    }

    public void setThereExists(boolean bl) {
        this.thereExists = bl;
    }

    public void setCoalitionAllPlayers() {
        this.coalition.setAllPlayers();
    }

    public void setCoalition(List<String> list) {
        this.coalition.setPlayers(list);
    }

    public void setSingleOperand(Expression expression) {
        this.operands.clear();
        this.operands.add(expression);
        this.singleOperand = true;
    }

    public void addOperand(Expression expression) {
        this.operands.add(expression);
    }

    public void setOperand(int n, Expression expression) {
        this.operands.set(n, expression);
    }

    public boolean isThereExists() {
        return this.thereExists;
    }

    public String getOperatorString() {
        return this.thereExists ? "<<>>" : "[[]]";
    }

    public Coalition getCoalition() {
        return this.coalition;
    }

    public boolean coalitionIsAllPlayers() {
        return this.coalition.isAllPlayers();
    }

    public List<String> getCoalitionPlayers() {
        return this.coalition.getPlayers();
    }

    public boolean hasSingleOperand() {
        return this.singleOperand;
    }

    public int getNumOperands() {
        return this.operands.size();
    }

    public Expression getOperand(int n) {
        return this.operands.get(n);
    }

    public List<Expression> getOperands() {
        return this.operands;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isProposition() {
        return false;
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        throw new PrismLangException("Cannot evaluate a " + this.getOperatorString() + " operator without a model");
    }

    @Override
    public boolean returnsSingleValue() {
        return false;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public ExpressionStrategy deepCopy(DeepCopy deepCopy) throws PrismLangException {
        deepCopy.copyAll(this.operands);
        return this;
    }

    @Override
    public ExpressionStrategy clone() {
        ExpressionStrategy expressionStrategy = (ExpressionStrategy)super.clone();
        expressionStrategy.coalition = new Coalition(this.coalition);
        expressionStrategy.operands = (ArrayList)this.operands.clone();
        return expressionStrategy;
    }

    @Override
    public String toString() {
        Object object = "";
        object = (String)object + (this.thereExists ? "<<" : "[[");
        object = (String)object + String.valueOf(this.coalition);
        object = (String)object + (this.thereExists ? ">> " : "]] ");
        if (this.singleOperand) {
            object = (String)object + String.valueOf(this.operands.get(0));
        } else {
            object = (String)object + "(";
            boolean bl = true;
            for (Expression expression : this.operands) {
                if (!bl) {
                    object = (String)object + ", ";
                } else {
                    bl = false;
                }
                object = (String)object + String.valueOf(expression);
            }
            object = (String)object + ")";
        }
        return object;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.coalition == null ? 0 : this.coalition.hashCode());
        n = 31 * n + (this.operands == null ? 0 : this.operands.hashCode());
        n = 31 * n + (this.singleOperand ? 1231 : 1237);
        n = 31 * n + (this.thereExists ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionStrategy expressionStrategy = (ExpressionStrategy)object;
        if (this.coalition == null ? expressionStrategy.coalition != null : !this.coalition.equals(expressionStrategy.coalition)) {
            return false;
        }
        if (this.operands == null ? expressionStrategy.operands != null : !this.operands.equals(expressionStrategy.operands)) {
            return false;
        }
        if (this.singleOperand != expressionStrategy.singleOperand) {
            return false;
        }
        return this.thereExists == expressionStrategy.thereExists;
    }
}

