/*
 * Decompiled with CFR 0.152.
 */
package parser.ast;

import java.math.BigInteger;
import param.BigRational;
import parser.EvaluateContext;
import parser.ast.Expression;
import parser.ast.ExpressionFunc;
import parser.type.TypeDouble;
import parser.type.TypeInt;
import parser.visitor.ASTVisitor;
import parser.visitor.DeepCopy;
import prism.PrismLangException;

public class ExpressionBinaryOp
extends Expression {
    public static final int IMPLIES = 1;
    public static final int IFF = 2;
    public static final int OR = 3;
    public static final int AND = 4;
    public static final int EQ = 5;
    public static final int NE = 6;
    public static final int GT = 7;
    public static final int GE = 8;
    public static final int LT = 9;
    public static final int LE = 10;
    public static final int PLUS = 11;
    public static final int MINUS = 12;
    public static final int TIMES = 13;
    public static final int DIVIDE = 14;
    public static final int POW = 15;
    public static final String[] opSymbols = new String[]{"", "=>", "<=>", "|", "&", "=", "!=", ">", ">=", "<", "<=", "+", "-", "*", "/", "^"};
    protected int op = 0;
    protected Expression operand1 = null;
    protected Expression operand2 = null;

    public static boolean isLogical(int n) {
        return n == 1 || n == 2 || n == 3 || n == 4;
    }

    public static boolean isRelOp(int n) {
        return n == 5 || n == 6 || n == 7 || n == 8 || n == 9 || n == 10;
    }

    public static boolean isArithmetic(int n) {
        return n == 11 || n == 12 || n == 13 || n == 14 || n == 15;
    }

    public ExpressionBinaryOp() {
    }

    public ExpressionBinaryOp(int n, Expression expression, Expression expression2) {
        this.operand1 = expression;
        this.operand2 = expression2;
        this.op = n;
    }

    public void setOperator(int n) {
        this.op = n;
    }

    public void setOperator(String string) throws PrismLangException {
        for (int i = 1; i < opSymbols.length; ++i) {
            if (!opSymbols[i].equals(string)) continue;
            this.setOperator(i);
            return;
        }
        throw new PrismLangException("Unknown binary operator '" + string + "'");
    }

    public void setOperand1(Expression expression) {
        this.operand1 = expression;
    }

    public void setOperand2(Expression expression) {
        this.operand2 = expression;
    }

    public int getOperator() {
        return this.op;
    }

    public String getOperatorSymbol() {
        return opSymbols[this.op];
    }

    public Expression getOperand1() {
        return this.operand1;
    }

    public Expression getOperand2() {
        return this.operand2;
    }

    @Override
    public boolean isConstant() {
        return this.operand1.isConstant() && this.operand2.isConstant();
    }

    @Override
    public boolean isProposition() {
        return this.operand1.isProposition() && this.operand2.isProposition();
    }

    @Override
    public Object evaluate(EvaluateContext evaluateContext) throws PrismLangException {
        Object object = this.operand1.evaluate(evaluateContext);
        switch (this.op) {
            case 1: {
                return (Boolean)object == false || (Boolean)this.operand2.evaluate(evaluateContext) != false;
            }
            case 3: {
                return (Boolean)object != false || (Boolean)this.operand2.evaluate(evaluateContext) != false;
            }
            case 4: {
                return (Boolean)object != false && (Boolean)this.operand2.evaluate(evaluateContext) != false;
            }
        }
        Object object2 = this.operand2.evaluate(evaluateContext);
        return this.apply(object, object2, evaluateContext.getEvaluationMode());
    }

    public Object apply(Object object, Object object2, EvaluateContext.EvalMode evalMode) throws PrismLangException {
        switch (this.op) {
            case 1: {
                return (Boolean)object == false || (Boolean)object2 != false;
            }
            case 2: {
                return ((Boolean)object).booleanValue() == ((Boolean)object2).booleanValue();
            }
            case 3: {
                return (Boolean)object != false || (Boolean)object2 != false;
            }
            case 4: {
                return (Boolean)object != false && (Boolean)object2 != false;
            }
            case 5: 
            case 6: {
                if (!this.operand1.getType().equals(this.operand2.getType())) {
                    if (this.operand1.getType().canCastTypeTo(this.operand2.getType())) {
                        object = this.operand1.getType().castValueTo(object);
                        object2 = this.operand1.getType().castValueTo(object2);
                    } else if (this.operand2.getType().canCastTypeTo(this.operand1.getType())) {
                        object = this.operand2.getType().castValueTo(object);
                        object2 = this.operand2.getType().castValueTo(object2);
                    } else {
                        throw new PrismLangException("Cannot apply " + this.getOperatorSymbol() + " to " + String.valueOf(this.operand1.getType()) + " and " + String.valueOf(this.operand2.getType()), this);
                    }
                }
                return this.op == 5 ? object.equals(object2) : !object.equals(object2);
            }
            case 14: {
                Number number = TypeDouble.getInstance().castValueTo(object, evalMode);
                Number number2 = TypeDouble.getInstance().castValueTo(object2, evalMode);
                switch (evalMode) {
                    case FP: {
                        return (Double)number / (Double)number2;
                    }
                    case EXACT: {
                        return ((BigRational)number).divide((BigRational)number2);
                    }
                }
                throw new PrismLangException("Unknown evaluation mode " + String.valueOf((Object)evalMode));
            }
            case 15: {
                return ExpressionFunc.applyPow(this.getType(), object, object2, evalMode);
            }
        }
        try {
            if (this.operand1.getType() == TypeInt.getInstance() && this.operand2.getType() == TypeInt.getInstance()) {
                switch (evalMode) {
                    case FP: {
                        int n = (Integer)object;
                        int n2 = (Integer)object2;
                        switch (this.op) {
                            case 7: {
                                return n > n2;
                            }
                            case 8: {
                                return n >= n2;
                            }
                            case 9: {
                                return n < n2;
                            }
                            case 10: {
                                return n <= n2;
                            }
                            case 11: {
                                return Math.addExact(n, n2);
                            }
                            case 12: {
                                return Math.subtractExact(n, n2);
                            }
                            case 13: {
                                return Math.multiplyExact(n, n2);
                            }
                        }
                    }
                    case EXACT: {
                        BigInteger bigInteger = (BigInteger)object;
                        BigInteger bigInteger2 = (BigInteger)object2;
                        switch (this.op) {
                            case 7: {
                                return bigInteger.compareTo(bigInteger2) > 0;
                            }
                            case 8: {
                                return bigInteger.compareTo(bigInteger2) >= 0;
                            }
                            case 9: {
                                return bigInteger.compareTo(bigInteger2) < 0;
                            }
                            case 10: {
                                return bigInteger.compareTo(bigInteger2) <= 0;
                            }
                            case 11: {
                                return bigInteger.add(bigInteger2);
                            }
                            case 12: {
                                return bigInteger.subtract(bigInteger2);
                            }
                            case 13: {
                                return bigInteger.multiply(bigInteger2);
                            }
                        }
                    }
                }
                throw new PrismLangException("Unknown evaluation mode " + String.valueOf((Object)evalMode));
            }
            Number number = TypeDouble.getInstance().castValueTo(object, evalMode);
            Number number3 = TypeDouble.getInstance().castValueTo(object2, evalMode);
            switch (evalMode) {
                case FP: {
                    double d = (Double)TypeDouble.getInstance().castValueTo(object, EvaluateContext.EvalMode.FP);
                    double d2 = (Double)TypeDouble.getInstance().castValueTo(object2, EvaluateContext.EvalMode.FP);
                    switch (this.op) {
                        case 7: {
                            return d > d2;
                        }
                        case 8: {
                            return d >= d2;
                        }
                        case 9: {
                            return d < d2;
                        }
                        case 10: {
                            return d <= d2;
                        }
                        case 11: {
                            return d + d2;
                        }
                        case 12: {
                            return d - d2;
                        }
                        case 13: {
                            return d * d2;
                        }
                    }
                    throw new PrismLangException("Unknown binary operator", this);
                }
                case EXACT: {
                    BigRational bigRational = (BigRational)TypeDouble.getInstance().castValueTo(object, EvaluateContext.EvalMode.EXACT);
                    BigRational bigRational2 = (BigRational)TypeDouble.getInstance().castValueTo(object2, EvaluateContext.EvalMode.EXACT);
                    switch (this.op) {
                        case 7: {
                            return bigRational.compareTo(bigRational2) > 0;
                        }
                        case 8: {
                            return bigRational.compareTo(bigRational2) >= 0;
                        }
                        case 9: {
                            return bigRational.compareTo(bigRational2) < 0;
                        }
                        case 10: {
                            return bigRational.compareTo(bigRational2) <= 0;
                        }
                        case 11: {
                            return bigRational.add(bigRational2);
                        }
                        case 12: {
                            return bigRational.subtract(bigRational2);
                        }
                        case 13: {
                            return bigRational.multiply(bigRational2);
                        }
                    }
                    throw new PrismLangException("Unknown binary operator", this);
                }
            }
            throw new PrismLangException("Unknown evaluation mode " + String.valueOf((Object)evalMode));
        }
        catch (ArithmeticException arithmeticException) {
            throw new PrismLangException(arithmeticException.getMessage(), this);
        }
    }

    @Override
    public boolean returnsSingleValue() {
        return this.operand1.returnsSingleValue() && this.operand2.returnsSingleValue();
    }

    @Override
    public Expression.Precedence getPrecedence() {
        switch (this.op) {
            case 1: {
                return Expression.Precedence.IMPLIES;
            }
            case 2: {
                return Expression.Precedence.IFF;
            }
            case 3: {
                return Expression.Precedence.OR;
            }
            case 4: {
                return Expression.Precedence.AND;
            }
            case 5: 
            case 6: {
                return Expression.Precedence.EQUALITY;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return Expression.Precedence.RELOP;
            }
            case 11: 
            case 12: {
                return Expression.Precedence.PLUS_MINUS;
            }
            case 13: 
            case 14: {
                return Expression.Precedence.TIMES_DIVIDE;
            }
            case 15: {
                return Expression.Precedence.POW;
            }
        }
        return null;
    }

    @Override
    public Object accept(ASTVisitor aSTVisitor) throws PrismLangException {
        return aSTVisitor.visit(this);
    }

    @Override
    public ExpressionBinaryOp deepCopy(DeepCopy deepCopy) throws PrismLangException {
        this.operand1 = deepCopy.copy(this.operand1);
        this.operand2 = deepCopy.copy(this.operand2);
        return this;
    }

    @Override
    public ExpressionBinaryOp clone() {
        return (ExpressionBinaryOp)super.clone();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.op == 1 || this.op == 5 || this.op == 6) {
            stringBuilder.append(Expression.toStringPrecLeq(this.operand1, this));
        } else {
            stringBuilder.append(Expression.toStringPrecLt(this.operand1, this));
        }
        stringBuilder.append(opSymbols[this.op]);
        if (this.op == 12 || this.op == 14 || this.op == 5 || this.op == 6) {
            stringBuilder.append(Expression.toStringPrecLeq(this.operand2, this));
        } else {
            stringBuilder.append(Expression.toStringPrecLt(this.operand2, this));
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.op;
        n = 31 * n + (this.operand1 == null ? 0 : this.operand1.hashCode());
        n = 31 * n + (this.operand2 == null ? 0 : this.operand2.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionBinaryOp expressionBinaryOp = (ExpressionBinaryOp)object;
        if (this.op != expressionBinaryOp.op) {
            return false;
        }
        if (this.operand1 == null ? expressionBinaryOp.operand1 != null : !this.operand1.equals(expressionBinaryOp.operand1)) {
            return false;
        }
        return !(this.operand2 == null ? expressionBinaryOp.operand2 != null : !this.operand2.equals(expressionBinaryOp.operand2));
    }
}

