/*
 * Decompiled with CFR 0.152.
 */
package param;

import common.IterableStateSet;
import common.iterable.FunctionalPrimitiveIterator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.IntPredicate;
import param.BigRational;
import param.Function;
import param.ParamMode;
import param.Point;
import param.StateBoolean;
import param.StateValue;
import parser.State;
import parser.type.Type;
import parser.type.TypeBool;
import prism.PrismLog;

public final class StateValues {
    private ArrayList<StateValue> values;
    private int initState;

    public StateValues(int n, int n2) {
        this.values = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            this.values.add(i, null);
        }
        this.initState = n2;
    }

    public StateValues(int n, int n2, StateValue stateValue) {
        this(n, n2);
        for (int i = 0; i < n; ++i) {
            this.values.set(i, stateValue);
        }
    }

    public StateValues(int n, int n2, boolean bl) {
        this(n, n2, new StateBoolean(bl));
    }

    public String toString() {
        return this.values.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof StateValues)) {
            return false;
        }
        StateValues stateValues = (StateValues)object;
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.values.get(i).equals(stateValues.values.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.values.size(); ++i) {
            n = this.values.get(i).hashCode() + (n << 6) + (n << 16) - n;
        }
        return n;
    }

    public StateValue getStateValue(int n) {
        return this.values.get(n);
    }

    public void setStateValue(int n, StateValue stateValue) {
        this.values.set(n, stateValue);
    }

    public void setStateValue(int n, boolean bl) {
        this.values.set(n, new StateBoolean(bl));
    }

    public Function getStateValueAsFunction(int n) {
        return (Function)this.values.get(n);
    }

    public boolean getStateValueAsBoolean(int n) {
        return ((StateBoolean)this.values.get(n)).getValue();
    }

    public Function getInitStateValueAsFunction() {
        return (Function)this.values.get(this.initState);
    }

    public boolean getInitStateValueAsBoolean() {
        return ((StateBoolean)this.values.get(this.initState)).getValue();
    }

    public StateValue getInitStateValue() {
        return this.values.get(this.initState);
    }

    public int getNumStates() {
        return this.values.size();
    }

    public BitSet toBitSet() {
        BitSet bitSet = new BitSet(this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            bitSet.set(i, this.getStateValueAsBoolean(i));
        }
        return bitSet;
    }

    public BigRational[] instantiate(Point point) {
        BigRational[] bigRationalArray = new BigRational[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            bigRationalArray[i] = this.getStateValueAsFunction(i).evaluate(point);
        }
        return bigRationalArray;
    }

    public void printFiltered(PrismLog prismLog, ParamMode paramMode, Type type, BitSet bitSet, List<State> list, boolean bl, boolean bl2, boolean bl3) {
        int n2 = 0;
        IntPredicate intPredicate = type instanceof TypeBool ? n -> this.getStateValueAsBoolean(n) : n -> !this.getStateValueAsFunction(n).isZero();
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(bitSet, this.getNumStates()).iterator();
        while (ofInt.hasNext()) {
            int n3 = (Integer)ofInt.next();
            if (bl && !intPredicate.test(n3)) continue;
            if (bl3) {
                prismLog.print(n3);
                prismLog.print(":");
            }
            if (bl2 && list != null) {
                prismLog.print(list.get(n3).toString());
            }
            if (bl && type instanceof TypeBool) {
                prismLog.println();
            } else {
                if (bl3 || bl2) {
                    prismLog.print("=");
                }
                if (type instanceof TypeBool) {
                    prismLog.println(this.getStateValueAsBoolean(n3));
                } else if (paramMode == ParamMode.EXACT) {
                    BigRational bigRational = this.getStateValueAsFunction(n3).asBigRational();
                    prismLog.println(String.valueOf(bigRational) + "   (" + bigRational.toApproximateString() + ")");
                } else {
                    prismLog.println(this.getStateValueAsFunction(n3));
                }
            }
            ++n2;
        }
        if (bl && n2 == 0) {
            prismLog.println("(all zero)");
            return;
        }
    }
}

