/*
 * Decompiled with CFR 0.152.
 */
package jltl2ba;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import jltl2ba.APSet;
import jltl2ba.Alternating;
import jltl2ba.Buchi;
import jltl2ba.Generalized;
import jltl2dstar.APMonom;
import jltl2dstar.NBA;
import prism.PrismException;

public class SimpleLTL {
    public SimpleLTL left;
    public SimpleLTL right;
    public LTLType kind;
    public String ap;

    public SimpleLTL(boolean bl) {
        this.left = null;
        this.right = null;
        this.kind = bl ? LTLType.TRUE : LTLType.FALSE;
        this.ap = null;
    }

    public SimpleLTL(String string) {
        this.left = null;
        this.right = null;
        this.kind = LTLType.AP;
        this.ap = string;
    }

    public SimpleLTL(LTLType lTLType, SimpleLTL simpleLTL) {
        switch (lTLType.ordinal()) {
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                this.left = simpleLTL;
                this.right = null;
                this.kind = lTLType;
                this.ap = null;
                break;
            }
        }
    }

    public SimpleLTL(LTLType lTLType, SimpleLTL simpleLTL, SimpleLTL simpleLTL2) {
        switch (lTLType.ordinal()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.left = simpleLTL;
                this.right = simpleLTL2;
                this.kind = lTLType;
                this.ap = null;
                break;
            }
        }
    }

    public SimpleLTL(LTLType lTLType, SimpleLTL simpleLTL, SimpleLTL simpleLTL2, String string) {
        this.kind = lTLType;
        this.left = simpleLTL;
        this.right = simpleLTL2;
        this.ap = null;
        if (string != null) {
            this.ap = string;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SimpleLTL) {
            SimpleLTL simpleLTL = (SimpleLTL)object;
            if (this.kind == simpleLTL.kind) {
                switch (this.kind.ordinal()) {
                    case 0: 
                    case 1: {
                        return true;
                    }
                    case 3: 
                    case 4: 
                    case 11: 
                    case 12: {
                        return this.left.equals(simpleLTL.left);
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        return this.left.equals(simpleLTL.left) && this.right.equals(simpleLTL.right);
                    }
                    case 2: {
                        return this.ap.equals(simpleLTL.ap);
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public APSet getAPs() {
        APSet aPSet;
        switch (this.kind.ordinal()) {
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                aPSet = this.left.getAPs();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                aPSet = this.left.getAPs();
                for (String string : this.right.getAPs()) {
                    aPSet.addAP(string);
                }
                break;
            }
            case 0: 
            case 1: {
                aPSet = new APSet();
                break;
            }
            case 2: {
                aPSet = new APSet();
                aPSet.addAP(this.ap);
                break;
            }
            default: {
                aPSet = new APSet();
            }
        }
        return aPSet;
    }

    public SimpleLTL clone() {
        SimpleLTL simpleLTL = new SimpleLTL(this.kind, this.left != null ? this.left.clone() : null, this.right != null ? this.right.clone() : null, this.ap);
        return simpleLTL;
    }

    private boolean implies(SimpleLTL simpleLTL) {
        return this.equals(simpleLTL) || simpleLTL.kind == LTLType.TRUE || this.kind == LTLType.FALSE || simpleLTL.kind == LTLType.AND && this.implies(simpleLTL.left) && this.implies(simpleLTL.right) || this.kind == LTLType.OR && this.left.implies(simpleLTL) && this.right.implies(simpleLTL) || this.kind == LTLType.AND && (this.left.implies(simpleLTL) || this.right.implies(simpleLTL)) || simpleLTL.kind == LTLType.OR && (this.implies(simpleLTL.left) || this.implies(simpleLTL.right)) || simpleLTL.kind == LTLType.UNTIL && this.implies(simpleLTL.right) || this.kind == LTLType.RELEASE && this.right.implies(simpleLTL) || this.kind == LTLType.UNTIL && this.left.implies(simpleLTL) && this.right.implies(simpleLTL) || simpleLTL.kind == LTLType.RELEASE && this.implies(simpleLTL.left) && this.implies(simpleLTL.right) || (this.kind == LTLType.UNTIL || this.kind == LTLType.RELEASE) && this.kind == simpleLTL.kind && this.left.implies(simpleLTL.left) && this.right.implies(simpleLTL.right);
    }

    public SimpleLTL simplify() {
        if (!this.isTree()) {
            throw new IllegalArgumentException("Implementation error: SimpleLTL.simplify() requires that the formula is a tree, not a DAG");
        }
        return this.simplified();
    }

    private SimpleLTL simplified() {
        SimpleLTL simpleLTL = this;
        switch (this.kind.ordinal()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.right = this.right.simplified();
                this.left = this.left.simplified();
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                this.left = this.left.simplified();
                break;
            }
        }
        switch (this.kind.ordinal()) {
            case 3: {
                SimpleLTL simpleLTL2 = this.pushNegation();
                if (simpleLTL2.kind != LTLType.NOT) {
                    simpleLTL = simpleLTL2.simplified();
                    break;
                }
                simpleLTL = simpleLTL2;
                break;
            }
            case 12: {
                if (this.left.kind == LTLType.TRUE || this.left.kind == LTLType.FALSE) {
                    simpleLTL = this.left;
                    break;
                }
                if (this.left.kind == LTLType.UNTIL) {
                    if (this.left.left.kind == LTLType.TRUE) {
                        simpleLTL = this.left;
                        break;
                    }
                    this.left = this.left.right;
                }
                SimpleLTL simpleLTL3 = new SimpleLTL(LTLType.UNTIL, new SimpleLTL(true), this.left);
                simpleLTL = simpleLTL3.simplified();
                break;
            }
            case 11: {
                if (this.left.kind == LTLType.FALSE || this.left.kind == LTLType.TRUE) {
                    simpleLTL = this.left;
                    break;
                }
                if (this.left.kind == LTLType.RELEASE) {
                    if (this.left.left.kind == LTLType.FALSE) {
                        simpleLTL = this.left;
                        break;
                    }
                    this.left = this.left.right;
                }
                SimpleLTL simpleLTL4 = new SimpleLTL(LTLType.RELEASE, new SimpleLTL(false), this.left);
                simpleLTL = simpleLTL4.simplified();
                break;
            }
            case 9: {
                SimpleLTL simpleLTL5;
                if (this.right.kind == LTLType.TRUE || this.right.kind == LTLType.FALSE || this.left.kind == LTLType.FALSE) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.left.implies(this.right)) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.left.kind == LTLType.UNTIL && this.left.left.equals(this.right)) {
                    this.left = this.left.right;
                    break;
                }
                if (this.right.kind == LTLType.UNTIL && this.left.implies(this.right.left)) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.right.kind == LTLType.NEXT && this.left.kind == LTLType.NEXT) {
                    simpleLTL = new SimpleLTL(LTLType.NEXT, new SimpleLTL(LTLType.UNTIL, this.left.left, this.right.left));
                    break;
                }
                if (this.left.kind == LTLType.TRUE && this.right.kind == LTLType.NEXT) {
                    simpleLTL = new SimpleLTL(LTLType.NEXT, new SimpleLTL(LTLType.UNTIL, new SimpleLTL(true), this.right.left));
                    break;
                }
                if (this.left.kind == LTLType.TRUE && this.right.kind == LTLType.RELEASE && this.right.left.kind == LTLType.FALSE && this.right.right.kind == LTLType.UNTIL && this.right.right.left.kind == LTLType.TRUE) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.left.kind == LTLType.TRUE || !(simpleLTL5 = new SimpleLTL(LTLType.NOT, this.right.clone())).pushNegation().implies(this.left)) break;
                this.left = new SimpleLTL(true);
                break;
            }
            case 10: {
                SimpleLTL simpleLTL6;
                if (this.right.kind == LTLType.FALSE || this.right.kind == LTLType.TRUE || this.left.kind == LTLType.TRUE) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.right.implies(this.left)) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.left.kind == LTLType.FALSE && this.right.kind == LTLType.RELEASE) {
                    this.right = this.right.right;
                    break;
                }
                if (this.left.kind == LTLType.FALSE && this.right.kind == LTLType.NEXT) {
                    simpleLTL = new SimpleLTL(LTLType.NEXT, new SimpleLTL(LTLType.RELEASE, new SimpleLTL(false), this.right.left));
                    break;
                }
                if (this.left.kind == LTLType.FALSE && this.right.kind == LTLType.UNTIL && this.right.left.kind == LTLType.TRUE && this.right.right.kind == LTLType.RELEASE && this.right.right.left.kind == LTLType.FALSE) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.right.kind == LTLType.RELEASE && this.right.left.implies(this.left)) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.left.kind == LTLType.FALSE || !this.left.implies((simpleLTL6 = new SimpleLTL(LTLType.NOT, this.right.clone())).pushNegation())) break;
                this.left = new SimpleLTL(false);
                break;
            }
            case 4: {
                if (this.left.kind == LTLType.TRUE || this.left.kind == LTLType.FALSE) {
                    simpleLTL = this.left;
                    break;
                }
                if (this.left.kind == LTLType.RELEASE && this.left.left.kind == LTLType.FALSE && this.left.right.kind == LTLType.UNTIL && this.left.right.left.kind == LTLType.TRUE) {
                    simpleLTL = this.left;
                    break;
                }
                if (this.left.kind != LTLType.UNTIL || this.left.left.kind != LTLType.TRUE || this.left.right.kind != LTLType.RELEASE || this.left.right.left.kind != LTLType.FALSE) break;
                simpleLTL = this.left;
                break;
            }
            case 8: {
                if (this.left.implies(this.right)) {
                    simpleLTL = new SimpleLTL(true);
                    break;
                }
                SimpleLTL simpleLTL7 = new SimpleLTL(LTLType.NOT, this.left);
                simpleLTL7 = new SimpleLTL(LTLType.OR, simpleLTL7.pushNegation(), this.right);
                simpleLTL = simpleLTL7.rewrite();
                break;
            }
            case 7: {
                if (this.left.implies(this.right) && this.right.implies(this.left)) {
                    simpleLTL = new SimpleLTL(true);
                    break;
                }
                SimpleLTL simpleLTL8 = new SimpleLTL(LTLType.AND, this.left.clone(), this.right.clone());
                SimpleLTL simpleLTL9 = new SimpleLTL(LTLType.NOT, this.left);
                SimpleLTL simpleLTL10 = new SimpleLTL(LTLType.NOT, this.right);
                SimpleLTL simpleLTL11 = new SimpleLTL(LTLType.AND, simpleLTL9.pushNegation(), simpleLTL10.pushNegation());
                simpleLTL = new SimpleLTL(LTLType.OR, simpleLTL8.rewrite(), simpleLTL11.rewrite());
                simpleLTL = simpleLTL.rewrite();
                break;
            }
            case 6: {
                if (this.right.kind == LTLType.UNTIL && this.right.right.equals(this.left)) {
                    simpleLTL = this.left;
                    break;
                }
                if (this.left.kind == LTLType.UNTIL && this.left.right.equals(this.right)) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.right.kind == LTLType.RELEASE && this.right.right.equals(this.left)) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.left.kind == LTLType.RELEASE && this.left.right.equals(this.right)) {
                    simpleLTL = this.left;
                    break;
                }
                if (this.right.kind == LTLType.UNTIL && this.left.kind == LTLType.UNTIL && this.right.right.equals(this.left.right)) {
                    simpleLTL = new SimpleLTL(LTLType.UNTIL, new SimpleLTL(LTLType.AND, this.left.left, this.right.left), this.left.right);
                    break;
                }
                if (this.right.kind == LTLType.RELEASE && this.left.kind == LTLType.RELEASE && this.right.left.equals(this.left.left)) {
                    simpleLTL = new SimpleLTL(LTLType.RELEASE, this.right.left, new SimpleLTL(LTLType.AND, this.left.right, this.right.right));
                    break;
                }
                if (this.right.kind == LTLType.NEXT && this.left.kind == LTLType.NEXT) {
                    simpleLTL = new SimpleLTL(LTLType.NEXT, new SimpleLTL(LTLType.AND, this.left.left, this.right.left));
                    break;
                }
                if (this.right.kind == LTLType.UNTIL && this.left.kind == LTLType.RELEASE && this.left.right.equals(this.right.right)) {
                    simpleLTL = this.left;
                    break;
                }
                if (this.left.equals(this.right) || this.right.kind == LTLType.FALSE || this.left.kind == LTLType.TRUE || this.right.implies(this.left)) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.right.kind == LTLType.TRUE || this.left.kind == LTLType.FALSE || this.left.implies(this.right)) {
                    simpleLTL = this.left;
                    break;
                }
                if (this.left.kind == LTLType.UNTIL && this.left.left.kind == LTLType.TRUE && this.left.right.kind == LTLType.RELEASE && this.left.right.left.kind == LTLType.FALSE && this.right.kind == LTLType.UNTIL && this.right.left.kind == LTLType.TRUE && this.right.right.kind == LTLType.RELEASE && this.right.right.left.kind == LTLType.FALSE) {
                    simpleLTL = new SimpleLTL(LTLType.UNTIL, new SimpleLTL(true), new SimpleLTL(LTLType.RELEASE, new SimpleLTL(false), new SimpleLTL(LTLType.AND, this.left.right.right, this.right.right.right)));
                    break;
                }
                SimpleLTL simpleLTL12 = new SimpleLTL(LTLType.NOT, this.right.clone());
                if (this.left.implies(simpleLTL12.pushNegation())) {
                    simpleLTL = new SimpleLTL(false);
                    break;
                }
                simpleLTL12 = new SimpleLTL(LTLType.NOT, this.left.clone());
                if (!this.right.implies(simpleLTL12.pushNegation())) break;
                simpleLTL = new SimpleLTL(false);
                break;
            }
            case 5: {
                if (this.right.kind == LTLType.UNTIL && this.right.right.equals(this.left)) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.right.kind == LTLType.RELEASE && this.right.right.equals(this.left)) {
                    simpleLTL = this.left;
                    break;
                }
                if (this.right.kind == LTLType.UNTIL && this.left.kind == LTLType.UNTIL && this.right.left.equals(this.left.left)) {
                    simpleLTL = new SimpleLTL(LTLType.UNTIL, this.right.left, new SimpleLTL(LTLType.OR, this.left.right, this.right.right));
                    break;
                }
                if (this.left.equals(this.right) || this.right.kind == LTLType.FALSE || this.left.kind == LTLType.TRUE || this.right.implies(this.left)) {
                    simpleLTL = this.left;
                    break;
                }
                if (this.right.kind == LTLType.TRUE || this.left.kind == LTLType.FALSE || this.left.implies(this.right)) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.right.kind == LTLType.RELEASE && this.left.kind == LTLType.RELEASE && this.left.right.equals(this.right.right)) {
                    simpleLTL = new SimpleLTL(LTLType.RELEASE, new SimpleLTL(LTLType.OR, this.left.left, this.right.left), this.right.right);
                    break;
                }
                if (this.right.kind == LTLType.UNTIL && this.left.kind == LTLType.RELEASE && this.left.right.equals(this.right.right)) {
                    simpleLTL = this.right;
                    break;
                }
                if (this.left.kind == LTLType.RELEASE && this.left.left.kind == LTLType.FALSE && this.left.right.kind == LTLType.UNTIL && this.left.right.left.kind == LTLType.TRUE && this.right.kind == LTLType.RELEASE && this.right.left.kind == LTLType.FALSE && this.right.right.kind == LTLType.UNTIL && this.right.right.left.kind == LTLType.TRUE) {
                    simpleLTL = new SimpleLTL(LTLType.RELEASE, new SimpleLTL(false), new SimpleLTL(LTLType.UNTIL, new SimpleLTL(true), new SimpleLTL(LTLType.OR, this.left.right.right, this.right.right.right)));
                    break;
                }
                SimpleLTL simpleLTL13 = new SimpleLTL(LTLType.NOT, this.right.clone());
                if (simpleLTL13.pushNegation().implies(this.left)) {
                    simpleLTL = new SimpleLTL(true);
                    break;
                }
                simpleLTL13 = new SimpleLTL(LTLType.NOT, this.left.clone());
                if (!simpleLTL13.pushNegation().implies(this.right)) break;
                simpleLTL = new SimpleLTL(true);
            }
        }
        return simpleLTL;
    }

    public SimpleLTL toBasicOperators() {
        switch (this.kind.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return this;
            }
            case 5: 
            case 6: 
            case 9: {
                return new SimpleLTL(this.kind, this.left.toBasicOperators(), this.right.toBasicOperators());
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                return new SimpleLTL(this.kind, this.left.toBasicOperators());
            }
            case 7: {
                SimpleLTL simpleLTL = this.left.toBasicOperators();
                SimpleLTL simpleLTL2 = this.right.toBasicOperators();
                SimpleLTL simpleLTL3 = new SimpleLTL(LTLType.AND, simpleLTL, simpleLTL2);
                SimpleLTL simpleLTL4 = new SimpleLTL(LTLType.AND, new SimpleLTL(LTLType.NOT, simpleLTL), new SimpleLTL(LTLType.NOT, simpleLTL2));
                return new SimpleLTL(LTLType.OR, simpleLTL3, simpleLTL4);
            }
            case 8: {
                SimpleLTL simpleLTL = new SimpleLTL(LTLType.NOT, this.left.toBasicOperators());
                return new SimpleLTL(LTLType.OR, simpleLTL, this.right.toBasicOperators());
            }
            case 10: {
                SimpleLTL simpleLTL = new SimpleLTL(LTLType.NOT, this.left.toBasicOperators());
                SimpleLTL simpleLTL5 = new SimpleLTL(LTLType.NOT, this.right.toBasicOperators());
                return new SimpleLTL(LTLType.UNTIL, simpleLTL, simpleLTL5);
            }
        }
        throw new UnsupportedOperationException("Unknown operator in SimpleLTL");
    }

    public SimpleLTL negate() {
        return new SimpleLTL(LTLType.NOT, this);
    }

    public SimpleLTL pushNegation() {
        SimpleLTL simpleLTL;
        boolean bl = false;
        if (this.kind != LTLType.NOT) {
            return this;
        }
        switch (this.left.kind.ordinal()) {
            case 1: {
                this.left = null;
                this.kind = LTLType.FALSE;
                break;
            }
            case 0: {
                this.left = null;
                this.kind = LTLType.TRUE;
                break;
            }
            case 3: {
                simpleLTL = this.left.left;
                this.left = simpleLTL.left;
                this.right = simpleLTL.right;
                this.kind = simpleLTL.kind;
                if (this.kind != LTLType.AP) break;
                this.ap = simpleLTL.ap;
                break;
            }
            case 10: {
                this.kind = LTLType.UNTIL;
                bl = true;
                break;
            }
            case 9: {
                this.kind = LTLType.RELEASE;
                bl = true;
                break;
            }
            case 4: {
                this.kind = LTLType.NEXT;
                this.left.kind = LTLType.NOT;
                this.left = this.left.pushNegation();
                break;
            }
            case 6: {
                this.kind = LTLType.OR;
                bl = true;
                break;
            }
            case 5: {
                this.kind = LTLType.AND;
                bl = true;
                break;
            }
            case 8: {
                this.kind = LTLType.AND;
                simpleLTL = new SimpleLTL(LTLType.NOT, this.left.right);
                this.right = simpleLTL.pushNegation();
                this.left = this.left.left;
                break;
            }
            case 7: {
                this.kind = LTLType.OR;
                simpleLTL = new SimpleLTL(LTLType.NOT, this.left.left.clone());
                this.right = new SimpleLTL(LTLType.AND, simpleLTL.pushNegation(), this.left.right.clone());
                this.left.kind = LTLType.AND;
                simpleLTL = new SimpleLTL(LTLType.NOT, this.left.right);
                this.left.right = simpleLTL.pushNegation();
                break;
            }
            case 12: {
                this.kind = LTLType.GLOBALLY;
                this.left.kind = LTLType.NOT;
                this.left = this.left.pushNegation();
                break;
            }
            case 11: {
                this.kind = LTLType.FINALLY;
                this.left.kind = LTLType.NOT;
                this.left = this.left.pushNegation();
                break;
            }
            case 2: {
                return this;
            }
        }
        if (bl) {
            simpleLTL = new SimpleLTL(LTLType.NOT, this.left.right);
            this.right = simpleLTL.pushNegation();
            this.left.kind = LTLType.NOT;
            this.left.right = null;
            this.left = this.left.pushNegation();
        }
        return this.rewrite();
    }

    public SimpleLTL rewrite() {
        return this.rightLinked().canonical();
    }

    public SimpleLTL rightLinked() {
        SimpleLTL simpleLTL = this;
        if (simpleLTL.kind == LTLType.AND || simpleLTL.kind == LTLType.OR) {
            while (simpleLTL.left != null && simpleLTL.left.kind == simpleLTL.kind) {
                SimpleLTL simpleLTL2 = simpleLTL.left;
                simpleLTL.left = simpleLTL2.right;
                simpleLTL2.right = simpleLTL;
                simpleLTL = simpleLTL2;
            }
        }
        if (simpleLTL.left != null) {
            simpleLTL.left = simpleLTL.left.rightLinked();
        }
        if (simpleLTL.right != null) {
            simpleLTL.right = simpleLTL.right.rightLinked();
        }
        return simpleLTL;
    }

    public SimpleLTL canonical() {
        return this;
    }

    public int countNodes() {
        switch (this.kind.ordinal()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.left.countNodes() + this.right.countNodes() + 1;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                return this.left.countNodes() + 1;
            }
        }
        return 1;
    }

    public int countPredicates() {
        switch (this.kind.ordinal()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return this.left.countPredicates() + this.right.countPredicates();
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                return this.left.countPredicates();
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    public String toString() {
        Object object = "";
        switch (this.kind.ordinal()) {
            case 5: {
                object = "(" + this.left.toString() + " || " + this.right.toString() + ")";
                break;
            }
            case 6: {
                object = "(" + this.left.toString() + " && " + this.right.toString() + ")";
                break;
            }
            case 9: {
                object = "(" + this.left.toString() + " U " + this.right.toString() + ")";
                break;
            }
            case 10: {
                object = "(" + this.left.toString() + " V " + this.right.toString() + ")";
                break;
            }
            case 8: {
                object = "(" + this.left.toString() + " -> " + this.right.toString() + ")";
                break;
            }
            case 7: {
                object = "(" + this.left.toString() + " <-> " + this.right.toString() + ")";
                break;
            }
            case 4: {
                object = "X " + this.left.toString();
                break;
            }
            case 12: {
                object = "F " + this.left.toString();
                break;
            }
            case 11: {
                object = "G " + this.left.toString();
                break;
            }
            case 3: {
                object = "! " + this.left.toString();
                break;
            }
            case 0: {
                object = "false";
                break;
            }
            case 1: {
                object = "true";
                break;
            }
            case 2: {
                object = this.ap;
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    public boolean isCoSafe() {
        switch (this.kind.ordinal()) {
            case 10: 
            case 11: {
                return false;
            }
        }
        if (this.left != null && !this.left.isCoSafe()) {
            return false;
        }
        return this.right == null || this.right.isCoSafe();
    }

    public boolean hasNextStep() {
        if (this.kind == LTLType.NEXT) {
            return true;
        }
        if (this.left != null && this.left.hasNextStep()) {
            return true;
        }
        return this.right != null && this.right.hasNextStep();
    }

    public boolean isTree() {
        IdentityHashMap<SimpleLTL, SimpleLTL> identityHashMap = new IdentityHashMap<SimpleLTL, SimpleLTL>();
        return this.isTree(identityHashMap);
    }

    private boolean isTree(IdentityHashMap<SimpleLTL, SimpleLTL> identityHashMap) {
        if (identityHashMap.containsKey(this)) {
            return false;
        }
        identityHashMap.put(this, this);
        if (this.left != null && !this.left.isTree(identityHashMap)) {
            return false;
        }
        return this.right == null || this.right.isTree(identityHashMap);
    }

    public SimpleLTL extendNextStepWithAP(String string) {
        switch (this.kind.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return this.clone();
            }
            case 3: {
                SimpleLTL simpleLTL = this.left.extendNextStepWithAP(string);
                return new SimpleLTL(this.kind, simpleLTL);
            }
            case 4: {
                SimpleLTL simpleLTL = this.left.extendNextStepWithAP(string);
                return new SimpleLTL(LTLType.NEXT, new SimpleLTL(LTLType.AND, new SimpleLTL(string), simpleLTL));
            }
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                SimpleLTL simpleLTL = this.left.extendNextStepWithAP(string);
                SimpleLTL simpleLTL2 = this.right.extendNextStepWithAP(string);
                return new SimpleLTL(this.kind, simpleLTL, simpleLTL2);
            }
            case 11: 
            case 12: {
                SimpleLTL simpleLTL = this.left.extendNextStepWithAP(string);
                return new SimpleLTL(this.kind, simpleLTL);
            }
            case 7: 
            case 8: {
                throw new UnsupportedOperationException("Extending Next operator with AP not supported for " + this.kind.toString() + " operator, only for basic operators: " + String.valueOf(this));
            }
        }
        throw new UnsupportedOperationException();
    }

    public SimpleLTL toDNF() throws PrismException {
        switch (this.kind.ordinal()) {
            case 1: {
                return new SimpleLTL(true);
            }
            case 0: {
                return new SimpleLTL(false);
            }
            case 3: {
                return new SimpleLTL(LTLType.NOT, this.left.toDNF());
            }
            case 2: {
                return new SimpleLTL(this.ap);
            }
            case 5: {
                return new SimpleLTL(LTLType.OR, this.left.toDNF(), this.right.toDNF());
            }
            case 6: {
                SimpleLTL simpleLTL = this.left.toDNF();
                SimpleLTL simpleLTL2 = this.right.toDNF();
                if (simpleLTL.kind == LTLType.OR) {
                    SimpleLTL simpleLTL3 = simpleLTL.left;
                    SimpleLTL simpleLTL4 = simpleLTL.right;
                    if (simpleLTL2.kind == LTLType.OR) {
                        SimpleLTL simpleLTL5 = simpleLTL2.left;
                        SimpleLTL simpleLTL6 = simpleLTL2.right;
                        SimpleLTL simpleLTL7 = new SimpleLTL(LTLType.AND, simpleLTL3, simpleLTL5);
                        SimpleLTL simpleLTL8 = new SimpleLTL(LTLType.AND, simpleLTL4, simpleLTL5);
                        SimpleLTL simpleLTL9 = new SimpleLTL(LTLType.AND, simpleLTL3, simpleLTL6);
                        SimpleLTL simpleLTL10 = new SimpleLTL(LTLType.AND, simpleLTL4, simpleLTL6);
                        return new SimpleLTL(LTLType.OR, new SimpleLTL(LTLType.OR, simpleLTL7, simpleLTL8).toDNF(), new SimpleLTL(LTLType.OR, simpleLTL9, simpleLTL10).toDNF());
                    }
                    SimpleLTL simpleLTL11 = new SimpleLTL(LTLType.AND, simpleLTL3, simpleLTL2);
                    SimpleLTL simpleLTL12 = new SimpleLTL(LTLType.AND, simpleLTL4, simpleLTL2);
                    return new SimpleLTL(LTLType.OR, simpleLTL11.toDNF(), simpleLTL12.toDNF());
                }
                if (simpleLTL2.kind == LTLType.OR) {
                    SimpleLTL simpleLTL13 = simpleLTL2.left;
                    SimpleLTL simpleLTL14 = simpleLTL2.right;
                    SimpleLTL simpleLTL15 = new SimpleLTL(LTLType.AND, simpleLTL, simpleLTL13);
                    SimpleLTL simpleLTL16 = new SimpleLTL(LTLType.AND, simpleLTL, simpleLTL14);
                    return new SimpleLTL(LTLType.OR, simpleLTL15.toDNF(), simpleLTL16.toDNF());
                }
                return new SimpleLTL(LTLType.AND, simpleLTL, simpleLTL2);
            }
        }
        throw new PrismException("Illegal operator for DNF!");
    }

    public APMonom toMonom(APSet aPSet) throws PrismException {
        APMonom aPMonom = new APMonom(true);
        switch (this.kind.ordinal()) {
            case 6: {
                APMonom aPMonom2 = this.left.toMonom(aPSet);
                APMonom aPMonom3 = this.right.toMonom(aPSet);
                aPMonom = aPMonom2.and(aPMonom3);
                return aPMonom;
            }
            case 3: {
                switch (this.left.kind.ordinal()) {
                    case 2: {
                        aPMonom.setValue(aPSet.indexOf(this.left.ap), false);
                        return aPMonom;
                    }
                    case 0: {
                        return new APMonom(true);
                    }
                    case 1: {
                        return new APMonom(false);
                    }
                }
                throw new PrismException("Formula not in DNF!");
            }
            case 2: {
                aPMonom.setValue(aPSet.indexOf(this.ap), true);
                return aPMonom;
            }
            case 0: {
                return new APMonom(false);
            }
            case 1: {
                return new APMonom(true);
            }
        }
        throw new PrismException("Formula not in DNF!");
    }

    public void renameAP(String string, String string2) {
        switch (this.kind.ordinal()) {
            case 2: {
                if (this.ap.startsWith(string)) {
                    this.ap = string2 + this.ap.substring(string.length());
                }
                return;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.left.renameAP(string, string2);
                this.right.renameAP(string, string2);
                return;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                this.left.renameAP(string, string2);
                return;
            }
            case 0: 
            case 1: {
                return;
            }
        }
        throw new UnsupportedOperationException("Unknown operator in SimpleLTL formula: " + String.valueOf(this));
    }

    public String toStringLBT() {
        Object object = "";
        switch (this.kind.ordinal()) {
            case 5: {
                object = "| " + this.left.toStringLBT() + " " + this.right.toStringLBT();
                break;
            }
            case 6: {
                object = "& " + this.left.toStringLBT() + " " + this.right.toStringLBT();
                break;
            }
            case 9: {
                object = "U " + this.left.toStringLBT() + " " + this.right.toStringLBT();
                break;
            }
            case 10: {
                object = "V " + this.left.toStringLBT() + " " + this.right.toStringLBT();
                break;
            }
            case 8: {
                object = "i " + this.left.toStringLBT() + " " + this.right.toStringLBT();
                break;
            }
            case 7: {
                object = "e " + this.left.toStringLBT() + " " + this.right.toStringLBT();
                break;
            }
            case 4: {
                object = "X " + this.left.toStringLBT();
                break;
            }
            case 12: {
                object = "F " + this.left.toStringLBT();
                break;
            }
            case 11: {
                object = "G " + this.left.toStringLBT();
                break;
            }
            case 3: {
                object = "! " + this.left.toStringLBT();
                break;
            }
            case 0: {
                object = "f";
                break;
            }
            case 1: {
                object = "t";
                break;
            }
            case 2: {
                object = this.ap;
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    public String toStringSpin() {
        Object object = "";
        switch (this.kind.ordinal()) {
            case 5: {
                object = "(" + this.left.toStringSpin() + ") || (" + this.right.toStringSpin() + ")";
                break;
            }
            case 6: {
                object = "(" + this.left.toStringSpin() + ") && (" + this.right.toStringSpin() + ")";
                break;
            }
            case 9: {
                object = "(" + this.left.toStringSpin() + ") U (" + this.right.toStringSpin() + ")";
                break;
            }
            case 10: {
                object = "(" + this.left.toStringSpin() + ") V (" + this.right.toStringSpin() + ")";
                break;
            }
            case 8: {
                object = "(" + this.left.toStringSpin() + ") -> (" + this.right.toStringSpin() + ")";
                break;
            }
            case 7: {
                object = "(" + this.left.toStringSpin() + ") <-> (" + this.right.toStringSpin() + ")";
                break;
            }
            case 4: {
                object = "X (" + this.left.toStringSpin() + ")";
                break;
            }
            case 12: {
                object = "<> (" + this.left.toStringSpin() + ")";
                break;
            }
            case 11: {
                object = "[] (" + this.left.toStringSpin() + ")";
                break;
            }
            case 3: {
                object = "! (" + this.left.toStringSpin() + ")";
                break;
            }
            case 0: {
                object = "false";
                break;
            }
            case 1: {
                object = "true";
                break;
            }
            case 2: {
                object = this.ap;
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    public String toStringSpot() {
        Object object = "";
        switch (this.kind.ordinal()) {
            case 5: {
                object = "(" + this.left.toStringSpot() + ") | (" + this.right.toStringSpot() + ")";
                break;
            }
            case 6: {
                object = "(" + this.left.toStringSpot() + ") & (" + this.right.toStringSpot() + ")";
                break;
            }
            case 9: {
                object = "(" + this.left.toStringSpot() + ") U (" + this.right.toStringSpot() + ")";
                break;
            }
            case 10: {
                object = "(" + this.left.toStringSpot() + ") R (" + this.right.toStringSpot() + ")";
                break;
            }
            case 8: {
                object = "(" + this.left.toStringSpot() + ") -> (" + this.right.toStringSpot() + ")";
                break;
            }
            case 7: {
                object = "(" + this.left.toStringSpot() + ") <-> (" + this.right.toStringSpot() + ")";
                break;
            }
            case 4: {
                object = "X (" + this.left.toStringSpot() + ")";
                break;
            }
            case 12: {
                object = "F (" + this.left.toStringSpot() + ")";
                break;
            }
            case 11: {
                object = "G (" + this.left.toStringSpot() + ")";
                break;
            }
            case 3: {
                object = "! (" + this.left.toStringSpot() + ")";
                break;
            }
            case 0: {
                object = "false";
                break;
            }
            case 1: {
                object = "true";
                break;
            }
            case 2: {
                object = this.ap;
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static SimpleLTL parseFormulaLBT(String string) throws Exception {
        string = string.trim();
        String[] stringArray = string.split("[ ]+");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String object : stringArray) {
            arrayList.add(object);
        }
        HashMap hashMap = new HashMap();
        HashMap<String, LTLType> hashMap2 = new HashMap<String, LTLType>();
        hashMap.put("!", LTLType.NOT);
        hashMap.put("F", LTLType.FINALLY);
        hashMap.put("G", LTLType.GLOBALLY);
        hashMap.put("X", LTLType.NEXT);
        hashMap2.put("|", LTLType.OR);
        hashMap2.put("&", LTLType.AND);
        hashMap2.put("i", LTLType.IMPLIES);
        hashMap2.put("e", LTLType.EQUIV);
        hashMap2.put("U", LTLType.UNTIL);
        hashMap2.put("V", LTLType.RELEASE);
        SimpleLTL simpleLTL = SimpleLTL.parseFormulaLBT(arrayList, hashMap, hashMap2);
        if (arrayList.size() > 0) {
            void var6_10;
            String string2 = "";
            for (String string3 : arrayList) {
                String string4 = (String)var6_10 + " " + string3;
            }
            throw new RuntimeException("Malformed formula, extra information after end of formula: " + (String)var6_10);
        }
        return simpleLTL;
    }

    private static SimpleLTL parseFormulaLBT(List<String> list, Map<String, LTLType> map, Map<String, LTLType> map2) throws RuntimeException {
        if (list.size() == 0) {
            throw new RuntimeException("Malformed formula, premature ending");
        }
        String string = list.get(0);
        list.remove(0);
        if (string.equals("t")) {
            return new SimpleLTL(true);
        }
        if (string.equals("f")) {
            return new SimpleLTL(false);
        }
        if (map.containsKey(string)) {
            SimpleLTL simpleLTL = SimpleLTL.parseFormulaLBT(list, map, map2);
            return new SimpleLTL(map.get(string), simpleLTL);
        }
        if (map2.containsKey(string)) {
            SimpleLTL simpleLTL = SimpleLTL.parseFormulaLBT(list, map, map2);
            SimpleLTL simpleLTL2 = SimpleLTL.parseFormulaLBT(list, map, map2);
            return new SimpleLTL(map2.get(string), simpleLTL, simpleLTL2);
        }
        if (string.equals("W")) {
            SimpleLTL simpleLTL = SimpleLTL.parseFormulaLBT(list, map, map2);
            SimpleLTL simpleLTL3 = SimpleLTL.parseFormulaLBT(list, map, map2);
            SimpleLTL simpleLTL4 = new SimpleLTL(LTLType.AND, simpleLTL.clone(), new SimpleLTL(LTLType.NOT, simpleLTL3.clone()));
            SimpleLTL simpleLTL5 = new SimpleLTL(LTLType.AND, new SimpleLTL(LTLType.NOT, simpleLTL.clone()), new SimpleLTL(LTLType.NOT, simpleLTL3.clone()));
            return new SimpleLTL(LTLType.NOT, new SimpleLTL(LTLType.UNTIL, simpleLTL4, simpleLTL5));
        }
        if (string.equals("^")) {
            SimpleLTL simpleLTL = SimpleLTL.parseFormulaLBT(list, map, map2);
            SimpleLTL simpleLTL6 = SimpleLTL.parseFormulaLBT(list, map, map2);
            return new SimpleLTL(LTLType.NOT, new SimpleLTL(LTLType.EQUIV, simpleLTL, simpleLTL6));
        }
        if (string.equals("M") || string.equals("B")) {
            throw new RuntimeException("Operator " + string + " currently not supported.");
        }
        if (string.matches("[a-zA-Z].*")) {
            return new SimpleLTL(string);
        }
        throw new RuntimeException("Illegal/unsupported operator: " + string);
    }

    public NBA toNBA(APSet aPSet) throws PrismException {
        Alternating alternating = new Alternating(this, aPSet);
        Generalized generalized = new Generalized(alternating);
        Buchi buchi = new Buchi(generalized);
        NBA nBA = buchi.toNBA(aPSet);
        nBA.setFailIfDisjoint(true);
        return nBA;
    }

    public NBA toNBA() throws PrismException {
        return this.toNBA(new APSet());
    }

    public void toDot(PrintStream printStream) {
        IdentityHashMap<SimpleLTL, String> identityHashMap = new IdentityHashMap<SimpleLTL, String>();
        printStream.println("digraph {");
        this.toDot(printStream, identityHashMap);
        printStream.println("}");
    }

    private String toDot(PrintStream printStream, IdentityHashMap<SimpleLTL, String> identityHashMap) {
        String string = identityHashMap.get(this);
        if (string != null) {
            return string;
        }
        string = Integer.toString(identityHashMap.size());
        identityHashMap.put(this, string);
        printStream.println(string + " [label=\"" + this.toStringLBT() + "\"]");
        switch (this.kind.ordinal()) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                String string2 = this.left.toDot(printStream, identityHashMap);
                String string3 = this.right.toDot(printStream, identityHashMap);
                printStream.println(string + " -> " + string2);
                printStream.println(string + " -> " + string3);
                break;
            }
            case 3: 
            case 4: 
            case 11: 
            case 12: {
                String string4 = this.left.toDot(printStream, identityHashMap);
                printStream.println(string + " -> " + string4);
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                break;
            }
        }
        return string;
    }

    public static enum LTLType {
        FALSE,
        TRUE,
        AP,
        NOT,
        NEXT,
        OR,
        AND,
        EQUIV,
        IMPLIES,
        UNTIL,
        RELEASE,
        GLOBALLY,
        FINALLY;

    }
}

